#!/usr/bin/env python

import sys
import argparse as ap
import re
parser = ap.ArgumentParser(prog='spotyping_postprocess', conflict_handler='resolve',
                           description="Postprocess galaxy spotyping output")

input = parser.add_argument_group('Input', '')
input.add_argument('-s', '--sample', nargs='+', required=True, help="Sample names")
input.add_argument('-f', '--file', nargs='+', required=True, help="File of spotyping in galaxy convention")
if len(sys.argv) == 0:
    parser.print_usage()
    sys.exit(1)

args = parser.parse_args()


sample_dict={}


with open('spotyping_postprocess_output.txt', 'w') as output:
	index = 0
	for path in args.file:
		with open(path) as f:
			for line in f:
				#sample_dict[re.sub(".*/","",line.rstrip())] = args.sample[path_index]
				sample = re.sub('(_1.fastq(.gz)*|_2.fastq(.gz)*|.fastq(.gz)*)', '', args.sample[index].rstrip().lstrip())
				output.write(re.sub(".*.dat", sample, line))
		index += 1

