/* soapC.c
   Generated by gSOAP 2.8.6 from gae.h

Copyright(C) 2000-2011, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
1) GPL or 2) Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.8.6 2013-04-04 13:42:58 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_ns1__hydropathy:
		return soap_in_ns1__hydropathy(soap, NULL, NULL, "ns1:hydropathy");
	case SOAP_TYPE_ns1__hydropathyResponse:
		return soap_in_ns1__hydropathyResponse(soap, NULL, NULL, "ns1:hydropathyResponse");
	case SOAP_TYPE_ns1__help:
		return soap_in_ns1__help(soap, NULL, NULL, "ns1:help");
	case SOAP_TYPE_ns1__helpResponse:
		return soap_in_ns1__helpResponse(soap, NULL, NULL, "ns1:helpResponse");
	case SOAP_TYPE_ns1__S_USCOREvalue:
		return soap_in_ns1__S_USCOREvalue(soap, NULL, NULL, "ns1:S_value");
	case SOAP_TYPE_ns1__S_USCOREvalueResponse:
		return soap_in_ns1__S_USCOREvalueResponse(soap, NULL, NULL, "ns1:S_valueResponse");
	case SOAP_TYPE_ns1__leading_USCOREstrand:
		return soap_in_ns1__leading_USCOREstrand(soap, NULL, NULL, "ns1:leading_strand");
	case SOAP_TYPE_ns1__leading_USCOREstrandResponse:
		return soap_in_ns1__leading_USCOREstrandResponse(soap, NULL, NULL, "ns1:leading_strandResponse");
	case SOAP_TYPE_ns1__scs:
		return soap_in_ns1__scs(soap, NULL, NULL, "ns1:scs");
	case SOAP_TYPE_ns1__scsResponse:
		return soap_in_ns1__scsResponse(soap, NULL, NULL, "ns1:scsResponse");
	case SOAP_TYPE_ns1__lda_USCOREbias:
		return soap_in_ns1__lda_USCOREbias(soap, NULL, NULL, "ns1:lda_bias");
	case SOAP_TYPE_ns1__lda_USCOREbiasResponse:
		return soap_in_ns1__lda_USCOREbiasResponse(soap, NULL, NULL, "ns1:lda_biasResponse");
	case SOAP_TYPE_ns1__kmer_USCOREtable:
		return soap_in_ns1__kmer_USCOREtable(soap, NULL, NULL, "ns1:kmer_table");
	case SOAP_TYPE_ns1__kmer_USCOREtableResponse:
		return soap_in_ns1__kmer_USCOREtableResponse(soap, NULL, NULL, "ns1:kmer_tableResponse");
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalue:
		return soap_in_ns1__base_USCOREz_USCOREvalue(soap, NULL, NULL, "ns1:base_z_value");
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse:
		return soap_in_ns1__base_USCOREz_USCOREvalueResponse(soap, NULL, NULL, "ns1:base_z_valueResponse");
	case SOAP_TYPE_ns1__base_USCOREcounter:
		return soap_in_ns1__base_USCOREcounter(soap, NULL, NULL, "ns1:base_counter");
	case SOAP_TYPE_ns1__base_USCOREcounterResponse:
		return soap_in_ns1__base_USCOREcounterResponse(soap, NULL, NULL, "ns1:base_counterResponse");
	case SOAP_TYPE_ns1__B2:
		return soap_in_ns1__B2(soap, NULL, NULL, "ns1:B2");
	case SOAP_TYPE_ns1__B2Response:
		return soap_in_ns1__B2Response(soap, NULL, NULL, "ns1:B2Response");
	case SOAP_TYPE_ns1__B1:
		return soap_in_ns1__B1(soap, NULL, NULL, "ns1:B1");
	case SOAP_TYPE_ns1__B1Response:
		return soap_in_ns1__B1Response(soap, NULL, NULL, "ns1:B1Response");
	case SOAP_TYPE_ns1__cgr:
		return soap_in_ns1__cgr(soap, NULL, NULL, "ns1:cgr");
	case SOAP_TYPE_ns1__cgrResponse:
		return soap_in_ns1__cgrResponse(soap, NULL, NULL, "ns1:cgrResponse");
	case SOAP_TYPE_ns1__dinuc:
		return soap_in_ns1__dinuc(soap, NULL, NULL, "ns1:dinuc");
	case SOAP_TYPE_ns1__dinucResponse:
		return soap_in_ns1__dinucResponse(soap, NULL, NULL, "ns1:dinucResponse");
	case SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit:
		return soap_in_ns1__least_USCOREsquares_USCOREfit(soap, NULL, NULL, "ns1:least_squares_fit");
	case SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse:
		return soap_in_ns1__least_USCOREsquares_USCOREfitResponse(soap, NULL, NULL, "ns1:least_squares_fitResponse");
	case SOAP_TYPE_ns1__palindrome:
		return soap_in_ns1__palindrome(soap, NULL, NULL, "ns1:palindrome");
	case SOAP_TYPE_ns1__palindromeResponse:
		return soap_in_ns1__palindromeResponse(soap, NULL, NULL, "ns1:palindromeResponse");
	case SOAP_TYPE_ns1__entrez:
		return soap_in_ns1__entrez(soap, NULL, NULL, "ns1:entrez");
	case SOAP_TYPE_ns1__entrezResponse:
		return soap_in_ns1__entrezResponse(soap, NULL, NULL, "ns1:entrezResponse");
	case SOAP_TYPE_ns1__codon_USCOREcounter:
		return soap_in_ns1__codon_USCOREcounter(soap, NULL, NULL, "ns1:codon_counter");
	case SOAP_TYPE_ns1__codon_USCOREcounterResponse:
		return soap_in_ns1__codon_USCOREcounterResponse(soap, NULL, NULL, "ns1:codon_counterResponse");
	case SOAP_TYPE_ns1__mean:
		return soap_in_ns1__mean(soap, NULL, NULL, "ns1:mean");
	case SOAP_TYPE_ns1__meanResponse:
		return soap_in_ns1__meanResponse(soap, NULL, NULL, "ns1:meanResponse");
	case SOAP_TYPE_ns1__complement:
		return soap_in_ns1__complement(soap, NULL, NULL, "ns1:complement");
	case SOAP_TYPE_ns1__complementResponse:
		return soap_in_ns1__complementResponse(soap, NULL, NULL, "ns1:complementResponse");
	case SOAP_TYPE_ns1__find_USCOREiteron:
		return soap_in_ns1__find_USCOREiteron(soap, NULL, NULL, "ns1:find_iteron");
	case SOAP_TYPE_ns1__find_USCOREiteronResponse:
		return soap_in_ns1__find_USCOREiteronResponse(soap, NULL, NULL, "ns1:find_iteronResponse");
	case SOAP_TYPE_ns1__min:
		return soap_in_ns1__min(soap, NULL, NULL, "ns1:min");
	case SOAP_TYPE_ns1__minResponse:
		return soap_in_ns1__minResponse(soap, NULL, NULL, "ns1:minResponse");
	case SOAP_TYPE_ns1__codon_USCOREusage:
		return soap_in_ns1__codon_USCOREusage(soap, NULL, NULL, "ns1:codon_usage");
	case SOAP_TYPE_ns1__codon_USCOREusageResponse:
		return soap_in_ns1__codon_USCOREusageResponse(soap, NULL, NULL, "ns1:codon_usageResponse");
	case SOAP_TYPE_ns1__oligomer_USCOREcounter:
		return soap_in_ns1__oligomer_USCOREcounter(soap, NULL, NULL, "ns1:oligomer_counter");
	case SOAP_TYPE_ns1__oligomer_USCOREcounterResponse:
		return soap_in_ns1__oligomer_USCOREcounterResponse(soap, NULL, NULL, "ns1:oligomer_counterResponse");
	case SOAP_TYPE_ns1__gcwin:
		return soap_in_ns1__gcwin(soap, NULL, NULL, "ns1:gcwin");
	case SOAP_TYPE_ns1__gcwinResponse:
		return soap_in_ns1__gcwinResponse(soap, NULL, NULL, "ns1:gcwinResponse");
	case SOAP_TYPE_ns1__find_USCOREpattern:
		return soap_in_ns1__find_USCOREpattern(soap, NULL, NULL, "ns1:find_pattern");
	case SOAP_TYPE_ns1__find_USCOREpatternResponse:
		return soap_in_ns1__find_USCOREpatternResponse(soap, NULL, NULL, "ns1:find_patternResponse");
	case SOAP_TYPE_ns1__oligomer_USCOREsearch:
		return soap_in_ns1__oligomer_USCOREsearch(soap, NULL, NULL, "ns1:oligomer_search");
	case SOAP_TYPE_ns1__oligomer_USCOREsearchResponse:
		return soap_in_ns1__oligomer_USCOREsearchResponse(soap, NULL, NULL, "ns1:oligomer_searchResponse");
	case SOAP_TYPE_ns1__shuffleseq:
		return soap_in_ns1__shuffleseq(soap, NULL, NULL, "ns1:shuffleseq");
	case SOAP_TYPE_ns1__shuffleseqResponse:
		return soap_in_ns1__shuffleseqResponse(soap, NULL, NULL, "ns1:shuffleseqResponse");
	case SOAP_TYPE_ns1__find_USCOREter:
		return soap_in_ns1__find_USCOREter(soap, NULL, NULL, "ns1:find_ter");
	case SOAP_TYPE_ns1__find_USCOREterResponse:
		return soap_in_ns1__find_USCOREterResponse(soap, NULL, NULL, "ns1:find_terResponse");
	case SOAP_TYPE_ns1__dnawalk:
		return soap_in_ns1__dnawalk(soap, NULL, NULL, "ns1:dnawalk");
	case SOAP_TYPE_ns1__dnawalkResponse:
		return soap_in_ns1__dnawalkResponse(soap, NULL, NULL, "ns1:dnawalkResponse");
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent:
		return soap_in_ns1__base_USCOREinformation_USCOREcontent(soap, NULL, NULL, "ns1:base_information_content");
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse:
		return soap_in_ns1__base_USCOREinformation_USCOREcontentResponse(soap, NULL, NULL, "ns1:base_information_contentResponse");
	case SOAP_TYPE_ns1__signature:
		return soap_in_ns1__signature(soap, NULL, NULL, "ns1:signature");
	case SOAP_TYPE_ns1__signatureResponse:
		return soap_in_ns1__signatureResponse(soap, NULL, NULL, "ns1:signatureResponse");
	case SOAP_TYPE_ns1__seqinfo:
		return soap_in_ns1__seqinfo(soap, NULL, NULL, "ns1:seqinfo");
	case SOAP_TYPE_ns1__seqinfoResponse:
		return soap_in_ns1__seqinfoResponse(soap, NULL, NULL, "ns1:seqinfoResponse");
	case SOAP_TYPE_ns1__genome_USCOREmap3:
		return soap_in_ns1__genome_USCOREmap3(soap, NULL, NULL, "ns1:genome_map3");
	case SOAP_TYPE_ns1__genome_USCOREmap3Response:
		return soap_in_ns1__genome_USCOREmap3Response(soap, NULL, NULL, "ns1:genome_map3Response");
	case SOAP_TYPE_ns1__gcskew:
		return soap_in_ns1__gcskew(soap, NULL, NULL, "ns1:gcskew");
	case SOAP_TYPE_ns1__gcskewResponse:
		return soap_in_ns1__gcskewResponse(soap, NULL, NULL, "ns1:gcskewResponse");
	case SOAP_TYPE_ns1__molecular_USCOREweight:
		return soap_in_ns1__molecular_USCOREweight(soap, NULL, NULL, "ns1:molecular_weight");
	case SOAP_TYPE_ns1__molecular_USCOREweightResponse:
		return soap_in_ns1__molecular_USCOREweightResponse(soap, NULL, NULL, "ns1:molecular_weightResponse");
	case SOAP_TYPE_ns1__delta_USCOREgcskew:
		return soap_in_ns1__delta_USCOREgcskew(soap, NULL, NULL, "ns1:delta_gcskew");
	case SOAP_TYPE_ns1__delta_USCOREgcskewResponse:
		return soap_in_ns1__delta_USCOREgcskewResponse(soap, NULL, NULL, "ns1:delta_gcskewResponse");
	case SOAP_TYPE_ns1__delta_USCOREenc:
		return soap_in_ns1__delta_USCOREenc(soap, NULL, NULL, "ns1:delta_enc");
	case SOAP_TYPE_ns1__delta_USCOREencResponse:
		return soap_in_ns1__delta_USCOREencResponse(soap, NULL, NULL, "ns1:delta_encResponse");
	case SOAP_TYPE_ns1__cumulative:
		return soap_in_ns1__cumulative(soap, NULL, NULL, "ns1:cumulative");
	case SOAP_TYPE_ns1__cumulativeResponse:
		return soap_in_ns1__cumulativeResponse(soap, NULL, NULL, "ns1:cumulativeResponse");
	case SOAP_TYPE_ns1__cor:
		return soap_in_ns1__cor(soap, NULL, NULL, "ns1:cor");
	case SOAP_TYPE_ns1__corResponse:
		return soap_in_ns1__corResponse(soap, NULL, NULL, "ns1:corResponse");
	case SOAP_TYPE_ns1__standard_USCOREdeviation:
		return soap_in_ns1__standard_USCOREdeviation(soap, NULL, NULL, "ns1:standard_deviation");
	case SOAP_TYPE_ns1__standard_USCOREdeviationResponse:
		return soap_in_ns1__standard_USCOREdeviationResponse(soap, NULL, NULL, "ns1:standard_deviationResponse");
	case SOAP_TYPE_ns1__geneskew:
		return soap_in_ns1__geneskew(soap, NULL, NULL, "ns1:geneskew");
	case SOAP_TYPE_ns1__geneskewResponse:
		return soap_in_ns1__geneskewResponse(soap, NULL, NULL, "ns1:geneskewResponse");
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori:
		return soap_in_ns1__genes_USCOREfrom_USCOREori(soap, NULL, NULL, "ns1:genes_from_ori");
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse:
		return soap_in_ns1__genes_USCOREfrom_USCOREoriResponse(soap, NULL, NULL, "ns1:genes_from_oriResponse");
	case SOAP_TYPE_ns1__cbi:
		return soap_in_ns1__cbi(soap, NULL, NULL, "ns1:cbi");
	case SOAP_TYPE_ns1__cbiResponse:
		return soap_in_ns1__cbiResponse(soap, NULL, NULL, "ns1:cbiResponse");
	case SOAP_TYPE_ns1__find_USCOREdif:
		return soap_in_ns1__find_USCOREdif(soap, NULL, NULL, "ns1:find_dif");
	case SOAP_TYPE_ns1__find_USCOREdifResponse:
		return soap_in_ns1__find_USCOREdifResponse(soap, NULL, NULL, "ns1:find_difResponse");
	case SOAP_TYPE_ns1__to_USCOREfasta:
		return soap_in_ns1__to_USCOREfasta(soap, NULL, NULL, "ns1:to_fasta");
	case SOAP_TYPE_ns1__to_USCOREfastaResponse:
		return soap_in_ns1__to_USCOREfastaResponse(soap, NULL, NULL, "ns1:to_fastaResponse");
	case SOAP_TYPE_ns1__base_USCOREentropy:
		return soap_in_ns1__base_USCOREentropy(soap, NULL, NULL, "ns1:base_entropy");
	case SOAP_TYPE_ns1__base_USCOREentropyResponse:
		return soap_in_ns1__base_USCOREentropyResponse(soap, NULL, NULL, "ns1:base_entropyResponse");
	case SOAP_TYPE_ns1__DoubleHelix:
		return soap_in_ns1__DoubleHelix(soap, NULL, NULL, "ns1:DoubleHelix");
	case SOAP_TYPE_ns1__DoubleHelixResponse:
		return soap_in_ns1__DoubleHelixResponse(soap, NULL, NULL, "ns1:DoubleHelixResponse");
	case SOAP_TYPE_ns1__calc_USCOREpI:
		return soap_in_ns1__calc_USCOREpI(soap, NULL, NULL, "ns1:calc_pI");
	case SOAP_TYPE_ns1__calc_USCOREpIResponse:
		return soap_in_ns1__calc_USCOREpIResponse(soap, NULL, NULL, "ns1:calc_pIResponse");
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREter:
		return soap_in_ns1__rep_USCOREori_USCOREter(soap, NULL, NULL, "ns1:rep_ori_ter");
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse:
		return soap_in_ns1__rep_USCOREori_USCOREterResponse(soap, NULL, NULL, "ns1:rep_ori_terResponse");
	case SOAP_TYPE_ns1__longest_USCOREORF:
		return soap_in_ns1__longest_USCOREORF(soap, NULL, NULL, "ns1:longest_ORF");
	case SOAP_TYPE_ns1__longest_USCOREORFResponse:
		return soap_in_ns1__longest_USCOREORFResponse(soap, NULL, NULL, "ns1:longest_ORFResponse");
	case SOAP_TYPE_ns1__genome_USCOREmap:
		return soap_in_ns1__genome_USCOREmap(soap, NULL, NULL, "ns1:genome_map");
	case SOAP_TYPE_ns1__genome_USCOREmapResponse:
		return soap_in_ns1__genome_USCOREmapResponse(soap, NULL, NULL, "ns1:genome_mapResponse");
	case SOAP_TYPE_ns1__consensus_USCOREz:
		return soap_in_ns1__consensus_USCOREz(soap, NULL, NULL, "ns1:consensus_z");
	case SOAP_TYPE_ns1__consensus_USCOREzResponse:
		return soap_in_ns1__consensus_USCOREzResponse(soap, NULL, NULL, "ns1:consensus_zResponse");
	case SOAP_TYPE_ns1__mindex:
		return soap_in_ns1__mindex(soap, NULL, NULL, "ns1:mindex");
	case SOAP_TYPE_ns1__mindexResponse:
		return soap_in_ns1__mindexResponse(soap, NULL, NULL, "ns1:mindexResponse");
	case SOAP_TYPE_ns1__query_USCOREarm:
		return soap_in_ns1__query_USCOREarm(soap, NULL, NULL, "ns1:query_arm");
	case SOAP_TYPE_ns1__query_USCOREarmResponse:
		return soap_in_ns1__query_USCOREarmResponse(soap, NULL, NULL, "ns1:query_armResponse");
	case SOAP_TYPE_ns1__max:
		return soap_in_ns1__max(soap, NULL, NULL, "ns1:max");
	case SOAP_TYPE_ns1__maxResponse:
		return soap_in_ns1__maxResponse(soap, NULL, NULL, "ns1:maxResponse");
	case SOAP_TYPE_ns1__maxdex:
		return soap_in_ns1__maxdex(soap, NULL, NULL, "ns1:maxdex");
	case SOAP_TYPE_ns1__maxdexResponse:
		return soap_in_ns1__maxdexResponse(soap, NULL, NULL, "ns1:maxdexResponse");
	case SOAP_TYPE_ns1__cai:
		return soap_in_ns1__cai(soap, NULL, NULL, "ns1:cai");
	case SOAP_TYPE_ns1__caiResponse:
		return soap_in_ns1__caiResponse(soap, NULL, NULL, "ns1:caiResponse");
	case SOAP_TYPE_ns1__gcsi:
		return soap_in_ns1__gcsi(soap, NULL, NULL, "ns1:gcsi");
	case SOAP_TYPE_ns1__gcsiResponse:
		return soap_in_ns1__gcsiResponse(soap, NULL, NULL, "ns1:gcsiResponse");
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg:
		return soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, NULL, NULL, "ns1:filter_cds_by_atg");
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse:
		return soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, NULL, NULL, "ns1:filter_cds_by_atgResponse");
	case SOAP_TYPE_ns1__genomicskew:
		return soap_in_ns1__genomicskew(soap, NULL, NULL, "ns1:genomicskew");
	case SOAP_TYPE_ns1__genomicskewResponse:
		return soap_in_ns1__genomicskewResponse(soap, NULL, NULL, "ns1:genomicskewResponse");
	case SOAP_TYPE_ns1__query_USCOREstrand:
		return soap_in_ns1__query_USCOREstrand(soap, NULL, NULL, "ns1:query_strand");
	case SOAP_TYPE_ns1__query_USCOREstrandResponse:
		return soap_in_ns1__query_USCOREstrandResponse(soap, NULL, NULL, "ns1:query_strandResponse");
	case SOAP_TYPE_ns1__view_USCOREcds:
		return soap_in_ns1__view_USCOREcds(soap, NULL, NULL, "ns1:view_cds");
	case SOAP_TYPE_ns1__view_USCOREcdsResponse:
		return soap_in_ns1__view_USCOREcdsResponse(soap, NULL, NULL, "ns1:view_cdsResponse");
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy:
		return soap_in_ns1__base_USCORErelative_USCOREentropy(soap, NULL, NULL, "ns1:base_relative_entropy");
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse:
		return soap_in_ns1__base_USCORErelative_USCOREentropyResponse(soap, NULL, NULL, "ns1:base_relative_entropyResponse");
	case SOAP_TYPE_ns1__Ew:
		return soap_in_ns1__Ew(soap, NULL, NULL, "ns1:Ew");
	case SOAP_TYPE_ns1__EwResponse:
		return soap_in_ns1__EwResponse(soap, NULL, NULL, "ns1:EwResponse");
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder:
		return soap_in_ns1__over_USCORElapping_USCOREfinder(soap, NULL, NULL, "ns1:over_lapping_finder");
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse:
		return soap_in_ns1__over_USCORElapping_USCOREfinderResponse(soap, NULL, NULL, "ns1:over_lapping_finderResponse");
	case SOAP_TYPE_ns1__codon_USCOREcompiler:
		return soap_in_ns1__codon_USCOREcompiler(soap, NULL, NULL, "ns1:codon_compiler");
	case SOAP_TYPE_ns1__codon_USCOREcompilerResponse:
		return soap_in_ns1__codon_USCOREcompilerResponse(soap, NULL, NULL, "ns1:codon_compilerResponse");
	case SOAP_TYPE_ns1__aaui:
		return soap_in_ns1__aaui(soap, NULL, NULL, "ns1:aaui");
	case SOAP_TYPE_ns1__aauiResponse:
		return soap_in_ns1__aauiResponse(soap, NULL, NULL, "ns1:aauiResponse");
	case SOAP_TYPE_ns1__amino_USCOREcounter:
		return soap_in_ns1__amino_USCOREcounter(soap, NULL, NULL, "ns1:amino_counter");
	case SOAP_TYPE_ns1__amino_USCOREcounterResponse:
		return soap_in_ns1__amino_USCOREcounterResponse(soap, NULL, NULL, "ns1:amino_counterResponse");
	case SOAP_TYPE_ns1__seq2png:
		return soap_in_ns1__seq2png(soap, NULL, NULL, "ns1:seq2png");
	case SOAP_TYPE_ns1__seq2pngResponse:
		return soap_in_ns1__seq2pngResponse(soap, NULL, NULL, "ns1:seq2pngResponse");
	case SOAP_TYPE_ns1__ttest:
		return soap_in_ns1__ttest(soap, NULL, NULL, "ns1:ttest");
	case SOAP_TYPE_ns1__ttestResponse:
		return soap_in_ns1__ttestResponse(soap, NULL, NULL, "ns1:ttestResponse");
	case SOAP_TYPE_ns1__find_USCOREdnaAbox:
		return soap_in_ns1__find_USCOREdnaAbox(soap, NULL, NULL, "ns1:find_dnaAbox");
	case SOAP_TYPE_ns1__find_USCOREdnaAboxResponse:
		return soap_in_ns1__find_USCOREdnaAboxResponse(soap, NULL, NULL, "ns1:find_dnaAboxResponse");
	case SOAP_TYPE_ns1__dist_USCOREin_USCOREcc:
		return soap_in_ns1__dist_USCOREin_USCOREcc(soap, NULL, NULL, "ns1:dist_in_cc");
	case SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse:
		return soap_in_ns1__dist_USCOREin_USCOREccResponse(soap, NULL, NULL, "ns1:dist_in_ccResponse");
	case SOAP_TYPE_ns1__bui:
		return soap_in_ns1__bui(soap, NULL, NULL, "ns1:bui");
	case SOAP_TYPE_ns1__buiResponse:
		return soap_in_ns1__buiResponse(soap, NULL, NULL, "ns1:buiResponse");
	case SOAP_TYPE_ns1__fop:
		return soap_in_ns1__fop(soap, NULL, NULL, "ns1:fop");
	case SOAP_TYPE_ns1__fopResponse:
		return soap_in_ns1__fopResponse(soap, NULL, NULL, "ns1:fopResponse");
	case SOAP_TYPE_ns1__enc:
		return soap_in_ns1__enc(soap, NULL, NULL, "ns1:enc");
	case SOAP_TYPE_ns1__encResponse:
		return soap_in_ns1__encResponse(soap, NULL, NULL, "ns1:encResponse");
	case SOAP_TYPE_ns1__icdi:
		return soap_in_ns1__icdi(soap, NULL, NULL, "ns1:icdi");
	case SOAP_TYPE_ns1__icdiResponse:
		return soap_in_ns1__icdiResponse(soap, NULL, NULL, "ns1:icdiResponse");
	case SOAP_TYPE_ns1__phx:
		return soap_in_ns1__phx(soap, NULL, NULL, "ns1:phx");
	case SOAP_TYPE_ns1__phxResponse:
		return soap_in_ns1__phxResponse(soap, NULL, NULL, "ns1:phxResponse");
	case SOAP_TYPE_ns1__translate:
		return soap_in_ns1__translate(soap, NULL, NULL, "ns1:translate");
	case SOAP_TYPE_ns1__translateResponse:
		return soap_in_ns1__translateResponse(soap, NULL, NULL, "ns1:translateResponse");
	case SOAP_TYPE_ns1__togoWS:
		return soap_in_ns1__togoWS(soap, NULL, NULL, "ns1:togoWS");
	case SOAP_TYPE_ns1__togoWSResponse:
		return soap_in_ns1__togoWSResponse(soap, NULL, NULL, "ns1:togoWSResponse");
	case SOAP_TYPE_ns1__circular_USCOREmap:
		return soap_in_ns1__circular_USCOREmap(soap, NULL, NULL, "ns1:circular_map");
	case SOAP_TYPE_ns1__circular_USCOREmapResponse:
		return soap_in_ns1__circular_USCOREmapResponse(soap, NULL, NULL, "ns1:circular_mapResponse");
	case SOAP_TYPE_ns1__amino_USCOREinfo:
		return soap_in_ns1__amino_USCOREinfo(soap, NULL, NULL, "ns1:amino_info");
	case SOAP_TYPE_ns1__amino_USCOREinfoResponse:
		return soap_in_ns1__amino_USCOREinfoResponse(soap, NULL, NULL, "ns1:amino_infoResponse");
	case SOAP_TYPE_ns1__variance:
		return soap_in_ns1__variance(soap, NULL, NULL, "ns1:variance");
	case SOAP_TYPE_ns1__varianceResponse:
		return soap_in_ns1__varianceResponse(soap, NULL, NULL, "ns1:varianceResponse");
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicity:
		return soap_in_ns1__nucleotide_USCOREperiodicity(soap, NULL, NULL, "ns1:nucleotide_periodicity");
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse:
		return soap_in_ns1__nucleotide_USCOREperiodicityResponse(soap, NULL, NULL, "ns1:nucleotide_periodicityResponse");
	case SOAP_TYPE_ns1__sum:
		return soap_in_ns1__sum(soap, NULL, NULL, "ns1:sum");
	case SOAP_TYPE_ns1__sumResponse:
		return soap_in_ns1__sumResponse(soap, NULL, NULL, "ns1:sumResponse");
	case SOAP_TYPE_ns1__plasmid_USCOREmap:
		return soap_in_ns1__plasmid_USCOREmap(soap, NULL, NULL, "ns1:plasmid_map");
	case SOAP_TYPE_ns1__plasmid_USCOREmapResponse:
		return soap_in_ns1__plasmid_USCOREmapResponse(soap, NULL, NULL, "ns1:plasmid_mapResponse");
	case SOAP_TYPE_ns1__find_USCOREori_USCOREter:
		return soap_in_ns1__find_USCOREori_USCOREter(soap, NULL, NULL, "ns1:find_ori_ter");
	case SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse:
		return soap_in_ns1__find_USCOREori_USCOREterResponse(soap, NULL, NULL, "ns1:find_ori_terResponse");
	case SOAP_TYPE_ns1__median:
		return soap_in_ns1__median(soap, NULL, NULL, "ns1:median");
	case SOAP_TYPE_ns1__medianResponse:
		return soap_in_ns1__medianResponse(soap, NULL, NULL, "ns1:medianResponse");
	case SOAP_TYPE_ns1__splitprintseq:
		return soap_in_ns1__splitprintseq(soap, NULL, NULL, "ns1:splitprintseq");
	case SOAP_TYPE_ns1__splitprintseqResponse:
		return soap_in_ns1__splitprintseqResponse(soap, NULL, NULL, "ns1:splitprintseqResponse");
	case SOAP_TYPE_ns1__w_USCOREvalue:
		return soap_in_ns1__w_USCOREvalue(soap, NULL, NULL, "ns1:w_value");
	case SOAP_TYPE_ns1__w_USCOREvalueResponse:
		return soap_in_ns1__w_USCOREvalueResponse(soap, NULL, NULL, "ns1:w_valueResponse");
	case SOAP_TYPE_ns1__P2:
		return soap_in_ns1__P2(soap, NULL, NULL, "ns1:P2");
	case SOAP_TYPE_ns1__P2Response:
		return soap_in_ns1__P2Response(soap, NULL, NULL, "ns1:P2Response");
	case SOAP_TYPE_ns1__codon_USCOREmva:
		return soap_in_ns1__codon_USCOREmva(soap, NULL, NULL, "ns1:codon_mva");
	case SOAP_TYPE_ns1__codon_USCOREmvaResponse:
		return soap_in_ns1__codon_USCOREmvaResponse(soap, NULL, NULL, "ns1:codon_mvaResponse");
	case SOAP_TYPE_arrayOut:
		return soap_in_arrayOut(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_arrayIn:
		return soap_in_arrayIn(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ns1__S_USCOREvalueInputParams:
		return soap_in_ns1__S_USCOREvalueInputParams(soap, NULL, NULL, "ns1:S_valueInputParams");
	case SOAP_TYPE_ns1__scsInputParams:
		return soap_in_ns1__scsInputParams(soap, NULL, NULL, "ns1:scsInputParams");
	case SOAP_TYPE_ns1__signatureInputParams:
		return soap_in_ns1__signatureInputParams(soap, NULL, NULL, "ns1:signatureInputParams");
	case SOAP_TYPE_ns1__lda_USCOREbiasInputParams:
		return soap_in_ns1__lda_USCOREbiasInputParams(soap, NULL, NULL, "ns1:lda_biasInputParams");
	case SOAP_TYPE_ns1__kmer_USCOREtableInputParams:
		return soap_in_ns1__kmer_USCOREtableInputParams(soap, NULL, NULL, "ns1:kmer_tableInputParams");
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams:
		return soap_in_ns1__base_USCOREz_USCOREvalueInputParams(soap, NULL, NULL, "ns1:base_z_valueInputParams");
	case SOAP_TYPE_ns1__base_USCOREcounterInputParams:
		return soap_in_ns1__base_USCOREcounterInputParams(soap, NULL, NULL, "ns1:base_counterInputParams");
	case SOAP_TYPE_ns1__B1InputParams:
		return soap_in_ns1__B1InputParams(soap, NULL, NULL, "ns1:B1InputParams");
	case SOAP_TYPE_ns1__cgrInputParams:
		return soap_in_ns1__cgrInputParams(soap, NULL, NULL, "ns1:cgrInputParams");
	case SOAP_TYPE_ns1__dinucInputParams:
		return soap_in_ns1__dinucInputParams(soap, NULL, NULL, "ns1:dinucInputParams");
	case SOAP_TYPE_ns1__caiInputParams:
		return soap_in_ns1__caiInputParams(soap, NULL, NULL, "ns1:caiInputParams");
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams:
		return soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, NULL, NULL, "ns1:filter_cds_by_atgInputParams");
	case SOAP_TYPE_ns1__gcsiInputParams:
		return soap_in_ns1__gcsiInputParams(soap, NULL, NULL, "ns1:gcsiInputParams");
	case SOAP_TYPE_ns1__query_USCOREstrandInputParams:
		return soap_in_ns1__query_USCOREstrandInputParams(soap, NULL, NULL, "ns1:query_strandInputParams");
	case SOAP_TYPE_ns1__genomicskewInputParams:
		return soap_in_ns1__genomicskewInputParams(soap, NULL, NULL, "ns1:genomicskewInputParams");
	case SOAP_TYPE_ns1__palindromeInputParams:
		return soap_in_ns1__palindromeInputParams(soap, NULL, NULL, "ns1:palindromeInputParams");
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams:
		return soap_in_ns1__base_USCORErelative_USCOREentropyInputParams(soap, NULL, NULL, "ns1:base_relative_entropyInputParams");
	case SOAP_TYPE_ns1__view_USCOREcdsInputParams:
		return soap_in_ns1__view_USCOREcdsInputParams(soap, NULL, NULL, "ns1:view_cdsInputParams");
	case SOAP_TYPE_ns1__codon_USCOREcounterInputParams:
		return soap_in_ns1__codon_USCOREcounterInputParams(soap, NULL, NULL, "ns1:codon_counterInputParams");
	case SOAP_TYPE_ns1__EwInputParams:
		return soap_in_ns1__EwInputParams(soap, NULL, NULL, "ns1:EwInputParams");
	case SOAP_TYPE_ns1__find_USCOREiteronInputParams:
		return soap_in_ns1__find_USCOREiteronInputParams(soap, NULL, NULL, "ns1:find_iteronInputParams");
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams:
		return soap_in_ns1__over_USCORElapping_USCOREfinderInputParams(soap, NULL, NULL, "ns1:over_lapping_finderInputParams");
	case SOAP_TYPE_ns1__codon_USCOREcompilerInputParams:
		return soap_in_ns1__codon_USCOREcompilerInputParams(soap, NULL, NULL, "ns1:codon_compilerInputParams");
	case SOAP_TYPE_ns1__aauiInputParams:
		return soap_in_ns1__aauiInputParams(soap, NULL, NULL, "ns1:aauiInputParams");
	case SOAP_TYPE_ns1__amino_USCOREcounterInputParams:
		return soap_in_ns1__amino_USCOREcounterInputParams(soap, NULL, NULL, "ns1:amino_counterInputParams");
	case SOAP_TYPE_ns1__seq2pngInputParams:
		return soap_in_ns1__seq2pngInputParams(soap, NULL, NULL, "ns1:seq2pngInputParams");
	case SOAP_TYPE_ns1__ttestInputParams:
		return soap_in_ns1__ttestInputParams(soap, NULL, NULL, "ns1:ttestInputParams");
	case SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams:
		return soap_in_ns1__find_USCOREdnaAboxInputParams(soap, NULL, NULL, "ns1:find_dnaAboxInputParams");
	case SOAP_TYPE_ns1__codon_USCOREusageInputParams:
		return soap_in_ns1__codon_USCOREusageInputParams(soap, NULL, NULL, "ns1:codon_usageInputParams");
	case SOAP_TYPE_ns1__buiInputParams:
		return soap_in_ns1__buiInputParams(soap, NULL, NULL, "ns1:buiInputParams");
	case SOAP_TYPE_ns1__fopInputParams:
		return soap_in_ns1__fopInputParams(soap, NULL, NULL, "ns1:fopInputParams");
	case SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams:
		return soap_in_ns1__oligomer_USCOREcounterInputParams(soap, NULL, NULL, "ns1:oligomer_counterInputParams");
	case SOAP_TYPE_ns1__encInputParams:
		return soap_in_ns1__encInputParams(soap, NULL, NULL, "ns1:encInputParams");
	case SOAP_TYPE_ns1__icdiInputParams:
		return soap_in_ns1__icdiInputParams(soap, NULL, NULL, "ns1:icdiInputParams");
	case SOAP_TYPE_ns1__gcwinInputParams:
		return soap_in_ns1__gcwinInputParams(soap, NULL, NULL, "ns1:gcwinInputParams");
	case SOAP_TYPE_ns1__find_USCOREpatternInputParams:
		return soap_in_ns1__find_USCOREpatternInputParams(soap, NULL, NULL, "ns1:find_patternInputParams");
	case SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams:
		return soap_in_ns1__oligomer_USCOREsearchInputParams(soap, NULL, NULL, "ns1:oligomer_searchInputParams");
	case SOAP_TYPE_ns1__phxInputParams:
		return soap_in_ns1__phxInputParams(soap, NULL, NULL, "ns1:phxInputParams");
	case SOAP_TYPE_ns1__shuffleseqInputParams:
		return soap_in_ns1__shuffleseqInputParams(soap, NULL, NULL, "ns1:shuffleseqInputParams");
	case SOAP_TYPE_ns1__find_USCOREterInputParams:
		return soap_in_ns1__find_USCOREterInputParams(soap, NULL, NULL, "ns1:find_terInputParams");
	case SOAP_TYPE_ns1__dnawalkInputParams:
		return soap_in_ns1__dnawalkInputParams(soap, NULL, NULL, "ns1:dnawalkInputParams");
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams:
		return soap_in_ns1__base_USCOREinformation_USCOREcontentInputParams(soap, NULL, NULL, "ns1:base_information_contentInputParams");
	case SOAP_TYPE_ns1__togoWSInputParams:
		return soap_in_ns1__togoWSInputParams(soap, NULL, NULL, "ns1:togoWSInputParams");
	case SOAP_TYPE_ns1__genome_USCOREmap3InputParams:
		return soap_in_ns1__genome_USCOREmap3InputParams(soap, NULL, NULL, "ns1:genome_map3InputParams");
	case SOAP_TYPE_ns1__gcskewInputParams:
		return soap_in_ns1__gcskewInputParams(soap, NULL, NULL, "ns1:gcskewInputParams");
	case SOAP_TYPE_ns1__circular_USCOREmapInputParams:
		return soap_in_ns1__circular_USCOREmapInputParams(soap, NULL, NULL, "ns1:circular_mapInputParams");
	case SOAP_TYPE_ns1__molecular_USCOREweightInputParams:
		return soap_in_ns1__molecular_USCOREweightInputParams(soap, NULL, NULL, "ns1:molecular_weightInputParams");
	case SOAP_TYPE_ns1__delta_USCOREgcskewInputParams:
		return soap_in_ns1__delta_USCOREgcskewInputParams(soap, NULL, NULL, "ns1:delta_gcskewInputParams");
	case SOAP_TYPE_ns1__corInputParams:
		return soap_in_ns1__corInputParams(soap, NULL, NULL, "ns1:corInputParams");
	case SOAP_TYPE_ns1__geneskewInputParams:
		return soap_in_ns1__geneskewInputParams(soap, NULL, NULL, "ns1:geneskewInputParams");
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriInputParams:
		return soap_in_ns1__genes_USCOREfrom_USCOREoriInputParams(soap, NULL, NULL, "ns1:genes_from_oriInputParams");
	case SOAP_TYPE_ns1__cbiInputParams:
		return soap_in_ns1__cbiInputParams(soap, NULL, NULL, "ns1:cbiInputParams");
	case SOAP_TYPE_ns1__find_USCOREdifInputParams:
		return soap_in_ns1__find_USCOREdifInputParams(soap, NULL, NULL, "ns1:find_difInputParams");
	case SOAP_TYPE_ns1__to_USCOREfastaInputParams:
		return soap_in_ns1__to_USCOREfastaInputParams(soap, NULL, NULL, "ns1:to_fastaInputParams");
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicityInputParams:
		return soap_in_ns1__nucleotide_USCOREperiodicityInputParams(soap, NULL, NULL, "ns1:nucleotide_periodicityInputParams");
	case SOAP_TYPE_ns1__base_USCOREentropyInputParams:
		return soap_in_ns1__base_USCOREentropyInputParams(soap, NULL, NULL, "ns1:base_entropyInputParams");
	case SOAP_TYPE_ns1__plasmid_USCOREmapInputParams:
		return soap_in_ns1__plasmid_USCOREmapInputParams(soap, NULL, NULL, "ns1:plasmid_mapInputParams");
	case SOAP_TYPE_ns1__DoubleHelixInputParams:
		return soap_in_ns1__DoubleHelixInputParams(soap, NULL, NULL, "ns1:DoubleHelixInputParams");
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREterInputParams:
		return soap_in_ns1__rep_USCOREori_USCOREterInputParams(soap, NULL, NULL, "ns1:rep_ori_terInputParams");
	case SOAP_TYPE_ns1__genome_USCOREmapInputParams:
		return soap_in_ns1__genome_USCOREmapInputParams(soap, NULL, NULL, "ns1:genome_mapInputParams");
	case SOAP_TYPE_ns1__consensus_USCOREzInputParams:
		return soap_in_ns1__consensus_USCOREzInputParams(soap, NULL, NULL, "ns1:consensus_zInputParams");
	case SOAP_TYPE_ns1__find_USCOREori_USCOREterInputParams:
		return soap_in_ns1__find_USCOREori_USCOREterInputParams(soap, NULL, NULL, "ns1:find_ori_terInputParams");
	case SOAP_TYPE_ns1__w_USCOREvalueInputParams:
		return soap_in_ns1__w_USCOREvalueInputParams(soap, NULL, NULL, "ns1:w_valueInputParams");
	case SOAP_TYPE_ns1__P2InputParams:
		return soap_in_ns1__P2InputParams(soap, NULL, NULL, "ns1:P2InputParams");
	case SOAP_TYPE_ns1__codon_USCOREmvaInputParams:
		return soap_in_ns1__codon_USCOREmvaInputParams(soap, NULL, NULL, "ns1:codon_mvaInputParams");
	case SOAP_TYPE_ns1__Definition:
		return soap_in_ns1__Definition(soap, NULL, NULL, "ns1:Definition");
	case SOAP_TYPE_PointerTofloat:
		return soap_in_PointerTofloat(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_PointerTons1__S_USCOREvalueInputParams:
		return soap_in_PointerTons1__S_USCOREvalueInputParams(soap, NULL, NULL, "ns1:S_valueInputParams");
	case SOAP_TYPE_PointerTons1__leading_USCOREstrandResponse:
		return soap_in_PointerTons1__leading_USCOREstrandResponse(soap, NULL, NULL, "ns1:leading_strandResponse");
	case SOAP_TYPE_PointerTons1__scsInputParams:
		return soap_in_PointerTons1__scsInputParams(soap, NULL, NULL, "ns1:scsInputParams");
	case SOAP_TYPE_PointerTons1__lda_USCOREbiasInputParams:
		return soap_in_PointerTons1__lda_USCOREbiasInputParams(soap, NULL, NULL, "ns1:lda_biasInputParams");
	case SOAP_TYPE_PointerTons1__kmer_USCOREtableInputParams:
		return soap_in_PointerTons1__kmer_USCOREtableInputParams(soap, NULL, NULL, "ns1:kmer_tableInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREz_USCOREvalueInputParams:
		return soap_in_PointerTons1__base_USCOREz_USCOREvalueInputParams(soap, NULL, NULL, "ns1:base_z_valueInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREcounterInputParams:
		return soap_in_PointerTons1__base_USCOREcounterInputParams(soap, NULL, NULL, "ns1:base_counterInputParams");
	case SOAP_TYPE_PointerTons1__B1InputParams:
		return soap_in_PointerTons1__B1InputParams(soap, NULL, NULL, "ns1:B1InputParams");
	case SOAP_TYPE_PointerTons1__cgrInputParams:
		return soap_in_PointerTons1__cgrInputParams(soap, NULL, NULL, "ns1:cgrInputParams");
	case SOAP_TYPE_PointerTons1__dinucInputParams:
		return soap_in_PointerTons1__dinucInputParams(soap, NULL, NULL, "ns1:dinucInputParams");
	case SOAP_TYPE_PointerTons1__least_USCOREsquares_USCOREfitResponse:
		return soap_in_PointerTons1__least_USCOREsquares_USCOREfitResponse(soap, NULL, NULL, "ns1:least_squares_fitResponse");
	case SOAP_TYPE_PointerTons1__palindromeInputParams:
		return soap_in_PointerTons1__palindromeInputParams(soap, NULL, NULL, "ns1:palindromeInputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREcounterInputParams:
		return soap_in_PointerTons1__codon_USCOREcounterInputParams(soap, NULL, NULL, "ns1:codon_counterInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREiteronInputParams:
		return soap_in_PointerTons1__find_USCOREiteronInputParams(soap, NULL, NULL, "ns1:find_iteronInputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREusageInputParams:
		return soap_in_PointerTons1__codon_USCOREusageInputParams(soap, NULL, NULL, "ns1:codon_usageInputParams");
	case SOAP_TYPE_PointerTons1__oligomer_USCOREcounterInputParams:
		return soap_in_PointerTons1__oligomer_USCOREcounterInputParams(soap, NULL, NULL, "ns1:oligomer_counterInputParams");
	case SOAP_TYPE_PointerTons1__gcwinInputParams:
		return soap_in_PointerTons1__gcwinInputParams(soap, NULL, NULL, "ns1:gcwinInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREpatternInputParams:
		return soap_in_PointerTons1__find_USCOREpatternInputParams(soap, NULL, NULL, "ns1:find_patternInputParams");
	case SOAP_TYPE_PointerTons1__oligomer_USCOREsearchResponse:
		return soap_in_PointerTons1__oligomer_USCOREsearchResponse(soap, NULL, NULL, "ns1:oligomer_searchResponse");
	case SOAP_TYPE_PointerTons1__oligomer_USCOREsearchInputParams:
		return soap_in_PointerTons1__oligomer_USCOREsearchInputParams(soap, NULL, NULL, "ns1:oligomer_searchInputParams");
	case SOAP_TYPE_PointerTons1__shuffleseqInputParams:
		return soap_in_PointerTons1__shuffleseqInputParams(soap, NULL, NULL, "ns1:shuffleseqInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREterResponse:
		return soap_in_PointerTons1__find_USCOREterResponse(soap, NULL, NULL, "ns1:find_terResponse");
	case SOAP_TYPE_PointerTons1__find_USCOREterInputParams:
		return soap_in_PointerTons1__find_USCOREterInputParams(soap, NULL, NULL, "ns1:find_terInputParams");
	case SOAP_TYPE_PointerTons1__dnawalkInputParams:
		return soap_in_PointerTons1__dnawalkInputParams(soap, NULL, NULL, "ns1:dnawalkInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREinformation_USCOREcontentInputParams:
		return soap_in_PointerTons1__base_USCOREinformation_USCOREcontentInputParams(soap, NULL, NULL, "ns1:base_information_contentInputParams");
	case SOAP_TYPE_PointerTons1__signatureInputParams:
		return soap_in_PointerTons1__signatureInputParams(soap, NULL, NULL, "ns1:signatureInputParams");
	case SOAP_TYPE_PointerTons1__genome_USCOREmap3InputParams:
		return soap_in_PointerTons1__genome_USCOREmap3InputParams(soap, NULL, NULL, "ns1:genome_map3InputParams");
	case SOAP_TYPE_PointerTons1__gcskewInputParams:
		return soap_in_PointerTons1__gcskewInputParams(soap, NULL, NULL, "ns1:gcskewInputParams");
	case SOAP_TYPE_PointerTons1__molecular_USCOREweightInputParams:
		return soap_in_PointerTons1__molecular_USCOREweightInputParams(soap, NULL, NULL, "ns1:molecular_weightInputParams");
	case SOAP_TYPE_PointerTons1__delta_USCOREgcskewInputParams:
		return soap_in_PointerTons1__delta_USCOREgcskewInputParams(soap, NULL, NULL, "ns1:delta_gcskewInputParams");
	case SOAP_TYPE_PointerTons1__cumulativeResponse:
		return soap_in_PointerTons1__cumulativeResponse(soap, NULL, NULL, "ns1:cumulativeResponse");
	case SOAP_TYPE_PointerTons1__corResponse:
		return soap_in_PointerTons1__corResponse(soap, NULL, NULL, "ns1:corResponse");
	case SOAP_TYPE_PointerTons1__corInputParams:
		return soap_in_PointerTons1__corInputParams(soap, NULL, NULL, "ns1:corInputParams");
	case SOAP_TYPE_PointerTons1__geneskewInputParams:
		return soap_in_PointerTons1__geneskewInputParams(soap, NULL, NULL, "ns1:geneskewInputParams");
	case SOAP_TYPE_PointerTons1__genes_USCOREfrom_USCOREoriResponse:
		return soap_in_PointerTons1__genes_USCOREfrom_USCOREoriResponse(soap, NULL, NULL, "ns1:genes_from_oriResponse");
	case SOAP_TYPE_PointerTons1__genes_USCOREfrom_USCOREoriInputParams:
		return soap_in_PointerTons1__genes_USCOREfrom_USCOREoriInputParams(soap, NULL, NULL, "ns1:genes_from_oriInputParams");
	case SOAP_TYPE_PointerTons1__cbiInputParams:
		return soap_in_PointerTons1__cbiInputParams(soap, NULL, NULL, "ns1:cbiInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREdifResponse:
		return soap_in_PointerTons1__find_USCOREdifResponse(soap, NULL, NULL, "ns1:find_difResponse");
	case SOAP_TYPE_PointerTons1__find_USCOREdifInputParams:
		return soap_in_PointerTons1__find_USCOREdifInputParams(soap, NULL, NULL, "ns1:find_difInputParams");
	case SOAP_TYPE_PointerTons1__to_USCOREfastaInputParams:
		return soap_in_PointerTons1__to_USCOREfastaInputParams(soap, NULL, NULL, "ns1:to_fastaInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREentropyInputParams:
		return soap_in_PointerTons1__base_USCOREentropyInputParams(soap, NULL, NULL, "ns1:base_entropyInputParams");
	case SOAP_TYPE_PointerTons1__DoubleHelixInputParams:
		return soap_in_PointerTons1__DoubleHelixInputParams(soap, NULL, NULL, "ns1:DoubleHelixInputParams");
	case SOAP_TYPE_PointerTons1__rep_USCOREori_USCOREterInputParams:
		return soap_in_PointerTons1__rep_USCOREori_USCOREterInputParams(soap, NULL, NULL, "ns1:rep_ori_terInputParams");
	case SOAP_TYPE_PointerTons1__genome_USCOREmapInputParams:
		return soap_in_PointerTons1__genome_USCOREmapInputParams(soap, NULL, NULL, "ns1:genome_mapInputParams");
	case SOAP_TYPE_PointerTons1__consensus_USCOREzInputParams:
		return soap_in_PointerTons1__consensus_USCOREzInputParams(soap, NULL, NULL, "ns1:consensus_zInputParams");
	case SOAP_TYPE_PointerTons1__caiInputParams:
		return soap_in_PointerTons1__caiInputParams(soap, NULL, NULL, "ns1:caiInputParams");
	case SOAP_TYPE_PointerTons1__gcsiInputParams:
		return soap_in_PointerTons1__gcsiInputParams(soap, NULL, NULL, "ns1:gcsiInputParams");
	case SOAP_TYPE_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgResponse:
		return soap_in_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, NULL, NULL, "ns1:filter_cds_by_atgResponse");
	case SOAP_TYPE_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams:
		return soap_in_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, NULL, NULL, "ns1:filter_cds_by_atgInputParams");
	case SOAP_TYPE_PointerTons1__genomicskewInputParams:
		return soap_in_PointerTons1__genomicskewInputParams(soap, NULL, NULL, "ns1:genomicskewInputParams");
	case SOAP_TYPE_PointerTons1__query_USCOREstrandInputParams:
		return soap_in_PointerTons1__query_USCOREstrandInputParams(soap, NULL, NULL, "ns1:query_strandInputParams");
	case SOAP_TYPE_PointerTons1__view_USCOREcdsInputParams:
		return soap_in_PointerTons1__view_USCOREcdsInputParams(soap, NULL, NULL, "ns1:view_cdsInputParams");
	case SOAP_TYPE_PointerTons1__base_USCORErelative_USCOREentropyInputParams:
		return soap_in_PointerTons1__base_USCORErelative_USCOREentropyInputParams(soap, NULL, NULL, "ns1:base_relative_entropyInputParams");
	case SOAP_TYPE_PointerTons1__EwInputParams:
		return soap_in_PointerTons1__EwInputParams(soap, NULL, NULL, "ns1:EwInputParams");
	case SOAP_TYPE_PointerTons1__over_USCORElapping_USCOREfinderInputParams:
		return soap_in_PointerTons1__over_USCORElapping_USCOREfinderInputParams(soap, NULL, NULL, "ns1:over_lapping_finderInputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREcompilerInputParams:
		return soap_in_PointerTons1__codon_USCOREcompilerInputParams(soap, NULL, NULL, "ns1:codon_compilerInputParams");
	case SOAP_TYPE_PointerTons1__aauiInputParams:
		return soap_in_PointerTons1__aauiInputParams(soap, NULL, NULL, "ns1:aauiInputParams");
	case SOAP_TYPE_PointerTons1__amino_USCOREcounterInputParams:
		return soap_in_PointerTons1__amino_USCOREcounterInputParams(soap, NULL, NULL, "ns1:amino_counterInputParams");
	case SOAP_TYPE_PointerTons1__seq2pngInputParams:
		return soap_in_PointerTons1__seq2pngInputParams(soap, NULL, NULL, "ns1:seq2pngInputParams");
	case SOAP_TYPE_PointerTons1__ttestResponse:
		return soap_in_PointerTons1__ttestResponse(soap, NULL, NULL, "ns1:ttestResponse");
	case SOAP_TYPE_PointerTons1__ttestInputParams:
		return soap_in_PointerTons1__ttestInputParams(soap, NULL, NULL, "ns1:ttestInputParams");
	case SOAP_TYPE_PointerToarrayOut:
		return soap_in_PointerToarrayOut(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTons1__find_USCOREdnaAboxInputParams:
		return soap_in_PointerTons1__find_USCOREdnaAboxInputParams(soap, NULL, NULL, "ns1:find_dnaAboxInputParams");
	case SOAP_TYPE_PointerTons1__buiInputParams:
		return soap_in_PointerTons1__buiInputParams(soap, NULL, NULL, "ns1:buiInputParams");
	case SOAP_TYPE_PointerTons1__fopInputParams:
		return soap_in_PointerTons1__fopInputParams(soap, NULL, NULL, "ns1:fopInputParams");
	case SOAP_TYPE_PointerTons1__encInputParams:
		return soap_in_PointerTons1__encInputParams(soap, NULL, NULL, "ns1:encInputParams");
	case SOAP_TYPE_PointerTons1__icdiInputParams:
		return soap_in_PointerTons1__icdiInputParams(soap, NULL, NULL, "ns1:icdiInputParams");
	case SOAP_TYPE_PointerTons1__phxInputParams:
		return soap_in_PointerTons1__phxInputParams(soap, NULL, NULL, "ns1:phxInputParams");
	case SOAP_TYPE_PointerTons1__togoWSInputParams:
		return soap_in_PointerTons1__togoWSInputParams(soap, NULL, NULL, "ns1:togoWSInputParams");
	case SOAP_TYPE_PointerTons1__circular_USCOREmapInputParams:
		return soap_in_PointerTons1__circular_USCOREmapInputParams(soap, NULL, NULL, "ns1:circular_mapInputParams");
	case SOAP_TYPE_PointerTons1__nucleotide_USCOREperiodicityInputParams:
		return soap_in_PointerTons1__nucleotide_USCOREperiodicityInputParams(soap, NULL, NULL, "ns1:nucleotide_periodicityInputParams");
	case SOAP_TYPE_PointerTons1__plasmid_USCOREmapInputParams:
		return soap_in_PointerTons1__plasmid_USCOREmapInputParams(soap, NULL, NULL, "ns1:plasmid_mapInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREori_USCOREterInputParams:
		return soap_in_PointerTons1__find_USCOREori_USCOREterInputParams(soap, NULL, NULL, "ns1:find_ori_terInputParams");
	case SOAP_TYPE_PointerToarrayIn:
		return soap_in_PointerToarrayIn(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTons1__w_USCOREvalueInputParams:
		return soap_in_PointerTons1__w_USCOREvalueInputParams(soap, NULL, NULL, "ns1:w_valueInputParams");
	case SOAP_TYPE_PointerTons1__P2InputParams:
		return soap_in_PointerTons1__P2InputParams(soap, NULL, NULL, "ns1:P2InputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREmvaInputParams:
		return soap_in_PointerTons1__codon_USCOREmvaInputParams(soap, NULL, NULL, "ns1:codon_mvaInputParams");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:hydropathy"))
		{	*type = SOAP_TYPE_ns1__hydropathy;
			return soap_in_ns1__hydropathy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:hydropathyResponse"))
		{	*type = SOAP_TYPE_ns1__hydropathyResponse;
			return soap_in_ns1__hydropathyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:help"))
		{	*type = SOAP_TYPE_ns1__help;
			return soap_in_ns1__help(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:helpResponse"))
		{	*type = SOAP_TYPE_ns1__helpResponse;
			return soap_in_ns1__helpResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:S_value"))
		{	*type = SOAP_TYPE_ns1__S_USCOREvalue;
			return soap_in_ns1__S_USCOREvalue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:S_valueResponse"))
		{	*type = SOAP_TYPE_ns1__S_USCOREvalueResponse;
			return soap_in_ns1__S_USCOREvalueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:leading_strand"))
		{	*type = SOAP_TYPE_ns1__leading_USCOREstrand;
			return soap_in_ns1__leading_USCOREstrand(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:leading_strandResponse"))
		{	*type = SOAP_TYPE_ns1__leading_USCOREstrandResponse;
			return soap_in_ns1__leading_USCOREstrandResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:scs"))
		{	*type = SOAP_TYPE_ns1__scs;
			return soap_in_ns1__scs(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:scsResponse"))
		{	*type = SOAP_TYPE_ns1__scsResponse;
			return soap_in_ns1__scsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lda_bias"))
		{	*type = SOAP_TYPE_ns1__lda_USCOREbias;
			return soap_in_ns1__lda_USCOREbias(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lda_biasResponse"))
		{	*type = SOAP_TYPE_ns1__lda_USCOREbiasResponse;
			return soap_in_ns1__lda_USCOREbiasResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:kmer_table"))
		{	*type = SOAP_TYPE_ns1__kmer_USCOREtable;
			return soap_in_ns1__kmer_USCOREtable(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:kmer_tableResponse"))
		{	*type = SOAP_TYPE_ns1__kmer_USCOREtableResponse;
			return soap_in_ns1__kmer_USCOREtableResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_z_value"))
		{	*type = SOAP_TYPE_ns1__base_USCOREz_USCOREvalue;
			return soap_in_ns1__base_USCOREz_USCOREvalue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_z_valueResponse"))
		{	*type = SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse;
			return soap_in_ns1__base_USCOREz_USCOREvalueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_counter"))
		{	*type = SOAP_TYPE_ns1__base_USCOREcounter;
			return soap_in_ns1__base_USCOREcounter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_counterResponse"))
		{	*type = SOAP_TYPE_ns1__base_USCOREcounterResponse;
			return soap_in_ns1__base_USCOREcounterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:B2"))
		{	*type = SOAP_TYPE_ns1__B2;
			return soap_in_ns1__B2(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:B2Response"))
		{	*type = SOAP_TYPE_ns1__B2Response;
			return soap_in_ns1__B2Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:B1"))
		{	*type = SOAP_TYPE_ns1__B1;
			return soap_in_ns1__B1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:B1Response"))
		{	*type = SOAP_TYPE_ns1__B1Response;
			return soap_in_ns1__B1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cgr"))
		{	*type = SOAP_TYPE_ns1__cgr;
			return soap_in_ns1__cgr(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cgrResponse"))
		{	*type = SOAP_TYPE_ns1__cgrResponse;
			return soap_in_ns1__cgrResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dinuc"))
		{	*type = SOAP_TYPE_ns1__dinuc;
			return soap_in_ns1__dinuc(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dinucResponse"))
		{	*type = SOAP_TYPE_ns1__dinucResponse;
			return soap_in_ns1__dinucResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:least_squares_fit"))
		{	*type = SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit;
			return soap_in_ns1__least_USCOREsquares_USCOREfit(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:least_squares_fitResponse"))
		{	*type = SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse;
			return soap_in_ns1__least_USCOREsquares_USCOREfitResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:palindrome"))
		{	*type = SOAP_TYPE_ns1__palindrome;
			return soap_in_ns1__palindrome(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:palindromeResponse"))
		{	*type = SOAP_TYPE_ns1__palindromeResponse;
			return soap_in_ns1__palindromeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:entrez"))
		{	*type = SOAP_TYPE_ns1__entrez;
			return soap_in_ns1__entrez(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:entrezResponse"))
		{	*type = SOAP_TYPE_ns1__entrezResponse;
			return soap_in_ns1__entrezResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_counter"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREcounter;
			return soap_in_ns1__codon_USCOREcounter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_counterResponse"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREcounterResponse;
			return soap_in_ns1__codon_USCOREcounterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mean"))
		{	*type = SOAP_TYPE_ns1__mean;
			return soap_in_ns1__mean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:meanResponse"))
		{	*type = SOAP_TYPE_ns1__meanResponse;
			return soap_in_ns1__meanResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:complement"))
		{	*type = SOAP_TYPE_ns1__complement;
			return soap_in_ns1__complement(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:complementResponse"))
		{	*type = SOAP_TYPE_ns1__complementResponse;
			return soap_in_ns1__complementResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_iteron"))
		{	*type = SOAP_TYPE_ns1__find_USCOREiteron;
			return soap_in_ns1__find_USCOREiteron(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_iteronResponse"))
		{	*type = SOAP_TYPE_ns1__find_USCOREiteronResponse;
			return soap_in_ns1__find_USCOREiteronResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:min"))
		{	*type = SOAP_TYPE_ns1__min;
			return soap_in_ns1__min(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:minResponse"))
		{	*type = SOAP_TYPE_ns1__minResponse;
			return soap_in_ns1__minResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_usage"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREusage;
			return soap_in_ns1__codon_USCOREusage(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_usageResponse"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREusageResponse;
			return soap_in_ns1__codon_USCOREusageResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:oligomer_counter"))
		{	*type = SOAP_TYPE_ns1__oligomer_USCOREcounter;
			return soap_in_ns1__oligomer_USCOREcounter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:oligomer_counterResponse"))
		{	*type = SOAP_TYPE_ns1__oligomer_USCOREcounterResponse;
			return soap_in_ns1__oligomer_USCOREcounterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcwin"))
		{	*type = SOAP_TYPE_ns1__gcwin;
			return soap_in_ns1__gcwin(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcwinResponse"))
		{	*type = SOAP_TYPE_ns1__gcwinResponse;
			return soap_in_ns1__gcwinResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_pattern"))
		{	*type = SOAP_TYPE_ns1__find_USCOREpattern;
			return soap_in_ns1__find_USCOREpattern(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_patternResponse"))
		{	*type = SOAP_TYPE_ns1__find_USCOREpatternResponse;
			return soap_in_ns1__find_USCOREpatternResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:oligomer_search"))
		{	*type = SOAP_TYPE_ns1__oligomer_USCOREsearch;
			return soap_in_ns1__oligomer_USCOREsearch(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:oligomer_searchResponse"))
		{	*type = SOAP_TYPE_ns1__oligomer_USCOREsearchResponse;
			return soap_in_ns1__oligomer_USCOREsearchResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:shuffleseq"))
		{	*type = SOAP_TYPE_ns1__shuffleseq;
			return soap_in_ns1__shuffleseq(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:shuffleseqResponse"))
		{	*type = SOAP_TYPE_ns1__shuffleseqResponse;
			return soap_in_ns1__shuffleseqResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_ter"))
		{	*type = SOAP_TYPE_ns1__find_USCOREter;
			return soap_in_ns1__find_USCOREter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_terResponse"))
		{	*type = SOAP_TYPE_ns1__find_USCOREterResponse;
			return soap_in_ns1__find_USCOREterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dnawalk"))
		{	*type = SOAP_TYPE_ns1__dnawalk;
			return soap_in_ns1__dnawalk(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dnawalkResponse"))
		{	*type = SOAP_TYPE_ns1__dnawalkResponse;
			return soap_in_ns1__dnawalkResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_information_content"))
		{	*type = SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent;
			return soap_in_ns1__base_USCOREinformation_USCOREcontent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_information_contentResponse"))
		{	*type = SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse;
			return soap_in_ns1__base_USCOREinformation_USCOREcontentResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:signature"))
		{	*type = SOAP_TYPE_ns1__signature;
			return soap_in_ns1__signature(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:signatureResponse"))
		{	*type = SOAP_TYPE_ns1__signatureResponse;
			return soap_in_ns1__signatureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:seqinfo"))
		{	*type = SOAP_TYPE_ns1__seqinfo;
			return soap_in_ns1__seqinfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:seqinfoResponse"))
		{	*type = SOAP_TYPE_ns1__seqinfoResponse;
			return soap_in_ns1__seqinfoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genome_map3"))
		{	*type = SOAP_TYPE_ns1__genome_USCOREmap3;
			return soap_in_ns1__genome_USCOREmap3(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genome_map3Response"))
		{	*type = SOAP_TYPE_ns1__genome_USCOREmap3Response;
			return soap_in_ns1__genome_USCOREmap3Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcskew"))
		{	*type = SOAP_TYPE_ns1__gcskew;
			return soap_in_ns1__gcskew(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcskewResponse"))
		{	*type = SOAP_TYPE_ns1__gcskewResponse;
			return soap_in_ns1__gcskewResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:molecular_weight"))
		{	*type = SOAP_TYPE_ns1__molecular_USCOREweight;
			return soap_in_ns1__molecular_USCOREweight(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:molecular_weightResponse"))
		{	*type = SOAP_TYPE_ns1__molecular_USCOREweightResponse;
			return soap_in_ns1__molecular_USCOREweightResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:delta_gcskew"))
		{	*type = SOAP_TYPE_ns1__delta_USCOREgcskew;
			return soap_in_ns1__delta_USCOREgcskew(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:delta_gcskewResponse"))
		{	*type = SOAP_TYPE_ns1__delta_USCOREgcskewResponse;
			return soap_in_ns1__delta_USCOREgcskewResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:delta_enc"))
		{	*type = SOAP_TYPE_ns1__delta_USCOREenc;
			return soap_in_ns1__delta_USCOREenc(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:delta_encResponse"))
		{	*type = SOAP_TYPE_ns1__delta_USCOREencResponse;
			return soap_in_ns1__delta_USCOREencResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cumulative"))
		{	*type = SOAP_TYPE_ns1__cumulative;
			return soap_in_ns1__cumulative(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cumulativeResponse"))
		{	*type = SOAP_TYPE_ns1__cumulativeResponse;
			return soap_in_ns1__cumulativeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cor"))
		{	*type = SOAP_TYPE_ns1__cor;
			return soap_in_ns1__cor(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:corResponse"))
		{	*type = SOAP_TYPE_ns1__corResponse;
			return soap_in_ns1__corResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:standard_deviation"))
		{	*type = SOAP_TYPE_ns1__standard_USCOREdeviation;
			return soap_in_ns1__standard_USCOREdeviation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:standard_deviationResponse"))
		{	*type = SOAP_TYPE_ns1__standard_USCOREdeviationResponse;
			return soap_in_ns1__standard_USCOREdeviationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:geneskew"))
		{	*type = SOAP_TYPE_ns1__geneskew;
			return soap_in_ns1__geneskew(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:geneskewResponse"))
		{	*type = SOAP_TYPE_ns1__geneskewResponse;
			return soap_in_ns1__geneskewResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genes_from_ori"))
		{	*type = SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori;
			return soap_in_ns1__genes_USCOREfrom_USCOREori(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genes_from_oriResponse"))
		{	*type = SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse;
			return soap_in_ns1__genes_USCOREfrom_USCOREoriResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cbi"))
		{	*type = SOAP_TYPE_ns1__cbi;
			return soap_in_ns1__cbi(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cbiResponse"))
		{	*type = SOAP_TYPE_ns1__cbiResponse;
			return soap_in_ns1__cbiResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_dif"))
		{	*type = SOAP_TYPE_ns1__find_USCOREdif;
			return soap_in_ns1__find_USCOREdif(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_difResponse"))
		{	*type = SOAP_TYPE_ns1__find_USCOREdifResponse;
			return soap_in_ns1__find_USCOREdifResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:to_fasta"))
		{	*type = SOAP_TYPE_ns1__to_USCOREfasta;
			return soap_in_ns1__to_USCOREfasta(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:to_fastaResponse"))
		{	*type = SOAP_TYPE_ns1__to_USCOREfastaResponse;
			return soap_in_ns1__to_USCOREfastaResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_entropy"))
		{	*type = SOAP_TYPE_ns1__base_USCOREentropy;
			return soap_in_ns1__base_USCOREentropy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_entropyResponse"))
		{	*type = SOAP_TYPE_ns1__base_USCOREentropyResponse;
			return soap_in_ns1__base_USCOREentropyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:DoubleHelix"))
		{	*type = SOAP_TYPE_ns1__DoubleHelix;
			return soap_in_ns1__DoubleHelix(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:DoubleHelixResponse"))
		{	*type = SOAP_TYPE_ns1__DoubleHelixResponse;
			return soap_in_ns1__DoubleHelixResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:calc_pI"))
		{	*type = SOAP_TYPE_ns1__calc_USCOREpI;
			return soap_in_ns1__calc_USCOREpI(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:calc_pIResponse"))
		{	*type = SOAP_TYPE_ns1__calc_USCOREpIResponse;
			return soap_in_ns1__calc_USCOREpIResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:rep_ori_ter"))
		{	*type = SOAP_TYPE_ns1__rep_USCOREori_USCOREter;
			return soap_in_ns1__rep_USCOREori_USCOREter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:rep_ori_terResponse"))
		{	*type = SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse;
			return soap_in_ns1__rep_USCOREori_USCOREterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:longest_ORF"))
		{	*type = SOAP_TYPE_ns1__longest_USCOREORF;
			return soap_in_ns1__longest_USCOREORF(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:longest_ORFResponse"))
		{	*type = SOAP_TYPE_ns1__longest_USCOREORFResponse;
			return soap_in_ns1__longest_USCOREORFResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genome_map"))
		{	*type = SOAP_TYPE_ns1__genome_USCOREmap;
			return soap_in_ns1__genome_USCOREmap(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genome_mapResponse"))
		{	*type = SOAP_TYPE_ns1__genome_USCOREmapResponse;
			return soap_in_ns1__genome_USCOREmapResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:consensus_z"))
		{	*type = SOAP_TYPE_ns1__consensus_USCOREz;
			return soap_in_ns1__consensus_USCOREz(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:consensus_zResponse"))
		{	*type = SOAP_TYPE_ns1__consensus_USCOREzResponse;
			return soap_in_ns1__consensus_USCOREzResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mindex"))
		{	*type = SOAP_TYPE_ns1__mindex;
			return soap_in_ns1__mindex(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mindexResponse"))
		{	*type = SOAP_TYPE_ns1__mindexResponse;
			return soap_in_ns1__mindexResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:query_arm"))
		{	*type = SOAP_TYPE_ns1__query_USCOREarm;
			return soap_in_ns1__query_USCOREarm(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:query_armResponse"))
		{	*type = SOAP_TYPE_ns1__query_USCOREarmResponse;
			return soap_in_ns1__query_USCOREarmResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:max"))
		{	*type = SOAP_TYPE_ns1__max;
			return soap_in_ns1__max(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:maxResponse"))
		{	*type = SOAP_TYPE_ns1__maxResponse;
			return soap_in_ns1__maxResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:maxdex"))
		{	*type = SOAP_TYPE_ns1__maxdex;
			return soap_in_ns1__maxdex(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:maxdexResponse"))
		{	*type = SOAP_TYPE_ns1__maxdexResponse;
			return soap_in_ns1__maxdexResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cai"))
		{	*type = SOAP_TYPE_ns1__cai;
			return soap_in_ns1__cai(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:caiResponse"))
		{	*type = SOAP_TYPE_ns1__caiResponse;
			return soap_in_ns1__caiResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcsi"))
		{	*type = SOAP_TYPE_ns1__gcsi;
			return soap_in_ns1__gcsi(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcsiResponse"))
		{	*type = SOAP_TYPE_ns1__gcsiResponse;
			return soap_in_ns1__gcsiResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:filter_cds_by_atg"))
		{	*type = SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg;
			return soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:filter_cds_by_atgResponse"))
		{	*type = SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse;
			return soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genomicskew"))
		{	*type = SOAP_TYPE_ns1__genomicskew;
			return soap_in_ns1__genomicskew(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genomicskewResponse"))
		{	*type = SOAP_TYPE_ns1__genomicskewResponse;
			return soap_in_ns1__genomicskewResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:query_strand"))
		{	*type = SOAP_TYPE_ns1__query_USCOREstrand;
			return soap_in_ns1__query_USCOREstrand(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:query_strandResponse"))
		{	*type = SOAP_TYPE_ns1__query_USCOREstrandResponse;
			return soap_in_ns1__query_USCOREstrandResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:view_cds"))
		{	*type = SOAP_TYPE_ns1__view_USCOREcds;
			return soap_in_ns1__view_USCOREcds(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:view_cdsResponse"))
		{	*type = SOAP_TYPE_ns1__view_USCOREcdsResponse;
			return soap_in_ns1__view_USCOREcdsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_relative_entropy"))
		{	*type = SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy;
			return soap_in_ns1__base_USCORErelative_USCOREentropy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_relative_entropyResponse"))
		{	*type = SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse;
			return soap_in_ns1__base_USCORErelative_USCOREentropyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:Ew"))
		{	*type = SOAP_TYPE_ns1__Ew;
			return soap_in_ns1__Ew(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:EwResponse"))
		{	*type = SOAP_TYPE_ns1__EwResponse;
			return soap_in_ns1__EwResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:over_lapping_finder"))
		{	*type = SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder;
			return soap_in_ns1__over_USCORElapping_USCOREfinder(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:over_lapping_finderResponse"))
		{	*type = SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse;
			return soap_in_ns1__over_USCORElapping_USCOREfinderResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_compiler"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREcompiler;
			return soap_in_ns1__codon_USCOREcompiler(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_compilerResponse"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREcompilerResponse;
			return soap_in_ns1__codon_USCOREcompilerResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:aaui"))
		{	*type = SOAP_TYPE_ns1__aaui;
			return soap_in_ns1__aaui(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:aauiResponse"))
		{	*type = SOAP_TYPE_ns1__aauiResponse;
			return soap_in_ns1__aauiResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:amino_counter"))
		{	*type = SOAP_TYPE_ns1__amino_USCOREcounter;
			return soap_in_ns1__amino_USCOREcounter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:amino_counterResponse"))
		{	*type = SOAP_TYPE_ns1__amino_USCOREcounterResponse;
			return soap_in_ns1__amino_USCOREcounterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:seq2png"))
		{	*type = SOAP_TYPE_ns1__seq2png;
			return soap_in_ns1__seq2png(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:seq2pngResponse"))
		{	*type = SOAP_TYPE_ns1__seq2pngResponse;
			return soap_in_ns1__seq2pngResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ttest"))
		{	*type = SOAP_TYPE_ns1__ttest;
			return soap_in_ns1__ttest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ttestResponse"))
		{	*type = SOAP_TYPE_ns1__ttestResponse;
			return soap_in_ns1__ttestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_dnaAbox"))
		{	*type = SOAP_TYPE_ns1__find_USCOREdnaAbox;
			return soap_in_ns1__find_USCOREdnaAbox(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_dnaAboxResponse"))
		{	*type = SOAP_TYPE_ns1__find_USCOREdnaAboxResponse;
			return soap_in_ns1__find_USCOREdnaAboxResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dist_in_cc"))
		{	*type = SOAP_TYPE_ns1__dist_USCOREin_USCOREcc;
			return soap_in_ns1__dist_USCOREin_USCOREcc(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dist_in_ccResponse"))
		{	*type = SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse;
			return soap_in_ns1__dist_USCOREin_USCOREccResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:bui"))
		{	*type = SOAP_TYPE_ns1__bui;
			return soap_in_ns1__bui(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:buiResponse"))
		{	*type = SOAP_TYPE_ns1__buiResponse;
			return soap_in_ns1__buiResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:fop"))
		{	*type = SOAP_TYPE_ns1__fop;
			return soap_in_ns1__fop(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:fopResponse"))
		{	*type = SOAP_TYPE_ns1__fopResponse;
			return soap_in_ns1__fopResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:enc"))
		{	*type = SOAP_TYPE_ns1__enc;
			return soap_in_ns1__enc(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:encResponse"))
		{	*type = SOAP_TYPE_ns1__encResponse;
			return soap_in_ns1__encResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:icdi"))
		{	*type = SOAP_TYPE_ns1__icdi;
			return soap_in_ns1__icdi(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:icdiResponse"))
		{	*type = SOAP_TYPE_ns1__icdiResponse;
			return soap_in_ns1__icdiResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:phx"))
		{	*type = SOAP_TYPE_ns1__phx;
			return soap_in_ns1__phx(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:phxResponse"))
		{	*type = SOAP_TYPE_ns1__phxResponse;
			return soap_in_ns1__phxResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:translate"))
		{	*type = SOAP_TYPE_ns1__translate;
			return soap_in_ns1__translate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:translateResponse"))
		{	*type = SOAP_TYPE_ns1__translateResponse;
			return soap_in_ns1__translateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:togoWS"))
		{	*type = SOAP_TYPE_ns1__togoWS;
			return soap_in_ns1__togoWS(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:togoWSResponse"))
		{	*type = SOAP_TYPE_ns1__togoWSResponse;
			return soap_in_ns1__togoWSResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:circular_map"))
		{	*type = SOAP_TYPE_ns1__circular_USCOREmap;
			return soap_in_ns1__circular_USCOREmap(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:circular_mapResponse"))
		{	*type = SOAP_TYPE_ns1__circular_USCOREmapResponse;
			return soap_in_ns1__circular_USCOREmapResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:amino_info"))
		{	*type = SOAP_TYPE_ns1__amino_USCOREinfo;
			return soap_in_ns1__amino_USCOREinfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:amino_infoResponse"))
		{	*type = SOAP_TYPE_ns1__amino_USCOREinfoResponse;
			return soap_in_ns1__amino_USCOREinfoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:variance"))
		{	*type = SOAP_TYPE_ns1__variance;
			return soap_in_ns1__variance(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:varianceResponse"))
		{	*type = SOAP_TYPE_ns1__varianceResponse;
			return soap_in_ns1__varianceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:nucleotide_periodicity"))
		{	*type = SOAP_TYPE_ns1__nucleotide_USCOREperiodicity;
			return soap_in_ns1__nucleotide_USCOREperiodicity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:nucleotide_periodicityResponse"))
		{	*type = SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse;
			return soap_in_ns1__nucleotide_USCOREperiodicityResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sum"))
		{	*type = SOAP_TYPE_ns1__sum;
			return soap_in_ns1__sum(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sumResponse"))
		{	*type = SOAP_TYPE_ns1__sumResponse;
			return soap_in_ns1__sumResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:plasmid_map"))
		{	*type = SOAP_TYPE_ns1__plasmid_USCOREmap;
			return soap_in_ns1__plasmid_USCOREmap(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:plasmid_mapResponse"))
		{	*type = SOAP_TYPE_ns1__plasmid_USCOREmapResponse;
			return soap_in_ns1__plasmid_USCOREmapResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_ori_ter"))
		{	*type = SOAP_TYPE_ns1__find_USCOREori_USCOREter;
			return soap_in_ns1__find_USCOREori_USCOREter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_ori_terResponse"))
		{	*type = SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse;
			return soap_in_ns1__find_USCOREori_USCOREterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:median"))
		{	*type = SOAP_TYPE_ns1__median;
			return soap_in_ns1__median(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:medianResponse"))
		{	*type = SOAP_TYPE_ns1__medianResponse;
			return soap_in_ns1__medianResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:splitprintseq"))
		{	*type = SOAP_TYPE_ns1__splitprintseq;
			return soap_in_ns1__splitprintseq(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:splitprintseqResponse"))
		{	*type = SOAP_TYPE_ns1__splitprintseqResponse;
			return soap_in_ns1__splitprintseqResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:w_value"))
		{	*type = SOAP_TYPE_ns1__w_USCOREvalue;
			return soap_in_ns1__w_USCOREvalue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:w_valueResponse"))
		{	*type = SOAP_TYPE_ns1__w_USCOREvalueResponse;
			return soap_in_ns1__w_USCOREvalueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:P2"))
		{	*type = SOAP_TYPE_ns1__P2;
			return soap_in_ns1__P2(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:P2Response"))
		{	*type = SOAP_TYPE_ns1__P2Response;
			return soap_in_ns1__P2Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_mva"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREmva;
			return soap_in_ns1__codon_USCOREmva(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_mvaResponse"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREmvaResponse;
			return soap_in_ns1__codon_USCOREmvaResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_arrayOut;
			return soap_in_arrayOut(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_arrayIn;
			return soap_in_arrayIn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:S_valueInputParams"))
		{	*type = SOAP_TYPE_ns1__S_USCOREvalueInputParams;
			return soap_in_ns1__S_USCOREvalueInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:scsInputParams"))
		{	*type = SOAP_TYPE_ns1__scsInputParams;
			return soap_in_ns1__scsInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:signatureInputParams"))
		{	*type = SOAP_TYPE_ns1__signatureInputParams;
			return soap_in_ns1__signatureInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lda_biasInputParams"))
		{	*type = SOAP_TYPE_ns1__lda_USCOREbiasInputParams;
			return soap_in_ns1__lda_USCOREbiasInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:kmer_tableInputParams"))
		{	*type = SOAP_TYPE_ns1__kmer_USCOREtableInputParams;
			return soap_in_ns1__kmer_USCOREtableInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_z_valueInputParams"))
		{	*type = SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams;
			return soap_in_ns1__base_USCOREz_USCOREvalueInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_counterInputParams"))
		{	*type = SOAP_TYPE_ns1__base_USCOREcounterInputParams;
			return soap_in_ns1__base_USCOREcounterInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:B1InputParams"))
		{	*type = SOAP_TYPE_ns1__B1InputParams;
			return soap_in_ns1__B1InputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cgrInputParams"))
		{	*type = SOAP_TYPE_ns1__cgrInputParams;
			return soap_in_ns1__cgrInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dinucInputParams"))
		{	*type = SOAP_TYPE_ns1__dinucInputParams;
			return soap_in_ns1__dinucInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:caiInputParams"))
		{	*type = SOAP_TYPE_ns1__caiInputParams;
			return soap_in_ns1__caiInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:filter_cds_by_atgInputParams"))
		{	*type = SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams;
			return soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcsiInputParams"))
		{	*type = SOAP_TYPE_ns1__gcsiInputParams;
			return soap_in_ns1__gcsiInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:query_strandInputParams"))
		{	*type = SOAP_TYPE_ns1__query_USCOREstrandInputParams;
			return soap_in_ns1__query_USCOREstrandInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genomicskewInputParams"))
		{	*type = SOAP_TYPE_ns1__genomicskewInputParams;
			return soap_in_ns1__genomicskewInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:palindromeInputParams"))
		{	*type = SOAP_TYPE_ns1__palindromeInputParams;
			return soap_in_ns1__palindromeInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_relative_entropyInputParams"))
		{	*type = SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams;
			return soap_in_ns1__base_USCORErelative_USCOREentropyInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:view_cdsInputParams"))
		{	*type = SOAP_TYPE_ns1__view_USCOREcdsInputParams;
			return soap_in_ns1__view_USCOREcdsInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_counterInputParams"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREcounterInputParams;
			return soap_in_ns1__codon_USCOREcounterInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:EwInputParams"))
		{	*type = SOAP_TYPE_ns1__EwInputParams;
			return soap_in_ns1__EwInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_iteronInputParams"))
		{	*type = SOAP_TYPE_ns1__find_USCOREiteronInputParams;
			return soap_in_ns1__find_USCOREiteronInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:over_lapping_finderInputParams"))
		{	*type = SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams;
			return soap_in_ns1__over_USCORElapping_USCOREfinderInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_compilerInputParams"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREcompilerInputParams;
			return soap_in_ns1__codon_USCOREcompilerInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:aauiInputParams"))
		{	*type = SOAP_TYPE_ns1__aauiInputParams;
			return soap_in_ns1__aauiInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:amino_counterInputParams"))
		{	*type = SOAP_TYPE_ns1__amino_USCOREcounterInputParams;
			return soap_in_ns1__amino_USCOREcounterInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:seq2pngInputParams"))
		{	*type = SOAP_TYPE_ns1__seq2pngInputParams;
			return soap_in_ns1__seq2pngInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ttestInputParams"))
		{	*type = SOAP_TYPE_ns1__ttestInputParams;
			return soap_in_ns1__ttestInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_dnaAboxInputParams"))
		{	*type = SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams;
			return soap_in_ns1__find_USCOREdnaAboxInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_usageInputParams"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREusageInputParams;
			return soap_in_ns1__codon_USCOREusageInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:buiInputParams"))
		{	*type = SOAP_TYPE_ns1__buiInputParams;
			return soap_in_ns1__buiInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:fopInputParams"))
		{	*type = SOAP_TYPE_ns1__fopInputParams;
			return soap_in_ns1__fopInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:oligomer_counterInputParams"))
		{	*type = SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams;
			return soap_in_ns1__oligomer_USCOREcounterInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:encInputParams"))
		{	*type = SOAP_TYPE_ns1__encInputParams;
			return soap_in_ns1__encInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:icdiInputParams"))
		{	*type = SOAP_TYPE_ns1__icdiInputParams;
			return soap_in_ns1__icdiInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcwinInputParams"))
		{	*type = SOAP_TYPE_ns1__gcwinInputParams;
			return soap_in_ns1__gcwinInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_patternInputParams"))
		{	*type = SOAP_TYPE_ns1__find_USCOREpatternInputParams;
			return soap_in_ns1__find_USCOREpatternInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:oligomer_searchInputParams"))
		{	*type = SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams;
			return soap_in_ns1__oligomer_USCOREsearchInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:phxInputParams"))
		{	*type = SOAP_TYPE_ns1__phxInputParams;
			return soap_in_ns1__phxInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:shuffleseqInputParams"))
		{	*type = SOAP_TYPE_ns1__shuffleseqInputParams;
			return soap_in_ns1__shuffleseqInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_terInputParams"))
		{	*type = SOAP_TYPE_ns1__find_USCOREterInputParams;
			return soap_in_ns1__find_USCOREterInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dnawalkInputParams"))
		{	*type = SOAP_TYPE_ns1__dnawalkInputParams;
			return soap_in_ns1__dnawalkInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_information_contentInputParams"))
		{	*type = SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams;
			return soap_in_ns1__base_USCOREinformation_USCOREcontentInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:togoWSInputParams"))
		{	*type = SOAP_TYPE_ns1__togoWSInputParams;
			return soap_in_ns1__togoWSInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genome_map3InputParams"))
		{	*type = SOAP_TYPE_ns1__genome_USCOREmap3InputParams;
			return soap_in_ns1__genome_USCOREmap3InputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:gcskewInputParams"))
		{	*type = SOAP_TYPE_ns1__gcskewInputParams;
			return soap_in_ns1__gcskewInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:circular_mapInputParams"))
		{	*type = SOAP_TYPE_ns1__circular_USCOREmapInputParams;
			return soap_in_ns1__circular_USCOREmapInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:molecular_weightInputParams"))
		{	*type = SOAP_TYPE_ns1__molecular_USCOREweightInputParams;
			return soap_in_ns1__molecular_USCOREweightInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:delta_gcskewInputParams"))
		{	*type = SOAP_TYPE_ns1__delta_USCOREgcskewInputParams;
			return soap_in_ns1__delta_USCOREgcskewInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:corInputParams"))
		{	*type = SOAP_TYPE_ns1__corInputParams;
			return soap_in_ns1__corInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:geneskewInputParams"))
		{	*type = SOAP_TYPE_ns1__geneskewInputParams;
			return soap_in_ns1__geneskewInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genes_from_oriInputParams"))
		{	*type = SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriInputParams;
			return soap_in_ns1__genes_USCOREfrom_USCOREoriInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cbiInputParams"))
		{	*type = SOAP_TYPE_ns1__cbiInputParams;
			return soap_in_ns1__cbiInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_difInputParams"))
		{	*type = SOAP_TYPE_ns1__find_USCOREdifInputParams;
			return soap_in_ns1__find_USCOREdifInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:to_fastaInputParams"))
		{	*type = SOAP_TYPE_ns1__to_USCOREfastaInputParams;
			return soap_in_ns1__to_USCOREfastaInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:nucleotide_periodicityInputParams"))
		{	*type = SOAP_TYPE_ns1__nucleotide_USCOREperiodicityInputParams;
			return soap_in_ns1__nucleotide_USCOREperiodicityInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:base_entropyInputParams"))
		{	*type = SOAP_TYPE_ns1__base_USCOREentropyInputParams;
			return soap_in_ns1__base_USCOREentropyInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:plasmid_mapInputParams"))
		{	*type = SOAP_TYPE_ns1__plasmid_USCOREmapInputParams;
			return soap_in_ns1__plasmid_USCOREmapInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:DoubleHelixInputParams"))
		{	*type = SOAP_TYPE_ns1__DoubleHelixInputParams;
			return soap_in_ns1__DoubleHelixInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:rep_ori_terInputParams"))
		{	*type = SOAP_TYPE_ns1__rep_USCOREori_USCOREterInputParams;
			return soap_in_ns1__rep_USCOREori_USCOREterInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:genome_mapInputParams"))
		{	*type = SOAP_TYPE_ns1__genome_USCOREmapInputParams;
			return soap_in_ns1__genome_USCOREmapInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:consensus_zInputParams"))
		{	*type = SOAP_TYPE_ns1__consensus_USCOREzInputParams;
			return soap_in_ns1__consensus_USCOREzInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:find_ori_terInputParams"))
		{	*type = SOAP_TYPE_ns1__find_USCOREori_USCOREterInputParams;
			return soap_in_ns1__find_USCOREori_USCOREterInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:w_valueInputParams"))
		{	*type = SOAP_TYPE_ns1__w_USCOREvalueInputParams;
			return soap_in_ns1__w_USCOREvalueInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:P2InputParams"))
		{	*type = SOAP_TYPE_ns1__P2InputParams;
			return soap_in_ns1__P2InputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:codon_mvaInputParams"))
		{	*type = SOAP_TYPE_ns1__codon_USCOREmvaInputParams;
			return soap_in_ns1__codon_USCOREmvaInputParams(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:Definition"))
		{	*type = SOAP_TYPE_ns1__Definition;
			return soap_in_ns1__Definition(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE_ns1__hydropathy:
		return soap_out_ns1__hydropathy(soap, tag, id, (const struct ns1__hydropathy *)ptr, "ns1:hydropathy");
	case SOAP_TYPE_ns1__hydropathyResponse:
		return soap_out_ns1__hydropathyResponse(soap, tag, id, (const struct ns1__hydropathyResponse *)ptr, "ns1:hydropathyResponse");
	case SOAP_TYPE_ns1__help:
		return soap_out_ns1__help(soap, tag, id, (const struct ns1__help *)ptr, "ns1:help");
	case SOAP_TYPE_ns1__helpResponse:
		return soap_out_ns1__helpResponse(soap, tag, id, (const struct ns1__helpResponse *)ptr, "ns1:helpResponse");
	case SOAP_TYPE_ns1__S_USCOREvalue:
		return soap_out_ns1__S_USCOREvalue(soap, tag, id, (const struct ns1__S_USCOREvalue *)ptr, "ns1:S_value");
	case SOAP_TYPE_ns1__S_USCOREvalueResponse:
		return soap_out_ns1__S_USCOREvalueResponse(soap, tag, id, (const struct ns1__S_USCOREvalueResponse *)ptr, "ns1:S_valueResponse");
	case SOAP_TYPE_ns1__leading_USCOREstrand:
		return soap_out_ns1__leading_USCOREstrand(soap, tag, id, (const struct ns1__leading_USCOREstrand *)ptr, "ns1:leading_strand");
	case SOAP_TYPE_ns1__leading_USCOREstrandResponse:
		return soap_out_ns1__leading_USCOREstrandResponse(soap, tag, id, (const struct ns1__leading_USCOREstrandResponse *)ptr, "ns1:leading_strandResponse");
	case SOAP_TYPE_ns1__scs:
		return soap_out_ns1__scs(soap, tag, id, (const struct ns1__scs *)ptr, "ns1:scs");
	case SOAP_TYPE_ns1__scsResponse:
		return soap_out_ns1__scsResponse(soap, tag, id, (const struct ns1__scsResponse *)ptr, "ns1:scsResponse");
	case SOAP_TYPE_ns1__lda_USCOREbias:
		return soap_out_ns1__lda_USCOREbias(soap, tag, id, (const struct ns1__lda_USCOREbias *)ptr, "ns1:lda_bias");
	case SOAP_TYPE_ns1__lda_USCOREbiasResponse:
		return soap_out_ns1__lda_USCOREbiasResponse(soap, tag, id, (const struct ns1__lda_USCOREbiasResponse *)ptr, "ns1:lda_biasResponse");
	case SOAP_TYPE_ns1__kmer_USCOREtable:
		return soap_out_ns1__kmer_USCOREtable(soap, tag, id, (const struct ns1__kmer_USCOREtable *)ptr, "ns1:kmer_table");
	case SOAP_TYPE_ns1__kmer_USCOREtableResponse:
		return soap_out_ns1__kmer_USCOREtableResponse(soap, tag, id, (const struct ns1__kmer_USCOREtableResponse *)ptr, "ns1:kmer_tableResponse");
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalue:
		return soap_out_ns1__base_USCOREz_USCOREvalue(soap, tag, id, (const struct ns1__base_USCOREz_USCOREvalue *)ptr, "ns1:base_z_value");
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse:
		return soap_out_ns1__base_USCOREz_USCOREvalueResponse(soap, tag, id, (const struct ns1__base_USCOREz_USCOREvalueResponse *)ptr, "ns1:base_z_valueResponse");
	case SOAP_TYPE_ns1__base_USCOREcounter:
		return soap_out_ns1__base_USCOREcounter(soap, tag, id, (const struct ns1__base_USCOREcounter *)ptr, "ns1:base_counter");
	case SOAP_TYPE_ns1__base_USCOREcounterResponse:
		return soap_out_ns1__base_USCOREcounterResponse(soap, tag, id, (const struct ns1__base_USCOREcounterResponse *)ptr, "ns1:base_counterResponse");
	case SOAP_TYPE_ns1__B2:
		return soap_out_ns1__B2(soap, tag, id, (const struct ns1__B2 *)ptr, "ns1:B2");
	case SOAP_TYPE_ns1__B2Response:
		return soap_out_ns1__B2Response(soap, tag, id, (const struct ns1__B2Response *)ptr, "ns1:B2Response");
	case SOAP_TYPE_ns1__B1:
		return soap_out_ns1__B1(soap, tag, id, (const struct ns1__B1 *)ptr, "ns1:B1");
	case SOAP_TYPE_ns1__B1Response:
		return soap_out_ns1__B1Response(soap, tag, id, (const struct ns1__B1Response *)ptr, "ns1:B1Response");
	case SOAP_TYPE_ns1__cgr:
		return soap_out_ns1__cgr(soap, tag, id, (const struct ns1__cgr *)ptr, "ns1:cgr");
	case SOAP_TYPE_ns1__cgrResponse:
		return soap_out_ns1__cgrResponse(soap, tag, id, (const struct ns1__cgrResponse *)ptr, "ns1:cgrResponse");
	case SOAP_TYPE_ns1__dinuc:
		return soap_out_ns1__dinuc(soap, tag, id, (const struct ns1__dinuc *)ptr, "ns1:dinuc");
	case SOAP_TYPE_ns1__dinucResponse:
		return soap_out_ns1__dinucResponse(soap, tag, id, (const struct ns1__dinucResponse *)ptr, "ns1:dinucResponse");
	case SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit:
		return soap_out_ns1__least_USCOREsquares_USCOREfit(soap, tag, id, (const struct ns1__least_USCOREsquares_USCOREfit *)ptr, "ns1:least_squares_fit");
	case SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse:
		return soap_out_ns1__least_USCOREsquares_USCOREfitResponse(soap, tag, id, (const struct ns1__least_USCOREsquares_USCOREfitResponse *)ptr, "ns1:least_squares_fitResponse");
	case SOAP_TYPE_ns1__palindrome:
		return soap_out_ns1__palindrome(soap, tag, id, (const struct ns1__palindrome *)ptr, "ns1:palindrome");
	case SOAP_TYPE_ns1__palindromeResponse:
		return soap_out_ns1__palindromeResponse(soap, tag, id, (const struct ns1__palindromeResponse *)ptr, "ns1:palindromeResponse");
	case SOAP_TYPE_ns1__entrez:
		return soap_out_ns1__entrez(soap, tag, id, (const struct ns1__entrez *)ptr, "ns1:entrez");
	case SOAP_TYPE_ns1__entrezResponse:
		return soap_out_ns1__entrezResponse(soap, tag, id, (const struct ns1__entrezResponse *)ptr, "ns1:entrezResponse");
	case SOAP_TYPE_ns1__codon_USCOREcounter:
		return soap_out_ns1__codon_USCOREcounter(soap, tag, id, (const struct ns1__codon_USCOREcounter *)ptr, "ns1:codon_counter");
	case SOAP_TYPE_ns1__codon_USCOREcounterResponse:
		return soap_out_ns1__codon_USCOREcounterResponse(soap, tag, id, (const struct ns1__codon_USCOREcounterResponse *)ptr, "ns1:codon_counterResponse");
	case SOAP_TYPE_ns1__mean:
		return soap_out_ns1__mean(soap, tag, id, (const struct ns1__mean *)ptr, "ns1:mean");
	case SOAP_TYPE_ns1__meanResponse:
		return soap_out_ns1__meanResponse(soap, tag, id, (const struct ns1__meanResponse *)ptr, "ns1:meanResponse");
	case SOAP_TYPE_ns1__complement:
		return soap_out_ns1__complement(soap, tag, id, (const struct ns1__complement *)ptr, "ns1:complement");
	case SOAP_TYPE_ns1__complementResponse:
		return soap_out_ns1__complementResponse(soap, tag, id, (const struct ns1__complementResponse *)ptr, "ns1:complementResponse");
	case SOAP_TYPE_ns1__find_USCOREiteron:
		return soap_out_ns1__find_USCOREiteron(soap, tag, id, (const struct ns1__find_USCOREiteron *)ptr, "ns1:find_iteron");
	case SOAP_TYPE_ns1__find_USCOREiteronResponse:
		return soap_out_ns1__find_USCOREiteronResponse(soap, tag, id, (const struct ns1__find_USCOREiteronResponse *)ptr, "ns1:find_iteronResponse");
	case SOAP_TYPE_ns1__min:
		return soap_out_ns1__min(soap, tag, id, (const struct ns1__min *)ptr, "ns1:min");
	case SOAP_TYPE_ns1__minResponse:
		return soap_out_ns1__minResponse(soap, tag, id, (const struct ns1__minResponse *)ptr, "ns1:minResponse");
	case SOAP_TYPE_ns1__codon_USCOREusage:
		return soap_out_ns1__codon_USCOREusage(soap, tag, id, (const struct ns1__codon_USCOREusage *)ptr, "ns1:codon_usage");
	case SOAP_TYPE_ns1__codon_USCOREusageResponse:
		return soap_out_ns1__codon_USCOREusageResponse(soap, tag, id, (const struct ns1__codon_USCOREusageResponse *)ptr, "ns1:codon_usageResponse");
	case SOAP_TYPE_ns1__oligomer_USCOREcounter:
		return soap_out_ns1__oligomer_USCOREcounter(soap, tag, id, (const struct ns1__oligomer_USCOREcounter *)ptr, "ns1:oligomer_counter");
	case SOAP_TYPE_ns1__oligomer_USCOREcounterResponse:
		return soap_out_ns1__oligomer_USCOREcounterResponse(soap, tag, id, (const struct ns1__oligomer_USCOREcounterResponse *)ptr, "ns1:oligomer_counterResponse");
	case SOAP_TYPE_ns1__gcwin:
		return soap_out_ns1__gcwin(soap, tag, id, (const struct ns1__gcwin *)ptr, "ns1:gcwin");
	case SOAP_TYPE_ns1__gcwinResponse:
		return soap_out_ns1__gcwinResponse(soap, tag, id, (const struct ns1__gcwinResponse *)ptr, "ns1:gcwinResponse");
	case SOAP_TYPE_ns1__find_USCOREpattern:
		return soap_out_ns1__find_USCOREpattern(soap, tag, id, (const struct ns1__find_USCOREpattern *)ptr, "ns1:find_pattern");
	case SOAP_TYPE_ns1__find_USCOREpatternResponse:
		return soap_out_ns1__find_USCOREpatternResponse(soap, tag, id, (const struct ns1__find_USCOREpatternResponse *)ptr, "ns1:find_patternResponse");
	case SOAP_TYPE_ns1__oligomer_USCOREsearch:
		return soap_out_ns1__oligomer_USCOREsearch(soap, tag, id, (const struct ns1__oligomer_USCOREsearch *)ptr, "ns1:oligomer_search");
	case SOAP_TYPE_ns1__oligomer_USCOREsearchResponse:
		return soap_out_ns1__oligomer_USCOREsearchResponse(soap, tag, id, (const struct ns1__oligomer_USCOREsearchResponse *)ptr, "ns1:oligomer_searchResponse");
	case SOAP_TYPE_ns1__shuffleseq:
		return soap_out_ns1__shuffleseq(soap, tag, id, (const struct ns1__shuffleseq *)ptr, "ns1:shuffleseq");
	case SOAP_TYPE_ns1__shuffleseqResponse:
		return soap_out_ns1__shuffleseqResponse(soap, tag, id, (const struct ns1__shuffleseqResponse *)ptr, "ns1:shuffleseqResponse");
	case SOAP_TYPE_ns1__find_USCOREter:
		return soap_out_ns1__find_USCOREter(soap, tag, id, (const struct ns1__find_USCOREter *)ptr, "ns1:find_ter");
	case SOAP_TYPE_ns1__find_USCOREterResponse:
		return soap_out_ns1__find_USCOREterResponse(soap, tag, id, (const struct ns1__find_USCOREterResponse *)ptr, "ns1:find_terResponse");
	case SOAP_TYPE_ns1__dnawalk:
		return soap_out_ns1__dnawalk(soap, tag, id, (const struct ns1__dnawalk *)ptr, "ns1:dnawalk");
	case SOAP_TYPE_ns1__dnawalkResponse:
		return soap_out_ns1__dnawalkResponse(soap, tag, id, (const struct ns1__dnawalkResponse *)ptr, "ns1:dnawalkResponse");
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent:
		return soap_out_ns1__base_USCOREinformation_USCOREcontent(soap, tag, id, (const struct ns1__base_USCOREinformation_USCOREcontent *)ptr, "ns1:base_information_content");
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse:
		return soap_out_ns1__base_USCOREinformation_USCOREcontentResponse(soap, tag, id, (const struct ns1__base_USCOREinformation_USCOREcontentResponse *)ptr, "ns1:base_information_contentResponse");
	case SOAP_TYPE_ns1__signature:
		return soap_out_ns1__signature(soap, tag, id, (const struct ns1__signature *)ptr, "ns1:signature");
	case SOAP_TYPE_ns1__signatureResponse:
		return soap_out_ns1__signatureResponse(soap, tag, id, (const struct ns1__signatureResponse *)ptr, "ns1:signatureResponse");
	case SOAP_TYPE_ns1__seqinfo:
		return soap_out_ns1__seqinfo(soap, tag, id, (const struct ns1__seqinfo *)ptr, "ns1:seqinfo");
	case SOAP_TYPE_ns1__seqinfoResponse:
		return soap_out_ns1__seqinfoResponse(soap, tag, id, (const struct ns1__seqinfoResponse *)ptr, "ns1:seqinfoResponse");
	case SOAP_TYPE_ns1__genome_USCOREmap3:
		return soap_out_ns1__genome_USCOREmap3(soap, tag, id, (const struct ns1__genome_USCOREmap3 *)ptr, "ns1:genome_map3");
	case SOAP_TYPE_ns1__genome_USCOREmap3Response:
		return soap_out_ns1__genome_USCOREmap3Response(soap, tag, id, (const struct ns1__genome_USCOREmap3Response *)ptr, "ns1:genome_map3Response");
	case SOAP_TYPE_ns1__gcskew:
		return soap_out_ns1__gcskew(soap, tag, id, (const struct ns1__gcskew *)ptr, "ns1:gcskew");
	case SOAP_TYPE_ns1__gcskewResponse:
		return soap_out_ns1__gcskewResponse(soap, tag, id, (const struct ns1__gcskewResponse *)ptr, "ns1:gcskewResponse");
	case SOAP_TYPE_ns1__molecular_USCOREweight:
		return soap_out_ns1__molecular_USCOREweight(soap, tag, id, (const struct ns1__molecular_USCOREweight *)ptr, "ns1:molecular_weight");
	case SOAP_TYPE_ns1__molecular_USCOREweightResponse:
		return soap_out_ns1__molecular_USCOREweightResponse(soap, tag, id, (const struct ns1__molecular_USCOREweightResponse *)ptr, "ns1:molecular_weightResponse");
	case SOAP_TYPE_ns1__delta_USCOREgcskew:
		return soap_out_ns1__delta_USCOREgcskew(soap, tag, id, (const struct ns1__delta_USCOREgcskew *)ptr, "ns1:delta_gcskew");
	case SOAP_TYPE_ns1__delta_USCOREgcskewResponse:
		return soap_out_ns1__delta_USCOREgcskewResponse(soap, tag, id, (const struct ns1__delta_USCOREgcskewResponse *)ptr, "ns1:delta_gcskewResponse");
	case SOAP_TYPE_ns1__delta_USCOREenc:
		return soap_out_ns1__delta_USCOREenc(soap, tag, id, (const struct ns1__delta_USCOREenc *)ptr, "ns1:delta_enc");
	case SOAP_TYPE_ns1__delta_USCOREencResponse:
		return soap_out_ns1__delta_USCOREencResponse(soap, tag, id, (const struct ns1__delta_USCOREencResponse *)ptr, "ns1:delta_encResponse");
	case SOAP_TYPE_ns1__cumulative:
		return soap_out_ns1__cumulative(soap, tag, id, (const struct ns1__cumulative *)ptr, "ns1:cumulative");
	case SOAP_TYPE_ns1__cumulativeResponse:
		return soap_out_ns1__cumulativeResponse(soap, tag, id, (const struct ns1__cumulativeResponse *)ptr, "ns1:cumulativeResponse");
	case SOAP_TYPE_ns1__cor:
		return soap_out_ns1__cor(soap, tag, id, (const struct ns1__cor *)ptr, "ns1:cor");
	case SOAP_TYPE_ns1__corResponse:
		return soap_out_ns1__corResponse(soap, tag, id, (const struct ns1__corResponse *)ptr, "ns1:corResponse");
	case SOAP_TYPE_ns1__standard_USCOREdeviation:
		return soap_out_ns1__standard_USCOREdeviation(soap, tag, id, (const struct ns1__standard_USCOREdeviation *)ptr, "ns1:standard_deviation");
	case SOAP_TYPE_ns1__standard_USCOREdeviationResponse:
		return soap_out_ns1__standard_USCOREdeviationResponse(soap, tag, id, (const struct ns1__standard_USCOREdeviationResponse *)ptr, "ns1:standard_deviationResponse");
	case SOAP_TYPE_ns1__geneskew:
		return soap_out_ns1__geneskew(soap, tag, id, (const struct ns1__geneskew *)ptr, "ns1:geneskew");
	case SOAP_TYPE_ns1__geneskewResponse:
		return soap_out_ns1__geneskewResponse(soap, tag, id, (const struct ns1__geneskewResponse *)ptr, "ns1:geneskewResponse");
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori:
		return soap_out_ns1__genes_USCOREfrom_USCOREori(soap, tag, id, (const struct ns1__genes_USCOREfrom_USCOREori *)ptr, "ns1:genes_from_ori");
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse:
		return soap_out_ns1__genes_USCOREfrom_USCOREoriResponse(soap, tag, id, (const struct ns1__genes_USCOREfrom_USCOREoriResponse *)ptr, "ns1:genes_from_oriResponse");
	case SOAP_TYPE_ns1__cbi:
		return soap_out_ns1__cbi(soap, tag, id, (const struct ns1__cbi *)ptr, "ns1:cbi");
	case SOAP_TYPE_ns1__cbiResponse:
		return soap_out_ns1__cbiResponse(soap, tag, id, (const struct ns1__cbiResponse *)ptr, "ns1:cbiResponse");
	case SOAP_TYPE_ns1__find_USCOREdif:
		return soap_out_ns1__find_USCOREdif(soap, tag, id, (const struct ns1__find_USCOREdif *)ptr, "ns1:find_dif");
	case SOAP_TYPE_ns1__find_USCOREdifResponse:
		return soap_out_ns1__find_USCOREdifResponse(soap, tag, id, (const struct ns1__find_USCOREdifResponse *)ptr, "ns1:find_difResponse");
	case SOAP_TYPE_ns1__to_USCOREfasta:
		return soap_out_ns1__to_USCOREfasta(soap, tag, id, (const struct ns1__to_USCOREfasta *)ptr, "ns1:to_fasta");
	case SOAP_TYPE_ns1__to_USCOREfastaResponse:
		return soap_out_ns1__to_USCOREfastaResponse(soap, tag, id, (const struct ns1__to_USCOREfastaResponse *)ptr, "ns1:to_fastaResponse");
	case SOAP_TYPE_ns1__base_USCOREentropy:
		return soap_out_ns1__base_USCOREentropy(soap, tag, id, (const struct ns1__base_USCOREentropy *)ptr, "ns1:base_entropy");
	case SOAP_TYPE_ns1__base_USCOREentropyResponse:
		return soap_out_ns1__base_USCOREentropyResponse(soap, tag, id, (const struct ns1__base_USCOREentropyResponse *)ptr, "ns1:base_entropyResponse");
	case SOAP_TYPE_ns1__DoubleHelix:
		return soap_out_ns1__DoubleHelix(soap, tag, id, (const struct ns1__DoubleHelix *)ptr, "ns1:DoubleHelix");
	case SOAP_TYPE_ns1__DoubleHelixResponse:
		return soap_out_ns1__DoubleHelixResponse(soap, tag, id, (const struct ns1__DoubleHelixResponse *)ptr, "ns1:DoubleHelixResponse");
	case SOAP_TYPE_ns1__calc_USCOREpI:
		return soap_out_ns1__calc_USCOREpI(soap, tag, id, (const struct ns1__calc_USCOREpI *)ptr, "ns1:calc_pI");
	case SOAP_TYPE_ns1__calc_USCOREpIResponse:
		return soap_out_ns1__calc_USCOREpIResponse(soap, tag, id, (const struct ns1__calc_USCOREpIResponse *)ptr, "ns1:calc_pIResponse");
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREter:
		return soap_out_ns1__rep_USCOREori_USCOREter(soap, tag, id, (const struct ns1__rep_USCOREori_USCOREter *)ptr, "ns1:rep_ori_ter");
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse:
		return soap_out_ns1__rep_USCOREori_USCOREterResponse(soap, tag, id, (const struct ns1__rep_USCOREori_USCOREterResponse *)ptr, "ns1:rep_ori_terResponse");
	case SOAP_TYPE_ns1__longest_USCOREORF:
		return soap_out_ns1__longest_USCOREORF(soap, tag, id, (const struct ns1__longest_USCOREORF *)ptr, "ns1:longest_ORF");
	case SOAP_TYPE_ns1__longest_USCOREORFResponse:
		return soap_out_ns1__longest_USCOREORFResponse(soap, tag, id, (const struct ns1__longest_USCOREORFResponse *)ptr, "ns1:longest_ORFResponse");
	case SOAP_TYPE_ns1__genome_USCOREmap:
		return soap_out_ns1__genome_USCOREmap(soap, tag, id, (const struct ns1__genome_USCOREmap *)ptr, "ns1:genome_map");
	case SOAP_TYPE_ns1__genome_USCOREmapResponse:
		return soap_out_ns1__genome_USCOREmapResponse(soap, tag, id, (const struct ns1__genome_USCOREmapResponse *)ptr, "ns1:genome_mapResponse");
	case SOAP_TYPE_ns1__consensus_USCOREz:
		return soap_out_ns1__consensus_USCOREz(soap, tag, id, (const struct ns1__consensus_USCOREz *)ptr, "ns1:consensus_z");
	case SOAP_TYPE_ns1__consensus_USCOREzResponse:
		return soap_out_ns1__consensus_USCOREzResponse(soap, tag, id, (const struct ns1__consensus_USCOREzResponse *)ptr, "ns1:consensus_zResponse");
	case SOAP_TYPE_ns1__mindex:
		return soap_out_ns1__mindex(soap, tag, id, (const struct ns1__mindex *)ptr, "ns1:mindex");
	case SOAP_TYPE_ns1__mindexResponse:
		return soap_out_ns1__mindexResponse(soap, tag, id, (const struct ns1__mindexResponse *)ptr, "ns1:mindexResponse");
	case SOAP_TYPE_ns1__query_USCOREarm:
		return soap_out_ns1__query_USCOREarm(soap, tag, id, (const struct ns1__query_USCOREarm *)ptr, "ns1:query_arm");
	case SOAP_TYPE_ns1__query_USCOREarmResponse:
		return soap_out_ns1__query_USCOREarmResponse(soap, tag, id, (const struct ns1__query_USCOREarmResponse *)ptr, "ns1:query_armResponse");
	case SOAP_TYPE_ns1__max:
		return soap_out_ns1__max(soap, tag, id, (const struct ns1__max *)ptr, "ns1:max");
	case SOAP_TYPE_ns1__maxResponse:
		return soap_out_ns1__maxResponse(soap, tag, id, (const struct ns1__maxResponse *)ptr, "ns1:maxResponse");
	case SOAP_TYPE_ns1__maxdex:
		return soap_out_ns1__maxdex(soap, tag, id, (const struct ns1__maxdex *)ptr, "ns1:maxdex");
	case SOAP_TYPE_ns1__maxdexResponse:
		return soap_out_ns1__maxdexResponse(soap, tag, id, (const struct ns1__maxdexResponse *)ptr, "ns1:maxdexResponse");
	case SOAP_TYPE_ns1__cai:
		return soap_out_ns1__cai(soap, tag, id, (const struct ns1__cai *)ptr, "ns1:cai");
	case SOAP_TYPE_ns1__caiResponse:
		return soap_out_ns1__caiResponse(soap, tag, id, (const struct ns1__caiResponse *)ptr, "ns1:caiResponse");
	case SOAP_TYPE_ns1__gcsi:
		return soap_out_ns1__gcsi(soap, tag, id, (const struct ns1__gcsi *)ptr, "ns1:gcsi");
	case SOAP_TYPE_ns1__gcsiResponse:
		return soap_out_ns1__gcsiResponse(soap, tag, id, (const struct ns1__gcsiResponse *)ptr, "ns1:gcsiResponse");
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg:
		return soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, tag, id, (const struct ns1__filter_USCOREcds_USCOREby_USCOREatg *)ptr, "ns1:filter_cds_by_atg");
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse:
		return soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, tag, id, (const struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *)ptr, "ns1:filter_cds_by_atgResponse");
	case SOAP_TYPE_ns1__genomicskew:
		return soap_out_ns1__genomicskew(soap, tag, id, (const struct ns1__genomicskew *)ptr, "ns1:genomicskew");
	case SOAP_TYPE_ns1__genomicskewResponse:
		return soap_out_ns1__genomicskewResponse(soap, tag, id, (const struct ns1__genomicskewResponse *)ptr, "ns1:genomicskewResponse");
	case SOAP_TYPE_ns1__query_USCOREstrand:
		return soap_out_ns1__query_USCOREstrand(soap, tag, id, (const struct ns1__query_USCOREstrand *)ptr, "ns1:query_strand");
	case SOAP_TYPE_ns1__query_USCOREstrandResponse:
		return soap_out_ns1__query_USCOREstrandResponse(soap, tag, id, (const struct ns1__query_USCOREstrandResponse *)ptr, "ns1:query_strandResponse");
	case SOAP_TYPE_ns1__view_USCOREcds:
		return soap_out_ns1__view_USCOREcds(soap, tag, id, (const struct ns1__view_USCOREcds *)ptr, "ns1:view_cds");
	case SOAP_TYPE_ns1__view_USCOREcdsResponse:
		return soap_out_ns1__view_USCOREcdsResponse(soap, tag, id, (const struct ns1__view_USCOREcdsResponse *)ptr, "ns1:view_cdsResponse");
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy:
		return soap_out_ns1__base_USCORErelative_USCOREentropy(soap, tag, id, (const struct ns1__base_USCORErelative_USCOREentropy *)ptr, "ns1:base_relative_entropy");
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse:
		return soap_out_ns1__base_USCORErelative_USCOREentropyResponse(soap, tag, id, (const struct ns1__base_USCORErelative_USCOREentropyResponse *)ptr, "ns1:base_relative_entropyResponse");
	case SOAP_TYPE_ns1__Ew:
		return soap_out_ns1__Ew(soap, tag, id, (const struct ns1__Ew *)ptr, "ns1:Ew");
	case SOAP_TYPE_ns1__EwResponse:
		return soap_out_ns1__EwResponse(soap, tag, id, (const struct ns1__EwResponse *)ptr, "ns1:EwResponse");
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder:
		return soap_out_ns1__over_USCORElapping_USCOREfinder(soap, tag, id, (const struct ns1__over_USCORElapping_USCOREfinder *)ptr, "ns1:over_lapping_finder");
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse:
		return soap_out_ns1__over_USCORElapping_USCOREfinderResponse(soap, tag, id, (const struct ns1__over_USCORElapping_USCOREfinderResponse *)ptr, "ns1:over_lapping_finderResponse");
	case SOAP_TYPE_ns1__codon_USCOREcompiler:
		return soap_out_ns1__codon_USCOREcompiler(soap, tag, id, (const struct ns1__codon_USCOREcompiler *)ptr, "ns1:codon_compiler");
	case SOAP_TYPE_ns1__codon_USCOREcompilerResponse:
		return soap_out_ns1__codon_USCOREcompilerResponse(soap, tag, id, (const struct ns1__codon_USCOREcompilerResponse *)ptr, "ns1:codon_compilerResponse");
	case SOAP_TYPE_ns1__aaui:
		return soap_out_ns1__aaui(soap, tag, id, (const struct ns1__aaui *)ptr, "ns1:aaui");
	case SOAP_TYPE_ns1__aauiResponse:
		return soap_out_ns1__aauiResponse(soap, tag, id, (const struct ns1__aauiResponse *)ptr, "ns1:aauiResponse");
	case SOAP_TYPE_ns1__amino_USCOREcounter:
		return soap_out_ns1__amino_USCOREcounter(soap, tag, id, (const struct ns1__amino_USCOREcounter *)ptr, "ns1:amino_counter");
	case SOAP_TYPE_ns1__amino_USCOREcounterResponse:
		return soap_out_ns1__amino_USCOREcounterResponse(soap, tag, id, (const struct ns1__amino_USCOREcounterResponse *)ptr, "ns1:amino_counterResponse");
	case SOAP_TYPE_ns1__seq2png:
		return soap_out_ns1__seq2png(soap, tag, id, (const struct ns1__seq2png *)ptr, "ns1:seq2png");
	case SOAP_TYPE_ns1__seq2pngResponse:
		return soap_out_ns1__seq2pngResponse(soap, tag, id, (const struct ns1__seq2pngResponse *)ptr, "ns1:seq2pngResponse");
	case SOAP_TYPE_ns1__ttest:
		return soap_out_ns1__ttest(soap, tag, id, (const struct ns1__ttest *)ptr, "ns1:ttest");
	case SOAP_TYPE_ns1__ttestResponse:
		return soap_out_ns1__ttestResponse(soap, tag, id, (const struct ns1__ttestResponse *)ptr, "ns1:ttestResponse");
	case SOAP_TYPE_ns1__find_USCOREdnaAbox:
		return soap_out_ns1__find_USCOREdnaAbox(soap, tag, id, (const struct ns1__find_USCOREdnaAbox *)ptr, "ns1:find_dnaAbox");
	case SOAP_TYPE_ns1__find_USCOREdnaAboxResponse:
		return soap_out_ns1__find_USCOREdnaAboxResponse(soap, tag, id, (const struct ns1__find_USCOREdnaAboxResponse *)ptr, "ns1:find_dnaAboxResponse");
	case SOAP_TYPE_ns1__dist_USCOREin_USCOREcc:
		return soap_out_ns1__dist_USCOREin_USCOREcc(soap, tag, id, (const struct ns1__dist_USCOREin_USCOREcc *)ptr, "ns1:dist_in_cc");
	case SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse:
		return soap_out_ns1__dist_USCOREin_USCOREccResponse(soap, tag, id, (const struct ns1__dist_USCOREin_USCOREccResponse *)ptr, "ns1:dist_in_ccResponse");
	case SOAP_TYPE_ns1__bui:
		return soap_out_ns1__bui(soap, tag, id, (const struct ns1__bui *)ptr, "ns1:bui");
	case SOAP_TYPE_ns1__buiResponse:
		return soap_out_ns1__buiResponse(soap, tag, id, (const struct ns1__buiResponse *)ptr, "ns1:buiResponse");
	case SOAP_TYPE_ns1__fop:
		return soap_out_ns1__fop(soap, tag, id, (const struct ns1__fop *)ptr, "ns1:fop");
	case SOAP_TYPE_ns1__fopResponse:
		return soap_out_ns1__fopResponse(soap, tag, id, (const struct ns1__fopResponse *)ptr, "ns1:fopResponse");
	case SOAP_TYPE_ns1__enc:
		return soap_out_ns1__enc(soap, tag, id, (const struct ns1__enc *)ptr, "ns1:enc");
	case SOAP_TYPE_ns1__encResponse:
		return soap_out_ns1__encResponse(soap, tag, id, (const struct ns1__encResponse *)ptr, "ns1:encResponse");
	case SOAP_TYPE_ns1__icdi:
		return soap_out_ns1__icdi(soap, tag, id, (const struct ns1__icdi *)ptr, "ns1:icdi");
	case SOAP_TYPE_ns1__icdiResponse:
		return soap_out_ns1__icdiResponse(soap, tag, id, (const struct ns1__icdiResponse *)ptr, "ns1:icdiResponse");
	case SOAP_TYPE_ns1__phx:
		return soap_out_ns1__phx(soap, tag, id, (const struct ns1__phx *)ptr, "ns1:phx");
	case SOAP_TYPE_ns1__phxResponse:
		return soap_out_ns1__phxResponse(soap, tag, id, (const struct ns1__phxResponse *)ptr, "ns1:phxResponse");
	case SOAP_TYPE_ns1__translate:
		return soap_out_ns1__translate(soap, tag, id, (const struct ns1__translate *)ptr, "ns1:translate");
	case SOAP_TYPE_ns1__translateResponse:
		return soap_out_ns1__translateResponse(soap, tag, id, (const struct ns1__translateResponse *)ptr, "ns1:translateResponse");
	case SOAP_TYPE_ns1__togoWS:
		return soap_out_ns1__togoWS(soap, tag, id, (const struct ns1__togoWS *)ptr, "ns1:togoWS");
	case SOAP_TYPE_ns1__togoWSResponse:
		return soap_out_ns1__togoWSResponse(soap, tag, id, (const struct ns1__togoWSResponse *)ptr, "ns1:togoWSResponse");
	case SOAP_TYPE_ns1__circular_USCOREmap:
		return soap_out_ns1__circular_USCOREmap(soap, tag, id, (const struct ns1__circular_USCOREmap *)ptr, "ns1:circular_map");
	case SOAP_TYPE_ns1__circular_USCOREmapResponse:
		return soap_out_ns1__circular_USCOREmapResponse(soap, tag, id, (const struct ns1__circular_USCOREmapResponse *)ptr, "ns1:circular_mapResponse");
	case SOAP_TYPE_ns1__amino_USCOREinfo:
		return soap_out_ns1__amino_USCOREinfo(soap, tag, id, (const struct ns1__amino_USCOREinfo *)ptr, "ns1:amino_info");
	case SOAP_TYPE_ns1__amino_USCOREinfoResponse:
		return soap_out_ns1__amino_USCOREinfoResponse(soap, tag, id, (const struct ns1__amino_USCOREinfoResponse *)ptr, "ns1:amino_infoResponse");
	case SOAP_TYPE_ns1__variance:
		return soap_out_ns1__variance(soap, tag, id, (const struct ns1__variance *)ptr, "ns1:variance");
	case SOAP_TYPE_ns1__varianceResponse:
		return soap_out_ns1__varianceResponse(soap, tag, id, (const struct ns1__varianceResponse *)ptr, "ns1:varianceResponse");
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicity:
		return soap_out_ns1__nucleotide_USCOREperiodicity(soap, tag, id, (const struct ns1__nucleotide_USCOREperiodicity *)ptr, "ns1:nucleotide_periodicity");
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse:
		return soap_out_ns1__nucleotide_USCOREperiodicityResponse(soap, tag, id, (const struct ns1__nucleotide_USCOREperiodicityResponse *)ptr, "ns1:nucleotide_periodicityResponse");
	case SOAP_TYPE_ns1__sum:
		return soap_out_ns1__sum(soap, tag, id, (const struct ns1__sum *)ptr, "ns1:sum");
	case SOAP_TYPE_ns1__sumResponse:
		return soap_out_ns1__sumResponse(soap, tag, id, (const struct ns1__sumResponse *)ptr, "ns1:sumResponse");
	case SOAP_TYPE_ns1__plasmid_USCOREmap:
		return soap_out_ns1__plasmid_USCOREmap(soap, tag, id, (const struct ns1__plasmid_USCOREmap *)ptr, "ns1:plasmid_map");
	case SOAP_TYPE_ns1__plasmid_USCOREmapResponse:
		return soap_out_ns1__plasmid_USCOREmapResponse(soap, tag, id, (const struct ns1__plasmid_USCOREmapResponse *)ptr, "ns1:plasmid_mapResponse");
	case SOAP_TYPE_ns1__find_USCOREori_USCOREter:
		return soap_out_ns1__find_USCOREori_USCOREter(soap, tag, id, (const struct ns1__find_USCOREori_USCOREter *)ptr, "ns1:find_ori_ter");
	case SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse:
		return soap_out_ns1__find_USCOREori_USCOREterResponse(soap, tag, id, (const struct ns1__find_USCOREori_USCOREterResponse *)ptr, "ns1:find_ori_terResponse");
	case SOAP_TYPE_ns1__median:
		return soap_out_ns1__median(soap, tag, id, (const struct ns1__median *)ptr, "ns1:median");
	case SOAP_TYPE_ns1__medianResponse:
		return soap_out_ns1__medianResponse(soap, tag, id, (const struct ns1__medianResponse *)ptr, "ns1:medianResponse");
	case SOAP_TYPE_ns1__splitprintseq:
		return soap_out_ns1__splitprintseq(soap, tag, id, (const struct ns1__splitprintseq *)ptr, "ns1:splitprintseq");
	case SOAP_TYPE_ns1__splitprintseqResponse:
		return soap_out_ns1__splitprintseqResponse(soap, tag, id, (const struct ns1__splitprintseqResponse *)ptr, "ns1:splitprintseqResponse");
	case SOAP_TYPE_ns1__w_USCOREvalue:
		return soap_out_ns1__w_USCOREvalue(soap, tag, id, (const struct ns1__w_USCOREvalue *)ptr, "ns1:w_value");
	case SOAP_TYPE_ns1__w_USCOREvalueResponse:
		return soap_out_ns1__w_USCOREvalueResponse(soap, tag, id, (const struct ns1__w_USCOREvalueResponse *)ptr, "ns1:w_valueResponse");
	case SOAP_TYPE_ns1__P2:
		return soap_out_ns1__P2(soap, tag, id, (const struct ns1__P2 *)ptr, "ns1:P2");
	case SOAP_TYPE_ns1__P2Response:
		return soap_out_ns1__P2Response(soap, tag, id, (const struct ns1__P2Response *)ptr, "ns1:P2Response");
	case SOAP_TYPE_ns1__codon_USCOREmva:
		return soap_out_ns1__codon_USCOREmva(soap, tag, id, (const struct ns1__codon_USCOREmva *)ptr, "ns1:codon_mva");
	case SOAP_TYPE_ns1__codon_USCOREmvaResponse:
		return soap_out_ns1__codon_USCOREmvaResponse(soap, tag, id, (const struct ns1__codon_USCOREmvaResponse *)ptr, "ns1:codon_mvaResponse");
	case SOAP_TYPE_arrayOut:
		return soap_out_arrayOut(soap, tag, id, (const struct arrayOut *)ptr, "xsd:string");
	case SOAP_TYPE_arrayIn:
		return soap_out_arrayIn(soap, tag, id, (const struct arrayIn *)ptr, "xsd:string");
	case SOAP_TYPE_ns1__S_USCOREvalueInputParams:
		return soap_out_ns1__S_USCOREvalueInputParams(soap, tag, id, (const struct ns1__S_USCOREvalueInputParams *)ptr, "ns1:S_valueInputParams");
	case SOAP_TYPE_ns1__scsInputParams:
		return soap_out_ns1__scsInputParams(soap, tag, id, (const struct ns1__scsInputParams *)ptr, "ns1:scsInputParams");
	case SOAP_TYPE_ns1__signatureInputParams:
		return soap_out_ns1__signatureInputParams(soap, tag, id, (const struct ns1__signatureInputParams *)ptr, "ns1:signatureInputParams");
	case SOAP_TYPE_ns1__lda_USCOREbiasInputParams:
		return soap_out_ns1__lda_USCOREbiasInputParams(soap, tag, id, (const struct ns1__lda_USCOREbiasInputParams *)ptr, "ns1:lda_biasInputParams");
	case SOAP_TYPE_ns1__kmer_USCOREtableInputParams:
		return soap_out_ns1__kmer_USCOREtableInputParams(soap, tag, id, (const struct ns1__kmer_USCOREtableInputParams *)ptr, "ns1:kmer_tableInputParams");
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams:
		return soap_out_ns1__base_USCOREz_USCOREvalueInputParams(soap, tag, id, (const struct ns1__base_USCOREz_USCOREvalueInputParams *)ptr, "ns1:base_z_valueInputParams");
	case SOAP_TYPE_ns1__base_USCOREcounterInputParams:
		return soap_out_ns1__base_USCOREcounterInputParams(soap, tag, id, (const struct ns1__base_USCOREcounterInputParams *)ptr, "ns1:base_counterInputParams");
	case SOAP_TYPE_ns1__B1InputParams:
		return soap_out_ns1__B1InputParams(soap, tag, id, (const struct ns1__B1InputParams *)ptr, "ns1:B1InputParams");
	case SOAP_TYPE_ns1__cgrInputParams:
		return soap_out_ns1__cgrInputParams(soap, tag, id, (const struct ns1__cgrInputParams *)ptr, "ns1:cgrInputParams");
	case SOAP_TYPE_ns1__dinucInputParams:
		return soap_out_ns1__dinucInputParams(soap, tag, id, (const struct ns1__dinucInputParams *)ptr, "ns1:dinucInputParams");
	case SOAP_TYPE_ns1__caiInputParams:
		return soap_out_ns1__caiInputParams(soap, tag, id, (const struct ns1__caiInputParams *)ptr, "ns1:caiInputParams");
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams:
		return soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, tag, id, (const struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *)ptr, "ns1:filter_cds_by_atgInputParams");
	case SOAP_TYPE_ns1__gcsiInputParams:
		return soap_out_ns1__gcsiInputParams(soap, tag, id, (const struct ns1__gcsiInputParams *)ptr, "ns1:gcsiInputParams");
	case SOAP_TYPE_ns1__query_USCOREstrandInputParams:
		return soap_out_ns1__query_USCOREstrandInputParams(soap, tag, id, (const struct ns1__query_USCOREstrandInputParams *)ptr, "ns1:query_strandInputParams");
	case SOAP_TYPE_ns1__genomicskewInputParams:
		return soap_out_ns1__genomicskewInputParams(soap, tag, id, (const struct ns1__genomicskewInputParams *)ptr, "ns1:genomicskewInputParams");
	case SOAP_TYPE_ns1__palindromeInputParams:
		return soap_out_ns1__palindromeInputParams(soap, tag, id, (const struct ns1__palindromeInputParams *)ptr, "ns1:palindromeInputParams");
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams:
		return soap_out_ns1__base_USCORErelative_USCOREentropyInputParams(soap, tag, id, (const struct ns1__base_USCORErelative_USCOREentropyInputParams *)ptr, "ns1:base_relative_entropyInputParams");
	case SOAP_TYPE_ns1__view_USCOREcdsInputParams:
		return soap_out_ns1__view_USCOREcdsInputParams(soap, tag, id, (const struct ns1__view_USCOREcdsInputParams *)ptr, "ns1:view_cdsInputParams");
	case SOAP_TYPE_ns1__codon_USCOREcounterInputParams:
		return soap_out_ns1__codon_USCOREcounterInputParams(soap, tag, id, (const struct ns1__codon_USCOREcounterInputParams *)ptr, "ns1:codon_counterInputParams");
	case SOAP_TYPE_ns1__EwInputParams:
		return soap_out_ns1__EwInputParams(soap, tag, id, (const struct ns1__EwInputParams *)ptr, "ns1:EwInputParams");
	case SOAP_TYPE_ns1__find_USCOREiteronInputParams:
		return soap_out_ns1__find_USCOREiteronInputParams(soap, tag, id, (const struct ns1__find_USCOREiteronInputParams *)ptr, "ns1:find_iteronInputParams");
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams:
		return soap_out_ns1__over_USCORElapping_USCOREfinderInputParams(soap, tag, id, (const struct ns1__over_USCORElapping_USCOREfinderInputParams *)ptr, "ns1:over_lapping_finderInputParams");
	case SOAP_TYPE_ns1__codon_USCOREcompilerInputParams:
		return soap_out_ns1__codon_USCOREcompilerInputParams(soap, tag, id, (const struct ns1__codon_USCOREcompilerInputParams *)ptr, "ns1:codon_compilerInputParams");
	case SOAP_TYPE_ns1__aauiInputParams:
		return soap_out_ns1__aauiInputParams(soap, tag, id, (const struct ns1__aauiInputParams *)ptr, "ns1:aauiInputParams");
	case SOAP_TYPE_ns1__amino_USCOREcounterInputParams:
		return soap_out_ns1__amino_USCOREcounterInputParams(soap, tag, id, (const struct ns1__amino_USCOREcounterInputParams *)ptr, "ns1:amino_counterInputParams");
	case SOAP_TYPE_ns1__seq2pngInputParams:
		return soap_out_ns1__seq2pngInputParams(soap, tag, id, (const struct ns1__seq2pngInputParams *)ptr, "ns1:seq2pngInputParams");
	case SOAP_TYPE_ns1__ttestInputParams:
		return soap_out_ns1__ttestInputParams(soap, tag, id, (const struct ns1__ttestInputParams *)ptr, "ns1:ttestInputParams");
	case SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams:
		return soap_out_ns1__find_USCOREdnaAboxInputParams(soap, tag, id, (const struct ns1__find_USCOREdnaAboxInputParams *)ptr, "ns1:find_dnaAboxInputParams");
	case SOAP_TYPE_ns1__codon_USCOREusageInputParams:
		return soap_out_ns1__codon_USCOREusageInputParams(soap, tag, id, (const struct ns1__codon_USCOREusageInputParams *)ptr, "ns1:codon_usageInputParams");
	case SOAP_TYPE_ns1__buiInputParams:
		return soap_out_ns1__buiInputParams(soap, tag, id, (const struct ns1__buiInputParams *)ptr, "ns1:buiInputParams");
	case SOAP_TYPE_ns1__fopInputParams:
		return soap_out_ns1__fopInputParams(soap, tag, id, (const struct ns1__fopInputParams *)ptr, "ns1:fopInputParams");
	case SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams:
		return soap_out_ns1__oligomer_USCOREcounterInputParams(soap, tag, id, (const struct ns1__oligomer_USCOREcounterInputParams *)ptr, "ns1:oligomer_counterInputParams");
	case SOAP_TYPE_ns1__encInputParams:
		return soap_out_ns1__encInputParams(soap, tag, id, (const struct ns1__encInputParams *)ptr, "ns1:encInputParams");
	case SOAP_TYPE_ns1__icdiInputParams:
		return soap_out_ns1__icdiInputParams(soap, tag, id, (const struct ns1__icdiInputParams *)ptr, "ns1:icdiInputParams");
	case SOAP_TYPE_ns1__gcwinInputParams:
		return soap_out_ns1__gcwinInputParams(soap, tag, id, (const struct ns1__gcwinInputParams *)ptr, "ns1:gcwinInputParams");
	case SOAP_TYPE_ns1__find_USCOREpatternInputParams:
		return soap_out_ns1__find_USCOREpatternInputParams(soap, tag, id, (const struct ns1__find_USCOREpatternInputParams *)ptr, "ns1:find_patternInputParams");
	case SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams:
		return soap_out_ns1__oligomer_USCOREsearchInputParams(soap, tag, id, (const struct ns1__oligomer_USCOREsearchInputParams *)ptr, "ns1:oligomer_searchInputParams");
	case SOAP_TYPE_ns1__phxInputParams:
		return soap_out_ns1__phxInputParams(soap, tag, id, (const struct ns1__phxInputParams *)ptr, "ns1:phxInputParams");
	case SOAP_TYPE_ns1__shuffleseqInputParams:
		return soap_out_ns1__shuffleseqInputParams(soap, tag, id, (const struct ns1__shuffleseqInputParams *)ptr, "ns1:shuffleseqInputParams");
	case SOAP_TYPE_ns1__find_USCOREterInputParams:
		return soap_out_ns1__find_USCOREterInputParams(soap, tag, id, (const struct ns1__find_USCOREterInputParams *)ptr, "ns1:find_terInputParams");
	case SOAP_TYPE_ns1__dnawalkInputParams:
		return soap_out_ns1__dnawalkInputParams(soap, tag, id, (const struct ns1__dnawalkInputParams *)ptr, "ns1:dnawalkInputParams");
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams:
		return soap_out_ns1__base_USCOREinformation_USCOREcontentInputParams(soap, tag, id, (const struct ns1__base_USCOREinformation_USCOREcontentInputParams *)ptr, "ns1:base_information_contentInputParams");
	case SOAP_TYPE_ns1__togoWSInputParams:
		return soap_out_ns1__togoWSInputParams(soap, tag, id, (const struct ns1__togoWSInputParams *)ptr, "ns1:togoWSInputParams");
	case SOAP_TYPE_ns1__genome_USCOREmap3InputParams:
		return soap_out_ns1__genome_USCOREmap3InputParams(soap, tag, id, (const struct ns1__genome_USCOREmap3InputParams *)ptr, "ns1:genome_map3InputParams");
	case SOAP_TYPE_ns1__gcskewInputParams:
		return soap_out_ns1__gcskewInputParams(soap, tag, id, (const struct ns1__gcskewInputParams *)ptr, "ns1:gcskewInputParams");
	case SOAP_TYPE_ns1__circular_USCOREmapInputParams:
		return soap_out_ns1__circular_USCOREmapInputParams(soap, tag, id, (const struct ns1__circular_USCOREmapInputParams *)ptr, "ns1:circular_mapInputParams");
	case SOAP_TYPE_ns1__molecular_USCOREweightInputParams:
		return soap_out_ns1__molecular_USCOREweightInputParams(soap, tag, id, (const struct ns1__molecular_USCOREweightInputParams *)ptr, "ns1:molecular_weightInputParams");
	case SOAP_TYPE_ns1__delta_USCOREgcskewInputParams:
		return soap_out_ns1__delta_USCOREgcskewInputParams(soap, tag, id, (const struct ns1__delta_USCOREgcskewInputParams *)ptr, "ns1:delta_gcskewInputParams");
	case SOAP_TYPE_ns1__corInputParams:
		return soap_out_ns1__corInputParams(soap, tag, id, (const struct ns1__corInputParams *)ptr, "ns1:corInputParams");
	case SOAP_TYPE_ns1__geneskewInputParams:
		return soap_out_ns1__geneskewInputParams(soap, tag, id, (const struct ns1__geneskewInputParams *)ptr, "ns1:geneskewInputParams");
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriInputParams:
		return soap_out_ns1__genes_USCOREfrom_USCOREoriInputParams(soap, tag, id, (const struct ns1__genes_USCOREfrom_USCOREoriInputParams *)ptr, "ns1:genes_from_oriInputParams");
	case SOAP_TYPE_ns1__cbiInputParams:
		return soap_out_ns1__cbiInputParams(soap, tag, id, (const struct ns1__cbiInputParams *)ptr, "ns1:cbiInputParams");
	case SOAP_TYPE_ns1__find_USCOREdifInputParams:
		return soap_out_ns1__find_USCOREdifInputParams(soap, tag, id, (const struct ns1__find_USCOREdifInputParams *)ptr, "ns1:find_difInputParams");
	case SOAP_TYPE_ns1__to_USCOREfastaInputParams:
		return soap_out_ns1__to_USCOREfastaInputParams(soap, tag, id, (const struct ns1__to_USCOREfastaInputParams *)ptr, "ns1:to_fastaInputParams");
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicityInputParams:
		return soap_out_ns1__nucleotide_USCOREperiodicityInputParams(soap, tag, id, (const struct ns1__nucleotide_USCOREperiodicityInputParams *)ptr, "ns1:nucleotide_periodicityInputParams");
	case SOAP_TYPE_ns1__base_USCOREentropyInputParams:
		return soap_out_ns1__base_USCOREentropyInputParams(soap, tag, id, (const struct ns1__base_USCOREentropyInputParams *)ptr, "ns1:base_entropyInputParams");
	case SOAP_TYPE_ns1__plasmid_USCOREmapInputParams:
		return soap_out_ns1__plasmid_USCOREmapInputParams(soap, tag, id, (const struct ns1__plasmid_USCOREmapInputParams *)ptr, "ns1:plasmid_mapInputParams");
	case SOAP_TYPE_ns1__DoubleHelixInputParams:
		return soap_out_ns1__DoubleHelixInputParams(soap, tag, id, (const struct ns1__DoubleHelixInputParams *)ptr, "ns1:DoubleHelixInputParams");
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREterInputParams:
		return soap_out_ns1__rep_USCOREori_USCOREterInputParams(soap, tag, id, (const struct ns1__rep_USCOREori_USCOREterInputParams *)ptr, "ns1:rep_ori_terInputParams");
	case SOAP_TYPE_ns1__genome_USCOREmapInputParams:
		return soap_out_ns1__genome_USCOREmapInputParams(soap, tag, id, (const struct ns1__genome_USCOREmapInputParams *)ptr, "ns1:genome_mapInputParams");
	case SOAP_TYPE_ns1__consensus_USCOREzInputParams:
		return soap_out_ns1__consensus_USCOREzInputParams(soap, tag, id, (const struct ns1__consensus_USCOREzInputParams *)ptr, "ns1:consensus_zInputParams");
	case SOAP_TYPE_ns1__find_USCOREori_USCOREterInputParams:
		return soap_out_ns1__find_USCOREori_USCOREterInputParams(soap, tag, id, (const struct ns1__find_USCOREori_USCOREterInputParams *)ptr, "ns1:find_ori_terInputParams");
	case SOAP_TYPE_ns1__w_USCOREvalueInputParams:
		return soap_out_ns1__w_USCOREvalueInputParams(soap, tag, id, (const struct ns1__w_USCOREvalueInputParams *)ptr, "ns1:w_valueInputParams");
	case SOAP_TYPE_ns1__P2InputParams:
		return soap_out_ns1__P2InputParams(soap, tag, id, (const struct ns1__P2InputParams *)ptr, "ns1:P2InputParams");
	case SOAP_TYPE_ns1__codon_USCOREmvaInputParams:
		return soap_out_ns1__codon_USCOREmvaInputParams(soap, tag, id, (const struct ns1__codon_USCOREmvaInputParams *)ptr, "ns1:codon_mvaInputParams");
	case SOAP_TYPE_ns1__Definition:
		return soap_out_ns1__Definition(soap, tag, id, (const struct ns1__Definition *)ptr, "ns1:Definition");
	case SOAP_TYPE_PointerTofloat:
		return soap_out_PointerTofloat(soap, tag, id, (float *const*)ptr, "xsd:float");
	case SOAP_TYPE_PointerTons1__S_USCOREvalueInputParams:
		return soap_out_PointerTons1__S_USCOREvalueInputParams(soap, tag, id, (struct ns1__S_USCOREvalueInputParams *const*)ptr, "ns1:S_valueInputParams");
	case SOAP_TYPE_PointerTons1__leading_USCOREstrandResponse:
		return soap_out_PointerTons1__leading_USCOREstrandResponse(soap, tag, id, (struct ns1__leading_USCOREstrandResponse *const*)ptr, "ns1:leading_strandResponse");
	case SOAP_TYPE_PointerTons1__scsInputParams:
		return soap_out_PointerTons1__scsInputParams(soap, tag, id, (struct ns1__scsInputParams *const*)ptr, "ns1:scsInputParams");
	case SOAP_TYPE_PointerTons1__lda_USCOREbiasInputParams:
		return soap_out_PointerTons1__lda_USCOREbiasInputParams(soap, tag, id, (struct ns1__lda_USCOREbiasInputParams *const*)ptr, "ns1:lda_biasInputParams");
	case SOAP_TYPE_PointerTons1__kmer_USCOREtableInputParams:
		return soap_out_PointerTons1__kmer_USCOREtableInputParams(soap, tag, id, (struct ns1__kmer_USCOREtableInputParams *const*)ptr, "ns1:kmer_tableInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREz_USCOREvalueInputParams:
		return soap_out_PointerTons1__base_USCOREz_USCOREvalueInputParams(soap, tag, id, (struct ns1__base_USCOREz_USCOREvalueInputParams *const*)ptr, "ns1:base_z_valueInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREcounterInputParams:
		return soap_out_PointerTons1__base_USCOREcounterInputParams(soap, tag, id, (struct ns1__base_USCOREcounterInputParams *const*)ptr, "ns1:base_counterInputParams");
	case SOAP_TYPE_PointerTons1__B1InputParams:
		return soap_out_PointerTons1__B1InputParams(soap, tag, id, (struct ns1__B1InputParams *const*)ptr, "ns1:B1InputParams");
	case SOAP_TYPE_PointerTons1__cgrInputParams:
		return soap_out_PointerTons1__cgrInputParams(soap, tag, id, (struct ns1__cgrInputParams *const*)ptr, "ns1:cgrInputParams");
	case SOAP_TYPE_PointerTons1__dinucInputParams:
		return soap_out_PointerTons1__dinucInputParams(soap, tag, id, (struct ns1__dinucInputParams *const*)ptr, "ns1:dinucInputParams");
	case SOAP_TYPE_PointerTons1__least_USCOREsquares_USCOREfitResponse:
		return soap_out_PointerTons1__least_USCOREsquares_USCOREfitResponse(soap, tag, id, (struct ns1__least_USCOREsquares_USCOREfitResponse *const*)ptr, "ns1:least_squares_fitResponse");
	case SOAP_TYPE_PointerTons1__palindromeInputParams:
		return soap_out_PointerTons1__palindromeInputParams(soap, tag, id, (struct ns1__palindromeInputParams *const*)ptr, "ns1:palindromeInputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREcounterInputParams:
		return soap_out_PointerTons1__codon_USCOREcounterInputParams(soap, tag, id, (struct ns1__codon_USCOREcounterInputParams *const*)ptr, "ns1:codon_counterInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREiteronInputParams:
		return soap_out_PointerTons1__find_USCOREiteronInputParams(soap, tag, id, (struct ns1__find_USCOREiteronInputParams *const*)ptr, "ns1:find_iteronInputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREusageInputParams:
		return soap_out_PointerTons1__codon_USCOREusageInputParams(soap, tag, id, (struct ns1__codon_USCOREusageInputParams *const*)ptr, "ns1:codon_usageInputParams");
	case SOAP_TYPE_PointerTons1__oligomer_USCOREcounterInputParams:
		return soap_out_PointerTons1__oligomer_USCOREcounterInputParams(soap, tag, id, (struct ns1__oligomer_USCOREcounterInputParams *const*)ptr, "ns1:oligomer_counterInputParams");
	case SOAP_TYPE_PointerTons1__gcwinInputParams:
		return soap_out_PointerTons1__gcwinInputParams(soap, tag, id, (struct ns1__gcwinInputParams *const*)ptr, "ns1:gcwinInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREpatternInputParams:
		return soap_out_PointerTons1__find_USCOREpatternInputParams(soap, tag, id, (struct ns1__find_USCOREpatternInputParams *const*)ptr, "ns1:find_patternInputParams");
	case SOAP_TYPE_PointerTons1__oligomer_USCOREsearchResponse:
		return soap_out_PointerTons1__oligomer_USCOREsearchResponse(soap, tag, id, (struct ns1__oligomer_USCOREsearchResponse *const*)ptr, "ns1:oligomer_searchResponse");
	case SOAP_TYPE_PointerTons1__oligomer_USCOREsearchInputParams:
		return soap_out_PointerTons1__oligomer_USCOREsearchInputParams(soap, tag, id, (struct ns1__oligomer_USCOREsearchInputParams *const*)ptr, "ns1:oligomer_searchInputParams");
	case SOAP_TYPE_PointerTons1__shuffleseqInputParams:
		return soap_out_PointerTons1__shuffleseqInputParams(soap, tag, id, (struct ns1__shuffleseqInputParams *const*)ptr, "ns1:shuffleseqInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREterResponse:
		return soap_out_PointerTons1__find_USCOREterResponse(soap, tag, id, (struct ns1__find_USCOREterResponse *const*)ptr, "ns1:find_terResponse");
	case SOAP_TYPE_PointerTons1__find_USCOREterInputParams:
		return soap_out_PointerTons1__find_USCOREterInputParams(soap, tag, id, (struct ns1__find_USCOREterInputParams *const*)ptr, "ns1:find_terInputParams");
	case SOAP_TYPE_PointerTons1__dnawalkInputParams:
		return soap_out_PointerTons1__dnawalkInputParams(soap, tag, id, (struct ns1__dnawalkInputParams *const*)ptr, "ns1:dnawalkInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREinformation_USCOREcontentInputParams:
		return soap_out_PointerTons1__base_USCOREinformation_USCOREcontentInputParams(soap, tag, id, (struct ns1__base_USCOREinformation_USCOREcontentInputParams *const*)ptr, "ns1:base_information_contentInputParams");
	case SOAP_TYPE_PointerTons1__signatureInputParams:
		return soap_out_PointerTons1__signatureInputParams(soap, tag, id, (struct ns1__signatureInputParams *const*)ptr, "ns1:signatureInputParams");
	case SOAP_TYPE_PointerTons1__genome_USCOREmap3InputParams:
		return soap_out_PointerTons1__genome_USCOREmap3InputParams(soap, tag, id, (struct ns1__genome_USCOREmap3InputParams *const*)ptr, "ns1:genome_map3InputParams");
	case SOAP_TYPE_PointerTons1__gcskewInputParams:
		return soap_out_PointerTons1__gcskewInputParams(soap, tag, id, (struct ns1__gcskewInputParams *const*)ptr, "ns1:gcskewInputParams");
	case SOAP_TYPE_PointerTons1__molecular_USCOREweightInputParams:
		return soap_out_PointerTons1__molecular_USCOREweightInputParams(soap, tag, id, (struct ns1__molecular_USCOREweightInputParams *const*)ptr, "ns1:molecular_weightInputParams");
	case SOAP_TYPE_PointerTons1__delta_USCOREgcskewInputParams:
		return soap_out_PointerTons1__delta_USCOREgcskewInputParams(soap, tag, id, (struct ns1__delta_USCOREgcskewInputParams *const*)ptr, "ns1:delta_gcskewInputParams");
	case SOAP_TYPE_PointerTons1__cumulativeResponse:
		return soap_out_PointerTons1__cumulativeResponse(soap, tag, id, (struct ns1__cumulativeResponse *const*)ptr, "ns1:cumulativeResponse");
	case SOAP_TYPE_PointerTons1__corResponse:
		return soap_out_PointerTons1__corResponse(soap, tag, id, (struct ns1__corResponse *const*)ptr, "ns1:corResponse");
	case SOAP_TYPE_PointerTons1__corInputParams:
		return soap_out_PointerTons1__corInputParams(soap, tag, id, (struct ns1__corInputParams *const*)ptr, "ns1:corInputParams");
	case SOAP_TYPE_PointerTons1__geneskewInputParams:
		return soap_out_PointerTons1__geneskewInputParams(soap, tag, id, (struct ns1__geneskewInputParams *const*)ptr, "ns1:geneskewInputParams");
	case SOAP_TYPE_PointerTons1__genes_USCOREfrom_USCOREoriResponse:
		return soap_out_PointerTons1__genes_USCOREfrom_USCOREoriResponse(soap, tag, id, (struct ns1__genes_USCOREfrom_USCOREoriResponse *const*)ptr, "ns1:genes_from_oriResponse");
	case SOAP_TYPE_PointerTons1__genes_USCOREfrom_USCOREoriInputParams:
		return soap_out_PointerTons1__genes_USCOREfrom_USCOREoriInputParams(soap, tag, id, (struct ns1__genes_USCOREfrom_USCOREoriInputParams *const*)ptr, "ns1:genes_from_oriInputParams");
	case SOAP_TYPE_PointerTons1__cbiInputParams:
		return soap_out_PointerTons1__cbiInputParams(soap, tag, id, (struct ns1__cbiInputParams *const*)ptr, "ns1:cbiInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREdifResponse:
		return soap_out_PointerTons1__find_USCOREdifResponse(soap, tag, id, (struct ns1__find_USCOREdifResponse *const*)ptr, "ns1:find_difResponse");
	case SOAP_TYPE_PointerTons1__find_USCOREdifInputParams:
		return soap_out_PointerTons1__find_USCOREdifInputParams(soap, tag, id, (struct ns1__find_USCOREdifInputParams *const*)ptr, "ns1:find_difInputParams");
	case SOAP_TYPE_PointerTons1__to_USCOREfastaInputParams:
		return soap_out_PointerTons1__to_USCOREfastaInputParams(soap, tag, id, (struct ns1__to_USCOREfastaInputParams *const*)ptr, "ns1:to_fastaInputParams");
	case SOAP_TYPE_PointerTons1__base_USCOREentropyInputParams:
		return soap_out_PointerTons1__base_USCOREentropyInputParams(soap, tag, id, (struct ns1__base_USCOREentropyInputParams *const*)ptr, "ns1:base_entropyInputParams");
	case SOAP_TYPE_PointerTons1__DoubleHelixInputParams:
		return soap_out_PointerTons1__DoubleHelixInputParams(soap, tag, id, (struct ns1__DoubleHelixInputParams *const*)ptr, "ns1:DoubleHelixInputParams");
	case SOAP_TYPE_PointerTons1__rep_USCOREori_USCOREterInputParams:
		return soap_out_PointerTons1__rep_USCOREori_USCOREterInputParams(soap, tag, id, (struct ns1__rep_USCOREori_USCOREterInputParams *const*)ptr, "ns1:rep_ori_terInputParams");
	case SOAP_TYPE_PointerTons1__genome_USCOREmapInputParams:
		return soap_out_PointerTons1__genome_USCOREmapInputParams(soap, tag, id, (struct ns1__genome_USCOREmapInputParams *const*)ptr, "ns1:genome_mapInputParams");
	case SOAP_TYPE_PointerTons1__consensus_USCOREzInputParams:
		return soap_out_PointerTons1__consensus_USCOREzInputParams(soap, tag, id, (struct ns1__consensus_USCOREzInputParams *const*)ptr, "ns1:consensus_zInputParams");
	case SOAP_TYPE_PointerTons1__caiInputParams:
		return soap_out_PointerTons1__caiInputParams(soap, tag, id, (struct ns1__caiInputParams *const*)ptr, "ns1:caiInputParams");
	case SOAP_TYPE_PointerTons1__gcsiInputParams:
		return soap_out_PointerTons1__gcsiInputParams(soap, tag, id, (struct ns1__gcsiInputParams *const*)ptr, "ns1:gcsiInputParams");
	case SOAP_TYPE_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgResponse:
		return soap_out_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, tag, id, (struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *const*)ptr, "ns1:filter_cds_by_atgResponse");
	case SOAP_TYPE_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams:
		return soap_out_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, tag, id, (struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *const*)ptr, "ns1:filter_cds_by_atgInputParams");
	case SOAP_TYPE_PointerTons1__genomicskewInputParams:
		return soap_out_PointerTons1__genomicskewInputParams(soap, tag, id, (struct ns1__genomicskewInputParams *const*)ptr, "ns1:genomicskewInputParams");
	case SOAP_TYPE_PointerTons1__query_USCOREstrandInputParams:
		return soap_out_PointerTons1__query_USCOREstrandInputParams(soap, tag, id, (struct ns1__query_USCOREstrandInputParams *const*)ptr, "ns1:query_strandInputParams");
	case SOAP_TYPE_PointerTons1__view_USCOREcdsInputParams:
		return soap_out_PointerTons1__view_USCOREcdsInputParams(soap, tag, id, (struct ns1__view_USCOREcdsInputParams *const*)ptr, "ns1:view_cdsInputParams");
	case SOAP_TYPE_PointerTons1__base_USCORErelative_USCOREentropyInputParams:
		return soap_out_PointerTons1__base_USCORErelative_USCOREentropyInputParams(soap, tag, id, (struct ns1__base_USCORErelative_USCOREentropyInputParams *const*)ptr, "ns1:base_relative_entropyInputParams");
	case SOAP_TYPE_PointerTons1__EwInputParams:
		return soap_out_PointerTons1__EwInputParams(soap, tag, id, (struct ns1__EwInputParams *const*)ptr, "ns1:EwInputParams");
	case SOAP_TYPE_PointerTons1__over_USCORElapping_USCOREfinderInputParams:
		return soap_out_PointerTons1__over_USCORElapping_USCOREfinderInputParams(soap, tag, id, (struct ns1__over_USCORElapping_USCOREfinderInputParams *const*)ptr, "ns1:over_lapping_finderInputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREcompilerInputParams:
		return soap_out_PointerTons1__codon_USCOREcompilerInputParams(soap, tag, id, (struct ns1__codon_USCOREcompilerInputParams *const*)ptr, "ns1:codon_compilerInputParams");
	case SOAP_TYPE_PointerTons1__aauiInputParams:
		return soap_out_PointerTons1__aauiInputParams(soap, tag, id, (struct ns1__aauiInputParams *const*)ptr, "ns1:aauiInputParams");
	case SOAP_TYPE_PointerTons1__amino_USCOREcounterInputParams:
		return soap_out_PointerTons1__amino_USCOREcounterInputParams(soap, tag, id, (struct ns1__amino_USCOREcounterInputParams *const*)ptr, "ns1:amino_counterInputParams");
	case SOAP_TYPE_PointerTons1__seq2pngInputParams:
		return soap_out_PointerTons1__seq2pngInputParams(soap, tag, id, (struct ns1__seq2pngInputParams *const*)ptr, "ns1:seq2pngInputParams");
	case SOAP_TYPE_PointerTons1__ttestResponse:
		return soap_out_PointerTons1__ttestResponse(soap, tag, id, (struct ns1__ttestResponse *const*)ptr, "ns1:ttestResponse");
	case SOAP_TYPE_PointerTons1__ttestInputParams:
		return soap_out_PointerTons1__ttestInputParams(soap, tag, id, (struct ns1__ttestInputParams *const*)ptr, "ns1:ttestInputParams");
	case SOAP_TYPE_PointerToarrayOut:
		return soap_out_PointerToarrayOut(soap, tag, id, (struct arrayOut *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTons1__find_USCOREdnaAboxInputParams:
		return soap_out_PointerTons1__find_USCOREdnaAboxInputParams(soap, tag, id, (struct ns1__find_USCOREdnaAboxInputParams *const*)ptr, "ns1:find_dnaAboxInputParams");
	case SOAP_TYPE_PointerTons1__buiInputParams:
		return soap_out_PointerTons1__buiInputParams(soap, tag, id, (struct ns1__buiInputParams *const*)ptr, "ns1:buiInputParams");
	case SOAP_TYPE_PointerTons1__fopInputParams:
		return soap_out_PointerTons1__fopInputParams(soap, tag, id, (struct ns1__fopInputParams *const*)ptr, "ns1:fopInputParams");
	case SOAP_TYPE_PointerTons1__encInputParams:
		return soap_out_PointerTons1__encInputParams(soap, tag, id, (struct ns1__encInputParams *const*)ptr, "ns1:encInputParams");
	case SOAP_TYPE_PointerTons1__icdiInputParams:
		return soap_out_PointerTons1__icdiInputParams(soap, tag, id, (struct ns1__icdiInputParams *const*)ptr, "ns1:icdiInputParams");
	case SOAP_TYPE_PointerTons1__phxInputParams:
		return soap_out_PointerTons1__phxInputParams(soap, tag, id, (struct ns1__phxInputParams *const*)ptr, "ns1:phxInputParams");
	case SOAP_TYPE_PointerTons1__togoWSInputParams:
		return soap_out_PointerTons1__togoWSInputParams(soap, tag, id, (struct ns1__togoWSInputParams *const*)ptr, "ns1:togoWSInputParams");
	case SOAP_TYPE_PointerTons1__circular_USCOREmapInputParams:
		return soap_out_PointerTons1__circular_USCOREmapInputParams(soap, tag, id, (struct ns1__circular_USCOREmapInputParams *const*)ptr, "ns1:circular_mapInputParams");
	case SOAP_TYPE_PointerTons1__nucleotide_USCOREperiodicityInputParams:
		return soap_out_PointerTons1__nucleotide_USCOREperiodicityInputParams(soap, tag, id, (struct ns1__nucleotide_USCOREperiodicityInputParams *const*)ptr, "ns1:nucleotide_periodicityInputParams");
	case SOAP_TYPE_PointerTons1__plasmid_USCOREmapInputParams:
		return soap_out_PointerTons1__plasmid_USCOREmapInputParams(soap, tag, id, (struct ns1__plasmid_USCOREmapInputParams *const*)ptr, "ns1:plasmid_mapInputParams");
	case SOAP_TYPE_PointerTons1__find_USCOREori_USCOREterInputParams:
		return soap_out_PointerTons1__find_USCOREori_USCOREterInputParams(soap, tag, id, (struct ns1__find_USCOREori_USCOREterInputParams *const*)ptr, "ns1:find_ori_terInputParams");
	case SOAP_TYPE_PointerToarrayIn:
		return soap_out_PointerToarrayIn(soap, tag, id, (struct arrayIn *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTons1__w_USCOREvalueInputParams:
		return soap_out_PointerTons1__w_USCOREvalueInputParams(soap, tag, id, (struct ns1__w_USCOREvalueInputParams *const*)ptr, "ns1:w_valueInputParams");
	case SOAP_TYPE_PointerTons1__P2InputParams:
		return soap_out_PointerTons1__P2InputParams(soap, tag, id, (struct ns1__P2InputParams *const*)ptr, "ns1:P2InputParams");
	case SOAP_TYPE_PointerTons1__codon_USCOREmvaInputParams:
		return soap_out_PointerTons1__codon_USCOREmvaInputParams(soap, tag, id, (struct ns1__codon_USCOREmvaInputParams *const*)ptr, "ns1:codon_mvaInputParams");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ns1__hydropathy:
		soap_serialize_ns1__hydropathy(soap, (const struct ns1__hydropathy *)ptr);
		break;
	case SOAP_TYPE_ns1__hydropathyResponse:
		soap_serialize_ns1__hydropathyResponse(soap, (const struct ns1__hydropathyResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__help:
		soap_serialize_ns1__help(soap, (const struct ns1__help *)ptr);
		break;
	case SOAP_TYPE_ns1__helpResponse:
		soap_serialize_ns1__helpResponse(soap, (const struct ns1__helpResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__S_USCOREvalue:
		soap_serialize_ns1__S_USCOREvalue(soap, (const struct ns1__S_USCOREvalue *)ptr);
		break;
	case SOAP_TYPE_ns1__S_USCOREvalueResponse:
		soap_serialize_ns1__S_USCOREvalueResponse(soap, (const struct ns1__S_USCOREvalueResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__leading_USCOREstrand:
		soap_serialize_ns1__leading_USCOREstrand(soap, (const struct ns1__leading_USCOREstrand *)ptr);
		break;
	case SOAP_TYPE_ns1__leading_USCOREstrandResponse:
		soap_serialize_ns1__leading_USCOREstrandResponse(soap, (const struct ns1__leading_USCOREstrandResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__scs:
		soap_serialize_ns1__scs(soap, (const struct ns1__scs *)ptr);
		break;
	case SOAP_TYPE_ns1__scsResponse:
		soap_serialize_ns1__scsResponse(soap, (const struct ns1__scsResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__lda_USCOREbias:
		soap_serialize_ns1__lda_USCOREbias(soap, (const struct ns1__lda_USCOREbias *)ptr);
		break;
	case SOAP_TYPE_ns1__lda_USCOREbiasResponse:
		soap_serialize_ns1__lda_USCOREbiasResponse(soap, (const struct ns1__lda_USCOREbiasResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__kmer_USCOREtable:
		soap_serialize_ns1__kmer_USCOREtable(soap, (const struct ns1__kmer_USCOREtable *)ptr);
		break;
	case SOAP_TYPE_ns1__kmer_USCOREtableResponse:
		soap_serialize_ns1__kmer_USCOREtableResponse(soap, (const struct ns1__kmer_USCOREtableResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalue:
		soap_serialize_ns1__base_USCOREz_USCOREvalue(soap, (const struct ns1__base_USCOREz_USCOREvalue *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse:
		soap_serialize_ns1__base_USCOREz_USCOREvalueResponse(soap, (const struct ns1__base_USCOREz_USCOREvalueResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREcounter:
		soap_serialize_ns1__base_USCOREcounter(soap, (const struct ns1__base_USCOREcounter *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREcounterResponse:
		soap_serialize_ns1__base_USCOREcounterResponse(soap, (const struct ns1__base_USCOREcounterResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__B2:
		soap_serialize_ns1__B2(soap, (const struct ns1__B2 *)ptr);
		break;
	case SOAP_TYPE_ns1__B2Response:
		soap_serialize_ns1__B2Response(soap, (const struct ns1__B2Response *)ptr);
		break;
	case SOAP_TYPE_ns1__B1:
		soap_serialize_ns1__B1(soap, (const struct ns1__B1 *)ptr);
		break;
	case SOAP_TYPE_ns1__B1Response:
		soap_serialize_ns1__B1Response(soap, (const struct ns1__B1Response *)ptr);
		break;
	case SOAP_TYPE_ns1__cgr:
		soap_serialize_ns1__cgr(soap, (const struct ns1__cgr *)ptr);
		break;
	case SOAP_TYPE_ns1__cgrResponse:
		soap_serialize_ns1__cgrResponse(soap, (const struct ns1__cgrResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__dinuc:
		soap_serialize_ns1__dinuc(soap, (const struct ns1__dinuc *)ptr);
		break;
	case SOAP_TYPE_ns1__dinucResponse:
		soap_serialize_ns1__dinucResponse(soap, (const struct ns1__dinucResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit:
		soap_serialize_ns1__least_USCOREsquares_USCOREfit(soap, (const struct ns1__least_USCOREsquares_USCOREfit *)ptr);
		break;
	case SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse:
		soap_serialize_ns1__least_USCOREsquares_USCOREfitResponse(soap, (const struct ns1__least_USCOREsquares_USCOREfitResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__palindrome:
		soap_serialize_ns1__palindrome(soap, (const struct ns1__palindrome *)ptr);
		break;
	case SOAP_TYPE_ns1__palindromeResponse:
		soap_serialize_ns1__palindromeResponse(soap, (const struct ns1__palindromeResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__entrez:
		soap_serialize_ns1__entrez(soap, (const struct ns1__entrez *)ptr);
		break;
	case SOAP_TYPE_ns1__entrezResponse:
		soap_serialize_ns1__entrezResponse(soap, (const struct ns1__entrezResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREcounter:
		soap_serialize_ns1__codon_USCOREcounter(soap, (const struct ns1__codon_USCOREcounter *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREcounterResponse:
		soap_serialize_ns1__codon_USCOREcounterResponse(soap, (const struct ns1__codon_USCOREcounterResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__mean:
		soap_serialize_ns1__mean(soap, (const struct ns1__mean *)ptr);
		break;
	case SOAP_TYPE_ns1__meanResponse:
		soap_serialize_ns1__meanResponse(soap, (const struct ns1__meanResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__complement:
		soap_serialize_ns1__complement(soap, (const struct ns1__complement *)ptr);
		break;
	case SOAP_TYPE_ns1__complementResponse:
		soap_serialize_ns1__complementResponse(soap, (const struct ns1__complementResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREiteron:
		soap_serialize_ns1__find_USCOREiteron(soap, (const struct ns1__find_USCOREiteron *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREiteronResponse:
		soap_serialize_ns1__find_USCOREiteronResponse(soap, (const struct ns1__find_USCOREiteronResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__min:
		soap_serialize_ns1__min(soap, (const struct ns1__min *)ptr);
		break;
	case SOAP_TYPE_ns1__minResponse:
		soap_serialize_ns1__minResponse(soap, (const struct ns1__minResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREusage:
		soap_serialize_ns1__codon_USCOREusage(soap, (const struct ns1__codon_USCOREusage *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREusageResponse:
		soap_serialize_ns1__codon_USCOREusageResponse(soap, (const struct ns1__codon_USCOREusageResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__oligomer_USCOREcounter:
		soap_serialize_ns1__oligomer_USCOREcounter(soap, (const struct ns1__oligomer_USCOREcounter *)ptr);
		break;
	case SOAP_TYPE_ns1__oligomer_USCOREcounterResponse:
		soap_serialize_ns1__oligomer_USCOREcounterResponse(soap, (const struct ns1__oligomer_USCOREcounterResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__gcwin:
		soap_serialize_ns1__gcwin(soap, (const struct ns1__gcwin *)ptr);
		break;
	case SOAP_TYPE_ns1__gcwinResponse:
		soap_serialize_ns1__gcwinResponse(soap, (const struct ns1__gcwinResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREpattern:
		soap_serialize_ns1__find_USCOREpattern(soap, (const struct ns1__find_USCOREpattern *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREpatternResponse:
		soap_serialize_ns1__find_USCOREpatternResponse(soap, (const struct ns1__find_USCOREpatternResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__oligomer_USCOREsearch:
		soap_serialize_ns1__oligomer_USCOREsearch(soap, (const struct ns1__oligomer_USCOREsearch *)ptr);
		break;
	case SOAP_TYPE_ns1__oligomer_USCOREsearchResponse:
		soap_serialize_ns1__oligomer_USCOREsearchResponse(soap, (const struct ns1__oligomer_USCOREsearchResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__shuffleseq:
		soap_serialize_ns1__shuffleseq(soap, (const struct ns1__shuffleseq *)ptr);
		break;
	case SOAP_TYPE_ns1__shuffleseqResponse:
		soap_serialize_ns1__shuffleseqResponse(soap, (const struct ns1__shuffleseqResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREter:
		soap_serialize_ns1__find_USCOREter(soap, (const struct ns1__find_USCOREter *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREterResponse:
		soap_serialize_ns1__find_USCOREterResponse(soap, (const struct ns1__find_USCOREterResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__dnawalk:
		soap_serialize_ns1__dnawalk(soap, (const struct ns1__dnawalk *)ptr);
		break;
	case SOAP_TYPE_ns1__dnawalkResponse:
		soap_serialize_ns1__dnawalkResponse(soap, (const struct ns1__dnawalkResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent:
		soap_serialize_ns1__base_USCOREinformation_USCOREcontent(soap, (const struct ns1__base_USCOREinformation_USCOREcontent *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse:
		soap_serialize_ns1__base_USCOREinformation_USCOREcontentResponse(soap, (const struct ns1__base_USCOREinformation_USCOREcontentResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__signature:
		soap_serialize_ns1__signature(soap, (const struct ns1__signature *)ptr);
		break;
	case SOAP_TYPE_ns1__signatureResponse:
		soap_serialize_ns1__signatureResponse(soap, (const struct ns1__signatureResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__seqinfo:
		soap_serialize_ns1__seqinfo(soap, (const struct ns1__seqinfo *)ptr);
		break;
	case SOAP_TYPE_ns1__seqinfoResponse:
		soap_serialize_ns1__seqinfoResponse(soap, (const struct ns1__seqinfoResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__genome_USCOREmap3:
		soap_serialize_ns1__genome_USCOREmap3(soap, (const struct ns1__genome_USCOREmap3 *)ptr);
		break;
	case SOAP_TYPE_ns1__genome_USCOREmap3Response:
		soap_serialize_ns1__genome_USCOREmap3Response(soap, (const struct ns1__genome_USCOREmap3Response *)ptr);
		break;
	case SOAP_TYPE_ns1__gcskew:
		soap_serialize_ns1__gcskew(soap, (const struct ns1__gcskew *)ptr);
		break;
	case SOAP_TYPE_ns1__gcskewResponse:
		soap_serialize_ns1__gcskewResponse(soap, (const struct ns1__gcskewResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__molecular_USCOREweight:
		soap_serialize_ns1__molecular_USCOREweight(soap, (const struct ns1__molecular_USCOREweight *)ptr);
		break;
	case SOAP_TYPE_ns1__molecular_USCOREweightResponse:
		soap_serialize_ns1__molecular_USCOREweightResponse(soap, (const struct ns1__molecular_USCOREweightResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__delta_USCOREgcskew:
		soap_serialize_ns1__delta_USCOREgcskew(soap, (const struct ns1__delta_USCOREgcskew *)ptr);
		break;
	case SOAP_TYPE_ns1__delta_USCOREgcskewResponse:
		soap_serialize_ns1__delta_USCOREgcskewResponse(soap, (const struct ns1__delta_USCOREgcskewResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__delta_USCOREenc:
		soap_serialize_ns1__delta_USCOREenc(soap, (const struct ns1__delta_USCOREenc *)ptr);
		break;
	case SOAP_TYPE_ns1__delta_USCOREencResponse:
		soap_serialize_ns1__delta_USCOREencResponse(soap, (const struct ns1__delta_USCOREencResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__cumulative:
		soap_serialize_ns1__cumulative(soap, (const struct ns1__cumulative *)ptr);
		break;
	case SOAP_TYPE_ns1__cumulativeResponse:
		soap_serialize_ns1__cumulativeResponse(soap, (const struct ns1__cumulativeResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__cor:
		soap_serialize_ns1__cor(soap, (const struct ns1__cor *)ptr);
		break;
	case SOAP_TYPE_ns1__corResponse:
		soap_serialize_ns1__corResponse(soap, (const struct ns1__corResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__standard_USCOREdeviation:
		soap_serialize_ns1__standard_USCOREdeviation(soap, (const struct ns1__standard_USCOREdeviation *)ptr);
		break;
	case SOAP_TYPE_ns1__standard_USCOREdeviationResponse:
		soap_serialize_ns1__standard_USCOREdeviationResponse(soap, (const struct ns1__standard_USCOREdeviationResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__geneskew:
		soap_serialize_ns1__geneskew(soap, (const struct ns1__geneskew *)ptr);
		break;
	case SOAP_TYPE_ns1__geneskewResponse:
		soap_serialize_ns1__geneskewResponse(soap, (const struct ns1__geneskewResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori:
		soap_serialize_ns1__genes_USCOREfrom_USCOREori(soap, (const struct ns1__genes_USCOREfrom_USCOREori *)ptr);
		break;
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse:
		soap_serialize_ns1__genes_USCOREfrom_USCOREoriResponse(soap, (const struct ns1__genes_USCOREfrom_USCOREoriResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__cbi:
		soap_serialize_ns1__cbi(soap, (const struct ns1__cbi *)ptr);
		break;
	case SOAP_TYPE_ns1__cbiResponse:
		soap_serialize_ns1__cbiResponse(soap, (const struct ns1__cbiResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREdif:
		soap_serialize_ns1__find_USCOREdif(soap, (const struct ns1__find_USCOREdif *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREdifResponse:
		soap_serialize_ns1__find_USCOREdifResponse(soap, (const struct ns1__find_USCOREdifResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__to_USCOREfasta:
		soap_serialize_ns1__to_USCOREfasta(soap, (const struct ns1__to_USCOREfasta *)ptr);
		break;
	case SOAP_TYPE_ns1__to_USCOREfastaResponse:
		soap_serialize_ns1__to_USCOREfastaResponse(soap, (const struct ns1__to_USCOREfastaResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREentropy:
		soap_serialize_ns1__base_USCOREentropy(soap, (const struct ns1__base_USCOREentropy *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREentropyResponse:
		soap_serialize_ns1__base_USCOREentropyResponse(soap, (const struct ns1__base_USCOREentropyResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__DoubleHelix:
		soap_serialize_ns1__DoubleHelix(soap, (const struct ns1__DoubleHelix *)ptr);
		break;
	case SOAP_TYPE_ns1__DoubleHelixResponse:
		soap_serialize_ns1__DoubleHelixResponse(soap, (const struct ns1__DoubleHelixResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__calc_USCOREpI:
		soap_serialize_ns1__calc_USCOREpI(soap, (const struct ns1__calc_USCOREpI *)ptr);
		break;
	case SOAP_TYPE_ns1__calc_USCOREpIResponse:
		soap_serialize_ns1__calc_USCOREpIResponse(soap, (const struct ns1__calc_USCOREpIResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREter:
		soap_serialize_ns1__rep_USCOREori_USCOREter(soap, (const struct ns1__rep_USCOREori_USCOREter *)ptr);
		break;
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse:
		soap_serialize_ns1__rep_USCOREori_USCOREterResponse(soap, (const struct ns1__rep_USCOREori_USCOREterResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__longest_USCOREORF:
		soap_serialize_ns1__longest_USCOREORF(soap, (const struct ns1__longest_USCOREORF *)ptr);
		break;
	case SOAP_TYPE_ns1__longest_USCOREORFResponse:
		soap_serialize_ns1__longest_USCOREORFResponse(soap, (const struct ns1__longest_USCOREORFResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__genome_USCOREmap:
		soap_serialize_ns1__genome_USCOREmap(soap, (const struct ns1__genome_USCOREmap *)ptr);
		break;
	case SOAP_TYPE_ns1__genome_USCOREmapResponse:
		soap_serialize_ns1__genome_USCOREmapResponse(soap, (const struct ns1__genome_USCOREmapResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__consensus_USCOREz:
		soap_serialize_ns1__consensus_USCOREz(soap, (const struct ns1__consensus_USCOREz *)ptr);
		break;
	case SOAP_TYPE_ns1__consensus_USCOREzResponse:
		soap_serialize_ns1__consensus_USCOREzResponse(soap, (const struct ns1__consensus_USCOREzResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__mindex:
		soap_serialize_ns1__mindex(soap, (const struct ns1__mindex *)ptr);
		break;
	case SOAP_TYPE_ns1__mindexResponse:
		soap_serialize_ns1__mindexResponse(soap, (const struct ns1__mindexResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__query_USCOREarm:
		soap_serialize_ns1__query_USCOREarm(soap, (const struct ns1__query_USCOREarm *)ptr);
		break;
	case SOAP_TYPE_ns1__query_USCOREarmResponse:
		soap_serialize_ns1__query_USCOREarmResponse(soap, (const struct ns1__query_USCOREarmResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__max:
		soap_serialize_ns1__max(soap, (const struct ns1__max *)ptr);
		break;
	case SOAP_TYPE_ns1__maxResponse:
		soap_serialize_ns1__maxResponse(soap, (const struct ns1__maxResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__maxdex:
		soap_serialize_ns1__maxdex(soap, (const struct ns1__maxdex *)ptr);
		break;
	case SOAP_TYPE_ns1__maxdexResponse:
		soap_serialize_ns1__maxdexResponse(soap, (const struct ns1__maxdexResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__cai:
		soap_serialize_ns1__cai(soap, (const struct ns1__cai *)ptr);
		break;
	case SOAP_TYPE_ns1__caiResponse:
		soap_serialize_ns1__caiResponse(soap, (const struct ns1__caiResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__gcsi:
		soap_serialize_ns1__gcsi(soap, (const struct ns1__gcsi *)ptr);
		break;
	case SOAP_TYPE_ns1__gcsiResponse:
		soap_serialize_ns1__gcsiResponse(soap, (const struct ns1__gcsiResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg:
		soap_serialize_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, (const struct ns1__filter_USCOREcds_USCOREby_USCOREatg *)ptr);
		break;
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse:
		soap_serialize_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, (const struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__genomicskew:
		soap_serialize_ns1__genomicskew(soap, (const struct ns1__genomicskew *)ptr);
		break;
	case SOAP_TYPE_ns1__genomicskewResponse:
		soap_serialize_ns1__genomicskewResponse(soap, (const struct ns1__genomicskewResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__query_USCOREstrand:
		soap_serialize_ns1__query_USCOREstrand(soap, (const struct ns1__query_USCOREstrand *)ptr);
		break;
	case SOAP_TYPE_ns1__query_USCOREstrandResponse:
		soap_serialize_ns1__query_USCOREstrandResponse(soap, (const struct ns1__query_USCOREstrandResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__view_USCOREcds:
		soap_serialize_ns1__view_USCOREcds(soap, (const struct ns1__view_USCOREcds *)ptr);
		break;
	case SOAP_TYPE_ns1__view_USCOREcdsResponse:
		soap_serialize_ns1__view_USCOREcdsResponse(soap, (const struct ns1__view_USCOREcdsResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy:
		soap_serialize_ns1__base_USCORErelative_USCOREentropy(soap, (const struct ns1__base_USCORErelative_USCOREentropy *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse:
		soap_serialize_ns1__base_USCORErelative_USCOREentropyResponse(soap, (const struct ns1__base_USCORErelative_USCOREentropyResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__Ew:
		soap_serialize_ns1__Ew(soap, (const struct ns1__Ew *)ptr);
		break;
	case SOAP_TYPE_ns1__EwResponse:
		soap_serialize_ns1__EwResponse(soap, (const struct ns1__EwResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder:
		soap_serialize_ns1__over_USCORElapping_USCOREfinder(soap, (const struct ns1__over_USCORElapping_USCOREfinder *)ptr);
		break;
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse:
		soap_serialize_ns1__over_USCORElapping_USCOREfinderResponse(soap, (const struct ns1__over_USCORElapping_USCOREfinderResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREcompiler:
		soap_serialize_ns1__codon_USCOREcompiler(soap, (const struct ns1__codon_USCOREcompiler *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREcompilerResponse:
		soap_serialize_ns1__codon_USCOREcompilerResponse(soap, (const struct ns1__codon_USCOREcompilerResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__aaui:
		soap_serialize_ns1__aaui(soap, (const struct ns1__aaui *)ptr);
		break;
	case SOAP_TYPE_ns1__aauiResponse:
		soap_serialize_ns1__aauiResponse(soap, (const struct ns1__aauiResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__amino_USCOREcounter:
		soap_serialize_ns1__amino_USCOREcounter(soap, (const struct ns1__amino_USCOREcounter *)ptr);
		break;
	case SOAP_TYPE_ns1__amino_USCOREcounterResponse:
		soap_serialize_ns1__amino_USCOREcounterResponse(soap, (const struct ns1__amino_USCOREcounterResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__seq2png:
		soap_serialize_ns1__seq2png(soap, (const struct ns1__seq2png *)ptr);
		break;
	case SOAP_TYPE_ns1__seq2pngResponse:
		soap_serialize_ns1__seq2pngResponse(soap, (const struct ns1__seq2pngResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__ttest:
		soap_serialize_ns1__ttest(soap, (const struct ns1__ttest *)ptr);
		break;
	case SOAP_TYPE_ns1__ttestResponse:
		soap_serialize_ns1__ttestResponse(soap, (const struct ns1__ttestResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREdnaAbox:
		soap_serialize_ns1__find_USCOREdnaAbox(soap, (const struct ns1__find_USCOREdnaAbox *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREdnaAboxResponse:
		soap_serialize_ns1__find_USCOREdnaAboxResponse(soap, (const struct ns1__find_USCOREdnaAboxResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__dist_USCOREin_USCOREcc:
		soap_serialize_ns1__dist_USCOREin_USCOREcc(soap, (const struct ns1__dist_USCOREin_USCOREcc *)ptr);
		break;
	case SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse:
		soap_serialize_ns1__dist_USCOREin_USCOREccResponse(soap, (const struct ns1__dist_USCOREin_USCOREccResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__bui:
		soap_serialize_ns1__bui(soap, (const struct ns1__bui *)ptr);
		break;
	case SOAP_TYPE_ns1__buiResponse:
		soap_serialize_ns1__buiResponse(soap, (const struct ns1__buiResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__fop:
		soap_serialize_ns1__fop(soap, (const struct ns1__fop *)ptr);
		break;
	case SOAP_TYPE_ns1__fopResponse:
		soap_serialize_ns1__fopResponse(soap, (const struct ns1__fopResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__enc:
		soap_serialize_ns1__enc(soap, (const struct ns1__enc *)ptr);
		break;
	case SOAP_TYPE_ns1__encResponse:
		soap_serialize_ns1__encResponse(soap, (const struct ns1__encResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__icdi:
		soap_serialize_ns1__icdi(soap, (const struct ns1__icdi *)ptr);
		break;
	case SOAP_TYPE_ns1__icdiResponse:
		soap_serialize_ns1__icdiResponse(soap, (const struct ns1__icdiResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__phx:
		soap_serialize_ns1__phx(soap, (const struct ns1__phx *)ptr);
		break;
	case SOAP_TYPE_ns1__phxResponse:
		soap_serialize_ns1__phxResponse(soap, (const struct ns1__phxResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__translate:
		soap_serialize_ns1__translate(soap, (const struct ns1__translate *)ptr);
		break;
	case SOAP_TYPE_ns1__translateResponse:
		soap_serialize_ns1__translateResponse(soap, (const struct ns1__translateResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__togoWS:
		soap_serialize_ns1__togoWS(soap, (const struct ns1__togoWS *)ptr);
		break;
	case SOAP_TYPE_ns1__togoWSResponse:
		soap_serialize_ns1__togoWSResponse(soap, (const struct ns1__togoWSResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__circular_USCOREmap:
		soap_serialize_ns1__circular_USCOREmap(soap, (const struct ns1__circular_USCOREmap *)ptr);
		break;
	case SOAP_TYPE_ns1__circular_USCOREmapResponse:
		soap_serialize_ns1__circular_USCOREmapResponse(soap, (const struct ns1__circular_USCOREmapResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__amino_USCOREinfo:
		soap_serialize_ns1__amino_USCOREinfo(soap, (const struct ns1__amino_USCOREinfo *)ptr);
		break;
	case SOAP_TYPE_ns1__amino_USCOREinfoResponse:
		soap_serialize_ns1__amino_USCOREinfoResponse(soap, (const struct ns1__amino_USCOREinfoResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__variance:
		soap_serialize_ns1__variance(soap, (const struct ns1__variance *)ptr);
		break;
	case SOAP_TYPE_ns1__varianceResponse:
		soap_serialize_ns1__varianceResponse(soap, (const struct ns1__varianceResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicity:
		soap_serialize_ns1__nucleotide_USCOREperiodicity(soap, (const struct ns1__nucleotide_USCOREperiodicity *)ptr);
		break;
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse:
		soap_serialize_ns1__nucleotide_USCOREperiodicityResponse(soap, (const struct ns1__nucleotide_USCOREperiodicityResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__sum:
		soap_serialize_ns1__sum(soap, (const struct ns1__sum *)ptr);
		break;
	case SOAP_TYPE_ns1__sumResponse:
		soap_serialize_ns1__sumResponse(soap, (const struct ns1__sumResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__plasmid_USCOREmap:
		soap_serialize_ns1__plasmid_USCOREmap(soap, (const struct ns1__plasmid_USCOREmap *)ptr);
		break;
	case SOAP_TYPE_ns1__plasmid_USCOREmapResponse:
		soap_serialize_ns1__plasmid_USCOREmapResponse(soap, (const struct ns1__plasmid_USCOREmapResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREori_USCOREter:
		soap_serialize_ns1__find_USCOREori_USCOREter(soap, (const struct ns1__find_USCOREori_USCOREter *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse:
		soap_serialize_ns1__find_USCOREori_USCOREterResponse(soap, (const struct ns1__find_USCOREori_USCOREterResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__median:
		soap_serialize_ns1__median(soap, (const struct ns1__median *)ptr);
		break;
	case SOAP_TYPE_ns1__medianResponse:
		soap_serialize_ns1__medianResponse(soap, (const struct ns1__medianResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__splitprintseq:
		soap_serialize_ns1__splitprintseq(soap, (const struct ns1__splitprintseq *)ptr);
		break;
	case SOAP_TYPE_ns1__splitprintseqResponse:
		soap_serialize_ns1__splitprintseqResponse(soap, (const struct ns1__splitprintseqResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__w_USCOREvalue:
		soap_serialize_ns1__w_USCOREvalue(soap, (const struct ns1__w_USCOREvalue *)ptr);
		break;
	case SOAP_TYPE_ns1__w_USCOREvalueResponse:
		soap_serialize_ns1__w_USCOREvalueResponse(soap, (const struct ns1__w_USCOREvalueResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__P2:
		soap_serialize_ns1__P2(soap, (const struct ns1__P2 *)ptr);
		break;
	case SOAP_TYPE_ns1__P2Response:
		soap_serialize_ns1__P2Response(soap, (const struct ns1__P2Response *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREmva:
		soap_serialize_ns1__codon_USCOREmva(soap, (const struct ns1__codon_USCOREmva *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREmvaResponse:
		soap_serialize_ns1__codon_USCOREmvaResponse(soap, (const struct ns1__codon_USCOREmvaResponse *)ptr);
		break;
	case SOAP_TYPE_arrayOut:
		soap_serialize_arrayOut(soap, (const struct arrayOut *)ptr);
		break;
	case SOAP_TYPE_arrayIn:
		soap_serialize_arrayIn(soap, (const struct arrayIn *)ptr);
		break;
	case SOAP_TYPE_ns1__S_USCOREvalueInputParams:
		soap_serialize_ns1__S_USCOREvalueInputParams(soap, (const struct ns1__S_USCOREvalueInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__scsInputParams:
		soap_serialize_ns1__scsInputParams(soap, (const struct ns1__scsInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__signatureInputParams:
		soap_serialize_ns1__signatureInputParams(soap, (const struct ns1__signatureInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__lda_USCOREbiasInputParams:
		soap_serialize_ns1__lda_USCOREbiasInputParams(soap, (const struct ns1__lda_USCOREbiasInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__kmer_USCOREtableInputParams:
		soap_serialize_ns1__kmer_USCOREtableInputParams(soap, (const struct ns1__kmer_USCOREtableInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams:
		soap_serialize_ns1__base_USCOREz_USCOREvalueInputParams(soap, (const struct ns1__base_USCOREz_USCOREvalueInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREcounterInputParams:
		soap_serialize_ns1__base_USCOREcounterInputParams(soap, (const struct ns1__base_USCOREcounterInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__B1InputParams:
		soap_serialize_ns1__B1InputParams(soap, (const struct ns1__B1InputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__cgrInputParams:
		soap_serialize_ns1__cgrInputParams(soap, (const struct ns1__cgrInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__dinucInputParams:
		soap_serialize_ns1__dinucInputParams(soap, (const struct ns1__dinucInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__caiInputParams:
		soap_serialize_ns1__caiInputParams(soap, (const struct ns1__caiInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams:
		soap_serialize_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, (const struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__gcsiInputParams:
		soap_serialize_ns1__gcsiInputParams(soap, (const struct ns1__gcsiInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__query_USCOREstrandInputParams:
		soap_serialize_ns1__query_USCOREstrandInputParams(soap, (const struct ns1__query_USCOREstrandInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__genomicskewInputParams:
		soap_serialize_ns1__genomicskewInputParams(soap, (const struct ns1__genomicskewInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__palindromeInputParams:
		soap_serialize_ns1__palindromeInputParams(soap, (const struct ns1__palindromeInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams:
		soap_serialize_ns1__base_USCORErelative_USCOREentropyInputParams(soap, (const struct ns1__base_USCORErelative_USCOREentropyInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__view_USCOREcdsInputParams:
		soap_serialize_ns1__view_USCOREcdsInputParams(soap, (const struct ns1__view_USCOREcdsInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREcounterInputParams:
		soap_serialize_ns1__codon_USCOREcounterInputParams(soap, (const struct ns1__codon_USCOREcounterInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__EwInputParams:
		soap_serialize_ns1__EwInputParams(soap, (const struct ns1__EwInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREiteronInputParams:
		soap_serialize_ns1__find_USCOREiteronInputParams(soap, (const struct ns1__find_USCOREiteronInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams:
		soap_serialize_ns1__over_USCORElapping_USCOREfinderInputParams(soap, (const struct ns1__over_USCORElapping_USCOREfinderInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREcompilerInputParams:
		soap_serialize_ns1__codon_USCOREcompilerInputParams(soap, (const struct ns1__codon_USCOREcompilerInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__aauiInputParams:
		soap_serialize_ns1__aauiInputParams(soap, (const struct ns1__aauiInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__amino_USCOREcounterInputParams:
		soap_serialize_ns1__amino_USCOREcounterInputParams(soap, (const struct ns1__amino_USCOREcounterInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__seq2pngInputParams:
		soap_serialize_ns1__seq2pngInputParams(soap, (const struct ns1__seq2pngInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__ttestInputParams:
		soap_serialize_ns1__ttestInputParams(soap, (const struct ns1__ttestInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams:
		soap_serialize_ns1__find_USCOREdnaAboxInputParams(soap, (const struct ns1__find_USCOREdnaAboxInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREusageInputParams:
		soap_serialize_ns1__codon_USCOREusageInputParams(soap, (const struct ns1__codon_USCOREusageInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__buiInputParams:
		soap_serialize_ns1__buiInputParams(soap, (const struct ns1__buiInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__fopInputParams:
		soap_serialize_ns1__fopInputParams(soap, (const struct ns1__fopInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams:
		soap_serialize_ns1__oligomer_USCOREcounterInputParams(soap, (const struct ns1__oligomer_USCOREcounterInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__encInputParams:
		soap_serialize_ns1__encInputParams(soap, (const struct ns1__encInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__icdiInputParams:
		soap_serialize_ns1__icdiInputParams(soap, (const struct ns1__icdiInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__gcwinInputParams:
		soap_serialize_ns1__gcwinInputParams(soap, (const struct ns1__gcwinInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREpatternInputParams:
		soap_serialize_ns1__find_USCOREpatternInputParams(soap, (const struct ns1__find_USCOREpatternInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams:
		soap_serialize_ns1__oligomer_USCOREsearchInputParams(soap, (const struct ns1__oligomer_USCOREsearchInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__phxInputParams:
		soap_serialize_ns1__phxInputParams(soap, (const struct ns1__phxInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__shuffleseqInputParams:
		soap_serialize_ns1__shuffleseqInputParams(soap, (const struct ns1__shuffleseqInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREterInputParams:
		soap_serialize_ns1__find_USCOREterInputParams(soap, (const struct ns1__find_USCOREterInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__dnawalkInputParams:
		soap_serialize_ns1__dnawalkInputParams(soap, (const struct ns1__dnawalkInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams:
		soap_serialize_ns1__base_USCOREinformation_USCOREcontentInputParams(soap, (const struct ns1__base_USCOREinformation_USCOREcontentInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__togoWSInputParams:
		soap_serialize_ns1__togoWSInputParams(soap, (const struct ns1__togoWSInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__genome_USCOREmap3InputParams:
		soap_serialize_ns1__genome_USCOREmap3InputParams(soap, (const struct ns1__genome_USCOREmap3InputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__gcskewInputParams:
		soap_serialize_ns1__gcskewInputParams(soap, (const struct ns1__gcskewInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__circular_USCOREmapInputParams:
		soap_serialize_ns1__circular_USCOREmapInputParams(soap, (const struct ns1__circular_USCOREmapInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__molecular_USCOREweightInputParams:
		soap_serialize_ns1__molecular_USCOREweightInputParams(soap, (const struct ns1__molecular_USCOREweightInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__delta_USCOREgcskewInputParams:
		soap_serialize_ns1__delta_USCOREgcskewInputParams(soap, (const struct ns1__delta_USCOREgcskewInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__corInputParams:
		soap_serialize_ns1__corInputParams(soap, (const struct ns1__corInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__geneskewInputParams:
		soap_serialize_ns1__geneskewInputParams(soap, (const struct ns1__geneskewInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriInputParams:
		soap_serialize_ns1__genes_USCOREfrom_USCOREoriInputParams(soap, (const struct ns1__genes_USCOREfrom_USCOREoriInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__cbiInputParams:
		soap_serialize_ns1__cbiInputParams(soap, (const struct ns1__cbiInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREdifInputParams:
		soap_serialize_ns1__find_USCOREdifInputParams(soap, (const struct ns1__find_USCOREdifInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__to_USCOREfastaInputParams:
		soap_serialize_ns1__to_USCOREfastaInputParams(soap, (const struct ns1__to_USCOREfastaInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__nucleotide_USCOREperiodicityInputParams:
		soap_serialize_ns1__nucleotide_USCOREperiodicityInputParams(soap, (const struct ns1__nucleotide_USCOREperiodicityInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__base_USCOREentropyInputParams:
		soap_serialize_ns1__base_USCOREentropyInputParams(soap, (const struct ns1__base_USCOREentropyInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__plasmid_USCOREmapInputParams:
		soap_serialize_ns1__plasmid_USCOREmapInputParams(soap, (const struct ns1__plasmid_USCOREmapInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__DoubleHelixInputParams:
		soap_serialize_ns1__DoubleHelixInputParams(soap, (const struct ns1__DoubleHelixInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__rep_USCOREori_USCOREterInputParams:
		soap_serialize_ns1__rep_USCOREori_USCOREterInputParams(soap, (const struct ns1__rep_USCOREori_USCOREterInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__genome_USCOREmapInputParams:
		soap_serialize_ns1__genome_USCOREmapInputParams(soap, (const struct ns1__genome_USCOREmapInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__consensus_USCOREzInputParams:
		soap_serialize_ns1__consensus_USCOREzInputParams(soap, (const struct ns1__consensus_USCOREzInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__find_USCOREori_USCOREterInputParams:
		soap_serialize_ns1__find_USCOREori_USCOREterInputParams(soap, (const struct ns1__find_USCOREori_USCOREterInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__w_USCOREvalueInputParams:
		soap_serialize_ns1__w_USCOREvalueInputParams(soap, (const struct ns1__w_USCOREvalueInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__P2InputParams:
		soap_serialize_ns1__P2InputParams(soap, (const struct ns1__P2InputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__codon_USCOREmvaInputParams:
		soap_serialize_ns1__codon_USCOREmvaInputParams(soap, (const struct ns1__codon_USCOREmvaInputParams *)ptr);
		break;
	case SOAP_TYPE_ns1__Definition:
		soap_serialize_ns1__Definition(soap, (const struct ns1__Definition *)ptr);
		break;
	case SOAP_TYPE_PointerTofloat:
		soap_serialize_PointerTofloat(soap, (float *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__S_USCOREvalueInputParams:
		soap_serialize_PointerTons1__S_USCOREvalueInputParams(soap, (struct ns1__S_USCOREvalueInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__leading_USCOREstrandResponse:
		soap_serialize_PointerTons1__leading_USCOREstrandResponse(soap, (struct ns1__leading_USCOREstrandResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__scsInputParams:
		soap_serialize_PointerTons1__scsInputParams(soap, (struct ns1__scsInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__lda_USCOREbiasInputParams:
		soap_serialize_PointerTons1__lda_USCOREbiasInputParams(soap, (struct ns1__lda_USCOREbiasInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__kmer_USCOREtableInputParams:
		soap_serialize_PointerTons1__kmer_USCOREtableInputParams(soap, (struct ns1__kmer_USCOREtableInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__base_USCOREz_USCOREvalueInputParams:
		soap_serialize_PointerTons1__base_USCOREz_USCOREvalueInputParams(soap, (struct ns1__base_USCOREz_USCOREvalueInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__base_USCOREcounterInputParams:
		soap_serialize_PointerTons1__base_USCOREcounterInputParams(soap, (struct ns1__base_USCOREcounterInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__B1InputParams:
		soap_serialize_PointerTons1__B1InputParams(soap, (struct ns1__B1InputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__cgrInputParams:
		soap_serialize_PointerTons1__cgrInputParams(soap, (struct ns1__cgrInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__dinucInputParams:
		soap_serialize_PointerTons1__dinucInputParams(soap, (struct ns1__dinucInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__least_USCOREsquares_USCOREfitResponse:
		soap_serialize_PointerTons1__least_USCOREsquares_USCOREfitResponse(soap, (struct ns1__least_USCOREsquares_USCOREfitResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__palindromeInputParams:
		soap_serialize_PointerTons1__palindromeInputParams(soap, (struct ns1__palindromeInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__codon_USCOREcounterInputParams:
		soap_serialize_PointerTons1__codon_USCOREcounterInputParams(soap, (struct ns1__codon_USCOREcounterInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREiteronInputParams:
		soap_serialize_PointerTons1__find_USCOREiteronInputParams(soap, (struct ns1__find_USCOREiteronInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__codon_USCOREusageInputParams:
		soap_serialize_PointerTons1__codon_USCOREusageInputParams(soap, (struct ns1__codon_USCOREusageInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__oligomer_USCOREcounterInputParams:
		soap_serialize_PointerTons1__oligomer_USCOREcounterInputParams(soap, (struct ns1__oligomer_USCOREcounterInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__gcwinInputParams:
		soap_serialize_PointerTons1__gcwinInputParams(soap, (struct ns1__gcwinInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREpatternInputParams:
		soap_serialize_PointerTons1__find_USCOREpatternInputParams(soap, (struct ns1__find_USCOREpatternInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__oligomer_USCOREsearchResponse:
		soap_serialize_PointerTons1__oligomer_USCOREsearchResponse(soap, (struct ns1__oligomer_USCOREsearchResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__oligomer_USCOREsearchInputParams:
		soap_serialize_PointerTons1__oligomer_USCOREsearchInputParams(soap, (struct ns1__oligomer_USCOREsearchInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__shuffleseqInputParams:
		soap_serialize_PointerTons1__shuffleseqInputParams(soap, (struct ns1__shuffleseqInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREterResponse:
		soap_serialize_PointerTons1__find_USCOREterResponse(soap, (struct ns1__find_USCOREterResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREterInputParams:
		soap_serialize_PointerTons1__find_USCOREterInputParams(soap, (struct ns1__find_USCOREterInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__dnawalkInputParams:
		soap_serialize_PointerTons1__dnawalkInputParams(soap, (struct ns1__dnawalkInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__base_USCOREinformation_USCOREcontentInputParams:
		soap_serialize_PointerTons1__base_USCOREinformation_USCOREcontentInputParams(soap, (struct ns1__base_USCOREinformation_USCOREcontentInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__signatureInputParams:
		soap_serialize_PointerTons1__signatureInputParams(soap, (struct ns1__signatureInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__genome_USCOREmap3InputParams:
		soap_serialize_PointerTons1__genome_USCOREmap3InputParams(soap, (struct ns1__genome_USCOREmap3InputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__gcskewInputParams:
		soap_serialize_PointerTons1__gcskewInputParams(soap, (struct ns1__gcskewInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__molecular_USCOREweightInputParams:
		soap_serialize_PointerTons1__molecular_USCOREweightInputParams(soap, (struct ns1__molecular_USCOREweightInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__delta_USCOREgcskewInputParams:
		soap_serialize_PointerTons1__delta_USCOREgcskewInputParams(soap, (struct ns1__delta_USCOREgcskewInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__cumulativeResponse:
		soap_serialize_PointerTons1__cumulativeResponse(soap, (struct ns1__cumulativeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__corResponse:
		soap_serialize_PointerTons1__corResponse(soap, (struct ns1__corResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__corInputParams:
		soap_serialize_PointerTons1__corInputParams(soap, (struct ns1__corInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__geneskewInputParams:
		soap_serialize_PointerTons1__geneskewInputParams(soap, (struct ns1__geneskewInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__genes_USCOREfrom_USCOREoriResponse:
		soap_serialize_PointerTons1__genes_USCOREfrom_USCOREoriResponse(soap, (struct ns1__genes_USCOREfrom_USCOREoriResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__genes_USCOREfrom_USCOREoriInputParams:
		soap_serialize_PointerTons1__genes_USCOREfrom_USCOREoriInputParams(soap, (struct ns1__genes_USCOREfrom_USCOREoriInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__cbiInputParams:
		soap_serialize_PointerTons1__cbiInputParams(soap, (struct ns1__cbiInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREdifResponse:
		soap_serialize_PointerTons1__find_USCOREdifResponse(soap, (struct ns1__find_USCOREdifResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREdifInputParams:
		soap_serialize_PointerTons1__find_USCOREdifInputParams(soap, (struct ns1__find_USCOREdifInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__to_USCOREfastaInputParams:
		soap_serialize_PointerTons1__to_USCOREfastaInputParams(soap, (struct ns1__to_USCOREfastaInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__base_USCOREentropyInputParams:
		soap_serialize_PointerTons1__base_USCOREentropyInputParams(soap, (struct ns1__base_USCOREentropyInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__DoubleHelixInputParams:
		soap_serialize_PointerTons1__DoubleHelixInputParams(soap, (struct ns1__DoubleHelixInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__rep_USCOREori_USCOREterInputParams:
		soap_serialize_PointerTons1__rep_USCOREori_USCOREterInputParams(soap, (struct ns1__rep_USCOREori_USCOREterInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__genome_USCOREmapInputParams:
		soap_serialize_PointerTons1__genome_USCOREmapInputParams(soap, (struct ns1__genome_USCOREmapInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__consensus_USCOREzInputParams:
		soap_serialize_PointerTons1__consensus_USCOREzInputParams(soap, (struct ns1__consensus_USCOREzInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__caiInputParams:
		soap_serialize_PointerTons1__caiInputParams(soap, (struct ns1__caiInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__gcsiInputParams:
		soap_serialize_PointerTons1__gcsiInputParams(soap, (struct ns1__gcsiInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgResponse:
		soap_serialize_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, (struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams:
		soap_serialize_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, (struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__genomicskewInputParams:
		soap_serialize_PointerTons1__genomicskewInputParams(soap, (struct ns1__genomicskewInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__query_USCOREstrandInputParams:
		soap_serialize_PointerTons1__query_USCOREstrandInputParams(soap, (struct ns1__query_USCOREstrandInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__view_USCOREcdsInputParams:
		soap_serialize_PointerTons1__view_USCOREcdsInputParams(soap, (struct ns1__view_USCOREcdsInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__base_USCORErelative_USCOREentropyInputParams:
		soap_serialize_PointerTons1__base_USCORErelative_USCOREentropyInputParams(soap, (struct ns1__base_USCORErelative_USCOREentropyInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__EwInputParams:
		soap_serialize_PointerTons1__EwInputParams(soap, (struct ns1__EwInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__over_USCORElapping_USCOREfinderInputParams:
		soap_serialize_PointerTons1__over_USCORElapping_USCOREfinderInputParams(soap, (struct ns1__over_USCORElapping_USCOREfinderInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__codon_USCOREcompilerInputParams:
		soap_serialize_PointerTons1__codon_USCOREcompilerInputParams(soap, (struct ns1__codon_USCOREcompilerInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__aauiInputParams:
		soap_serialize_PointerTons1__aauiInputParams(soap, (struct ns1__aauiInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__amino_USCOREcounterInputParams:
		soap_serialize_PointerTons1__amino_USCOREcounterInputParams(soap, (struct ns1__amino_USCOREcounterInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__seq2pngInputParams:
		soap_serialize_PointerTons1__seq2pngInputParams(soap, (struct ns1__seq2pngInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__ttestResponse:
		soap_serialize_PointerTons1__ttestResponse(soap, (struct ns1__ttestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__ttestInputParams:
		soap_serialize_PointerTons1__ttestInputParams(soap, (struct ns1__ttestInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerToarrayOut:
		soap_serialize_PointerToarrayOut(soap, (struct arrayOut *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREdnaAboxInputParams:
		soap_serialize_PointerTons1__find_USCOREdnaAboxInputParams(soap, (struct ns1__find_USCOREdnaAboxInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__buiInputParams:
		soap_serialize_PointerTons1__buiInputParams(soap, (struct ns1__buiInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__fopInputParams:
		soap_serialize_PointerTons1__fopInputParams(soap, (struct ns1__fopInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__encInputParams:
		soap_serialize_PointerTons1__encInputParams(soap, (struct ns1__encInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__icdiInputParams:
		soap_serialize_PointerTons1__icdiInputParams(soap, (struct ns1__icdiInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__phxInputParams:
		soap_serialize_PointerTons1__phxInputParams(soap, (struct ns1__phxInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__togoWSInputParams:
		soap_serialize_PointerTons1__togoWSInputParams(soap, (struct ns1__togoWSInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__circular_USCOREmapInputParams:
		soap_serialize_PointerTons1__circular_USCOREmapInputParams(soap, (struct ns1__circular_USCOREmapInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__nucleotide_USCOREperiodicityInputParams:
		soap_serialize_PointerTons1__nucleotide_USCOREperiodicityInputParams(soap, (struct ns1__nucleotide_USCOREperiodicityInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__plasmid_USCOREmapInputParams:
		soap_serialize_PointerTons1__plasmid_USCOREmapInputParams(soap, (struct ns1__plasmid_USCOREmapInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__find_USCOREori_USCOREterInputParams:
		soap_serialize_PointerTons1__find_USCOREori_USCOREterInputParams(soap, (struct ns1__find_USCOREori_USCOREterInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerToarrayIn:
		soap_serialize_PointerToarrayIn(soap, (struct arrayIn *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__w_USCOREvalueInputParams:
		soap_serialize_PointerTons1__w_USCOREvalueInputParams(soap, (struct ns1__w_USCOREvalueInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__P2InputParams:
		soap_serialize_PointerTons1__P2InputParams(soap, (struct ns1__P2InputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__codon_USCOREmvaInputParams:
		soap_serialize_PointerTons1__codon_USCOREmvaInputParams(soap, (struct ns1__codon_USCOREmvaInputParams *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{	float *p;
	p = soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag?tag:"float", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{	double *p;
	p = soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
	if (soap_out_double(soap, tag?tag:"double", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__hydropathy(struct soap *soap, struct ns1__hydropathy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__hydropathy(struct soap *soap, const struct ns1__hydropathy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__hydropathy(struct soap *soap, const char *tag, int id, const struct ns1__hydropathy *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__hydropathy), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__hydropathy * SOAP_FMAC4 soap_in_ns1__hydropathy(struct soap *soap, const char *tag, struct ns1__hydropathy *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__hydropathy *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__hydropathy, sizeof(struct ns1__hydropathy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__hydropathy(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__hydropathy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__hydropathy, 0, sizeof(struct ns1__hydropathy), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__hydropathy(struct soap *soap, const struct ns1__hydropathy *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__hydropathy);
	if (soap_out_ns1__hydropathy(soap, tag?tag:"ns1:hydropathy", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__hydropathy * SOAP_FMAC4 soap_get_ns1__hydropathy(struct soap *soap, struct ns1__hydropathy *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__hydropathy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__hydropathyResponse(struct soap *soap, struct ns1__hydropathyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__hydropathyResponse(struct soap *soap, const struct ns1__hydropathyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTofloat(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__hydropathyResponse(struct soap *soap, const char *tag, int id, const struct ns1__hydropathyResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__hydropathyResponse), type))
		return soap->error;
	if (soap_out_PointerTofloat(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__hydropathyResponse * SOAP_FMAC4 soap_in_ns1__hydropathyResponse(struct soap *soap, const char *tag, struct ns1__hydropathyResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__hydropathyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__hydropathyResponse, sizeof(struct ns1__hydropathyResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__hydropathyResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTofloat(soap, NULL, &a->_result, "xsd:float"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__hydropathyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__hydropathyResponse, 0, sizeof(struct ns1__hydropathyResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__hydropathyResponse(struct soap *soap, const struct ns1__hydropathyResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__hydropathyResponse);
	if (soap_out_ns1__hydropathyResponse(soap, tag?tag:"ns1:hydropathyResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__hydropathyResponse * SOAP_FMAC4 soap_get_ns1__hydropathyResponse(struct soap *soap, struct ns1__hydropathyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__hydropathyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__help(struct soap *soap, struct ns1__help *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_keywords);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__help(struct soap *soap, const struct ns1__help *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_keywords);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__help(struct soap *soap, const char *tag, int id, const struct ns1__help *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__help), type))
		return soap->error;
	if (soap_out_string(soap, "keywords", -1, &a->_keywords, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__help * SOAP_FMAC4 soap_in_ns1__help(struct soap *soap, const char *tag, struct ns1__help *a, const char *type)
{
	size_t soap_flag__keywords = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__help *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__help, sizeof(struct ns1__help), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__help(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__keywords && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_keywords, "xsd:string"))
				{	soap_flag__keywords--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__help *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__help, 0, sizeof(struct ns1__help), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__help(struct soap *soap, const struct ns1__help *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__help);
	if (soap_out_ns1__help(soap, tag?tag:"ns1:help", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__help * SOAP_FMAC4 soap_get_ns1__help(struct soap *soap, struct ns1__help *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__help(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__helpResponse(struct soap *soap, struct ns1__helpResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__helpResponse(struct soap *soap, const struct ns1__helpResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__helpResponse(struct soap *soap, const char *tag, int id, const struct ns1__helpResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__helpResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__helpResponse * SOAP_FMAC4 soap_in_ns1__helpResponse(struct soap *soap, const char *tag, struct ns1__helpResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__helpResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__helpResponse, sizeof(struct ns1__helpResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__helpResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__helpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__helpResponse, 0, sizeof(struct ns1__helpResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__helpResponse(struct soap *soap, const struct ns1__helpResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__helpResponse);
	if (soap_out_ns1__helpResponse(soap, tag?tag:"ns1:helpResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__helpResponse * SOAP_FMAC4 soap_get_ns1__helpResponse(struct soap *soap, struct ns1__helpResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__helpResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__S_USCOREvalue(struct soap *soap, struct ns1__S_USCOREvalue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__S_USCOREvalue(struct soap *soap, const struct ns1__S_USCOREvalue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__S_USCOREvalueInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__S_USCOREvalue(struct soap *soap, const char *tag, int id, const struct ns1__S_USCOREvalue *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__S_USCOREvalue), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__S_USCOREvalueInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__S_USCOREvalue * SOAP_FMAC4 soap_in_ns1__S_USCOREvalue(struct soap *soap, const char *tag, struct ns1__S_USCOREvalue *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__S_USCOREvalue *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__S_USCOREvalue, sizeof(struct ns1__S_USCOREvalue), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__S_USCOREvalue(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__S_USCOREvalueInputParams(soap, NULL, &a->_params, "ns1:S_valueInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__S_USCOREvalue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__S_USCOREvalue, 0, sizeof(struct ns1__S_USCOREvalue), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__S_USCOREvalue(struct soap *soap, const struct ns1__S_USCOREvalue *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__S_USCOREvalue);
	if (soap_out_ns1__S_USCOREvalue(soap, tag?tag:"ns1:S_value", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__S_USCOREvalue * SOAP_FMAC4 soap_get_ns1__S_USCOREvalue(struct soap *soap, struct ns1__S_USCOREvalue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__S_USCOREvalue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__S_USCOREvalueResponse(struct soap *soap, struct ns1__S_USCOREvalueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__S_USCOREvalueResponse(struct soap *soap, const struct ns1__S_USCOREvalueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__S_USCOREvalueResponse(struct soap *soap, const char *tag, int id, const struct ns1__S_USCOREvalueResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__S_USCOREvalueResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__S_USCOREvalueResponse * SOAP_FMAC4 soap_in_ns1__S_USCOREvalueResponse(struct soap *soap, const char *tag, struct ns1__S_USCOREvalueResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__S_USCOREvalueResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__S_USCOREvalueResponse, sizeof(struct ns1__S_USCOREvalueResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__S_USCOREvalueResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__S_USCOREvalueResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__S_USCOREvalueResponse, 0, sizeof(struct ns1__S_USCOREvalueResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__S_USCOREvalueResponse(struct soap *soap, const struct ns1__S_USCOREvalueResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__S_USCOREvalueResponse);
	if (soap_out_ns1__S_USCOREvalueResponse(soap, tag?tag:"ns1:S_valueResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__S_USCOREvalueResponse * SOAP_FMAC4 soap_get_ns1__S_USCOREvalueResponse(struct soap *soap, struct ns1__S_USCOREvalueResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__S_USCOREvalueResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__leading_USCOREstrand(struct soap *soap, struct ns1__leading_USCOREstrand *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__leading_USCOREstrand(struct soap *soap, const struct ns1__leading_USCOREstrand *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__leading_USCOREstrand(struct soap *soap, const char *tag, int id, const struct ns1__leading_USCOREstrand *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__leading_USCOREstrand), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__leading_USCOREstrand * SOAP_FMAC4 soap_in_ns1__leading_USCOREstrand(struct soap *soap, const char *tag, struct ns1__leading_USCOREstrand *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__leading_USCOREstrand *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__leading_USCOREstrand, sizeof(struct ns1__leading_USCOREstrand), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__leading_USCOREstrand(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__leading_USCOREstrand *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__leading_USCOREstrand, 0, sizeof(struct ns1__leading_USCOREstrand), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__leading_USCOREstrand(struct soap *soap, const struct ns1__leading_USCOREstrand *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__leading_USCOREstrand);
	if (soap_out_ns1__leading_USCOREstrand(soap, tag?tag:"ns1:leading_strand", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__leading_USCOREstrand * SOAP_FMAC4 soap_get_ns1__leading_USCOREstrand(struct soap *soap, struct ns1__leading_USCOREstrand *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__leading_USCOREstrand(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__leading_USCOREstrandResponse(struct soap *soap, struct ns1__leading_USCOREstrandResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__leading_USCOREstrandResponse(struct soap *soap, const struct ns1__leading_USCOREstrandResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__leading_USCOREstrandResponse(struct soap *soap, const char *tag, int id, const struct ns1__leading_USCOREstrandResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__leading_USCOREstrandResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__leading_USCOREstrandResponse * SOAP_FMAC4 soap_in_ns1__leading_USCOREstrandResponse(struct soap *soap, const char *tag, struct ns1__leading_USCOREstrandResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__leading_USCOREstrandResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__leading_USCOREstrandResponse, sizeof(struct ns1__leading_USCOREstrandResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__leading_USCOREstrandResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__leading_USCOREstrandResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__leading_USCOREstrandResponse, 0, sizeof(struct ns1__leading_USCOREstrandResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__leading_USCOREstrandResponse(struct soap *soap, const struct ns1__leading_USCOREstrandResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__leading_USCOREstrandResponse);
	if (soap_out_ns1__leading_USCOREstrandResponse(soap, tag?tag:"ns1:leading_strandResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__leading_USCOREstrandResponse * SOAP_FMAC4 soap_get_ns1__leading_USCOREstrandResponse(struct soap *soap, struct ns1__leading_USCOREstrandResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__leading_USCOREstrandResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__scs(struct soap *soap, struct ns1__scs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__scs(struct soap *soap, const struct ns1__scs *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__scsInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__scs(struct soap *soap, const char *tag, int id, const struct ns1__scs *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__scs), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__scsInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__scs * SOAP_FMAC4 soap_in_ns1__scs(struct soap *soap, const char *tag, struct ns1__scs *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__scs *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__scs, sizeof(struct ns1__scs), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__scs(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__scsInputParams(soap, NULL, &a->_params, "ns1:scsInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__scs *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__scs, 0, sizeof(struct ns1__scs), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__scs(struct soap *soap, const struct ns1__scs *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__scs);
	if (soap_out_ns1__scs(soap, tag?tag:"ns1:scs", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__scs * SOAP_FMAC4 soap_get_ns1__scs(struct soap *soap, struct ns1__scs *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__scs(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__scsResponse(struct soap *soap, struct ns1__scsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__scsResponse(struct soap *soap, const struct ns1__scsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__scsResponse(struct soap *soap, const char *tag, int id, const struct ns1__scsResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__scsResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__scsResponse * SOAP_FMAC4 soap_in_ns1__scsResponse(struct soap *soap, const char *tag, struct ns1__scsResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__scsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__scsResponse, sizeof(struct ns1__scsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__scsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__scsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__scsResponse, 0, sizeof(struct ns1__scsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__scsResponse(struct soap *soap, const struct ns1__scsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__scsResponse);
	if (soap_out_ns1__scsResponse(soap, tag?tag:"ns1:scsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__scsResponse * SOAP_FMAC4 soap_get_ns1__scsResponse(struct soap *soap, struct ns1__scsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__scsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__lda_USCOREbias(struct soap *soap, struct ns1__lda_USCOREbias *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__lda_USCOREbias(struct soap *soap, const struct ns1__lda_USCOREbias *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__lda_USCOREbiasInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__lda_USCOREbias(struct soap *soap, const char *tag, int id, const struct ns1__lda_USCOREbias *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__lda_USCOREbias), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__lda_USCOREbiasInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__lda_USCOREbias * SOAP_FMAC4 soap_in_ns1__lda_USCOREbias(struct soap *soap, const char *tag, struct ns1__lda_USCOREbias *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__lda_USCOREbias *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__lda_USCOREbias, sizeof(struct ns1__lda_USCOREbias), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__lda_USCOREbias(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__lda_USCOREbiasInputParams(soap, NULL, &a->_params, "ns1:lda_biasInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__lda_USCOREbias *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__lda_USCOREbias, 0, sizeof(struct ns1__lda_USCOREbias), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__lda_USCOREbias(struct soap *soap, const struct ns1__lda_USCOREbias *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__lda_USCOREbias);
	if (soap_out_ns1__lda_USCOREbias(soap, tag?tag:"ns1:lda_bias", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__lda_USCOREbias * SOAP_FMAC4 soap_get_ns1__lda_USCOREbias(struct soap *soap, struct ns1__lda_USCOREbias *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__lda_USCOREbias(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__lda_USCOREbiasResponse(struct soap *soap, struct ns1__lda_USCOREbiasResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__lda_USCOREbiasResponse(struct soap *soap, const struct ns1__lda_USCOREbiasResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__lda_USCOREbiasResponse(struct soap *soap, const char *tag, int id, const struct ns1__lda_USCOREbiasResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__lda_USCOREbiasResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__lda_USCOREbiasResponse * SOAP_FMAC4 soap_in_ns1__lda_USCOREbiasResponse(struct soap *soap, const char *tag, struct ns1__lda_USCOREbiasResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__lda_USCOREbiasResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__lda_USCOREbiasResponse, sizeof(struct ns1__lda_USCOREbiasResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__lda_USCOREbiasResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__lda_USCOREbiasResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__lda_USCOREbiasResponse, 0, sizeof(struct ns1__lda_USCOREbiasResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__lda_USCOREbiasResponse(struct soap *soap, const struct ns1__lda_USCOREbiasResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__lda_USCOREbiasResponse);
	if (soap_out_ns1__lda_USCOREbiasResponse(soap, tag?tag:"ns1:lda_biasResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__lda_USCOREbiasResponse * SOAP_FMAC4 soap_get_ns1__lda_USCOREbiasResponse(struct soap *soap, struct ns1__lda_USCOREbiasResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__lda_USCOREbiasResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__kmer_USCOREtable(struct soap *soap, struct ns1__kmer_USCOREtable *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__kmer_USCOREtable(struct soap *soap, const struct ns1__kmer_USCOREtable *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__kmer_USCOREtableInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__kmer_USCOREtable(struct soap *soap, const char *tag, int id, const struct ns1__kmer_USCOREtable *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__kmer_USCOREtable), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__kmer_USCOREtableInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__kmer_USCOREtable * SOAP_FMAC4 soap_in_ns1__kmer_USCOREtable(struct soap *soap, const char *tag, struct ns1__kmer_USCOREtable *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__kmer_USCOREtable *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__kmer_USCOREtable, sizeof(struct ns1__kmer_USCOREtable), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__kmer_USCOREtable(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__kmer_USCOREtableInputParams(soap, NULL, &a->_params, "ns1:kmer_tableInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__kmer_USCOREtable *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__kmer_USCOREtable, 0, sizeof(struct ns1__kmer_USCOREtable), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__kmer_USCOREtable(struct soap *soap, const struct ns1__kmer_USCOREtable *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__kmer_USCOREtable);
	if (soap_out_ns1__kmer_USCOREtable(soap, tag?tag:"ns1:kmer_table", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__kmer_USCOREtable * SOAP_FMAC4 soap_get_ns1__kmer_USCOREtable(struct soap *soap, struct ns1__kmer_USCOREtable *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__kmer_USCOREtable(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__kmer_USCOREtableResponse(struct soap *soap, struct ns1__kmer_USCOREtableResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__kmer_USCOREtableResponse(struct soap *soap, const struct ns1__kmer_USCOREtableResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__kmer_USCOREtableResponse(struct soap *soap, const char *tag, int id, const struct ns1__kmer_USCOREtableResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__kmer_USCOREtableResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__kmer_USCOREtableResponse * SOAP_FMAC4 soap_in_ns1__kmer_USCOREtableResponse(struct soap *soap, const char *tag, struct ns1__kmer_USCOREtableResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__kmer_USCOREtableResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__kmer_USCOREtableResponse, sizeof(struct ns1__kmer_USCOREtableResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__kmer_USCOREtableResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__kmer_USCOREtableResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__kmer_USCOREtableResponse, 0, sizeof(struct ns1__kmer_USCOREtableResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__kmer_USCOREtableResponse(struct soap *soap, const struct ns1__kmer_USCOREtableResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__kmer_USCOREtableResponse);
	if (soap_out_ns1__kmer_USCOREtableResponse(soap, tag?tag:"ns1:kmer_tableResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__kmer_USCOREtableResponse * SOAP_FMAC4 soap_get_ns1__kmer_USCOREtableResponse(struct soap *soap, struct ns1__kmer_USCOREtableResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__kmer_USCOREtableResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREz_USCOREvalue(struct soap *soap, struct ns1__base_USCOREz_USCOREvalue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREz_USCOREvalue(struct soap *soap, const struct ns1__base_USCOREz_USCOREvalue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__base_USCOREz_USCOREvalueInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREz_USCOREvalue(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREz_USCOREvalue *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREz_USCOREvalue), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__base_USCOREz_USCOREvalueInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREz_USCOREvalue * SOAP_FMAC4 soap_in_ns1__base_USCOREz_USCOREvalue(struct soap *soap, const char *tag, struct ns1__base_USCOREz_USCOREvalue *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREz_USCOREvalue *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREz_USCOREvalue, sizeof(struct ns1__base_USCOREz_USCOREvalue), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREz_USCOREvalue(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__base_USCOREz_USCOREvalueInputParams(soap, NULL, &a->_params, "ns1:base_z_valueInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREz_USCOREvalue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREz_USCOREvalue, 0, sizeof(struct ns1__base_USCOREz_USCOREvalue), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREz_USCOREvalue(struct soap *soap, const struct ns1__base_USCOREz_USCOREvalue *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREz_USCOREvalue);
	if (soap_out_ns1__base_USCOREz_USCOREvalue(soap, tag?tag:"ns1:base_z_value", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREz_USCOREvalue * SOAP_FMAC4 soap_get_ns1__base_USCOREz_USCOREvalue(struct soap *soap, struct ns1__base_USCOREz_USCOREvalue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREz_USCOREvalue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREz_USCOREvalueResponse(struct soap *soap, struct ns1__base_USCOREz_USCOREvalueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREz_USCOREvalueResponse(struct soap *soap, const struct ns1__base_USCOREz_USCOREvalueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREz_USCOREvalueResponse(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREz_USCOREvalueResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREz_USCOREvalueResponse * SOAP_FMAC4 soap_in_ns1__base_USCOREz_USCOREvalueResponse(struct soap *soap, const char *tag, struct ns1__base_USCOREz_USCOREvalueResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREz_USCOREvalueResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse, sizeof(struct ns1__base_USCOREz_USCOREvalueResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREz_USCOREvalueResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREz_USCOREvalueResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse, 0, sizeof(struct ns1__base_USCOREz_USCOREvalueResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREz_USCOREvalueResponse(struct soap *soap, const struct ns1__base_USCOREz_USCOREvalueResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueResponse);
	if (soap_out_ns1__base_USCOREz_USCOREvalueResponse(soap, tag?tag:"ns1:base_z_valueResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREz_USCOREvalueResponse * SOAP_FMAC4 soap_get_ns1__base_USCOREz_USCOREvalueResponse(struct soap *soap, struct ns1__base_USCOREz_USCOREvalueResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREz_USCOREvalueResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREcounter(struct soap *soap, struct ns1__base_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREcounter(struct soap *soap, const struct ns1__base_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__base_USCOREcounterInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREcounter(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREcounter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREcounter), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__base_USCOREcounterInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREcounter * SOAP_FMAC4 soap_in_ns1__base_USCOREcounter(struct soap *soap, const char *tag, struct ns1__base_USCOREcounter *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREcounter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREcounter, sizeof(struct ns1__base_USCOREcounter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREcounter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__base_USCOREcounterInputParams(soap, NULL, &a->_params, "ns1:base_counterInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREcounter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREcounter, 0, sizeof(struct ns1__base_USCOREcounter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREcounter(struct soap *soap, const struct ns1__base_USCOREcounter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREcounter);
	if (soap_out_ns1__base_USCOREcounter(soap, tag?tag:"ns1:base_counter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREcounter * SOAP_FMAC4 soap_get_ns1__base_USCOREcounter(struct soap *soap, struct ns1__base_USCOREcounter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREcounter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREcounterResponse(struct soap *soap, struct ns1__base_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREcounterResponse(struct soap *soap, const struct ns1__base_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREcounterResponse(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREcounterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREcounterResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREcounterResponse * SOAP_FMAC4 soap_in_ns1__base_USCOREcounterResponse(struct soap *soap, const char *tag, struct ns1__base_USCOREcounterResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREcounterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREcounterResponse, sizeof(struct ns1__base_USCOREcounterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREcounterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREcounterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREcounterResponse, 0, sizeof(struct ns1__base_USCOREcounterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREcounterResponse(struct soap *soap, const struct ns1__base_USCOREcounterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREcounterResponse);
	if (soap_out_ns1__base_USCOREcounterResponse(soap, tag?tag:"ns1:base_counterResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREcounterResponse * SOAP_FMAC4 soap_get_ns1__base_USCOREcounterResponse(struct soap *soap, struct ns1__base_USCOREcounterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREcounterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__B2(struct soap *soap, struct ns1__B2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__B2(struct soap *soap, const struct ns1__B2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__B2(struct soap *soap, const char *tag, int id, const struct ns1__B2 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__B2), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__B2 * SOAP_FMAC4 soap_in_ns1__B2(struct soap *soap, const char *tag, struct ns1__B2 *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__B2 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__B2, sizeof(struct ns1__B2), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__B2(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__B2 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__B2, 0, sizeof(struct ns1__B2), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__B2(struct soap *soap, const struct ns1__B2 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__B2);
	if (soap_out_ns1__B2(soap, tag?tag:"ns1:B2", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__B2 * SOAP_FMAC4 soap_get_ns1__B2(struct soap *soap, struct ns1__B2 *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__B2(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__B2Response(struct soap *soap, struct ns1__B2Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__B2Response(struct soap *soap, const struct ns1__B2Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__B2Response(struct soap *soap, const char *tag, int id, const struct ns1__B2Response *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__B2Response), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__B2Response * SOAP_FMAC4 soap_in_ns1__B2Response(struct soap *soap, const char *tag, struct ns1__B2Response *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__B2Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__B2Response, sizeof(struct ns1__B2Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__B2Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__B2Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__B2Response, 0, sizeof(struct ns1__B2Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__B2Response(struct soap *soap, const struct ns1__B2Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__B2Response);
	if (soap_out_ns1__B2Response(soap, tag?tag:"ns1:B2Response", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__B2Response * SOAP_FMAC4 soap_get_ns1__B2Response(struct soap *soap, struct ns1__B2Response *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__B2Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__B1(struct soap *soap, struct ns1__B1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__B1(struct soap *soap, const struct ns1__B1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__B1InputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__B1(struct soap *soap, const char *tag, int id, const struct ns1__B1 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__B1), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__B1InputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__B1 * SOAP_FMAC4 soap_in_ns1__B1(struct soap *soap, const char *tag, struct ns1__B1 *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__B1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__B1, sizeof(struct ns1__B1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__B1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__B1InputParams(soap, NULL, &a->_params, "ns1:B1InputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__B1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__B1, 0, sizeof(struct ns1__B1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__B1(struct soap *soap, const struct ns1__B1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__B1);
	if (soap_out_ns1__B1(soap, tag?tag:"ns1:B1", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__B1 * SOAP_FMAC4 soap_get_ns1__B1(struct soap *soap, struct ns1__B1 *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__B1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__B1Response(struct soap *soap, struct ns1__B1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__B1Response(struct soap *soap, const struct ns1__B1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__B1Response(struct soap *soap, const char *tag, int id, const struct ns1__B1Response *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__B1Response), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__B1Response * SOAP_FMAC4 soap_in_ns1__B1Response(struct soap *soap, const char *tag, struct ns1__B1Response *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__B1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__B1Response, sizeof(struct ns1__B1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__B1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__B1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__B1Response, 0, sizeof(struct ns1__B1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__B1Response(struct soap *soap, const struct ns1__B1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__B1Response);
	if (soap_out_ns1__B1Response(soap, tag?tag:"ns1:B1Response", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__B1Response * SOAP_FMAC4 soap_get_ns1__B1Response(struct soap *soap, struct ns1__B1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__B1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cgr(struct soap *soap, struct ns1__cgr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cgr(struct soap *soap, const struct ns1__cgr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__cgrInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cgr(struct soap *soap, const char *tag, int id, const struct ns1__cgr *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cgr), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__cgrInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cgr * SOAP_FMAC4 soap_in_ns1__cgr(struct soap *soap, const char *tag, struct ns1__cgr *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cgr *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cgr, sizeof(struct ns1__cgr), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cgr(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__cgrInputParams(soap, NULL, &a->_params, "ns1:cgrInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cgr *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cgr, 0, sizeof(struct ns1__cgr), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cgr(struct soap *soap, const struct ns1__cgr *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cgr);
	if (soap_out_ns1__cgr(soap, tag?tag:"ns1:cgr", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cgr * SOAP_FMAC4 soap_get_ns1__cgr(struct soap *soap, struct ns1__cgr *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cgr(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cgrResponse(struct soap *soap, struct ns1__cgrResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cgrResponse(struct soap *soap, const struct ns1__cgrResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cgrResponse(struct soap *soap, const char *tag, int id, const struct ns1__cgrResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cgrResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cgrResponse * SOAP_FMAC4 soap_in_ns1__cgrResponse(struct soap *soap, const char *tag, struct ns1__cgrResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cgrResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cgrResponse, sizeof(struct ns1__cgrResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cgrResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cgrResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cgrResponse, 0, sizeof(struct ns1__cgrResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cgrResponse(struct soap *soap, const struct ns1__cgrResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cgrResponse);
	if (soap_out_ns1__cgrResponse(soap, tag?tag:"ns1:cgrResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cgrResponse * SOAP_FMAC4 soap_get_ns1__cgrResponse(struct soap *soap, struct ns1__cgrResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cgrResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dinuc(struct soap *soap, struct ns1__dinuc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dinuc(struct soap *soap, const struct ns1__dinuc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__dinucInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dinuc(struct soap *soap, const char *tag, int id, const struct ns1__dinuc *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dinuc), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__dinucInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dinuc * SOAP_FMAC4 soap_in_ns1__dinuc(struct soap *soap, const char *tag, struct ns1__dinuc *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dinuc *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dinuc, sizeof(struct ns1__dinuc), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dinuc(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__dinucInputParams(soap, NULL, &a->_params, "ns1:dinucInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dinuc *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dinuc, 0, sizeof(struct ns1__dinuc), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dinuc(struct soap *soap, const struct ns1__dinuc *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dinuc);
	if (soap_out_ns1__dinuc(soap, tag?tag:"ns1:dinuc", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dinuc * SOAP_FMAC4 soap_get_ns1__dinuc(struct soap *soap, struct ns1__dinuc *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dinuc(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dinucResponse(struct soap *soap, struct ns1__dinucResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dinucResponse(struct soap *soap, const struct ns1__dinucResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dinucResponse(struct soap *soap, const char *tag, int id, const struct ns1__dinucResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dinucResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dinucResponse * SOAP_FMAC4 soap_in_ns1__dinucResponse(struct soap *soap, const char *tag, struct ns1__dinucResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dinucResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dinucResponse, sizeof(struct ns1__dinucResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dinucResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dinucResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dinucResponse, 0, sizeof(struct ns1__dinucResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dinucResponse(struct soap *soap, const struct ns1__dinucResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dinucResponse);
	if (soap_out_ns1__dinucResponse(soap, tag?tag:"ns1:dinucResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dinucResponse * SOAP_FMAC4 soap_get_ns1__dinucResponse(struct soap *soap, struct ns1__dinucResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dinucResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__least_USCOREsquares_USCOREfit(struct soap *soap, struct ns1__least_USCOREsquares_USCOREfit *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__least_USCOREsquares_USCOREfit(struct soap *soap, const struct ns1__least_USCOREsquares_USCOREfit *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__least_USCOREsquares_USCOREfit(struct soap *soap, const char *tag, int id, const struct ns1__least_USCOREsquares_USCOREfit *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__least_USCOREsquares_USCOREfit * SOAP_FMAC4 soap_in_ns1__least_USCOREsquares_USCOREfit(struct soap *soap, const char *tag, struct ns1__least_USCOREsquares_USCOREfit *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__least_USCOREsquares_USCOREfit *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit, sizeof(struct ns1__least_USCOREsquares_USCOREfit), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__least_USCOREsquares_USCOREfit(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__least_USCOREsquares_USCOREfit *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit, 0, sizeof(struct ns1__least_USCOREsquares_USCOREfit), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__least_USCOREsquares_USCOREfit(struct soap *soap, const struct ns1__least_USCOREsquares_USCOREfit *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfit);
	if (soap_out_ns1__least_USCOREsquares_USCOREfit(soap, tag?tag:"ns1:least_squares_fit", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__least_USCOREsquares_USCOREfit * SOAP_FMAC4 soap_get_ns1__least_USCOREsquares_USCOREfit(struct soap *soap, struct ns1__least_USCOREsquares_USCOREfit *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__least_USCOREsquares_USCOREfit(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__least_USCOREsquares_USCOREfitResponse(struct soap *soap, struct ns1__least_USCOREsquares_USCOREfitResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__least_USCOREsquares_USCOREfitResponse(struct soap *soap, const struct ns1__least_USCOREsquares_USCOREfitResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__least_USCOREsquares_USCOREfitResponse(struct soap *soap, const char *tag, int id, const struct ns1__least_USCOREsquares_USCOREfitResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__least_USCOREsquares_USCOREfitResponse * SOAP_FMAC4 soap_in_ns1__least_USCOREsquares_USCOREfitResponse(struct soap *soap, const char *tag, struct ns1__least_USCOREsquares_USCOREfitResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__least_USCOREsquares_USCOREfitResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse, sizeof(struct ns1__least_USCOREsquares_USCOREfitResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__least_USCOREsquares_USCOREfitResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__least_USCOREsquares_USCOREfitResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse, 0, sizeof(struct ns1__least_USCOREsquares_USCOREfitResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__least_USCOREsquares_USCOREfitResponse(struct soap *soap, const struct ns1__least_USCOREsquares_USCOREfitResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__least_USCOREsquares_USCOREfitResponse);
	if (soap_out_ns1__least_USCOREsquares_USCOREfitResponse(soap, tag?tag:"ns1:least_squares_fitResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__least_USCOREsquares_USCOREfitResponse * SOAP_FMAC4 soap_get_ns1__least_USCOREsquares_USCOREfitResponse(struct soap *soap, struct ns1__least_USCOREsquares_USCOREfitResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__least_USCOREsquares_USCOREfitResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__palindrome(struct soap *soap, struct ns1__palindrome *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__palindrome(struct soap *soap, const struct ns1__palindrome *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__palindromeInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__palindrome(struct soap *soap, const char *tag, int id, const struct ns1__palindrome *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__palindrome), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__palindromeInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__palindrome * SOAP_FMAC4 soap_in_ns1__palindrome(struct soap *soap, const char *tag, struct ns1__palindrome *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__palindrome *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__palindrome, sizeof(struct ns1__palindrome), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__palindrome(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__palindromeInputParams(soap, NULL, &a->_params, "ns1:palindromeInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__palindrome *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__palindrome, 0, sizeof(struct ns1__palindrome), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__palindrome(struct soap *soap, const struct ns1__palindrome *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__palindrome);
	if (soap_out_ns1__palindrome(soap, tag?tag:"ns1:palindrome", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__palindrome * SOAP_FMAC4 soap_get_ns1__palindrome(struct soap *soap, struct ns1__palindrome *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__palindrome(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__palindromeResponse(struct soap *soap, struct ns1__palindromeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__palindromeResponse(struct soap *soap, const struct ns1__palindromeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__palindromeResponse(struct soap *soap, const char *tag, int id, const struct ns1__palindromeResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__palindromeResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__palindromeResponse * SOAP_FMAC4 soap_in_ns1__palindromeResponse(struct soap *soap, const char *tag, struct ns1__palindromeResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__palindromeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__palindromeResponse, sizeof(struct ns1__palindromeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__palindromeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__palindromeResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__palindromeResponse, 0, sizeof(struct ns1__palindromeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__palindromeResponse(struct soap *soap, const struct ns1__palindromeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__palindromeResponse);
	if (soap_out_ns1__palindromeResponse(soap, tag?tag:"ns1:palindromeResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__palindromeResponse * SOAP_FMAC4 soap_get_ns1__palindromeResponse(struct soap *soap, struct ns1__palindromeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__palindromeResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__entrez(struct soap *soap, struct ns1__entrez *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_database);
	soap_default_string(soap, &a->_query);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__entrez(struct soap *soap, const struct ns1__entrez *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_database);
	soap_serialize_string(soap, &a->_query);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__entrez(struct soap *soap, const char *tag, int id, const struct ns1__entrez *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__entrez), type))
		return soap->error;
	if (soap_out_string(soap, "database", -1, &a->_database, ""))
		return soap->error;
	if (soap_out_string(soap, "query", -1, &a->_query, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__entrez * SOAP_FMAC4 soap_in_ns1__entrez(struct soap *soap, const char *tag, struct ns1__entrez *a, const char *type)
{
	size_t soap_flag__database = 1;
	size_t soap_flag__query = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__entrez *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__entrez, sizeof(struct ns1__entrez), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__entrez(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__database && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_database, "xsd:string"))
				{	soap_flag__database--;
					continue;
				}
			if (soap_flag__query && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_query, "xsd:string"))
				{	soap_flag__query--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__entrez *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__entrez, 0, sizeof(struct ns1__entrez), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__entrez(struct soap *soap, const struct ns1__entrez *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__entrez);
	if (soap_out_ns1__entrez(soap, tag?tag:"ns1:entrez", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__entrez * SOAP_FMAC4 soap_get_ns1__entrez(struct soap *soap, struct ns1__entrez *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__entrez(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__entrezResponse(struct soap *soap, struct ns1__entrezResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__entrezResponse(struct soap *soap, const struct ns1__entrezResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__entrezResponse(struct soap *soap, const char *tag, int id, const struct ns1__entrezResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__entrezResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__entrezResponse * SOAP_FMAC4 soap_in_ns1__entrezResponse(struct soap *soap, const char *tag, struct ns1__entrezResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__entrezResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__entrezResponse, sizeof(struct ns1__entrezResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__entrezResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__entrezResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__entrezResponse, 0, sizeof(struct ns1__entrezResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__entrezResponse(struct soap *soap, const struct ns1__entrezResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__entrezResponse);
	if (soap_out_ns1__entrezResponse(soap, tag?tag:"ns1:entrezResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__entrezResponse * SOAP_FMAC4 soap_get_ns1__entrezResponse(struct soap *soap, struct ns1__entrezResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__entrezResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREcounter(struct soap *soap, struct ns1__codon_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREcounter(struct soap *soap, const struct ns1__codon_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__codon_USCOREcounterInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREcounter(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREcounter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREcounter), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__codon_USCOREcounterInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREcounter * SOAP_FMAC4 soap_in_ns1__codon_USCOREcounter(struct soap *soap, const char *tag, struct ns1__codon_USCOREcounter *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREcounter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREcounter, sizeof(struct ns1__codon_USCOREcounter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREcounter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__codon_USCOREcounterInputParams(soap, NULL, &a->_params, "ns1:codon_counterInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREcounter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREcounter, 0, sizeof(struct ns1__codon_USCOREcounter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREcounter(struct soap *soap, const struct ns1__codon_USCOREcounter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREcounter);
	if (soap_out_ns1__codon_USCOREcounter(soap, tag?tag:"ns1:codon_counter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREcounter * SOAP_FMAC4 soap_get_ns1__codon_USCOREcounter(struct soap *soap, struct ns1__codon_USCOREcounter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREcounter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREcounterResponse(struct soap *soap, struct ns1__codon_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREcounterResponse(struct soap *soap, const struct ns1__codon_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREcounterResponse(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREcounterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREcounterResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREcounterResponse * SOAP_FMAC4 soap_in_ns1__codon_USCOREcounterResponse(struct soap *soap, const char *tag, struct ns1__codon_USCOREcounterResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREcounterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREcounterResponse, sizeof(struct ns1__codon_USCOREcounterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREcounterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREcounterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREcounterResponse, 0, sizeof(struct ns1__codon_USCOREcounterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREcounterResponse(struct soap *soap, const struct ns1__codon_USCOREcounterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREcounterResponse);
	if (soap_out_ns1__codon_USCOREcounterResponse(soap, tag?tag:"ns1:codon_counterResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREcounterResponse * SOAP_FMAC4 soap_get_ns1__codon_USCOREcounterResponse(struct soap *soap, struct ns1__codon_USCOREcounterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREcounterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__mean(struct soap *soap, struct ns1__mean *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__mean(struct soap *soap, const struct ns1__mean *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__mean(struct soap *soap, const char *tag, int id, const struct ns1__mean *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__mean), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__mean * SOAP_FMAC4 soap_in_ns1__mean(struct soap *soap, const char *tag, struct ns1__mean *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__mean *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__mean, sizeof(struct ns1__mean), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__mean(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__mean *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__mean, 0, sizeof(struct ns1__mean), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__mean(struct soap *soap, const struct ns1__mean *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__mean);
	if (soap_out_ns1__mean(soap, tag?tag:"ns1:mean", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__mean * SOAP_FMAC4 soap_get_ns1__mean(struct soap *soap, struct ns1__mean *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__mean(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__meanResponse(struct soap *soap, struct ns1__meanResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__meanResponse(struct soap *soap, const struct ns1__meanResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__meanResponse(struct soap *soap, const char *tag, int id, const struct ns1__meanResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__meanResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__meanResponse * SOAP_FMAC4 soap_in_ns1__meanResponse(struct soap *soap, const char *tag, struct ns1__meanResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__meanResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__meanResponse, sizeof(struct ns1__meanResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__meanResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__meanResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__meanResponse, 0, sizeof(struct ns1__meanResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__meanResponse(struct soap *soap, const struct ns1__meanResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__meanResponse);
	if (soap_out_ns1__meanResponse(soap, tag?tag:"ns1:meanResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__meanResponse * SOAP_FMAC4 soap_get_ns1__meanResponse(struct soap *soap, struct ns1__meanResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__meanResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__complement(struct soap *soap, struct ns1__complement *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__complement(struct soap *soap, const struct ns1__complement *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__complement(struct soap *soap, const char *tag, int id, const struct ns1__complement *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__complement), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__complement * SOAP_FMAC4 soap_in_ns1__complement(struct soap *soap, const char *tag, struct ns1__complement *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__complement *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__complement, sizeof(struct ns1__complement), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__complement(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__complement *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__complement, 0, sizeof(struct ns1__complement), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__complement(struct soap *soap, const struct ns1__complement *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__complement);
	if (soap_out_ns1__complement(soap, tag?tag:"ns1:complement", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__complement * SOAP_FMAC4 soap_get_ns1__complement(struct soap *soap, struct ns1__complement *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__complement(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__complementResponse(struct soap *soap, struct ns1__complementResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__complementResponse(struct soap *soap, const struct ns1__complementResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__complementResponse(struct soap *soap, const char *tag, int id, const struct ns1__complementResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__complementResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__complementResponse * SOAP_FMAC4 soap_in_ns1__complementResponse(struct soap *soap, const char *tag, struct ns1__complementResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__complementResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__complementResponse, sizeof(struct ns1__complementResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__complementResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__complementResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__complementResponse, 0, sizeof(struct ns1__complementResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__complementResponse(struct soap *soap, const struct ns1__complementResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__complementResponse);
	if (soap_out_ns1__complementResponse(soap, tag?tag:"ns1:complementResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__complementResponse * SOAP_FMAC4 soap_get_ns1__complementResponse(struct soap *soap, struct ns1__complementResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__complementResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREiteron(struct soap *soap, struct ns1__find_USCOREiteron *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREiteron(struct soap *soap, const struct ns1__find_USCOREiteron *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__find_USCOREiteronInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREiteron(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREiteron *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREiteron), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__find_USCOREiteronInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREiteron * SOAP_FMAC4 soap_in_ns1__find_USCOREiteron(struct soap *soap, const char *tag, struct ns1__find_USCOREiteron *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREiteron *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREiteron, sizeof(struct ns1__find_USCOREiteron), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREiteron(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__find_USCOREiteronInputParams(soap, NULL, &a->_params, "ns1:find_iteronInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREiteron *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREiteron, 0, sizeof(struct ns1__find_USCOREiteron), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREiteron(struct soap *soap, const struct ns1__find_USCOREiteron *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREiteron);
	if (soap_out_ns1__find_USCOREiteron(soap, tag?tag:"ns1:find_iteron", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREiteron * SOAP_FMAC4 soap_get_ns1__find_USCOREiteron(struct soap *soap, struct ns1__find_USCOREiteron *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREiteron(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREiteronResponse(struct soap *soap, struct ns1__find_USCOREiteronResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREiteronResponse(struct soap *soap, const struct ns1__find_USCOREiteronResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREiteronResponse(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREiteronResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREiteronResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREiteronResponse * SOAP_FMAC4 soap_in_ns1__find_USCOREiteronResponse(struct soap *soap, const char *tag, struct ns1__find_USCOREiteronResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREiteronResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREiteronResponse, sizeof(struct ns1__find_USCOREiteronResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREiteronResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREiteronResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREiteronResponse, 0, sizeof(struct ns1__find_USCOREiteronResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREiteronResponse(struct soap *soap, const struct ns1__find_USCOREiteronResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREiteronResponse);
	if (soap_out_ns1__find_USCOREiteronResponse(soap, tag?tag:"ns1:find_iteronResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREiteronResponse * SOAP_FMAC4 soap_get_ns1__find_USCOREiteronResponse(struct soap *soap, struct ns1__find_USCOREiteronResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREiteronResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__min(struct soap *soap, struct ns1__min *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__min(struct soap *soap, const struct ns1__min *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__min(struct soap *soap, const char *tag, int id, const struct ns1__min *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__min), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__min * SOAP_FMAC4 soap_in_ns1__min(struct soap *soap, const char *tag, struct ns1__min *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__min *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__min, sizeof(struct ns1__min), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__min(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__min *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__min, 0, sizeof(struct ns1__min), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__min(struct soap *soap, const struct ns1__min *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__min);
	if (soap_out_ns1__min(soap, tag?tag:"ns1:min", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__min * SOAP_FMAC4 soap_get_ns1__min(struct soap *soap, struct ns1__min *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__min(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__minResponse(struct soap *soap, struct ns1__minResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__minResponse(struct soap *soap, const struct ns1__minResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__minResponse(struct soap *soap, const char *tag, int id, const struct ns1__minResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__minResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__minResponse * SOAP_FMAC4 soap_in_ns1__minResponse(struct soap *soap, const char *tag, struct ns1__minResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__minResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__minResponse, sizeof(struct ns1__minResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__minResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__minResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__minResponse, 0, sizeof(struct ns1__minResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__minResponse(struct soap *soap, const struct ns1__minResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__minResponse);
	if (soap_out_ns1__minResponse(soap, tag?tag:"ns1:minResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__minResponse * SOAP_FMAC4 soap_get_ns1__minResponse(struct soap *soap, struct ns1__minResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__minResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREusage(struct soap *soap, struct ns1__codon_USCOREusage *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREusage(struct soap *soap, const struct ns1__codon_USCOREusage *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__codon_USCOREusageInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREusage(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREusage *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREusage), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__codon_USCOREusageInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREusage * SOAP_FMAC4 soap_in_ns1__codon_USCOREusage(struct soap *soap, const char *tag, struct ns1__codon_USCOREusage *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREusage *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREusage, sizeof(struct ns1__codon_USCOREusage), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREusage(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__codon_USCOREusageInputParams(soap, NULL, &a->_params, "ns1:codon_usageInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREusage *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREusage, 0, sizeof(struct ns1__codon_USCOREusage), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREusage(struct soap *soap, const struct ns1__codon_USCOREusage *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREusage);
	if (soap_out_ns1__codon_USCOREusage(soap, tag?tag:"ns1:codon_usage", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREusage * SOAP_FMAC4 soap_get_ns1__codon_USCOREusage(struct soap *soap, struct ns1__codon_USCOREusage *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREusage(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREusageResponse(struct soap *soap, struct ns1__codon_USCOREusageResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREusageResponse(struct soap *soap, const struct ns1__codon_USCOREusageResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREusageResponse(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREusageResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREusageResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREusageResponse * SOAP_FMAC4 soap_in_ns1__codon_USCOREusageResponse(struct soap *soap, const char *tag, struct ns1__codon_USCOREusageResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREusageResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREusageResponse, sizeof(struct ns1__codon_USCOREusageResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREusageResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREusageResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREusageResponse, 0, sizeof(struct ns1__codon_USCOREusageResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREusageResponse(struct soap *soap, const struct ns1__codon_USCOREusageResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREusageResponse);
	if (soap_out_ns1__codon_USCOREusageResponse(soap, tag?tag:"ns1:codon_usageResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREusageResponse * SOAP_FMAC4 soap_get_ns1__codon_USCOREusageResponse(struct soap *soap, struct ns1__codon_USCOREusageResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREusageResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__oligomer_USCOREcounter(struct soap *soap, struct ns1__oligomer_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	soap_default_string(soap, &a->_oligomer);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__oligomer_USCOREcounter(struct soap *soap, const struct ns1__oligomer_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_string(soap, &a->_oligomer);
	soap_serialize_PointerTons1__oligomer_USCOREcounterInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__oligomer_USCOREcounter(struct soap *soap, const char *tag, int id, const struct ns1__oligomer_USCOREcounter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__oligomer_USCOREcounter), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_string(soap, "oligomer", -1, &a->_oligomer, ""))
		return soap->error;
	if (soap_out_PointerTons1__oligomer_USCOREcounterInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREcounter * SOAP_FMAC4 soap_in_ns1__oligomer_USCOREcounter(struct soap *soap, const char *tag, struct ns1__oligomer_USCOREcounter *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__oligomer = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__oligomer_USCOREcounter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__oligomer_USCOREcounter, sizeof(struct ns1__oligomer_USCOREcounter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__oligomer_USCOREcounter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__oligomer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_oligomer, "xsd:string"))
				{	soap_flag__oligomer--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__oligomer_USCOREcounterInputParams(soap, NULL, &a->_params, "ns1:oligomer_counterInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__oligomer_USCOREcounter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__oligomer_USCOREcounter, 0, sizeof(struct ns1__oligomer_USCOREcounter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__oligomer_USCOREcounter(struct soap *soap, const struct ns1__oligomer_USCOREcounter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__oligomer_USCOREcounter);
	if (soap_out_ns1__oligomer_USCOREcounter(soap, tag?tag:"ns1:oligomer_counter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREcounter * SOAP_FMAC4 soap_get_ns1__oligomer_USCOREcounter(struct soap *soap, struct ns1__oligomer_USCOREcounter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__oligomer_USCOREcounter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__oligomer_USCOREcounterResponse(struct soap *soap, struct ns1__oligomer_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__oligomer_USCOREcounterResponse(struct soap *soap, const struct ns1__oligomer_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__oligomer_USCOREcounterResponse(struct soap *soap, const char *tag, int id, const struct ns1__oligomer_USCOREcounterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__oligomer_USCOREcounterResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREcounterResponse * SOAP_FMAC4 soap_in_ns1__oligomer_USCOREcounterResponse(struct soap *soap, const char *tag, struct ns1__oligomer_USCOREcounterResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__oligomer_USCOREcounterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__oligomer_USCOREcounterResponse, sizeof(struct ns1__oligomer_USCOREcounterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__oligomer_USCOREcounterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__oligomer_USCOREcounterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__oligomer_USCOREcounterResponse, 0, sizeof(struct ns1__oligomer_USCOREcounterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__oligomer_USCOREcounterResponse(struct soap *soap, const struct ns1__oligomer_USCOREcounterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__oligomer_USCOREcounterResponse);
	if (soap_out_ns1__oligomer_USCOREcounterResponse(soap, tag?tag:"ns1:oligomer_counterResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREcounterResponse * SOAP_FMAC4 soap_get_ns1__oligomer_USCOREcounterResponse(struct soap *soap, struct ns1__oligomer_USCOREcounterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__oligomer_USCOREcounterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcwin(struct soap *soap, struct ns1__gcwin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcwin(struct soap *soap, const struct ns1__gcwin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__gcwinInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcwin(struct soap *soap, const char *tag, int id, const struct ns1__gcwin *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcwin), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__gcwinInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcwin * SOAP_FMAC4 soap_in_ns1__gcwin(struct soap *soap, const char *tag, struct ns1__gcwin *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcwin *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcwin, sizeof(struct ns1__gcwin), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcwin(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__gcwinInputParams(soap, NULL, &a->_params, "ns1:gcwinInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcwin *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcwin, 0, sizeof(struct ns1__gcwin), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcwin(struct soap *soap, const struct ns1__gcwin *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcwin);
	if (soap_out_ns1__gcwin(soap, tag?tag:"ns1:gcwin", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcwin * SOAP_FMAC4 soap_get_ns1__gcwin(struct soap *soap, struct ns1__gcwin *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcwin(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcwinResponse(struct soap *soap, struct ns1__gcwinResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcwinResponse(struct soap *soap, const struct ns1__gcwinResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcwinResponse(struct soap *soap, const char *tag, int id, const struct ns1__gcwinResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcwinResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcwinResponse * SOAP_FMAC4 soap_in_ns1__gcwinResponse(struct soap *soap, const char *tag, struct ns1__gcwinResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcwinResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcwinResponse, sizeof(struct ns1__gcwinResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcwinResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcwinResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcwinResponse, 0, sizeof(struct ns1__gcwinResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcwinResponse(struct soap *soap, const struct ns1__gcwinResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcwinResponse);
	if (soap_out_ns1__gcwinResponse(soap, tag?tag:"ns1:gcwinResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcwinResponse * SOAP_FMAC4 soap_get_ns1__gcwinResponse(struct soap *soap, struct ns1__gcwinResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcwinResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREpattern(struct soap *soap, struct ns1__find_USCOREpattern *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	soap_default_string(soap, &a->_pattern);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREpattern(struct soap *soap, const struct ns1__find_USCOREpattern *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_string(soap, &a->_pattern);
	soap_serialize_PointerTons1__find_USCOREpatternInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREpattern(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREpattern *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREpattern), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_string(soap, "pattern", -1, &a->_pattern, ""))
		return soap->error;
	if (soap_out_PointerTons1__find_USCOREpatternInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREpattern * SOAP_FMAC4 soap_in_ns1__find_USCOREpattern(struct soap *soap, const char *tag, struct ns1__find_USCOREpattern *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__pattern = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREpattern *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREpattern, sizeof(struct ns1__find_USCOREpattern), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREpattern(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__pattern && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_pattern, "xsd:string"))
				{	soap_flag__pattern--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__find_USCOREpatternInputParams(soap, NULL, &a->_params, "ns1:find_patternInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREpattern *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREpattern, 0, sizeof(struct ns1__find_USCOREpattern), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREpattern(struct soap *soap, const struct ns1__find_USCOREpattern *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREpattern);
	if (soap_out_ns1__find_USCOREpattern(soap, tag?tag:"ns1:find_pattern", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREpattern * SOAP_FMAC4 soap_get_ns1__find_USCOREpattern(struct soap *soap, struct ns1__find_USCOREpattern *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREpattern(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREpatternResponse(struct soap *soap, struct ns1__find_USCOREpatternResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREpatternResponse(struct soap *soap, const struct ns1__find_USCOREpatternResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREpatternResponse(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREpatternResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREpatternResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREpatternResponse * SOAP_FMAC4 soap_in_ns1__find_USCOREpatternResponse(struct soap *soap, const char *tag, struct ns1__find_USCOREpatternResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREpatternResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREpatternResponse, sizeof(struct ns1__find_USCOREpatternResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREpatternResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREpatternResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREpatternResponse, 0, sizeof(struct ns1__find_USCOREpatternResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREpatternResponse(struct soap *soap, const struct ns1__find_USCOREpatternResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREpatternResponse);
	if (soap_out_ns1__find_USCOREpatternResponse(soap, tag?tag:"ns1:find_patternResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREpatternResponse * SOAP_FMAC4 soap_get_ns1__find_USCOREpatternResponse(struct soap *soap, struct ns1__find_USCOREpatternResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREpatternResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__oligomer_USCOREsearch(struct soap *soap, struct ns1__oligomer_USCOREsearch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	soap_default_string(soap, &a->_oligomer);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__oligomer_USCOREsearch(struct soap *soap, const struct ns1__oligomer_USCOREsearch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_string(soap, &a->_oligomer);
	soap_serialize_PointerTons1__oligomer_USCOREsearchInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__oligomer_USCOREsearch(struct soap *soap, const char *tag, int id, const struct ns1__oligomer_USCOREsearch *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__oligomer_USCOREsearch), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_string(soap, "oligomer", -1, &a->_oligomer, ""))
		return soap->error;
	if (soap_out_PointerTons1__oligomer_USCOREsearchInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREsearch * SOAP_FMAC4 soap_in_ns1__oligomer_USCOREsearch(struct soap *soap, const char *tag, struct ns1__oligomer_USCOREsearch *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__oligomer = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__oligomer_USCOREsearch *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__oligomer_USCOREsearch, sizeof(struct ns1__oligomer_USCOREsearch), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__oligomer_USCOREsearch(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__oligomer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_oligomer, "xsd:string"))
				{	soap_flag__oligomer--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__oligomer_USCOREsearchInputParams(soap, NULL, &a->_params, "ns1:oligomer_searchInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__oligomer_USCOREsearch *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__oligomer_USCOREsearch, 0, sizeof(struct ns1__oligomer_USCOREsearch), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__oligomer_USCOREsearch(struct soap *soap, const struct ns1__oligomer_USCOREsearch *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__oligomer_USCOREsearch);
	if (soap_out_ns1__oligomer_USCOREsearch(soap, tag?tag:"ns1:oligomer_search", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREsearch * SOAP_FMAC4 soap_get_ns1__oligomer_USCOREsearch(struct soap *soap, struct ns1__oligomer_USCOREsearch *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__oligomer_USCOREsearch(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__oligomer_USCOREsearchResponse(struct soap *soap, struct ns1__oligomer_USCOREsearchResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__oligomer_USCOREsearchResponse(struct soap *soap, const struct ns1__oligomer_USCOREsearchResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__oligomer_USCOREsearchResponse(struct soap *soap, const char *tag, int id, const struct ns1__oligomer_USCOREsearchResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__oligomer_USCOREsearchResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREsearchResponse * SOAP_FMAC4 soap_in_ns1__oligomer_USCOREsearchResponse(struct soap *soap, const char *tag, struct ns1__oligomer_USCOREsearchResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__oligomer_USCOREsearchResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__oligomer_USCOREsearchResponse, sizeof(struct ns1__oligomer_USCOREsearchResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__oligomer_USCOREsearchResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__oligomer_USCOREsearchResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__oligomer_USCOREsearchResponse, 0, sizeof(struct ns1__oligomer_USCOREsearchResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__oligomer_USCOREsearchResponse(struct soap *soap, const struct ns1__oligomer_USCOREsearchResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__oligomer_USCOREsearchResponse);
	if (soap_out_ns1__oligomer_USCOREsearchResponse(soap, tag?tag:"ns1:oligomer_searchResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREsearchResponse * SOAP_FMAC4 soap_get_ns1__oligomer_USCOREsearchResponse(struct soap *soap, struct ns1__oligomer_USCOREsearchResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__oligomer_USCOREsearchResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__shuffleseq(struct soap *soap, struct ns1__shuffleseq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__shuffleseq(struct soap *soap, const struct ns1__shuffleseq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__shuffleseqInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__shuffleseq(struct soap *soap, const char *tag, int id, const struct ns1__shuffleseq *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__shuffleseq), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__shuffleseqInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__shuffleseq * SOAP_FMAC4 soap_in_ns1__shuffleseq(struct soap *soap, const char *tag, struct ns1__shuffleseq *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__shuffleseq *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__shuffleseq, sizeof(struct ns1__shuffleseq), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__shuffleseq(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__shuffleseqInputParams(soap, NULL, &a->_params, "ns1:shuffleseqInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__shuffleseq *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__shuffleseq, 0, sizeof(struct ns1__shuffleseq), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__shuffleseq(struct soap *soap, const struct ns1__shuffleseq *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__shuffleseq);
	if (soap_out_ns1__shuffleseq(soap, tag?tag:"ns1:shuffleseq", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__shuffleseq * SOAP_FMAC4 soap_get_ns1__shuffleseq(struct soap *soap, struct ns1__shuffleseq *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__shuffleseq(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__shuffleseqResponse(struct soap *soap, struct ns1__shuffleseqResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__shuffleseqResponse(struct soap *soap, const struct ns1__shuffleseqResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__shuffleseqResponse(struct soap *soap, const char *tag, int id, const struct ns1__shuffleseqResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__shuffleseqResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__shuffleseqResponse * SOAP_FMAC4 soap_in_ns1__shuffleseqResponse(struct soap *soap, const char *tag, struct ns1__shuffleseqResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__shuffleseqResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__shuffleseqResponse, sizeof(struct ns1__shuffleseqResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__shuffleseqResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__shuffleseqResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__shuffleseqResponse, 0, sizeof(struct ns1__shuffleseqResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__shuffleseqResponse(struct soap *soap, const struct ns1__shuffleseqResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__shuffleseqResponse);
	if (soap_out_ns1__shuffleseqResponse(soap, tag?tag:"ns1:shuffleseqResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__shuffleseqResponse * SOAP_FMAC4 soap_get_ns1__shuffleseqResponse(struct soap *soap, struct ns1__shuffleseqResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__shuffleseqResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREter(struct soap *soap, struct ns1__find_USCOREter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREter(struct soap *soap, const struct ns1__find_USCOREter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__find_USCOREterInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREter(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREter), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__find_USCOREterInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREter * SOAP_FMAC4 soap_in_ns1__find_USCOREter(struct soap *soap, const char *tag, struct ns1__find_USCOREter *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREter, sizeof(struct ns1__find_USCOREter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__find_USCOREterInputParams(soap, NULL, &a->_params, "ns1:find_terInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREter, 0, sizeof(struct ns1__find_USCOREter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREter(struct soap *soap, const struct ns1__find_USCOREter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREter);
	if (soap_out_ns1__find_USCOREter(soap, tag?tag:"ns1:find_ter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREter * SOAP_FMAC4 soap_get_ns1__find_USCOREter(struct soap *soap, struct ns1__find_USCOREter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREterResponse(struct soap *soap, struct ns1__find_USCOREterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREterResponse(struct soap *soap, const struct ns1__find_USCOREterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREterResponse(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREterResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREterResponse * SOAP_FMAC4 soap_in_ns1__find_USCOREterResponse(struct soap *soap, const char *tag, struct ns1__find_USCOREterResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREterResponse, sizeof(struct ns1__find_USCOREterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREterResponse, 0, sizeof(struct ns1__find_USCOREterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREterResponse(struct soap *soap, const struct ns1__find_USCOREterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREterResponse);
	if (soap_out_ns1__find_USCOREterResponse(soap, tag?tag:"ns1:find_terResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREterResponse * SOAP_FMAC4 soap_get_ns1__find_USCOREterResponse(struct soap *soap, struct ns1__find_USCOREterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dnawalk(struct soap *soap, struct ns1__dnawalk *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dnawalk(struct soap *soap, const struct ns1__dnawalk *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__dnawalkInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dnawalk(struct soap *soap, const char *tag, int id, const struct ns1__dnawalk *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dnawalk), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__dnawalkInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dnawalk * SOAP_FMAC4 soap_in_ns1__dnawalk(struct soap *soap, const char *tag, struct ns1__dnawalk *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dnawalk *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dnawalk, sizeof(struct ns1__dnawalk), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dnawalk(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__dnawalkInputParams(soap, NULL, &a->_params, "ns1:dnawalkInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dnawalk *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dnawalk, 0, sizeof(struct ns1__dnawalk), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dnawalk(struct soap *soap, const struct ns1__dnawalk *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dnawalk);
	if (soap_out_ns1__dnawalk(soap, tag?tag:"ns1:dnawalk", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dnawalk * SOAP_FMAC4 soap_get_ns1__dnawalk(struct soap *soap, struct ns1__dnawalk *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dnawalk(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dnawalkResponse(struct soap *soap, struct ns1__dnawalkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dnawalkResponse(struct soap *soap, const struct ns1__dnawalkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dnawalkResponse(struct soap *soap, const char *tag, int id, const struct ns1__dnawalkResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dnawalkResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dnawalkResponse * SOAP_FMAC4 soap_in_ns1__dnawalkResponse(struct soap *soap, const char *tag, struct ns1__dnawalkResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dnawalkResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dnawalkResponse, sizeof(struct ns1__dnawalkResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dnawalkResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dnawalkResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dnawalkResponse, 0, sizeof(struct ns1__dnawalkResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dnawalkResponse(struct soap *soap, const struct ns1__dnawalkResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dnawalkResponse);
	if (soap_out_ns1__dnawalkResponse(soap, tag?tag:"ns1:dnawalkResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dnawalkResponse * SOAP_FMAC4 soap_get_ns1__dnawalkResponse(struct soap *soap, struct ns1__dnawalkResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dnawalkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREinformation_USCOREcontent(struct soap *soap, struct ns1__base_USCOREinformation_USCOREcontent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREinformation_USCOREcontent(struct soap *soap, const struct ns1__base_USCOREinformation_USCOREcontent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__base_USCOREinformation_USCOREcontentInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREinformation_USCOREcontent(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREinformation_USCOREcontent *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__base_USCOREinformation_USCOREcontentInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREinformation_USCOREcontent * SOAP_FMAC4 soap_in_ns1__base_USCOREinformation_USCOREcontent(struct soap *soap, const char *tag, struct ns1__base_USCOREinformation_USCOREcontent *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREinformation_USCOREcontent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent, sizeof(struct ns1__base_USCOREinformation_USCOREcontent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREinformation_USCOREcontent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__base_USCOREinformation_USCOREcontentInputParams(soap, NULL, &a->_params, "ns1:base_information_contentInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREinformation_USCOREcontent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent, 0, sizeof(struct ns1__base_USCOREinformation_USCOREcontent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREinformation_USCOREcontent(struct soap *soap, const struct ns1__base_USCOREinformation_USCOREcontent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontent);
	if (soap_out_ns1__base_USCOREinformation_USCOREcontent(soap, tag?tag:"ns1:base_information_content", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREinformation_USCOREcontent * SOAP_FMAC4 soap_get_ns1__base_USCOREinformation_USCOREcontent(struct soap *soap, struct ns1__base_USCOREinformation_USCOREcontent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREinformation_USCOREcontent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREinformation_USCOREcontentResponse(struct soap *soap, struct ns1__base_USCOREinformation_USCOREcontentResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREinformation_USCOREcontentResponse(struct soap *soap, const struct ns1__base_USCOREinformation_USCOREcontentResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREinformation_USCOREcontentResponse(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREinformation_USCOREcontentResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREinformation_USCOREcontentResponse * SOAP_FMAC4 soap_in_ns1__base_USCOREinformation_USCOREcontentResponse(struct soap *soap, const char *tag, struct ns1__base_USCOREinformation_USCOREcontentResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREinformation_USCOREcontentResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse, sizeof(struct ns1__base_USCOREinformation_USCOREcontentResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREinformation_USCOREcontentResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREinformation_USCOREcontentResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse, 0, sizeof(struct ns1__base_USCOREinformation_USCOREcontentResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREinformation_USCOREcontentResponse(struct soap *soap, const struct ns1__base_USCOREinformation_USCOREcontentResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentResponse);
	if (soap_out_ns1__base_USCOREinformation_USCOREcontentResponse(soap, tag?tag:"ns1:base_information_contentResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREinformation_USCOREcontentResponse * SOAP_FMAC4 soap_get_ns1__base_USCOREinformation_USCOREcontentResponse(struct soap *soap, struct ns1__base_USCOREinformation_USCOREcontentResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREinformation_USCOREcontentResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__signature(struct soap *soap, struct ns1__signature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__signature(struct soap *soap, const struct ns1__signature *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__signatureInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__signature(struct soap *soap, const char *tag, int id, const struct ns1__signature *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__signature), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__signatureInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__signature * SOAP_FMAC4 soap_in_ns1__signature(struct soap *soap, const char *tag, struct ns1__signature *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__signature *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__signature, sizeof(struct ns1__signature), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__signature(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__signatureInputParams(soap, NULL, &a->_params, "ns1:signatureInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__signature *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__signature, 0, sizeof(struct ns1__signature), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__signature(struct soap *soap, const struct ns1__signature *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__signature);
	if (soap_out_ns1__signature(soap, tag?tag:"ns1:signature", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__signature * SOAP_FMAC4 soap_get_ns1__signature(struct soap *soap, struct ns1__signature *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__signature(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__signatureResponse(struct soap *soap, struct ns1__signatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__signatureResponse(struct soap *soap, const struct ns1__signatureResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__signatureResponse(struct soap *soap, const char *tag, int id, const struct ns1__signatureResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__signatureResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__signatureResponse * SOAP_FMAC4 soap_in_ns1__signatureResponse(struct soap *soap, const char *tag, struct ns1__signatureResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__signatureResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__signatureResponse, sizeof(struct ns1__signatureResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__signatureResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__signatureResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__signatureResponse, 0, sizeof(struct ns1__signatureResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__signatureResponse(struct soap *soap, const struct ns1__signatureResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__signatureResponse);
	if (soap_out_ns1__signatureResponse(soap, tag?tag:"ns1:signatureResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__signatureResponse * SOAP_FMAC4 soap_get_ns1__signatureResponse(struct soap *soap, struct ns1__signatureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__signatureResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__seqinfo(struct soap *soap, struct ns1__seqinfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__seqinfo(struct soap *soap, const struct ns1__seqinfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__seqinfo(struct soap *soap, const char *tag, int id, const struct ns1__seqinfo *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__seqinfo), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__seqinfo * SOAP_FMAC4 soap_in_ns1__seqinfo(struct soap *soap, const char *tag, struct ns1__seqinfo *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__seqinfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__seqinfo, sizeof(struct ns1__seqinfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__seqinfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__seqinfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__seqinfo, 0, sizeof(struct ns1__seqinfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__seqinfo(struct soap *soap, const struct ns1__seqinfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__seqinfo);
	if (soap_out_ns1__seqinfo(soap, tag?tag:"ns1:seqinfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__seqinfo * SOAP_FMAC4 soap_get_ns1__seqinfo(struct soap *soap, struct ns1__seqinfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__seqinfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__seqinfoResponse(struct soap *soap, struct ns1__seqinfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__seqinfoResponse(struct soap *soap, const struct ns1__seqinfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__seqinfoResponse(struct soap *soap, const char *tag, int id, const struct ns1__seqinfoResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__seqinfoResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__seqinfoResponse * SOAP_FMAC4 soap_in_ns1__seqinfoResponse(struct soap *soap, const char *tag, struct ns1__seqinfoResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__seqinfoResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__seqinfoResponse, sizeof(struct ns1__seqinfoResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__seqinfoResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__seqinfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__seqinfoResponse, 0, sizeof(struct ns1__seqinfoResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__seqinfoResponse(struct soap *soap, const struct ns1__seqinfoResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__seqinfoResponse);
	if (soap_out_ns1__seqinfoResponse(soap, tag?tag:"ns1:seqinfoResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__seqinfoResponse * SOAP_FMAC4 soap_get_ns1__seqinfoResponse(struct soap *soap, struct ns1__seqinfoResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__seqinfoResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genome_USCOREmap3(struct soap *soap, struct ns1__genome_USCOREmap3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genome_USCOREmap3(struct soap *soap, const struct ns1__genome_USCOREmap3 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__genome_USCOREmap3InputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genome_USCOREmap3(struct soap *soap, const char *tag, int id, const struct ns1__genome_USCOREmap3 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genome_USCOREmap3), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__genome_USCOREmap3InputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap3 * SOAP_FMAC4 soap_in_ns1__genome_USCOREmap3(struct soap *soap, const char *tag, struct ns1__genome_USCOREmap3 *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genome_USCOREmap3 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genome_USCOREmap3, sizeof(struct ns1__genome_USCOREmap3), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genome_USCOREmap3(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__genome_USCOREmap3InputParams(soap, NULL, &a->_params, "ns1:genome_map3InputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genome_USCOREmap3 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genome_USCOREmap3, 0, sizeof(struct ns1__genome_USCOREmap3), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genome_USCOREmap3(struct soap *soap, const struct ns1__genome_USCOREmap3 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genome_USCOREmap3);
	if (soap_out_ns1__genome_USCOREmap3(soap, tag?tag:"ns1:genome_map3", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap3 * SOAP_FMAC4 soap_get_ns1__genome_USCOREmap3(struct soap *soap, struct ns1__genome_USCOREmap3 *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genome_USCOREmap3(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genome_USCOREmap3Response(struct soap *soap, struct ns1__genome_USCOREmap3Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genome_USCOREmap3Response(struct soap *soap, const struct ns1__genome_USCOREmap3Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genome_USCOREmap3Response(struct soap *soap, const char *tag, int id, const struct ns1__genome_USCOREmap3Response *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genome_USCOREmap3Response), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap3Response * SOAP_FMAC4 soap_in_ns1__genome_USCOREmap3Response(struct soap *soap, const char *tag, struct ns1__genome_USCOREmap3Response *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genome_USCOREmap3Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genome_USCOREmap3Response, sizeof(struct ns1__genome_USCOREmap3Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genome_USCOREmap3Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genome_USCOREmap3Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genome_USCOREmap3Response, 0, sizeof(struct ns1__genome_USCOREmap3Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genome_USCOREmap3Response(struct soap *soap, const struct ns1__genome_USCOREmap3Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genome_USCOREmap3Response);
	if (soap_out_ns1__genome_USCOREmap3Response(soap, tag?tag:"ns1:genome_map3Response", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap3Response * SOAP_FMAC4 soap_get_ns1__genome_USCOREmap3Response(struct soap *soap, struct ns1__genome_USCOREmap3Response *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genome_USCOREmap3Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcskew(struct soap *soap, struct ns1__gcskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcskew(struct soap *soap, const struct ns1__gcskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__gcskewInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcskew(struct soap *soap, const char *tag, int id, const struct ns1__gcskew *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcskew), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__gcskewInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcskew * SOAP_FMAC4 soap_in_ns1__gcskew(struct soap *soap, const char *tag, struct ns1__gcskew *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcskew *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcskew, sizeof(struct ns1__gcskew), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcskew(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__gcskewInputParams(soap, NULL, &a->_params, "ns1:gcskewInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcskew *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcskew, 0, sizeof(struct ns1__gcskew), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcskew(struct soap *soap, const struct ns1__gcskew *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcskew);
	if (soap_out_ns1__gcskew(soap, tag?tag:"ns1:gcskew", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcskew * SOAP_FMAC4 soap_get_ns1__gcskew(struct soap *soap, struct ns1__gcskew *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcskew(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcskewResponse(struct soap *soap, struct ns1__gcskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcskewResponse(struct soap *soap, const struct ns1__gcskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcskewResponse(struct soap *soap, const char *tag, int id, const struct ns1__gcskewResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcskewResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcskewResponse * SOAP_FMAC4 soap_in_ns1__gcskewResponse(struct soap *soap, const char *tag, struct ns1__gcskewResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcskewResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcskewResponse, sizeof(struct ns1__gcskewResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcskewResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcskewResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcskewResponse, 0, sizeof(struct ns1__gcskewResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcskewResponse(struct soap *soap, const struct ns1__gcskewResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcskewResponse);
	if (soap_out_ns1__gcskewResponse(soap, tag?tag:"ns1:gcskewResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcskewResponse * SOAP_FMAC4 soap_get_ns1__gcskewResponse(struct soap *soap, struct ns1__gcskewResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcskewResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__molecular_USCOREweight(struct soap *soap, struct ns1__molecular_USCOREweight *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__molecular_USCOREweight(struct soap *soap, const struct ns1__molecular_USCOREweight *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__molecular_USCOREweightInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__molecular_USCOREweight(struct soap *soap, const char *tag, int id, const struct ns1__molecular_USCOREweight *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__molecular_USCOREweight), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__molecular_USCOREweightInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__molecular_USCOREweight * SOAP_FMAC4 soap_in_ns1__molecular_USCOREweight(struct soap *soap, const char *tag, struct ns1__molecular_USCOREweight *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__molecular_USCOREweight *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__molecular_USCOREweight, sizeof(struct ns1__molecular_USCOREweight), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__molecular_USCOREweight(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__molecular_USCOREweightInputParams(soap, NULL, &a->_params, "ns1:molecular_weightInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__molecular_USCOREweight *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__molecular_USCOREweight, 0, sizeof(struct ns1__molecular_USCOREweight), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__molecular_USCOREweight(struct soap *soap, const struct ns1__molecular_USCOREweight *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__molecular_USCOREweight);
	if (soap_out_ns1__molecular_USCOREweight(soap, tag?tag:"ns1:molecular_weight", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__molecular_USCOREweight * SOAP_FMAC4 soap_get_ns1__molecular_USCOREweight(struct soap *soap, struct ns1__molecular_USCOREweight *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__molecular_USCOREweight(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__molecular_USCOREweightResponse(struct soap *soap, struct ns1__molecular_USCOREweightResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__molecular_USCOREweightResponse(struct soap *soap, const struct ns1__molecular_USCOREweightResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__molecular_USCOREweightResponse(struct soap *soap, const char *tag, int id, const struct ns1__molecular_USCOREweightResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__molecular_USCOREweightResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__molecular_USCOREweightResponse * SOAP_FMAC4 soap_in_ns1__molecular_USCOREweightResponse(struct soap *soap, const char *tag, struct ns1__molecular_USCOREweightResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__molecular_USCOREweightResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__molecular_USCOREweightResponse, sizeof(struct ns1__molecular_USCOREweightResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__molecular_USCOREweightResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__molecular_USCOREweightResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__molecular_USCOREweightResponse, 0, sizeof(struct ns1__molecular_USCOREweightResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__molecular_USCOREweightResponse(struct soap *soap, const struct ns1__molecular_USCOREweightResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__molecular_USCOREweightResponse);
	if (soap_out_ns1__molecular_USCOREweightResponse(soap, tag?tag:"ns1:molecular_weightResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__molecular_USCOREweightResponse * SOAP_FMAC4 soap_get_ns1__molecular_USCOREweightResponse(struct soap *soap, struct ns1__molecular_USCOREweightResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__molecular_USCOREweightResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__delta_USCOREgcskew(struct soap *soap, struct ns1__delta_USCOREgcskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__delta_USCOREgcskew(struct soap *soap, const struct ns1__delta_USCOREgcskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__delta_USCOREgcskewInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__delta_USCOREgcskew(struct soap *soap, const char *tag, int id, const struct ns1__delta_USCOREgcskew *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__delta_USCOREgcskew), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__delta_USCOREgcskewInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__delta_USCOREgcskew * SOAP_FMAC4 soap_in_ns1__delta_USCOREgcskew(struct soap *soap, const char *tag, struct ns1__delta_USCOREgcskew *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__delta_USCOREgcskew *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__delta_USCOREgcskew, sizeof(struct ns1__delta_USCOREgcskew), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__delta_USCOREgcskew(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__delta_USCOREgcskewInputParams(soap, NULL, &a->_params, "ns1:delta_gcskewInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__delta_USCOREgcskew *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__delta_USCOREgcskew, 0, sizeof(struct ns1__delta_USCOREgcskew), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__delta_USCOREgcskew(struct soap *soap, const struct ns1__delta_USCOREgcskew *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__delta_USCOREgcskew);
	if (soap_out_ns1__delta_USCOREgcskew(soap, tag?tag:"ns1:delta_gcskew", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__delta_USCOREgcskew * SOAP_FMAC4 soap_get_ns1__delta_USCOREgcskew(struct soap *soap, struct ns1__delta_USCOREgcskew *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__delta_USCOREgcskew(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__delta_USCOREgcskewResponse(struct soap *soap, struct ns1__delta_USCOREgcskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__delta_USCOREgcskewResponse(struct soap *soap, const struct ns1__delta_USCOREgcskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__delta_USCOREgcskewResponse(struct soap *soap, const char *tag, int id, const struct ns1__delta_USCOREgcskewResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__delta_USCOREgcskewResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__delta_USCOREgcskewResponse * SOAP_FMAC4 soap_in_ns1__delta_USCOREgcskewResponse(struct soap *soap, const char *tag, struct ns1__delta_USCOREgcskewResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__delta_USCOREgcskewResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__delta_USCOREgcskewResponse, sizeof(struct ns1__delta_USCOREgcskewResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__delta_USCOREgcskewResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__delta_USCOREgcskewResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__delta_USCOREgcskewResponse, 0, sizeof(struct ns1__delta_USCOREgcskewResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__delta_USCOREgcskewResponse(struct soap *soap, const struct ns1__delta_USCOREgcskewResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__delta_USCOREgcskewResponse);
	if (soap_out_ns1__delta_USCOREgcskewResponse(soap, tag?tag:"ns1:delta_gcskewResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__delta_USCOREgcskewResponse * SOAP_FMAC4 soap_get_ns1__delta_USCOREgcskewResponse(struct soap *soap, struct ns1__delta_USCOREgcskewResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__delta_USCOREgcskewResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__delta_USCOREenc(struct soap *soap, struct ns1__delta_USCOREenc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__delta_USCOREenc(struct soap *soap, const struct ns1__delta_USCOREenc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__delta_USCOREenc(struct soap *soap, const char *tag, int id, const struct ns1__delta_USCOREenc *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__delta_USCOREenc), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__delta_USCOREenc * SOAP_FMAC4 soap_in_ns1__delta_USCOREenc(struct soap *soap, const char *tag, struct ns1__delta_USCOREenc *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__delta_USCOREenc *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__delta_USCOREenc, sizeof(struct ns1__delta_USCOREenc), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__delta_USCOREenc(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__delta_USCOREenc *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__delta_USCOREenc, 0, sizeof(struct ns1__delta_USCOREenc), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__delta_USCOREenc(struct soap *soap, const struct ns1__delta_USCOREenc *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__delta_USCOREenc);
	if (soap_out_ns1__delta_USCOREenc(soap, tag?tag:"ns1:delta_enc", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__delta_USCOREenc * SOAP_FMAC4 soap_get_ns1__delta_USCOREenc(struct soap *soap, struct ns1__delta_USCOREenc *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__delta_USCOREenc(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__delta_USCOREencResponse(struct soap *soap, struct ns1__delta_USCOREencResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__delta_USCOREencResponse(struct soap *soap, const struct ns1__delta_USCOREencResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__delta_USCOREencResponse(struct soap *soap, const char *tag, int id, const struct ns1__delta_USCOREencResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__delta_USCOREencResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__delta_USCOREencResponse * SOAP_FMAC4 soap_in_ns1__delta_USCOREencResponse(struct soap *soap, const char *tag, struct ns1__delta_USCOREencResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__delta_USCOREencResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__delta_USCOREencResponse, sizeof(struct ns1__delta_USCOREencResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__delta_USCOREencResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__delta_USCOREencResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__delta_USCOREencResponse, 0, sizeof(struct ns1__delta_USCOREencResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__delta_USCOREencResponse(struct soap *soap, const struct ns1__delta_USCOREencResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__delta_USCOREencResponse);
	if (soap_out_ns1__delta_USCOREencResponse(soap, tag?tag:"ns1:delta_encResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__delta_USCOREencResponse * SOAP_FMAC4 soap_get_ns1__delta_USCOREencResponse(struct soap *soap, struct ns1__delta_USCOREencResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__delta_USCOREencResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cumulative(struct soap *soap, struct ns1__cumulative *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cumulative(struct soap *soap, const struct ns1__cumulative *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cumulative(struct soap *soap, const char *tag, int id, const struct ns1__cumulative *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cumulative), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cumulative * SOAP_FMAC4 soap_in_ns1__cumulative(struct soap *soap, const char *tag, struct ns1__cumulative *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cumulative *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cumulative, sizeof(struct ns1__cumulative), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cumulative(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cumulative *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cumulative, 0, sizeof(struct ns1__cumulative), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cumulative(struct soap *soap, const struct ns1__cumulative *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cumulative);
	if (soap_out_ns1__cumulative(soap, tag?tag:"ns1:cumulative", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cumulative * SOAP_FMAC4 soap_get_ns1__cumulative(struct soap *soap, struct ns1__cumulative *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cumulative(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cumulativeResponse(struct soap *soap, struct ns1__cumulativeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cumulativeResponse(struct soap *soap, const struct ns1__cumulativeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cumulativeResponse(struct soap *soap, const char *tag, int id, const struct ns1__cumulativeResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cumulativeResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cumulativeResponse * SOAP_FMAC4 soap_in_ns1__cumulativeResponse(struct soap *soap, const char *tag, struct ns1__cumulativeResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cumulativeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cumulativeResponse, sizeof(struct ns1__cumulativeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cumulativeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cumulativeResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cumulativeResponse, 0, sizeof(struct ns1__cumulativeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cumulativeResponse(struct soap *soap, const struct ns1__cumulativeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cumulativeResponse);
	if (soap_out_ns1__cumulativeResponse(soap, tag?tag:"ns1:cumulativeResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cumulativeResponse * SOAP_FMAC4 soap_get_ns1__cumulativeResponse(struct soap *soap, struct ns1__cumulativeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cumulativeResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cor(struct soap *soap, struct ns1__cor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array1 = NULL;
	a->_array2 = NULL;
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cor(struct soap *soap, const struct ns1__cor *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array1);
	soap_serialize_PointerToarrayIn(soap, &a->_array2);
	soap_serialize_PointerTons1__corInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cor(struct soap *soap, const char *tag, int id, const struct ns1__cor *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cor), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array1", -1, &a->_array1, ""))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array2", -1, &a->_array2, ""))
		return soap->error;
	if (soap_out_PointerTons1__corInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cor * SOAP_FMAC4 soap_in_ns1__cor(struct soap *soap, const char *tag, struct ns1__cor *a, const char *type)
{
	size_t soap_flag__array1 = 1;
	size_t soap_flag__array2 = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cor *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cor, sizeof(struct ns1__cor), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cor(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array1, "xsd:string"))
				{	soap_flag__array1--;
					continue;
				}
			if (soap_flag__array2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array2, "xsd:string"))
				{	soap_flag__array2--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__corInputParams(soap, NULL, &a->_params, "ns1:corInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cor, 0, sizeof(struct ns1__cor), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cor(struct soap *soap, const struct ns1__cor *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cor);
	if (soap_out_ns1__cor(soap, tag?tag:"ns1:cor", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cor * SOAP_FMAC4 soap_get_ns1__cor(struct soap *soap, struct ns1__cor *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__corResponse(struct soap *soap, struct ns1__corResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__corResponse(struct soap *soap, const struct ns1__corResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__corResponse(struct soap *soap, const char *tag, int id, const struct ns1__corResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__corResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__corResponse * SOAP_FMAC4 soap_in_ns1__corResponse(struct soap *soap, const char *tag, struct ns1__corResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__corResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__corResponse, sizeof(struct ns1__corResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__corResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__corResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__corResponse, 0, sizeof(struct ns1__corResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__corResponse(struct soap *soap, const struct ns1__corResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__corResponse);
	if (soap_out_ns1__corResponse(soap, tag?tag:"ns1:corResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__corResponse * SOAP_FMAC4 soap_get_ns1__corResponse(struct soap *soap, struct ns1__corResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__corResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__standard_USCOREdeviation(struct soap *soap, struct ns1__standard_USCOREdeviation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__standard_USCOREdeviation(struct soap *soap, const struct ns1__standard_USCOREdeviation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__standard_USCOREdeviation(struct soap *soap, const char *tag, int id, const struct ns1__standard_USCOREdeviation *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__standard_USCOREdeviation), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__standard_USCOREdeviation * SOAP_FMAC4 soap_in_ns1__standard_USCOREdeviation(struct soap *soap, const char *tag, struct ns1__standard_USCOREdeviation *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__standard_USCOREdeviation *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__standard_USCOREdeviation, sizeof(struct ns1__standard_USCOREdeviation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__standard_USCOREdeviation(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__standard_USCOREdeviation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__standard_USCOREdeviation, 0, sizeof(struct ns1__standard_USCOREdeviation), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__standard_USCOREdeviation(struct soap *soap, const struct ns1__standard_USCOREdeviation *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__standard_USCOREdeviation);
	if (soap_out_ns1__standard_USCOREdeviation(soap, tag?tag:"ns1:standard_deviation", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__standard_USCOREdeviation * SOAP_FMAC4 soap_get_ns1__standard_USCOREdeviation(struct soap *soap, struct ns1__standard_USCOREdeviation *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__standard_USCOREdeviation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__standard_USCOREdeviationResponse(struct soap *soap, struct ns1__standard_USCOREdeviationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__standard_USCOREdeviationResponse(struct soap *soap, const struct ns1__standard_USCOREdeviationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__standard_USCOREdeviationResponse(struct soap *soap, const char *tag, int id, const struct ns1__standard_USCOREdeviationResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__standard_USCOREdeviationResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__standard_USCOREdeviationResponse * SOAP_FMAC4 soap_in_ns1__standard_USCOREdeviationResponse(struct soap *soap, const char *tag, struct ns1__standard_USCOREdeviationResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__standard_USCOREdeviationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__standard_USCOREdeviationResponse, sizeof(struct ns1__standard_USCOREdeviationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__standard_USCOREdeviationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__standard_USCOREdeviationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__standard_USCOREdeviationResponse, 0, sizeof(struct ns1__standard_USCOREdeviationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__standard_USCOREdeviationResponse(struct soap *soap, const struct ns1__standard_USCOREdeviationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__standard_USCOREdeviationResponse);
	if (soap_out_ns1__standard_USCOREdeviationResponse(soap, tag?tag:"ns1:standard_deviationResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__standard_USCOREdeviationResponse * SOAP_FMAC4 soap_get_ns1__standard_USCOREdeviationResponse(struct soap *soap, struct ns1__standard_USCOREdeviationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__standard_USCOREdeviationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__geneskew(struct soap *soap, struct ns1__geneskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__geneskew(struct soap *soap, const struct ns1__geneskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__geneskewInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__geneskew(struct soap *soap, const char *tag, int id, const struct ns1__geneskew *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__geneskew), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__geneskewInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__geneskew * SOAP_FMAC4 soap_in_ns1__geneskew(struct soap *soap, const char *tag, struct ns1__geneskew *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__geneskew *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__geneskew, sizeof(struct ns1__geneskew), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__geneskew(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__geneskewInputParams(soap, NULL, &a->_params, "ns1:geneskewInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__geneskew *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__geneskew, 0, sizeof(struct ns1__geneskew), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__geneskew(struct soap *soap, const struct ns1__geneskew *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__geneskew);
	if (soap_out_ns1__geneskew(soap, tag?tag:"ns1:geneskew", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__geneskew * SOAP_FMAC4 soap_get_ns1__geneskew(struct soap *soap, struct ns1__geneskew *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__geneskew(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__geneskewResponse(struct soap *soap, struct ns1__geneskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__geneskewResponse(struct soap *soap, const struct ns1__geneskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__geneskewResponse(struct soap *soap, const char *tag, int id, const struct ns1__geneskewResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__geneskewResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__geneskewResponse * SOAP_FMAC4 soap_in_ns1__geneskewResponse(struct soap *soap, const char *tag, struct ns1__geneskewResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__geneskewResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__geneskewResponse, sizeof(struct ns1__geneskewResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__geneskewResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__geneskewResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__geneskewResponse, 0, sizeof(struct ns1__geneskewResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__geneskewResponse(struct soap *soap, const struct ns1__geneskewResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__geneskewResponse);
	if (soap_out_ns1__geneskewResponse(soap, tag?tag:"ns1:geneskewResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__geneskewResponse * SOAP_FMAC4 soap_get_ns1__geneskewResponse(struct soap *soap, struct ns1__geneskewResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__geneskewResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genes_USCOREfrom_USCOREori(struct soap *soap, struct ns1__genes_USCOREfrom_USCOREori *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	soap_default_string(soap, &a->_direction);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genes_USCOREfrom_USCOREori(struct soap *soap, const struct ns1__genes_USCOREfrom_USCOREori *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_string(soap, &a->_direction);
	soap_serialize_PointerTons1__genes_USCOREfrom_USCOREoriInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genes_USCOREfrom_USCOREori(struct soap *soap, const char *tag, int id, const struct ns1__genes_USCOREfrom_USCOREori *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_string(soap, "direction", -1, &a->_direction, ""))
		return soap->error;
	if (soap_out_PointerTons1__genes_USCOREfrom_USCOREoriInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genes_USCOREfrom_USCOREori * SOAP_FMAC4 soap_in_ns1__genes_USCOREfrom_USCOREori(struct soap *soap, const char *tag, struct ns1__genes_USCOREfrom_USCOREori *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__direction = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genes_USCOREfrom_USCOREori *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori, sizeof(struct ns1__genes_USCOREfrom_USCOREori), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genes_USCOREfrom_USCOREori(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__direction && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_direction, "xsd:string"))
				{	soap_flag__direction--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__genes_USCOREfrom_USCOREoriInputParams(soap, NULL, &a->_params, "ns1:genes_from_oriInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genes_USCOREfrom_USCOREori *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori, 0, sizeof(struct ns1__genes_USCOREfrom_USCOREori), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genes_USCOREfrom_USCOREori(struct soap *soap, const struct ns1__genes_USCOREfrom_USCOREori *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREori);
	if (soap_out_ns1__genes_USCOREfrom_USCOREori(soap, tag?tag:"ns1:genes_from_ori", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genes_USCOREfrom_USCOREori * SOAP_FMAC4 soap_get_ns1__genes_USCOREfrom_USCOREori(struct soap *soap, struct ns1__genes_USCOREfrom_USCOREori *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genes_USCOREfrom_USCOREori(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genes_USCOREfrom_USCOREoriResponse(struct soap *soap, struct ns1__genes_USCOREfrom_USCOREoriResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genes_USCOREfrom_USCOREoriResponse(struct soap *soap, const struct ns1__genes_USCOREfrom_USCOREoriResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genes_USCOREfrom_USCOREoriResponse(struct soap *soap, const char *tag, int id, const struct ns1__genes_USCOREfrom_USCOREoriResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genes_USCOREfrom_USCOREoriResponse * SOAP_FMAC4 soap_in_ns1__genes_USCOREfrom_USCOREoriResponse(struct soap *soap, const char *tag, struct ns1__genes_USCOREfrom_USCOREoriResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genes_USCOREfrom_USCOREoriResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse, sizeof(struct ns1__genes_USCOREfrom_USCOREoriResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genes_USCOREfrom_USCOREoriResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genes_USCOREfrom_USCOREoriResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse, 0, sizeof(struct ns1__genes_USCOREfrom_USCOREoriResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genes_USCOREfrom_USCOREoriResponse(struct soap *soap, const struct ns1__genes_USCOREfrom_USCOREoriResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriResponse);
	if (soap_out_ns1__genes_USCOREfrom_USCOREoriResponse(soap, tag?tag:"ns1:genes_from_oriResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genes_USCOREfrom_USCOREoriResponse * SOAP_FMAC4 soap_get_ns1__genes_USCOREfrom_USCOREoriResponse(struct soap *soap, struct ns1__genes_USCOREfrom_USCOREoriResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genes_USCOREfrom_USCOREoriResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cbi(struct soap *soap, struct ns1__cbi *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cbi(struct soap *soap, const struct ns1__cbi *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__cbiInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cbi(struct soap *soap, const char *tag, int id, const struct ns1__cbi *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cbi), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__cbiInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cbi * SOAP_FMAC4 soap_in_ns1__cbi(struct soap *soap, const char *tag, struct ns1__cbi *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cbi *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cbi, sizeof(struct ns1__cbi), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cbi(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__cbiInputParams(soap, NULL, &a->_params, "ns1:cbiInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cbi *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cbi, 0, sizeof(struct ns1__cbi), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cbi(struct soap *soap, const struct ns1__cbi *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cbi);
	if (soap_out_ns1__cbi(soap, tag?tag:"ns1:cbi", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cbi * SOAP_FMAC4 soap_get_ns1__cbi(struct soap *soap, struct ns1__cbi *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cbi(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cbiResponse(struct soap *soap, struct ns1__cbiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cbiResponse(struct soap *soap, const struct ns1__cbiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cbiResponse(struct soap *soap, const char *tag, int id, const struct ns1__cbiResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cbiResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cbiResponse * SOAP_FMAC4 soap_in_ns1__cbiResponse(struct soap *soap, const char *tag, struct ns1__cbiResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cbiResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cbiResponse, sizeof(struct ns1__cbiResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cbiResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cbiResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cbiResponse, 0, sizeof(struct ns1__cbiResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cbiResponse(struct soap *soap, const struct ns1__cbiResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cbiResponse);
	if (soap_out_ns1__cbiResponse(soap, tag?tag:"ns1:cbiResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cbiResponse * SOAP_FMAC4 soap_get_ns1__cbiResponse(struct soap *soap, struct ns1__cbiResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cbiResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREdif(struct soap *soap, struct ns1__find_USCOREdif *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREdif(struct soap *soap, const struct ns1__find_USCOREdif *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__find_USCOREdifInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREdif(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREdif *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREdif), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__find_USCOREdifInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREdif * SOAP_FMAC4 soap_in_ns1__find_USCOREdif(struct soap *soap, const char *tag, struct ns1__find_USCOREdif *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREdif *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREdif, sizeof(struct ns1__find_USCOREdif), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREdif(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__find_USCOREdifInputParams(soap, NULL, &a->_params, "ns1:find_difInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREdif *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREdif, 0, sizeof(struct ns1__find_USCOREdif), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREdif(struct soap *soap, const struct ns1__find_USCOREdif *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREdif);
	if (soap_out_ns1__find_USCOREdif(soap, tag?tag:"ns1:find_dif", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREdif * SOAP_FMAC4 soap_get_ns1__find_USCOREdif(struct soap *soap, struct ns1__find_USCOREdif *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREdif(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREdifResponse(struct soap *soap, struct ns1__find_USCOREdifResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREdifResponse(struct soap *soap, const struct ns1__find_USCOREdifResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREdifResponse(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREdifResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREdifResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREdifResponse * SOAP_FMAC4 soap_in_ns1__find_USCOREdifResponse(struct soap *soap, const char *tag, struct ns1__find_USCOREdifResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREdifResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREdifResponse, sizeof(struct ns1__find_USCOREdifResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREdifResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREdifResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREdifResponse, 0, sizeof(struct ns1__find_USCOREdifResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREdifResponse(struct soap *soap, const struct ns1__find_USCOREdifResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREdifResponse);
	if (soap_out_ns1__find_USCOREdifResponse(soap, tag?tag:"ns1:find_difResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREdifResponse * SOAP_FMAC4 soap_get_ns1__find_USCOREdifResponse(struct soap *soap, struct ns1__find_USCOREdifResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREdifResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__to_USCOREfasta(struct soap *soap, struct ns1__to_USCOREfasta *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__to_USCOREfasta(struct soap *soap, const struct ns1__to_USCOREfasta *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__to_USCOREfastaInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__to_USCOREfasta(struct soap *soap, const char *tag, int id, const struct ns1__to_USCOREfasta *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__to_USCOREfasta), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__to_USCOREfastaInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__to_USCOREfasta * SOAP_FMAC4 soap_in_ns1__to_USCOREfasta(struct soap *soap, const char *tag, struct ns1__to_USCOREfasta *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__to_USCOREfasta *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__to_USCOREfasta, sizeof(struct ns1__to_USCOREfasta), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__to_USCOREfasta(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__to_USCOREfastaInputParams(soap, NULL, &a->_params, "ns1:to_fastaInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__to_USCOREfasta *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__to_USCOREfasta, 0, sizeof(struct ns1__to_USCOREfasta), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__to_USCOREfasta(struct soap *soap, const struct ns1__to_USCOREfasta *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__to_USCOREfasta);
	if (soap_out_ns1__to_USCOREfasta(soap, tag?tag:"ns1:to_fasta", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__to_USCOREfasta * SOAP_FMAC4 soap_get_ns1__to_USCOREfasta(struct soap *soap, struct ns1__to_USCOREfasta *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__to_USCOREfasta(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__to_USCOREfastaResponse(struct soap *soap, struct ns1__to_USCOREfastaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__to_USCOREfastaResponse(struct soap *soap, const struct ns1__to_USCOREfastaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__to_USCOREfastaResponse(struct soap *soap, const char *tag, int id, const struct ns1__to_USCOREfastaResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__to_USCOREfastaResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__to_USCOREfastaResponse * SOAP_FMAC4 soap_in_ns1__to_USCOREfastaResponse(struct soap *soap, const char *tag, struct ns1__to_USCOREfastaResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__to_USCOREfastaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__to_USCOREfastaResponse, sizeof(struct ns1__to_USCOREfastaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__to_USCOREfastaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__to_USCOREfastaResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__to_USCOREfastaResponse, 0, sizeof(struct ns1__to_USCOREfastaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__to_USCOREfastaResponse(struct soap *soap, const struct ns1__to_USCOREfastaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__to_USCOREfastaResponse);
	if (soap_out_ns1__to_USCOREfastaResponse(soap, tag?tag:"ns1:to_fastaResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__to_USCOREfastaResponse * SOAP_FMAC4 soap_get_ns1__to_USCOREfastaResponse(struct soap *soap, struct ns1__to_USCOREfastaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__to_USCOREfastaResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREentropy(struct soap *soap, struct ns1__base_USCOREentropy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREentropy(struct soap *soap, const struct ns1__base_USCOREentropy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__base_USCOREentropyInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREentropy(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREentropy *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREentropy), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__base_USCOREentropyInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREentropy * SOAP_FMAC4 soap_in_ns1__base_USCOREentropy(struct soap *soap, const char *tag, struct ns1__base_USCOREentropy *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREentropy *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREentropy, sizeof(struct ns1__base_USCOREentropy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREentropy(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__base_USCOREentropyInputParams(soap, NULL, &a->_params, "ns1:base_entropyInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREentropy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREentropy, 0, sizeof(struct ns1__base_USCOREentropy), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREentropy(struct soap *soap, const struct ns1__base_USCOREentropy *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREentropy);
	if (soap_out_ns1__base_USCOREentropy(soap, tag?tag:"ns1:base_entropy", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREentropy * SOAP_FMAC4 soap_get_ns1__base_USCOREentropy(struct soap *soap, struct ns1__base_USCOREentropy *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREentropy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREentropyResponse(struct soap *soap, struct ns1__base_USCOREentropyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREentropyResponse(struct soap *soap, const struct ns1__base_USCOREentropyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREentropyResponse(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREentropyResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREentropyResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREentropyResponse * SOAP_FMAC4 soap_in_ns1__base_USCOREentropyResponse(struct soap *soap, const char *tag, struct ns1__base_USCOREentropyResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREentropyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREentropyResponse, sizeof(struct ns1__base_USCOREentropyResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREentropyResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREentropyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREentropyResponse, 0, sizeof(struct ns1__base_USCOREentropyResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREentropyResponse(struct soap *soap, const struct ns1__base_USCOREentropyResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREentropyResponse);
	if (soap_out_ns1__base_USCOREentropyResponse(soap, tag?tag:"ns1:base_entropyResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREentropyResponse * SOAP_FMAC4 soap_get_ns1__base_USCOREentropyResponse(struct soap *soap, struct ns1__base_USCOREentropyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREentropyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__DoubleHelix(struct soap *soap, struct ns1__DoubleHelix *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__DoubleHelix(struct soap *soap, const struct ns1__DoubleHelix *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__DoubleHelixInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__DoubleHelix(struct soap *soap, const char *tag, int id, const struct ns1__DoubleHelix *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__DoubleHelix), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__DoubleHelixInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__DoubleHelix * SOAP_FMAC4 soap_in_ns1__DoubleHelix(struct soap *soap, const char *tag, struct ns1__DoubleHelix *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__DoubleHelix *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__DoubleHelix, sizeof(struct ns1__DoubleHelix), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__DoubleHelix(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__DoubleHelixInputParams(soap, NULL, &a->_params, "ns1:DoubleHelixInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__DoubleHelix *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__DoubleHelix, 0, sizeof(struct ns1__DoubleHelix), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__DoubleHelix(struct soap *soap, const struct ns1__DoubleHelix *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__DoubleHelix);
	if (soap_out_ns1__DoubleHelix(soap, tag?tag:"ns1:DoubleHelix", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__DoubleHelix * SOAP_FMAC4 soap_get_ns1__DoubleHelix(struct soap *soap, struct ns1__DoubleHelix *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__DoubleHelix(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__DoubleHelixResponse(struct soap *soap, struct ns1__DoubleHelixResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__DoubleHelixResponse(struct soap *soap, const struct ns1__DoubleHelixResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__DoubleHelixResponse(struct soap *soap, const char *tag, int id, const struct ns1__DoubleHelixResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__DoubleHelixResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__DoubleHelixResponse * SOAP_FMAC4 soap_in_ns1__DoubleHelixResponse(struct soap *soap, const char *tag, struct ns1__DoubleHelixResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__DoubleHelixResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__DoubleHelixResponse, sizeof(struct ns1__DoubleHelixResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__DoubleHelixResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__DoubleHelixResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__DoubleHelixResponse, 0, sizeof(struct ns1__DoubleHelixResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__DoubleHelixResponse(struct soap *soap, const struct ns1__DoubleHelixResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__DoubleHelixResponse);
	if (soap_out_ns1__DoubleHelixResponse(soap, tag?tag:"ns1:DoubleHelixResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__DoubleHelixResponse * SOAP_FMAC4 soap_get_ns1__DoubleHelixResponse(struct soap *soap, struct ns1__DoubleHelixResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__DoubleHelixResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__calc_USCOREpI(struct soap *soap, struct ns1__calc_USCOREpI *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__calc_USCOREpI(struct soap *soap, const struct ns1__calc_USCOREpI *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__calc_USCOREpI(struct soap *soap, const char *tag, int id, const struct ns1__calc_USCOREpI *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__calc_USCOREpI), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__calc_USCOREpI * SOAP_FMAC4 soap_in_ns1__calc_USCOREpI(struct soap *soap, const char *tag, struct ns1__calc_USCOREpI *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__calc_USCOREpI *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__calc_USCOREpI, sizeof(struct ns1__calc_USCOREpI), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__calc_USCOREpI(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__calc_USCOREpI *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__calc_USCOREpI, 0, sizeof(struct ns1__calc_USCOREpI), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__calc_USCOREpI(struct soap *soap, const struct ns1__calc_USCOREpI *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__calc_USCOREpI);
	if (soap_out_ns1__calc_USCOREpI(soap, tag?tag:"ns1:calc_pI", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__calc_USCOREpI * SOAP_FMAC4 soap_get_ns1__calc_USCOREpI(struct soap *soap, struct ns1__calc_USCOREpI *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__calc_USCOREpI(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__calc_USCOREpIResponse(struct soap *soap, struct ns1__calc_USCOREpIResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__calc_USCOREpIResponse(struct soap *soap, const struct ns1__calc_USCOREpIResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__calc_USCOREpIResponse(struct soap *soap, const char *tag, int id, const struct ns1__calc_USCOREpIResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__calc_USCOREpIResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__calc_USCOREpIResponse * SOAP_FMAC4 soap_in_ns1__calc_USCOREpIResponse(struct soap *soap, const char *tag, struct ns1__calc_USCOREpIResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__calc_USCOREpIResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__calc_USCOREpIResponse, sizeof(struct ns1__calc_USCOREpIResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__calc_USCOREpIResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__calc_USCOREpIResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__calc_USCOREpIResponse, 0, sizeof(struct ns1__calc_USCOREpIResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__calc_USCOREpIResponse(struct soap *soap, const struct ns1__calc_USCOREpIResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__calc_USCOREpIResponse);
	if (soap_out_ns1__calc_USCOREpIResponse(soap, tag?tag:"ns1:calc_pIResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__calc_USCOREpIResponse * SOAP_FMAC4 soap_get_ns1__calc_USCOREpIResponse(struct soap *soap, struct ns1__calc_USCOREpIResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__calc_USCOREpIResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__rep_USCOREori_USCOREter(struct soap *soap, struct ns1__rep_USCOREori_USCOREter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__rep_USCOREori_USCOREter(struct soap *soap, const struct ns1__rep_USCOREori_USCOREter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__rep_USCOREori_USCOREterInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__rep_USCOREori_USCOREter(struct soap *soap, const char *tag, int id, const struct ns1__rep_USCOREori_USCOREter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__rep_USCOREori_USCOREter), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__rep_USCOREori_USCOREterInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__rep_USCOREori_USCOREter * SOAP_FMAC4 soap_in_ns1__rep_USCOREori_USCOREter(struct soap *soap, const char *tag, struct ns1__rep_USCOREori_USCOREter *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__rep_USCOREori_USCOREter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__rep_USCOREori_USCOREter, sizeof(struct ns1__rep_USCOREori_USCOREter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__rep_USCOREori_USCOREter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__rep_USCOREori_USCOREterInputParams(soap, NULL, &a->_params, "ns1:rep_ori_terInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__rep_USCOREori_USCOREter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__rep_USCOREori_USCOREter, 0, sizeof(struct ns1__rep_USCOREori_USCOREter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__rep_USCOREori_USCOREter(struct soap *soap, const struct ns1__rep_USCOREori_USCOREter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__rep_USCOREori_USCOREter);
	if (soap_out_ns1__rep_USCOREori_USCOREter(soap, tag?tag:"ns1:rep_ori_ter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__rep_USCOREori_USCOREter * SOAP_FMAC4 soap_get_ns1__rep_USCOREori_USCOREter(struct soap *soap, struct ns1__rep_USCOREori_USCOREter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__rep_USCOREori_USCOREter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__rep_USCOREori_USCOREterResponse(struct soap *soap, struct ns1__rep_USCOREori_USCOREterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__rep_USCOREori_USCOREterResponse(struct soap *soap, const struct ns1__rep_USCOREori_USCOREterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__rep_USCOREori_USCOREterResponse(struct soap *soap, const char *tag, int id, const struct ns1__rep_USCOREori_USCOREterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__rep_USCOREori_USCOREterResponse * SOAP_FMAC4 soap_in_ns1__rep_USCOREori_USCOREterResponse(struct soap *soap, const char *tag, struct ns1__rep_USCOREori_USCOREterResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__rep_USCOREori_USCOREterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse, sizeof(struct ns1__rep_USCOREori_USCOREterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__rep_USCOREori_USCOREterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__rep_USCOREori_USCOREterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse, 0, sizeof(struct ns1__rep_USCOREori_USCOREterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__rep_USCOREori_USCOREterResponse(struct soap *soap, const struct ns1__rep_USCOREori_USCOREterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__rep_USCOREori_USCOREterResponse);
	if (soap_out_ns1__rep_USCOREori_USCOREterResponse(soap, tag?tag:"ns1:rep_ori_terResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__rep_USCOREori_USCOREterResponse * SOAP_FMAC4 soap_get_ns1__rep_USCOREori_USCOREterResponse(struct soap *soap, struct ns1__rep_USCOREori_USCOREterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__rep_USCOREori_USCOREterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__longest_USCOREORF(struct soap *soap, struct ns1__longest_USCOREORF *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__longest_USCOREORF(struct soap *soap, const struct ns1__longest_USCOREORF *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__longest_USCOREORF(struct soap *soap, const char *tag, int id, const struct ns1__longest_USCOREORF *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__longest_USCOREORF), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__longest_USCOREORF * SOAP_FMAC4 soap_in_ns1__longest_USCOREORF(struct soap *soap, const char *tag, struct ns1__longest_USCOREORF *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__longest_USCOREORF *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__longest_USCOREORF, sizeof(struct ns1__longest_USCOREORF), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__longest_USCOREORF(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__longest_USCOREORF *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__longest_USCOREORF, 0, sizeof(struct ns1__longest_USCOREORF), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__longest_USCOREORF(struct soap *soap, const struct ns1__longest_USCOREORF *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__longest_USCOREORF);
	if (soap_out_ns1__longest_USCOREORF(soap, tag?tag:"ns1:longest_ORF", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__longest_USCOREORF * SOAP_FMAC4 soap_get_ns1__longest_USCOREORF(struct soap *soap, struct ns1__longest_USCOREORF *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__longest_USCOREORF(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__longest_USCOREORFResponse(struct soap *soap, struct ns1__longest_USCOREORFResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__longest_USCOREORFResponse(struct soap *soap, const struct ns1__longest_USCOREORFResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__longest_USCOREORFResponse(struct soap *soap, const char *tag, int id, const struct ns1__longest_USCOREORFResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__longest_USCOREORFResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__longest_USCOREORFResponse * SOAP_FMAC4 soap_in_ns1__longest_USCOREORFResponse(struct soap *soap, const char *tag, struct ns1__longest_USCOREORFResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__longest_USCOREORFResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__longest_USCOREORFResponse, sizeof(struct ns1__longest_USCOREORFResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__longest_USCOREORFResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__longest_USCOREORFResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__longest_USCOREORFResponse, 0, sizeof(struct ns1__longest_USCOREORFResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__longest_USCOREORFResponse(struct soap *soap, const struct ns1__longest_USCOREORFResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__longest_USCOREORFResponse);
	if (soap_out_ns1__longest_USCOREORFResponse(soap, tag?tag:"ns1:longest_ORFResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__longest_USCOREORFResponse * SOAP_FMAC4 soap_get_ns1__longest_USCOREORFResponse(struct soap *soap, struct ns1__longest_USCOREORFResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__longest_USCOREORFResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genome_USCOREmap(struct soap *soap, struct ns1__genome_USCOREmap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genome_USCOREmap(struct soap *soap, const struct ns1__genome_USCOREmap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__genome_USCOREmapInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genome_USCOREmap(struct soap *soap, const char *tag, int id, const struct ns1__genome_USCOREmap *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genome_USCOREmap), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__genome_USCOREmapInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap * SOAP_FMAC4 soap_in_ns1__genome_USCOREmap(struct soap *soap, const char *tag, struct ns1__genome_USCOREmap *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genome_USCOREmap *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genome_USCOREmap, sizeof(struct ns1__genome_USCOREmap), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genome_USCOREmap(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__genome_USCOREmapInputParams(soap, NULL, &a->_params, "ns1:genome_mapInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genome_USCOREmap *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genome_USCOREmap, 0, sizeof(struct ns1__genome_USCOREmap), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genome_USCOREmap(struct soap *soap, const struct ns1__genome_USCOREmap *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genome_USCOREmap);
	if (soap_out_ns1__genome_USCOREmap(soap, tag?tag:"ns1:genome_map", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap * SOAP_FMAC4 soap_get_ns1__genome_USCOREmap(struct soap *soap, struct ns1__genome_USCOREmap *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genome_USCOREmap(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genome_USCOREmapResponse(struct soap *soap, struct ns1__genome_USCOREmapResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genome_USCOREmapResponse(struct soap *soap, const struct ns1__genome_USCOREmapResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genome_USCOREmapResponse(struct soap *soap, const char *tag, int id, const struct ns1__genome_USCOREmapResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genome_USCOREmapResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genome_USCOREmapResponse * SOAP_FMAC4 soap_in_ns1__genome_USCOREmapResponse(struct soap *soap, const char *tag, struct ns1__genome_USCOREmapResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genome_USCOREmapResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genome_USCOREmapResponse, sizeof(struct ns1__genome_USCOREmapResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genome_USCOREmapResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genome_USCOREmapResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genome_USCOREmapResponse, 0, sizeof(struct ns1__genome_USCOREmapResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genome_USCOREmapResponse(struct soap *soap, const struct ns1__genome_USCOREmapResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genome_USCOREmapResponse);
	if (soap_out_ns1__genome_USCOREmapResponse(soap, tag?tag:"ns1:genome_mapResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genome_USCOREmapResponse * SOAP_FMAC4 soap_get_ns1__genome_USCOREmapResponse(struct soap *soap, struct ns1__genome_USCOREmapResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genome_USCOREmapResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__consensus_USCOREz(struct soap *soap, struct ns1__consensus_USCOREz *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array_USCOREseq = NULL;
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__consensus_USCOREz(struct soap *soap, const struct ns1__consensus_USCOREz *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array_USCOREseq);
	soap_serialize_PointerTons1__consensus_USCOREzInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__consensus_USCOREz(struct soap *soap, const char *tag, int id, const struct ns1__consensus_USCOREz *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__consensus_USCOREz), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array_seq", -1, &a->_array_USCOREseq, ""))
		return soap->error;
	if (soap_out_PointerTons1__consensus_USCOREzInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__consensus_USCOREz * SOAP_FMAC4 soap_in_ns1__consensus_USCOREz(struct soap *soap, const char *tag, struct ns1__consensus_USCOREz *a, const char *type)
{
	size_t soap_flag__array_USCOREseq = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__consensus_USCOREz *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__consensus_USCOREz, sizeof(struct ns1__consensus_USCOREz), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__consensus_USCOREz(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array_USCOREseq && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array_USCOREseq, "xsd:string"))
				{	soap_flag__array_USCOREseq--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__consensus_USCOREzInputParams(soap, NULL, &a->_params, "ns1:consensus_zInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__consensus_USCOREz *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__consensus_USCOREz, 0, sizeof(struct ns1__consensus_USCOREz), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__consensus_USCOREz(struct soap *soap, const struct ns1__consensus_USCOREz *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__consensus_USCOREz);
	if (soap_out_ns1__consensus_USCOREz(soap, tag?tag:"ns1:consensus_z", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__consensus_USCOREz * SOAP_FMAC4 soap_get_ns1__consensus_USCOREz(struct soap *soap, struct ns1__consensus_USCOREz *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__consensus_USCOREz(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__consensus_USCOREzResponse(struct soap *soap, struct ns1__consensus_USCOREzResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__consensus_USCOREzResponse(struct soap *soap, const struct ns1__consensus_USCOREzResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__consensus_USCOREzResponse(struct soap *soap, const char *tag, int id, const struct ns1__consensus_USCOREzResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__consensus_USCOREzResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__consensus_USCOREzResponse * SOAP_FMAC4 soap_in_ns1__consensus_USCOREzResponse(struct soap *soap, const char *tag, struct ns1__consensus_USCOREzResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__consensus_USCOREzResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__consensus_USCOREzResponse, sizeof(struct ns1__consensus_USCOREzResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__consensus_USCOREzResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__consensus_USCOREzResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__consensus_USCOREzResponse, 0, sizeof(struct ns1__consensus_USCOREzResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__consensus_USCOREzResponse(struct soap *soap, const struct ns1__consensus_USCOREzResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__consensus_USCOREzResponse);
	if (soap_out_ns1__consensus_USCOREzResponse(soap, tag?tag:"ns1:consensus_zResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__consensus_USCOREzResponse * SOAP_FMAC4 soap_get_ns1__consensus_USCOREzResponse(struct soap *soap, struct ns1__consensus_USCOREzResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__consensus_USCOREzResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__mindex(struct soap *soap, struct ns1__mindex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__mindex(struct soap *soap, const struct ns1__mindex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__mindex(struct soap *soap, const char *tag, int id, const struct ns1__mindex *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__mindex), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__mindex * SOAP_FMAC4 soap_in_ns1__mindex(struct soap *soap, const char *tag, struct ns1__mindex *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__mindex *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__mindex, sizeof(struct ns1__mindex), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__mindex(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__mindex *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__mindex, 0, sizeof(struct ns1__mindex), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__mindex(struct soap *soap, const struct ns1__mindex *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__mindex);
	if (soap_out_ns1__mindex(soap, tag?tag:"ns1:mindex", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__mindex * SOAP_FMAC4 soap_get_ns1__mindex(struct soap *soap, struct ns1__mindex *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__mindex(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__mindexResponse(struct soap *soap, struct ns1__mindexResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__mindexResponse(struct soap *soap, const struct ns1__mindexResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__mindexResponse(struct soap *soap, const char *tag, int id, const struct ns1__mindexResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__mindexResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__mindexResponse * SOAP_FMAC4 soap_in_ns1__mindexResponse(struct soap *soap, const char *tag, struct ns1__mindexResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__mindexResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__mindexResponse, sizeof(struct ns1__mindexResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__mindexResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__mindexResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__mindexResponse, 0, sizeof(struct ns1__mindexResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__mindexResponse(struct soap *soap, const struct ns1__mindexResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__mindexResponse);
	if (soap_out_ns1__mindexResponse(soap, tag?tag:"ns1:mindexResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__mindexResponse * SOAP_FMAC4 soap_get_ns1__mindexResponse(struct soap *soap, struct ns1__mindexResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__mindexResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__query_USCOREarm(struct soap *soap, struct ns1__query_USCOREarm *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	soap_default_int(soap, &a->_position);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__query_USCOREarm(struct soap *soap, const struct ns1__query_USCOREarm *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__query_USCOREarm(struct soap *soap, const char *tag, int id, const struct ns1__query_USCOREarm *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__query_USCOREarm), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_int(soap, "position", -1, &a->_position, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__query_USCOREarm * SOAP_FMAC4 soap_in_ns1__query_USCOREarm(struct soap *soap, const char *tag, struct ns1__query_USCOREarm *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__position = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__query_USCOREarm *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__query_USCOREarm, sizeof(struct ns1__query_USCOREarm), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__query_USCOREarm(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__position && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_position, "xsd:int"))
				{	soap_flag__position--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__query_USCOREarm *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__query_USCOREarm, 0, sizeof(struct ns1__query_USCOREarm), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__position > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__query_USCOREarm(struct soap *soap, const struct ns1__query_USCOREarm *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__query_USCOREarm);
	if (soap_out_ns1__query_USCOREarm(soap, tag?tag:"ns1:query_arm", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__query_USCOREarm * SOAP_FMAC4 soap_get_ns1__query_USCOREarm(struct soap *soap, struct ns1__query_USCOREarm *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__query_USCOREarm(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__query_USCOREarmResponse(struct soap *soap, struct ns1__query_USCOREarmResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__query_USCOREarmResponse(struct soap *soap, const struct ns1__query_USCOREarmResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__query_USCOREarmResponse(struct soap *soap, const char *tag, int id, const struct ns1__query_USCOREarmResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__query_USCOREarmResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__query_USCOREarmResponse * SOAP_FMAC4 soap_in_ns1__query_USCOREarmResponse(struct soap *soap, const char *tag, struct ns1__query_USCOREarmResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__query_USCOREarmResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__query_USCOREarmResponse, sizeof(struct ns1__query_USCOREarmResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__query_USCOREarmResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__query_USCOREarmResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__query_USCOREarmResponse, 0, sizeof(struct ns1__query_USCOREarmResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__query_USCOREarmResponse(struct soap *soap, const struct ns1__query_USCOREarmResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__query_USCOREarmResponse);
	if (soap_out_ns1__query_USCOREarmResponse(soap, tag?tag:"ns1:query_armResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__query_USCOREarmResponse * SOAP_FMAC4 soap_get_ns1__query_USCOREarmResponse(struct soap *soap, struct ns1__query_USCOREarmResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__query_USCOREarmResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__max(struct soap *soap, struct ns1__max *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__max(struct soap *soap, const struct ns1__max *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__max(struct soap *soap, const char *tag, int id, const struct ns1__max *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__max), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__max * SOAP_FMAC4 soap_in_ns1__max(struct soap *soap, const char *tag, struct ns1__max *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__max *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__max, sizeof(struct ns1__max), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__max(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__max *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__max, 0, sizeof(struct ns1__max), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__max(struct soap *soap, const struct ns1__max *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__max);
	if (soap_out_ns1__max(soap, tag?tag:"ns1:max", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__max * SOAP_FMAC4 soap_get_ns1__max(struct soap *soap, struct ns1__max *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__max(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__maxResponse(struct soap *soap, struct ns1__maxResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__maxResponse(struct soap *soap, const struct ns1__maxResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__maxResponse(struct soap *soap, const char *tag, int id, const struct ns1__maxResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__maxResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__maxResponse * SOAP_FMAC4 soap_in_ns1__maxResponse(struct soap *soap, const char *tag, struct ns1__maxResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__maxResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__maxResponse, sizeof(struct ns1__maxResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__maxResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__maxResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__maxResponse, 0, sizeof(struct ns1__maxResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__maxResponse(struct soap *soap, const struct ns1__maxResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__maxResponse);
	if (soap_out_ns1__maxResponse(soap, tag?tag:"ns1:maxResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__maxResponse * SOAP_FMAC4 soap_get_ns1__maxResponse(struct soap *soap, struct ns1__maxResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__maxResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__maxdex(struct soap *soap, struct ns1__maxdex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__maxdex(struct soap *soap, const struct ns1__maxdex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__maxdex(struct soap *soap, const char *tag, int id, const struct ns1__maxdex *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__maxdex), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__maxdex * SOAP_FMAC4 soap_in_ns1__maxdex(struct soap *soap, const char *tag, struct ns1__maxdex *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__maxdex *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__maxdex, sizeof(struct ns1__maxdex), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__maxdex(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__maxdex *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__maxdex, 0, sizeof(struct ns1__maxdex), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__maxdex(struct soap *soap, const struct ns1__maxdex *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__maxdex);
	if (soap_out_ns1__maxdex(soap, tag?tag:"ns1:maxdex", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__maxdex * SOAP_FMAC4 soap_get_ns1__maxdex(struct soap *soap, struct ns1__maxdex *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__maxdex(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__maxdexResponse(struct soap *soap, struct ns1__maxdexResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__maxdexResponse(struct soap *soap, const struct ns1__maxdexResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__maxdexResponse(struct soap *soap, const char *tag, int id, const struct ns1__maxdexResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__maxdexResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__maxdexResponse * SOAP_FMAC4 soap_in_ns1__maxdexResponse(struct soap *soap, const char *tag, struct ns1__maxdexResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__maxdexResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__maxdexResponse, sizeof(struct ns1__maxdexResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__maxdexResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__maxdexResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__maxdexResponse, 0, sizeof(struct ns1__maxdexResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__maxdexResponse(struct soap *soap, const struct ns1__maxdexResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__maxdexResponse);
	if (soap_out_ns1__maxdexResponse(soap, tag?tag:"ns1:maxdexResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__maxdexResponse * SOAP_FMAC4 soap_get_ns1__maxdexResponse(struct soap *soap, struct ns1__maxdexResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__maxdexResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cai(struct soap *soap, struct ns1__cai *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cai(struct soap *soap, const struct ns1__cai *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__caiInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cai(struct soap *soap, const char *tag, int id, const struct ns1__cai *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cai), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__caiInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cai * SOAP_FMAC4 soap_in_ns1__cai(struct soap *soap, const char *tag, struct ns1__cai *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cai *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cai, sizeof(struct ns1__cai), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cai(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__caiInputParams(soap, NULL, &a->_params, "ns1:caiInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cai *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cai, 0, sizeof(struct ns1__cai), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cai(struct soap *soap, const struct ns1__cai *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cai);
	if (soap_out_ns1__cai(soap, tag?tag:"ns1:cai", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cai * SOAP_FMAC4 soap_get_ns1__cai(struct soap *soap, struct ns1__cai *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cai(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__caiResponse(struct soap *soap, struct ns1__caiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__caiResponse(struct soap *soap, const struct ns1__caiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__caiResponse(struct soap *soap, const char *tag, int id, const struct ns1__caiResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__caiResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__caiResponse * SOAP_FMAC4 soap_in_ns1__caiResponse(struct soap *soap, const char *tag, struct ns1__caiResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__caiResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__caiResponse, sizeof(struct ns1__caiResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__caiResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__caiResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__caiResponse, 0, sizeof(struct ns1__caiResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__caiResponse(struct soap *soap, const struct ns1__caiResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__caiResponse);
	if (soap_out_ns1__caiResponse(soap, tag?tag:"ns1:caiResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__caiResponse * SOAP_FMAC4 soap_get_ns1__caiResponse(struct soap *soap, struct ns1__caiResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__caiResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcsi(struct soap *soap, struct ns1__gcsi *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcsi(struct soap *soap, const struct ns1__gcsi *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__gcsiInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcsi(struct soap *soap, const char *tag, int id, const struct ns1__gcsi *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcsi), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__gcsiInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcsi * SOAP_FMAC4 soap_in_ns1__gcsi(struct soap *soap, const char *tag, struct ns1__gcsi *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcsi *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcsi, sizeof(struct ns1__gcsi), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcsi(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__gcsiInputParams(soap, NULL, &a->_params, "ns1:gcsiInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcsi *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcsi, 0, sizeof(struct ns1__gcsi), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcsi(struct soap *soap, const struct ns1__gcsi *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcsi);
	if (soap_out_ns1__gcsi(soap, tag?tag:"ns1:gcsi", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcsi * SOAP_FMAC4 soap_get_ns1__gcsi(struct soap *soap, struct ns1__gcsi *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcsi(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcsiResponse(struct soap *soap, struct ns1__gcsiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcsiResponse(struct soap *soap, const struct ns1__gcsiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcsiResponse(struct soap *soap, const char *tag, int id, const struct ns1__gcsiResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcsiResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcsiResponse * SOAP_FMAC4 soap_in_ns1__gcsiResponse(struct soap *soap, const char *tag, struct ns1__gcsiResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcsiResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcsiResponse, sizeof(struct ns1__gcsiResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcsiResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcsiResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcsiResponse, 0, sizeof(struct ns1__gcsiResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcsiResponse(struct soap *soap, const struct ns1__gcsiResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcsiResponse);
	if (soap_out_ns1__gcsiResponse(soap, tag?tag:"ns1:gcsiResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcsiResponse * SOAP_FMAC4 soap_get_ns1__gcsiResponse(struct soap *soap, struct ns1__gcsiResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcsiResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatg(struct soap *soap, struct ns1__filter_USCOREcds_USCOREby_USCOREatg *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__filter_USCOREcds_USCOREby_USCOREatg(struct soap *soap, const struct ns1__filter_USCOREcds_USCOREby_USCOREatg *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatg(struct soap *soap, const char *tag, int id, const struct ns1__filter_USCOREcds_USCOREby_USCOREatg *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__filter_USCOREcds_USCOREby_USCOREatg * SOAP_FMAC4 soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatg(struct soap *soap, const char *tag, struct ns1__filter_USCOREcds_USCOREby_USCOREatg *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__filter_USCOREcds_USCOREby_USCOREatg *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg, sizeof(struct ns1__filter_USCOREcds_USCOREby_USCOREatg), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, NULL, &a->_params, "ns1:filter_cds_by_atgInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__filter_USCOREcds_USCOREby_USCOREatg *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg, 0, sizeof(struct ns1__filter_USCOREcds_USCOREby_USCOREatg), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__filter_USCOREcds_USCOREby_USCOREatg(struct soap *soap, const struct ns1__filter_USCOREcds_USCOREby_USCOREatg *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatg);
	if (soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, tag?tag:"ns1:filter_cds_by_atg", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__filter_USCOREcds_USCOREby_USCOREatg * SOAP_FMAC4 soap_get_ns1__filter_USCOREcds_USCOREby_USCOREatg(struct soap *soap, struct ns1__filter_USCOREcds_USCOREby_USCOREatg *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(struct soap *soap, struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(struct soap *soap, const struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(struct soap *soap, const char *tag, int id, const struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse * SOAP_FMAC4 soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(struct soap *soap, const char *tag, struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse, sizeof(struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse, 0, sizeof(struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(struct soap *soap, const struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse);
	if (soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, tag?tag:"ns1:filter_cds_by_atgResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse * SOAP_FMAC4 soap_get_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(struct soap *soap, struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genomicskew(struct soap *soap, struct ns1__genomicskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genomicskew(struct soap *soap, const struct ns1__genomicskew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__genomicskewInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genomicskew(struct soap *soap, const char *tag, int id, const struct ns1__genomicskew *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genomicskew), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__genomicskewInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genomicskew * SOAP_FMAC4 soap_in_ns1__genomicskew(struct soap *soap, const char *tag, struct ns1__genomicskew *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genomicskew *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genomicskew, sizeof(struct ns1__genomicskew), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genomicskew(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__genomicskewInputParams(soap, NULL, &a->_params, "ns1:genomicskewInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genomicskew *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genomicskew, 0, sizeof(struct ns1__genomicskew), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genomicskew(struct soap *soap, const struct ns1__genomicskew *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genomicskew);
	if (soap_out_ns1__genomicskew(soap, tag?tag:"ns1:genomicskew", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genomicskew * SOAP_FMAC4 soap_get_ns1__genomicskew(struct soap *soap, struct ns1__genomicskew *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genomicskew(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genomicskewResponse(struct soap *soap, struct ns1__genomicskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genomicskewResponse(struct soap *soap, const struct ns1__genomicskewResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genomicskewResponse(struct soap *soap, const char *tag, int id, const struct ns1__genomicskewResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genomicskewResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genomicskewResponse * SOAP_FMAC4 soap_in_ns1__genomicskewResponse(struct soap *soap, const char *tag, struct ns1__genomicskewResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genomicskewResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genomicskewResponse, sizeof(struct ns1__genomicskewResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genomicskewResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genomicskewResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genomicskewResponse, 0, sizeof(struct ns1__genomicskewResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genomicskewResponse(struct soap *soap, const struct ns1__genomicskewResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genomicskewResponse);
	if (soap_out_ns1__genomicskewResponse(soap, tag?tag:"ns1:genomicskewResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genomicskewResponse * SOAP_FMAC4 soap_get_ns1__genomicskewResponse(struct soap *soap, struct ns1__genomicskewResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genomicskewResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__query_USCOREstrand(struct soap *soap, struct ns1__query_USCOREstrand *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	soap_default_int(soap, &a->_position);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__query_USCOREstrand(struct soap *soap, const struct ns1__query_USCOREstrand *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__query_USCOREstrandInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__query_USCOREstrand(struct soap *soap, const char *tag, int id, const struct ns1__query_USCOREstrand *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__query_USCOREstrand), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_int(soap, "position", -1, &a->_position, ""))
		return soap->error;
	if (soap_out_PointerTons1__query_USCOREstrandInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__query_USCOREstrand * SOAP_FMAC4 soap_in_ns1__query_USCOREstrand(struct soap *soap, const char *tag, struct ns1__query_USCOREstrand *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__position = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__query_USCOREstrand *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__query_USCOREstrand, sizeof(struct ns1__query_USCOREstrand), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__query_USCOREstrand(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__position && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_position, "xsd:int"))
				{	soap_flag__position--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__query_USCOREstrandInputParams(soap, NULL, &a->_params, "ns1:query_strandInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__query_USCOREstrand *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__query_USCOREstrand, 0, sizeof(struct ns1__query_USCOREstrand), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__position > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__query_USCOREstrand(struct soap *soap, const struct ns1__query_USCOREstrand *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__query_USCOREstrand);
	if (soap_out_ns1__query_USCOREstrand(soap, tag?tag:"ns1:query_strand", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__query_USCOREstrand * SOAP_FMAC4 soap_get_ns1__query_USCOREstrand(struct soap *soap, struct ns1__query_USCOREstrand *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__query_USCOREstrand(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__query_USCOREstrandResponse(struct soap *soap, struct ns1__query_USCOREstrandResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__query_USCOREstrandResponse(struct soap *soap, const struct ns1__query_USCOREstrandResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__query_USCOREstrandResponse(struct soap *soap, const char *tag, int id, const struct ns1__query_USCOREstrandResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__query_USCOREstrandResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__query_USCOREstrandResponse * SOAP_FMAC4 soap_in_ns1__query_USCOREstrandResponse(struct soap *soap, const char *tag, struct ns1__query_USCOREstrandResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__query_USCOREstrandResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__query_USCOREstrandResponse, sizeof(struct ns1__query_USCOREstrandResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__query_USCOREstrandResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__query_USCOREstrandResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__query_USCOREstrandResponse, 0, sizeof(struct ns1__query_USCOREstrandResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__query_USCOREstrandResponse(struct soap *soap, const struct ns1__query_USCOREstrandResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__query_USCOREstrandResponse);
	if (soap_out_ns1__query_USCOREstrandResponse(soap, tag?tag:"ns1:query_strandResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__query_USCOREstrandResponse * SOAP_FMAC4 soap_get_ns1__query_USCOREstrandResponse(struct soap *soap, struct ns1__query_USCOREstrandResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__query_USCOREstrandResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__view_USCOREcds(struct soap *soap, struct ns1__view_USCOREcds *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__view_USCOREcds(struct soap *soap, const struct ns1__view_USCOREcds *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__view_USCOREcdsInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__view_USCOREcds(struct soap *soap, const char *tag, int id, const struct ns1__view_USCOREcds *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__view_USCOREcds), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__view_USCOREcdsInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__view_USCOREcds * SOAP_FMAC4 soap_in_ns1__view_USCOREcds(struct soap *soap, const char *tag, struct ns1__view_USCOREcds *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__view_USCOREcds *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__view_USCOREcds, sizeof(struct ns1__view_USCOREcds), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__view_USCOREcds(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__view_USCOREcdsInputParams(soap, NULL, &a->_params, "ns1:view_cdsInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__view_USCOREcds *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__view_USCOREcds, 0, sizeof(struct ns1__view_USCOREcds), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__view_USCOREcds(struct soap *soap, const struct ns1__view_USCOREcds *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__view_USCOREcds);
	if (soap_out_ns1__view_USCOREcds(soap, tag?tag:"ns1:view_cds", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__view_USCOREcds * SOAP_FMAC4 soap_get_ns1__view_USCOREcds(struct soap *soap, struct ns1__view_USCOREcds *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__view_USCOREcds(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__view_USCOREcdsResponse(struct soap *soap, struct ns1__view_USCOREcdsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__view_USCOREcdsResponse(struct soap *soap, const struct ns1__view_USCOREcdsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__view_USCOREcdsResponse(struct soap *soap, const char *tag, int id, const struct ns1__view_USCOREcdsResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__view_USCOREcdsResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__view_USCOREcdsResponse * SOAP_FMAC4 soap_in_ns1__view_USCOREcdsResponse(struct soap *soap, const char *tag, struct ns1__view_USCOREcdsResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__view_USCOREcdsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__view_USCOREcdsResponse, sizeof(struct ns1__view_USCOREcdsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__view_USCOREcdsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__view_USCOREcdsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__view_USCOREcdsResponse, 0, sizeof(struct ns1__view_USCOREcdsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__view_USCOREcdsResponse(struct soap *soap, const struct ns1__view_USCOREcdsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__view_USCOREcdsResponse);
	if (soap_out_ns1__view_USCOREcdsResponse(soap, tag?tag:"ns1:view_cdsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__view_USCOREcdsResponse * SOAP_FMAC4 soap_get_ns1__view_USCOREcdsResponse(struct soap *soap, struct ns1__view_USCOREcdsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__view_USCOREcdsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCORErelative_USCOREentropy(struct soap *soap, struct ns1__base_USCORErelative_USCOREentropy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCORErelative_USCOREentropy(struct soap *soap, const struct ns1__base_USCORErelative_USCOREentropy *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__base_USCORErelative_USCOREentropyInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCORErelative_USCOREentropy(struct soap *soap, const char *tag, int id, const struct ns1__base_USCORErelative_USCOREentropy *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__base_USCORErelative_USCOREentropyInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCORErelative_USCOREentropy * SOAP_FMAC4 soap_in_ns1__base_USCORErelative_USCOREentropy(struct soap *soap, const char *tag, struct ns1__base_USCORErelative_USCOREentropy *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCORErelative_USCOREentropy *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy, sizeof(struct ns1__base_USCORErelative_USCOREentropy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCORErelative_USCOREentropy(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__base_USCORErelative_USCOREentropyInputParams(soap, NULL, &a->_params, "ns1:base_relative_entropyInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCORErelative_USCOREentropy *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy, 0, sizeof(struct ns1__base_USCORErelative_USCOREentropy), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCORErelative_USCOREentropy(struct soap *soap, const struct ns1__base_USCORErelative_USCOREentropy *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropy);
	if (soap_out_ns1__base_USCORErelative_USCOREentropy(soap, tag?tag:"ns1:base_relative_entropy", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCORErelative_USCOREentropy * SOAP_FMAC4 soap_get_ns1__base_USCORErelative_USCOREentropy(struct soap *soap, struct ns1__base_USCORErelative_USCOREentropy *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCORErelative_USCOREentropy(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCORErelative_USCOREentropyResponse(struct soap *soap, struct ns1__base_USCORErelative_USCOREentropyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCORErelative_USCOREentropyResponse(struct soap *soap, const struct ns1__base_USCORErelative_USCOREentropyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCORErelative_USCOREentropyResponse(struct soap *soap, const char *tag, int id, const struct ns1__base_USCORErelative_USCOREentropyResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCORErelative_USCOREentropyResponse * SOAP_FMAC4 soap_in_ns1__base_USCORErelative_USCOREentropyResponse(struct soap *soap, const char *tag, struct ns1__base_USCORErelative_USCOREentropyResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCORErelative_USCOREentropyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse, sizeof(struct ns1__base_USCORErelative_USCOREentropyResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCORErelative_USCOREentropyResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCORErelative_USCOREentropyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse, 0, sizeof(struct ns1__base_USCORErelative_USCOREentropyResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCORErelative_USCOREentropyResponse(struct soap *soap, const struct ns1__base_USCORErelative_USCOREentropyResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyResponse);
	if (soap_out_ns1__base_USCORErelative_USCOREentropyResponse(soap, tag?tag:"ns1:base_relative_entropyResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCORErelative_USCOREentropyResponse * SOAP_FMAC4 soap_get_ns1__base_USCORErelative_USCOREentropyResponse(struct soap *soap, struct ns1__base_USCORErelative_USCOREentropyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCORErelative_USCOREentropyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__Ew(struct soap *soap, struct ns1__Ew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__Ew(struct soap *soap, const struct ns1__Ew *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__EwInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__Ew(struct soap *soap, const char *tag, int id, const struct ns1__Ew *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__Ew), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__EwInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__Ew * SOAP_FMAC4 soap_in_ns1__Ew(struct soap *soap, const char *tag, struct ns1__Ew *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__Ew *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__Ew, sizeof(struct ns1__Ew), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__Ew(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__EwInputParams(soap, NULL, &a->_params, "ns1:EwInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__Ew *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__Ew, 0, sizeof(struct ns1__Ew), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__Ew(struct soap *soap, const struct ns1__Ew *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__Ew);
	if (soap_out_ns1__Ew(soap, tag?tag:"ns1:Ew", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__Ew * SOAP_FMAC4 soap_get_ns1__Ew(struct soap *soap, struct ns1__Ew *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__Ew(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__EwResponse(struct soap *soap, struct ns1__EwResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__EwResponse(struct soap *soap, const struct ns1__EwResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__EwResponse(struct soap *soap, const char *tag, int id, const struct ns1__EwResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__EwResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__EwResponse * SOAP_FMAC4 soap_in_ns1__EwResponse(struct soap *soap, const char *tag, struct ns1__EwResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__EwResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__EwResponse, sizeof(struct ns1__EwResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__EwResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__EwResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__EwResponse, 0, sizeof(struct ns1__EwResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__EwResponse(struct soap *soap, const struct ns1__EwResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__EwResponse);
	if (soap_out_ns1__EwResponse(soap, tag?tag:"ns1:EwResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__EwResponse * SOAP_FMAC4 soap_get_ns1__EwResponse(struct soap *soap, struct ns1__EwResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__EwResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__over_USCORElapping_USCOREfinder(struct soap *soap, struct ns1__over_USCORElapping_USCOREfinder *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__over_USCORElapping_USCOREfinder(struct soap *soap, const struct ns1__over_USCORElapping_USCOREfinder *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__over_USCORElapping_USCOREfinderInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__over_USCORElapping_USCOREfinder(struct soap *soap, const char *tag, int id, const struct ns1__over_USCORElapping_USCOREfinder *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__over_USCORElapping_USCOREfinderInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__over_USCORElapping_USCOREfinder * SOAP_FMAC4 soap_in_ns1__over_USCORElapping_USCOREfinder(struct soap *soap, const char *tag, struct ns1__over_USCORElapping_USCOREfinder *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__over_USCORElapping_USCOREfinder *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder, sizeof(struct ns1__over_USCORElapping_USCOREfinder), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__over_USCORElapping_USCOREfinder(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__over_USCORElapping_USCOREfinderInputParams(soap, NULL, &a->_params, "ns1:over_lapping_finderInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__over_USCORElapping_USCOREfinder *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder, 0, sizeof(struct ns1__over_USCORElapping_USCOREfinder), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__over_USCORElapping_USCOREfinder(struct soap *soap, const struct ns1__over_USCORElapping_USCOREfinder *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinder);
	if (soap_out_ns1__over_USCORElapping_USCOREfinder(soap, tag?tag:"ns1:over_lapping_finder", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__over_USCORElapping_USCOREfinder * SOAP_FMAC4 soap_get_ns1__over_USCORElapping_USCOREfinder(struct soap *soap, struct ns1__over_USCORElapping_USCOREfinder *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__over_USCORElapping_USCOREfinder(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__over_USCORElapping_USCOREfinderResponse(struct soap *soap, struct ns1__over_USCORElapping_USCOREfinderResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__over_USCORElapping_USCOREfinderResponse(struct soap *soap, const struct ns1__over_USCORElapping_USCOREfinderResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__over_USCORElapping_USCOREfinderResponse(struct soap *soap, const char *tag, int id, const struct ns1__over_USCORElapping_USCOREfinderResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__over_USCORElapping_USCOREfinderResponse * SOAP_FMAC4 soap_in_ns1__over_USCORElapping_USCOREfinderResponse(struct soap *soap, const char *tag, struct ns1__over_USCORElapping_USCOREfinderResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__over_USCORElapping_USCOREfinderResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse, sizeof(struct ns1__over_USCORElapping_USCOREfinderResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__over_USCORElapping_USCOREfinderResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__over_USCORElapping_USCOREfinderResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse, 0, sizeof(struct ns1__over_USCORElapping_USCOREfinderResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__over_USCORElapping_USCOREfinderResponse(struct soap *soap, const struct ns1__over_USCORElapping_USCOREfinderResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderResponse);
	if (soap_out_ns1__over_USCORElapping_USCOREfinderResponse(soap, tag?tag:"ns1:over_lapping_finderResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__over_USCORElapping_USCOREfinderResponse * SOAP_FMAC4 soap_get_ns1__over_USCORElapping_USCOREfinderResponse(struct soap *soap, struct ns1__over_USCORElapping_USCOREfinderResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__over_USCORElapping_USCOREfinderResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREcompiler(struct soap *soap, struct ns1__codon_USCOREcompiler *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREcompiler(struct soap *soap, const struct ns1__codon_USCOREcompiler *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__codon_USCOREcompilerInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREcompiler(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREcompiler *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREcompiler), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__codon_USCOREcompilerInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREcompiler * SOAP_FMAC4 soap_in_ns1__codon_USCOREcompiler(struct soap *soap, const char *tag, struct ns1__codon_USCOREcompiler *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREcompiler *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREcompiler, sizeof(struct ns1__codon_USCOREcompiler), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREcompiler(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__codon_USCOREcompilerInputParams(soap, NULL, &a->_params, "ns1:codon_compilerInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREcompiler *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREcompiler, 0, sizeof(struct ns1__codon_USCOREcompiler), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREcompiler(struct soap *soap, const struct ns1__codon_USCOREcompiler *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREcompiler);
	if (soap_out_ns1__codon_USCOREcompiler(soap, tag?tag:"ns1:codon_compiler", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREcompiler * SOAP_FMAC4 soap_get_ns1__codon_USCOREcompiler(struct soap *soap, struct ns1__codon_USCOREcompiler *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREcompiler(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREcompilerResponse(struct soap *soap, struct ns1__codon_USCOREcompilerResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREcompilerResponse(struct soap *soap, const struct ns1__codon_USCOREcompilerResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREcompilerResponse(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREcompilerResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREcompilerResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREcompilerResponse * SOAP_FMAC4 soap_in_ns1__codon_USCOREcompilerResponse(struct soap *soap, const char *tag, struct ns1__codon_USCOREcompilerResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREcompilerResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREcompilerResponse, sizeof(struct ns1__codon_USCOREcompilerResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREcompilerResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREcompilerResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREcompilerResponse, 0, sizeof(struct ns1__codon_USCOREcompilerResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREcompilerResponse(struct soap *soap, const struct ns1__codon_USCOREcompilerResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREcompilerResponse);
	if (soap_out_ns1__codon_USCOREcompilerResponse(soap, tag?tag:"ns1:codon_compilerResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREcompilerResponse * SOAP_FMAC4 soap_get_ns1__codon_USCOREcompilerResponse(struct soap *soap, struct ns1__codon_USCOREcompilerResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREcompilerResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__aaui(struct soap *soap, struct ns1__aaui *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__aaui(struct soap *soap, const struct ns1__aaui *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__aauiInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__aaui(struct soap *soap, const char *tag, int id, const struct ns1__aaui *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__aaui), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__aauiInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__aaui * SOAP_FMAC4 soap_in_ns1__aaui(struct soap *soap, const char *tag, struct ns1__aaui *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__aaui *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__aaui, sizeof(struct ns1__aaui), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__aaui(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__aauiInputParams(soap, NULL, &a->_params, "ns1:aauiInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__aaui *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__aaui, 0, sizeof(struct ns1__aaui), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__aaui(struct soap *soap, const struct ns1__aaui *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__aaui);
	if (soap_out_ns1__aaui(soap, tag?tag:"ns1:aaui", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__aaui * SOAP_FMAC4 soap_get_ns1__aaui(struct soap *soap, struct ns1__aaui *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__aaui(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__aauiResponse(struct soap *soap, struct ns1__aauiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__aauiResponse(struct soap *soap, const struct ns1__aauiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__aauiResponse(struct soap *soap, const char *tag, int id, const struct ns1__aauiResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__aauiResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__aauiResponse * SOAP_FMAC4 soap_in_ns1__aauiResponse(struct soap *soap, const char *tag, struct ns1__aauiResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__aauiResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__aauiResponse, sizeof(struct ns1__aauiResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__aauiResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__aauiResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__aauiResponse, 0, sizeof(struct ns1__aauiResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__aauiResponse(struct soap *soap, const struct ns1__aauiResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__aauiResponse);
	if (soap_out_ns1__aauiResponse(soap, tag?tag:"ns1:aauiResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__aauiResponse * SOAP_FMAC4 soap_get_ns1__aauiResponse(struct soap *soap, struct ns1__aauiResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__aauiResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__amino_USCOREcounter(struct soap *soap, struct ns1__amino_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__amino_USCOREcounter(struct soap *soap, const struct ns1__amino_USCOREcounter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__amino_USCOREcounterInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__amino_USCOREcounter(struct soap *soap, const char *tag, int id, const struct ns1__amino_USCOREcounter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__amino_USCOREcounter), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__amino_USCOREcounterInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__amino_USCOREcounter * SOAP_FMAC4 soap_in_ns1__amino_USCOREcounter(struct soap *soap, const char *tag, struct ns1__amino_USCOREcounter *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__amino_USCOREcounter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__amino_USCOREcounter, sizeof(struct ns1__amino_USCOREcounter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__amino_USCOREcounter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__amino_USCOREcounterInputParams(soap, NULL, &a->_params, "ns1:amino_counterInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__amino_USCOREcounter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__amino_USCOREcounter, 0, sizeof(struct ns1__amino_USCOREcounter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__amino_USCOREcounter(struct soap *soap, const struct ns1__amino_USCOREcounter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__amino_USCOREcounter);
	if (soap_out_ns1__amino_USCOREcounter(soap, tag?tag:"ns1:amino_counter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__amino_USCOREcounter * SOAP_FMAC4 soap_get_ns1__amino_USCOREcounter(struct soap *soap, struct ns1__amino_USCOREcounter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__amino_USCOREcounter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__amino_USCOREcounterResponse(struct soap *soap, struct ns1__amino_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__amino_USCOREcounterResponse(struct soap *soap, const struct ns1__amino_USCOREcounterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__amino_USCOREcounterResponse(struct soap *soap, const char *tag, int id, const struct ns1__amino_USCOREcounterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__amino_USCOREcounterResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__amino_USCOREcounterResponse * SOAP_FMAC4 soap_in_ns1__amino_USCOREcounterResponse(struct soap *soap, const char *tag, struct ns1__amino_USCOREcounterResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__amino_USCOREcounterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__amino_USCOREcounterResponse, sizeof(struct ns1__amino_USCOREcounterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__amino_USCOREcounterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__amino_USCOREcounterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__amino_USCOREcounterResponse, 0, sizeof(struct ns1__amino_USCOREcounterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__amino_USCOREcounterResponse(struct soap *soap, const struct ns1__amino_USCOREcounterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__amino_USCOREcounterResponse);
	if (soap_out_ns1__amino_USCOREcounterResponse(soap, tag?tag:"ns1:amino_counterResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__amino_USCOREcounterResponse * SOAP_FMAC4 soap_get_ns1__amino_USCOREcounterResponse(struct soap *soap, struct ns1__amino_USCOREcounterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__amino_USCOREcounterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__seq2png(struct soap *soap, struct ns1__seq2png *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__seq2png(struct soap *soap, const struct ns1__seq2png *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__seq2pngInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__seq2png(struct soap *soap, const char *tag, int id, const struct ns1__seq2png *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__seq2png), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__seq2pngInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__seq2png * SOAP_FMAC4 soap_in_ns1__seq2png(struct soap *soap, const char *tag, struct ns1__seq2png *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__seq2png *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__seq2png, sizeof(struct ns1__seq2png), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__seq2png(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__seq2pngInputParams(soap, NULL, &a->_params, "ns1:seq2pngInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__seq2png *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__seq2png, 0, sizeof(struct ns1__seq2png), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__seq2png(struct soap *soap, const struct ns1__seq2png *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__seq2png);
	if (soap_out_ns1__seq2png(soap, tag?tag:"ns1:seq2png", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__seq2png * SOAP_FMAC4 soap_get_ns1__seq2png(struct soap *soap, struct ns1__seq2png *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__seq2png(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__seq2pngResponse(struct soap *soap, struct ns1__seq2pngResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__seq2pngResponse(struct soap *soap, const struct ns1__seq2pngResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__seq2pngResponse(struct soap *soap, const char *tag, int id, const struct ns1__seq2pngResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__seq2pngResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__seq2pngResponse * SOAP_FMAC4 soap_in_ns1__seq2pngResponse(struct soap *soap, const char *tag, struct ns1__seq2pngResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__seq2pngResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__seq2pngResponse, sizeof(struct ns1__seq2pngResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__seq2pngResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__seq2pngResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__seq2pngResponse, 0, sizeof(struct ns1__seq2pngResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__seq2pngResponse(struct soap *soap, const struct ns1__seq2pngResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__seq2pngResponse);
	if (soap_out_ns1__seq2pngResponse(soap, tag?tag:"ns1:seq2pngResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__seq2pngResponse * SOAP_FMAC4 soap_get_ns1__seq2pngResponse(struct soap *soap, struct ns1__seq2pngResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__seq2pngResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__ttest(struct soap *soap, struct ns1__ttest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array1 = NULL;
	a->_array2 = NULL;
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__ttest(struct soap *soap, const struct ns1__ttest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array1);
	soap_serialize_PointerToarrayIn(soap, &a->_array2);
	soap_serialize_PointerTons1__ttestInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ttest(struct soap *soap, const char *tag, int id, const struct ns1__ttest *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ttest), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array1", -1, &a->_array1, ""))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array2", -1, &a->_array2, ""))
		return soap->error;
	if (soap_out_PointerTons1__ttestInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__ttest * SOAP_FMAC4 soap_in_ns1__ttest(struct soap *soap, const char *tag, struct ns1__ttest *a, const char *type)
{
	size_t soap_flag__array1 = 1;
	size_t soap_flag__array2 = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__ttest *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ttest, sizeof(struct ns1__ttest), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__ttest(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array1, "xsd:string"))
				{	soap_flag__array1--;
					continue;
				}
			if (soap_flag__array2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array2, "xsd:string"))
				{	soap_flag__array2--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ttestInputParams(soap, NULL, &a->_params, "ns1:ttestInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__ttest *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ttest, 0, sizeof(struct ns1__ttest), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__ttest(struct soap *soap, const struct ns1__ttest *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__ttest);
	if (soap_out_ns1__ttest(soap, tag?tag:"ns1:ttest", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__ttest * SOAP_FMAC4 soap_get_ns1__ttest(struct soap *soap, struct ns1__ttest *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__ttest(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__ttestResponse(struct soap *soap, struct ns1__ttestResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__ttestResponse(struct soap *soap, const struct ns1__ttestResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayOut(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ttestResponse(struct soap *soap, const char *tag, int id, const struct ns1__ttestResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ttestResponse), type))
		return soap->error;
	if (soap_out_PointerToarrayOut(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__ttestResponse * SOAP_FMAC4 soap_in_ns1__ttestResponse(struct soap *soap, const char *tag, struct ns1__ttestResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__ttestResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ttestResponse, sizeof(struct ns1__ttestResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__ttestResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayOut(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__ttestResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ttestResponse, 0, sizeof(struct ns1__ttestResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__ttestResponse(struct soap *soap, const struct ns1__ttestResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__ttestResponse);
	if (soap_out_ns1__ttestResponse(soap, tag?tag:"ns1:ttestResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__ttestResponse * SOAP_FMAC4 soap_get_ns1__ttestResponse(struct soap *soap, struct ns1__ttestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__ttestResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREdnaAbox(struct soap *soap, struct ns1__find_USCOREdnaAbox *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREdnaAbox(struct soap *soap, const struct ns1__find_USCOREdnaAbox *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__find_USCOREdnaAboxInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREdnaAbox(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREdnaAbox *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREdnaAbox), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__find_USCOREdnaAboxInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREdnaAbox * SOAP_FMAC4 soap_in_ns1__find_USCOREdnaAbox(struct soap *soap, const char *tag, struct ns1__find_USCOREdnaAbox *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREdnaAbox *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREdnaAbox, sizeof(struct ns1__find_USCOREdnaAbox), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREdnaAbox(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__find_USCOREdnaAboxInputParams(soap, NULL, &a->_params, "ns1:find_dnaAboxInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREdnaAbox *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREdnaAbox, 0, sizeof(struct ns1__find_USCOREdnaAbox), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREdnaAbox(struct soap *soap, const struct ns1__find_USCOREdnaAbox *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREdnaAbox);
	if (soap_out_ns1__find_USCOREdnaAbox(soap, tag?tag:"ns1:find_dnaAbox", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREdnaAbox * SOAP_FMAC4 soap_get_ns1__find_USCOREdnaAbox(struct soap *soap, struct ns1__find_USCOREdnaAbox *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREdnaAbox(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREdnaAboxResponse(struct soap *soap, struct ns1__find_USCOREdnaAboxResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREdnaAboxResponse(struct soap *soap, const struct ns1__find_USCOREdnaAboxResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREdnaAboxResponse(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREdnaAboxResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREdnaAboxResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREdnaAboxResponse * SOAP_FMAC4 soap_in_ns1__find_USCOREdnaAboxResponse(struct soap *soap, const char *tag, struct ns1__find_USCOREdnaAboxResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREdnaAboxResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREdnaAboxResponse, sizeof(struct ns1__find_USCOREdnaAboxResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREdnaAboxResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREdnaAboxResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREdnaAboxResponse, 0, sizeof(struct ns1__find_USCOREdnaAboxResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREdnaAboxResponse(struct soap *soap, const struct ns1__find_USCOREdnaAboxResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREdnaAboxResponse);
	if (soap_out_ns1__find_USCOREdnaAboxResponse(soap, tag?tag:"ns1:find_dnaAboxResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREdnaAboxResponse * SOAP_FMAC4 soap_get_ns1__find_USCOREdnaAboxResponse(struct soap *soap, struct ns1__find_USCOREdnaAboxResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREdnaAboxResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dist_USCOREin_USCOREcc(struct soap *soap, struct ns1__dist_USCOREin_USCOREcc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	soap_default_int(soap, &a->_position1);
	soap_default_int(soap, &a->_position2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dist_USCOREin_USCOREcc(struct soap *soap, const struct ns1__dist_USCOREin_USCOREcc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dist_USCOREin_USCOREcc(struct soap *soap, const char *tag, int id, const struct ns1__dist_USCOREin_USCOREcc *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dist_USCOREin_USCOREcc), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_int(soap, "position1", -1, &a->_position1, ""))
		return soap->error;
	if (soap_out_int(soap, "position2", -1, &a->_position2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dist_USCOREin_USCOREcc * SOAP_FMAC4 soap_in_ns1__dist_USCOREin_USCOREcc(struct soap *soap, const char *tag, struct ns1__dist_USCOREin_USCOREcc *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__position1 = 1;
	size_t soap_flag__position2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dist_USCOREin_USCOREcc *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dist_USCOREin_USCOREcc, sizeof(struct ns1__dist_USCOREin_USCOREcc), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dist_USCOREin_USCOREcc(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__position1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_position1, "xsd:int"))
				{	soap_flag__position1--;
					continue;
				}
			if (soap_flag__position2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_position2, "xsd:int"))
				{	soap_flag__position2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dist_USCOREin_USCOREcc *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dist_USCOREin_USCOREcc, 0, sizeof(struct ns1__dist_USCOREin_USCOREcc), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__position1 > 0 || soap_flag__position2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dist_USCOREin_USCOREcc(struct soap *soap, const struct ns1__dist_USCOREin_USCOREcc *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dist_USCOREin_USCOREcc);
	if (soap_out_ns1__dist_USCOREin_USCOREcc(soap, tag?tag:"ns1:dist_in_cc", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dist_USCOREin_USCOREcc * SOAP_FMAC4 soap_get_ns1__dist_USCOREin_USCOREcc(struct soap *soap, struct ns1__dist_USCOREin_USCOREcc *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dist_USCOREin_USCOREcc(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dist_USCOREin_USCOREccResponse(struct soap *soap, struct ns1__dist_USCOREin_USCOREccResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dist_USCOREin_USCOREccResponse(struct soap *soap, const struct ns1__dist_USCOREin_USCOREccResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dist_USCOREin_USCOREccResponse(struct soap *soap, const char *tag, int id, const struct ns1__dist_USCOREin_USCOREccResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dist_USCOREin_USCOREccResponse * SOAP_FMAC4 soap_in_ns1__dist_USCOREin_USCOREccResponse(struct soap *soap, const char *tag, struct ns1__dist_USCOREin_USCOREccResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dist_USCOREin_USCOREccResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse, sizeof(struct ns1__dist_USCOREin_USCOREccResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dist_USCOREin_USCOREccResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dist_USCOREin_USCOREccResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse, 0, sizeof(struct ns1__dist_USCOREin_USCOREccResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dist_USCOREin_USCOREccResponse(struct soap *soap, const struct ns1__dist_USCOREin_USCOREccResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dist_USCOREin_USCOREccResponse);
	if (soap_out_ns1__dist_USCOREin_USCOREccResponse(soap, tag?tag:"ns1:dist_in_ccResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dist_USCOREin_USCOREccResponse * SOAP_FMAC4 soap_get_ns1__dist_USCOREin_USCOREccResponse(struct soap *soap, struct ns1__dist_USCOREin_USCOREccResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dist_USCOREin_USCOREccResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__bui(struct soap *soap, struct ns1__bui *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__bui(struct soap *soap, const struct ns1__bui *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__buiInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__bui(struct soap *soap, const char *tag, int id, const struct ns1__bui *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__bui), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__buiInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__bui * SOAP_FMAC4 soap_in_ns1__bui(struct soap *soap, const char *tag, struct ns1__bui *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__bui *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__bui, sizeof(struct ns1__bui), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__bui(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__buiInputParams(soap, NULL, &a->_params, "ns1:buiInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__bui *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__bui, 0, sizeof(struct ns1__bui), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__bui(struct soap *soap, const struct ns1__bui *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__bui);
	if (soap_out_ns1__bui(soap, tag?tag:"ns1:bui", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__bui * SOAP_FMAC4 soap_get_ns1__bui(struct soap *soap, struct ns1__bui *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__bui(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__buiResponse(struct soap *soap, struct ns1__buiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__buiResponse(struct soap *soap, const struct ns1__buiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__buiResponse(struct soap *soap, const char *tag, int id, const struct ns1__buiResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__buiResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__buiResponse * SOAP_FMAC4 soap_in_ns1__buiResponse(struct soap *soap, const char *tag, struct ns1__buiResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__buiResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__buiResponse, sizeof(struct ns1__buiResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__buiResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__buiResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__buiResponse, 0, sizeof(struct ns1__buiResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__buiResponse(struct soap *soap, const struct ns1__buiResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__buiResponse);
	if (soap_out_ns1__buiResponse(soap, tag?tag:"ns1:buiResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__buiResponse * SOAP_FMAC4 soap_get_ns1__buiResponse(struct soap *soap, struct ns1__buiResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__buiResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__fop(struct soap *soap, struct ns1__fop *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__fop(struct soap *soap, const struct ns1__fop *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__fopInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__fop(struct soap *soap, const char *tag, int id, const struct ns1__fop *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__fop), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__fopInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__fop * SOAP_FMAC4 soap_in_ns1__fop(struct soap *soap, const char *tag, struct ns1__fop *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__fop *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__fop, sizeof(struct ns1__fop), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__fop(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__fopInputParams(soap, NULL, &a->_params, "ns1:fopInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__fop *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__fop, 0, sizeof(struct ns1__fop), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__fop(struct soap *soap, const struct ns1__fop *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__fop);
	if (soap_out_ns1__fop(soap, tag?tag:"ns1:fop", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__fop * SOAP_FMAC4 soap_get_ns1__fop(struct soap *soap, struct ns1__fop *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__fop(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__fopResponse(struct soap *soap, struct ns1__fopResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__fopResponse(struct soap *soap, const struct ns1__fopResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__fopResponse(struct soap *soap, const char *tag, int id, const struct ns1__fopResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__fopResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__fopResponse * SOAP_FMAC4 soap_in_ns1__fopResponse(struct soap *soap, const char *tag, struct ns1__fopResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__fopResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__fopResponse, sizeof(struct ns1__fopResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__fopResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__fopResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__fopResponse, 0, sizeof(struct ns1__fopResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__fopResponse(struct soap *soap, const struct ns1__fopResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__fopResponse);
	if (soap_out_ns1__fopResponse(soap, tag?tag:"ns1:fopResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__fopResponse * SOAP_FMAC4 soap_get_ns1__fopResponse(struct soap *soap, struct ns1__fopResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__fopResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__enc(struct soap *soap, struct ns1__enc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__enc(struct soap *soap, const struct ns1__enc *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__encInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__enc(struct soap *soap, const char *tag, int id, const struct ns1__enc *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__enc), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__encInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__enc * SOAP_FMAC4 soap_in_ns1__enc(struct soap *soap, const char *tag, struct ns1__enc *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__enc *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__enc, sizeof(struct ns1__enc), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__enc(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__encInputParams(soap, NULL, &a->_params, "ns1:encInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__enc *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__enc, 0, sizeof(struct ns1__enc), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__enc(struct soap *soap, const struct ns1__enc *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__enc);
	if (soap_out_ns1__enc(soap, tag?tag:"ns1:enc", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__enc * SOAP_FMAC4 soap_get_ns1__enc(struct soap *soap, struct ns1__enc *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__enc(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__encResponse(struct soap *soap, struct ns1__encResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__encResponse(struct soap *soap, const struct ns1__encResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__encResponse(struct soap *soap, const char *tag, int id, const struct ns1__encResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__encResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__encResponse * SOAP_FMAC4 soap_in_ns1__encResponse(struct soap *soap, const char *tag, struct ns1__encResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__encResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__encResponse, sizeof(struct ns1__encResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__encResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__encResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__encResponse, 0, sizeof(struct ns1__encResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__encResponse(struct soap *soap, const struct ns1__encResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__encResponse);
	if (soap_out_ns1__encResponse(soap, tag?tag:"ns1:encResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__encResponse * SOAP_FMAC4 soap_get_ns1__encResponse(struct soap *soap, struct ns1__encResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__encResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__icdi(struct soap *soap, struct ns1__icdi *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__icdi(struct soap *soap, const struct ns1__icdi *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__icdiInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__icdi(struct soap *soap, const char *tag, int id, const struct ns1__icdi *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__icdi), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__icdiInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__icdi * SOAP_FMAC4 soap_in_ns1__icdi(struct soap *soap, const char *tag, struct ns1__icdi *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__icdi *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__icdi, sizeof(struct ns1__icdi), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__icdi(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__icdiInputParams(soap, NULL, &a->_params, "ns1:icdiInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__icdi *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__icdi, 0, sizeof(struct ns1__icdi), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__icdi(struct soap *soap, const struct ns1__icdi *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__icdi);
	if (soap_out_ns1__icdi(soap, tag?tag:"ns1:icdi", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__icdi * SOAP_FMAC4 soap_get_ns1__icdi(struct soap *soap, struct ns1__icdi *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__icdi(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__icdiResponse(struct soap *soap, struct ns1__icdiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__icdiResponse(struct soap *soap, const struct ns1__icdiResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__icdiResponse(struct soap *soap, const char *tag, int id, const struct ns1__icdiResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__icdiResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__icdiResponse * SOAP_FMAC4 soap_in_ns1__icdiResponse(struct soap *soap, const char *tag, struct ns1__icdiResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__icdiResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__icdiResponse, sizeof(struct ns1__icdiResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__icdiResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__icdiResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__icdiResponse, 0, sizeof(struct ns1__icdiResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__icdiResponse(struct soap *soap, const struct ns1__icdiResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__icdiResponse);
	if (soap_out_ns1__icdiResponse(soap, tag?tag:"ns1:icdiResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__icdiResponse * SOAP_FMAC4 soap_get_ns1__icdiResponse(struct soap *soap, struct ns1__icdiResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__icdiResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__phx(struct soap *soap, struct ns1__phx *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__phx(struct soap *soap, const struct ns1__phx *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__phxInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__phx(struct soap *soap, const char *tag, int id, const struct ns1__phx *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__phx), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__phxInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__phx * SOAP_FMAC4 soap_in_ns1__phx(struct soap *soap, const char *tag, struct ns1__phx *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__phx *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__phx, sizeof(struct ns1__phx), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__phx(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__phxInputParams(soap, NULL, &a->_params, "ns1:phxInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__phx *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__phx, 0, sizeof(struct ns1__phx), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__phx(struct soap *soap, const struct ns1__phx *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__phx);
	if (soap_out_ns1__phx(soap, tag?tag:"ns1:phx", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__phx * SOAP_FMAC4 soap_get_ns1__phx(struct soap *soap, struct ns1__phx *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__phx(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__phxResponse(struct soap *soap, struct ns1__phxResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__phxResponse(struct soap *soap, const struct ns1__phxResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__phxResponse(struct soap *soap, const char *tag, int id, const struct ns1__phxResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__phxResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__phxResponse * SOAP_FMAC4 soap_in_ns1__phxResponse(struct soap *soap, const char *tag, struct ns1__phxResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__phxResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__phxResponse, sizeof(struct ns1__phxResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__phxResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__phxResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__phxResponse, 0, sizeof(struct ns1__phxResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__phxResponse(struct soap *soap, const struct ns1__phxResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__phxResponse);
	if (soap_out_ns1__phxResponse(soap, tag?tag:"ns1:phxResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__phxResponse * SOAP_FMAC4 soap_get_ns1__phxResponse(struct soap *soap, struct ns1__phxResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__phxResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__translate(struct soap *soap, struct ns1__translate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__translate(struct soap *soap, const struct ns1__translate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__translate(struct soap *soap, const char *tag, int id, const struct ns1__translate *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__translate), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__translate * SOAP_FMAC4 soap_in_ns1__translate(struct soap *soap, const char *tag, struct ns1__translate *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__translate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__translate, sizeof(struct ns1__translate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__translate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__translate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__translate, 0, sizeof(struct ns1__translate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__translate(struct soap *soap, const struct ns1__translate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__translate);
	if (soap_out_ns1__translate(soap, tag?tag:"ns1:translate", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__translate * SOAP_FMAC4 soap_get_ns1__translate(struct soap *soap, struct ns1__translate *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__translate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__translateResponse(struct soap *soap, struct ns1__translateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__translateResponse(struct soap *soap, const struct ns1__translateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__translateResponse(struct soap *soap, const char *tag, int id, const struct ns1__translateResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__translateResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__translateResponse * SOAP_FMAC4 soap_in_ns1__translateResponse(struct soap *soap, const char *tag, struct ns1__translateResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__translateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__translateResponse, sizeof(struct ns1__translateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__translateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__translateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__translateResponse, 0, sizeof(struct ns1__translateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__translateResponse(struct soap *soap, const struct ns1__translateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__translateResponse);
	if (soap_out_ns1__translateResponse(soap, tag?tag:"ns1:translateResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__translateResponse * SOAP_FMAC4 soap_get_ns1__translateResponse(struct soap *soap, struct ns1__translateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__translateResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__togoWS(struct soap *soap, struct ns1__togoWS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_query);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__togoWS(struct soap *soap, const struct ns1__togoWS *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_query);
	soap_serialize_PointerTons1__togoWSInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__togoWS(struct soap *soap, const char *tag, int id, const struct ns1__togoWS *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__togoWS), type))
		return soap->error;
	if (soap_out_string(soap, "query", -1, &a->_query, ""))
		return soap->error;
	if (soap_out_PointerTons1__togoWSInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__togoWS * SOAP_FMAC4 soap_in_ns1__togoWS(struct soap *soap, const char *tag, struct ns1__togoWS *a, const char *type)
{
	size_t soap_flag__query = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__togoWS *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__togoWS, sizeof(struct ns1__togoWS), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__togoWS(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__query && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_query, "xsd:string"))
				{	soap_flag__query--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__togoWSInputParams(soap, NULL, &a->_params, "ns1:togoWSInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__togoWS *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__togoWS, 0, sizeof(struct ns1__togoWS), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__togoWS(struct soap *soap, const struct ns1__togoWS *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__togoWS);
	if (soap_out_ns1__togoWS(soap, tag?tag:"ns1:togoWS", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__togoWS * SOAP_FMAC4 soap_get_ns1__togoWS(struct soap *soap, struct ns1__togoWS *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__togoWS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__togoWSResponse(struct soap *soap, struct ns1__togoWSResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__togoWSResponse(struct soap *soap, const struct ns1__togoWSResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__togoWSResponse(struct soap *soap, const char *tag, int id, const struct ns1__togoWSResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__togoWSResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__togoWSResponse * SOAP_FMAC4 soap_in_ns1__togoWSResponse(struct soap *soap, const char *tag, struct ns1__togoWSResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__togoWSResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__togoWSResponse, sizeof(struct ns1__togoWSResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__togoWSResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__togoWSResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__togoWSResponse, 0, sizeof(struct ns1__togoWSResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__togoWSResponse(struct soap *soap, const struct ns1__togoWSResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__togoWSResponse);
	if (soap_out_ns1__togoWSResponse(soap, tag?tag:"ns1:togoWSResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__togoWSResponse * SOAP_FMAC4 soap_get_ns1__togoWSResponse(struct soap *soap, struct ns1__togoWSResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__togoWSResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__circular_USCOREmap(struct soap *soap, struct ns1__circular_USCOREmap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__circular_USCOREmap(struct soap *soap, const struct ns1__circular_USCOREmap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__circular_USCOREmapInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__circular_USCOREmap(struct soap *soap, const char *tag, int id, const struct ns1__circular_USCOREmap *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__circular_USCOREmap), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__circular_USCOREmapInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__circular_USCOREmap * SOAP_FMAC4 soap_in_ns1__circular_USCOREmap(struct soap *soap, const char *tag, struct ns1__circular_USCOREmap *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__circular_USCOREmap *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__circular_USCOREmap, sizeof(struct ns1__circular_USCOREmap), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__circular_USCOREmap(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__circular_USCOREmapInputParams(soap, NULL, &a->_params, "ns1:circular_mapInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__circular_USCOREmap *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__circular_USCOREmap, 0, sizeof(struct ns1__circular_USCOREmap), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__circular_USCOREmap(struct soap *soap, const struct ns1__circular_USCOREmap *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__circular_USCOREmap);
	if (soap_out_ns1__circular_USCOREmap(soap, tag?tag:"ns1:circular_map", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__circular_USCOREmap * SOAP_FMAC4 soap_get_ns1__circular_USCOREmap(struct soap *soap, struct ns1__circular_USCOREmap *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__circular_USCOREmap(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__circular_USCOREmapResponse(struct soap *soap, struct ns1__circular_USCOREmapResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__circular_USCOREmapResponse(struct soap *soap, const struct ns1__circular_USCOREmapResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__circular_USCOREmapResponse(struct soap *soap, const char *tag, int id, const struct ns1__circular_USCOREmapResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__circular_USCOREmapResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__circular_USCOREmapResponse * SOAP_FMAC4 soap_in_ns1__circular_USCOREmapResponse(struct soap *soap, const char *tag, struct ns1__circular_USCOREmapResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__circular_USCOREmapResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__circular_USCOREmapResponse, sizeof(struct ns1__circular_USCOREmapResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__circular_USCOREmapResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__circular_USCOREmapResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__circular_USCOREmapResponse, 0, sizeof(struct ns1__circular_USCOREmapResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__circular_USCOREmapResponse(struct soap *soap, const struct ns1__circular_USCOREmapResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__circular_USCOREmapResponse);
	if (soap_out_ns1__circular_USCOREmapResponse(soap, tag?tag:"ns1:circular_mapResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__circular_USCOREmapResponse * SOAP_FMAC4 soap_get_ns1__circular_USCOREmapResponse(struct soap *soap, struct ns1__circular_USCOREmapResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__circular_USCOREmapResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__amino_USCOREinfo(struct soap *soap, struct ns1__amino_USCOREinfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__amino_USCOREinfo(struct soap *soap, const struct ns1__amino_USCOREinfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__amino_USCOREinfo(struct soap *soap, const char *tag, int id, const struct ns1__amino_USCOREinfo *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__amino_USCOREinfo), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__amino_USCOREinfo * SOAP_FMAC4 soap_in_ns1__amino_USCOREinfo(struct soap *soap, const char *tag, struct ns1__amino_USCOREinfo *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__amino_USCOREinfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__amino_USCOREinfo, sizeof(struct ns1__amino_USCOREinfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__amino_USCOREinfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__amino_USCOREinfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__amino_USCOREinfo, 0, sizeof(struct ns1__amino_USCOREinfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__amino_USCOREinfo(struct soap *soap, const struct ns1__amino_USCOREinfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__amino_USCOREinfo);
	if (soap_out_ns1__amino_USCOREinfo(soap, tag?tag:"ns1:amino_info", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__amino_USCOREinfo * SOAP_FMAC4 soap_get_ns1__amino_USCOREinfo(struct soap *soap, struct ns1__amino_USCOREinfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__amino_USCOREinfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__amino_USCOREinfoResponse(struct soap *soap, struct ns1__amino_USCOREinfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__amino_USCOREinfoResponse(struct soap *soap, const struct ns1__amino_USCOREinfoResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__amino_USCOREinfoResponse(struct soap *soap, const char *tag, int id, const struct ns1__amino_USCOREinfoResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__amino_USCOREinfoResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__amino_USCOREinfoResponse * SOAP_FMAC4 soap_in_ns1__amino_USCOREinfoResponse(struct soap *soap, const char *tag, struct ns1__amino_USCOREinfoResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__amino_USCOREinfoResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__amino_USCOREinfoResponse, sizeof(struct ns1__amino_USCOREinfoResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__amino_USCOREinfoResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__amino_USCOREinfoResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__amino_USCOREinfoResponse, 0, sizeof(struct ns1__amino_USCOREinfoResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__amino_USCOREinfoResponse(struct soap *soap, const struct ns1__amino_USCOREinfoResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__amino_USCOREinfoResponse);
	if (soap_out_ns1__amino_USCOREinfoResponse(soap, tag?tag:"ns1:amino_infoResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__amino_USCOREinfoResponse * SOAP_FMAC4 soap_get_ns1__amino_USCOREinfoResponse(struct soap *soap, struct ns1__amino_USCOREinfoResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__amino_USCOREinfoResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__variance(struct soap *soap, struct ns1__variance *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__variance(struct soap *soap, const struct ns1__variance *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__variance(struct soap *soap, const char *tag, int id, const struct ns1__variance *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__variance), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__variance * SOAP_FMAC4 soap_in_ns1__variance(struct soap *soap, const char *tag, struct ns1__variance *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__variance *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__variance, sizeof(struct ns1__variance), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__variance(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__variance *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__variance, 0, sizeof(struct ns1__variance), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__variance(struct soap *soap, const struct ns1__variance *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__variance);
	if (soap_out_ns1__variance(soap, tag?tag:"ns1:variance", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__variance * SOAP_FMAC4 soap_get_ns1__variance(struct soap *soap, struct ns1__variance *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__variance(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__varianceResponse(struct soap *soap, struct ns1__varianceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__varianceResponse(struct soap *soap, const struct ns1__varianceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__varianceResponse(struct soap *soap, const char *tag, int id, const struct ns1__varianceResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__varianceResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__varianceResponse * SOAP_FMAC4 soap_in_ns1__varianceResponse(struct soap *soap, const char *tag, struct ns1__varianceResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__varianceResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__varianceResponse, sizeof(struct ns1__varianceResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__varianceResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__varianceResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__varianceResponse, 0, sizeof(struct ns1__varianceResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__varianceResponse(struct soap *soap, const struct ns1__varianceResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__varianceResponse);
	if (soap_out_ns1__varianceResponse(soap, tag?tag:"ns1:varianceResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__varianceResponse * SOAP_FMAC4 soap_get_ns1__varianceResponse(struct soap *soap, struct ns1__varianceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__varianceResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__nucleotide_USCOREperiodicity(struct soap *soap, struct ns1__nucleotide_USCOREperiodicity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__nucleotide_USCOREperiodicity(struct soap *soap, const struct ns1__nucleotide_USCOREperiodicity *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__nucleotide_USCOREperiodicityInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__nucleotide_USCOREperiodicity(struct soap *soap, const char *tag, int id, const struct ns1__nucleotide_USCOREperiodicity *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__nucleotide_USCOREperiodicity), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__nucleotide_USCOREperiodicityInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__nucleotide_USCOREperiodicity * SOAP_FMAC4 soap_in_ns1__nucleotide_USCOREperiodicity(struct soap *soap, const char *tag, struct ns1__nucleotide_USCOREperiodicity *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__nucleotide_USCOREperiodicity *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__nucleotide_USCOREperiodicity, sizeof(struct ns1__nucleotide_USCOREperiodicity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__nucleotide_USCOREperiodicity(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__nucleotide_USCOREperiodicityInputParams(soap, NULL, &a->_params, "ns1:nucleotide_periodicityInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__nucleotide_USCOREperiodicity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__nucleotide_USCOREperiodicity, 0, sizeof(struct ns1__nucleotide_USCOREperiodicity), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__nucleotide_USCOREperiodicity(struct soap *soap, const struct ns1__nucleotide_USCOREperiodicity *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__nucleotide_USCOREperiodicity);
	if (soap_out_ns1__nucleotide_USCOREperiodicity(soap, tag?tag:"ns1:nucleotide_periodicity", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__nucleotide_USCOREperiodicity * SOAP_FMAC4 soap_get_ns1__nucleotide_USCOREperiodicity(struct soap *soap, struct ns1__nucleotide_USCOREperiodicity *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__nucleotide_USCOREperiodicity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__nucleotide_USCOREperiodicityResponse(struct soap *soap, struct ns1__nucleotide_USCOREperiodicityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__nucleotide_USCOREperiodicityResponse(struct soap *soap, const struct ns1__nucleotide_USCOREperiodicityResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__nucleotide_USCOREperiodicityResponse(struct soap *soap, const char *tag, int id, const struct ns1__nucleotide_USCOREperiodicityResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__nucleotide_USCOREperiodicityResponse * SOAP_FMAC4 soap_in_ns1__nucleotide_USCOREperiodicityResponse(struct soap *soap, const char *tag, struct ns1__nucleotide_USCOREperiodicityResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__nucleotide_USCOREperiodicityResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse, sizeof(struct ns1__nucleotide_USCOREperiodicityResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__nucleotide_USCOREperiodicityResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__nucleotide_USCOREperiodicityResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse, 0, sizeof(struct ns1__nucleotide_USCOREperiodicityResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__nucleotide_USCOREperiodicityResponse(struct soap *soap, const struct ns1__nucleotide_USCOREperiodicityResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__nucleotide_USCOREperiodicityResponse);
	if (soap_out_ns1__nucleotide_USCOREperiodicityResponse(soap, tag?tag:"ns1:nucleotide_periodicityResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__nucleotide_USCOREperiodicityResponse * SOAP_FMAC4 soap_get_ns1__nucleotide_USCOREperiodicityResponse(struct soap *soap, struct ns1__nucleotide_USCOREperiodicityResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__nucleotide_USCOREperiodicityResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sum(struct soap *soap, struct ns1__sum *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sum(struct soap *soap, const struct ns1__sum *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sum(struct soap *soap, const char *tag, int id, const struct ns1__sum *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sum), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sum * SOAP_FMAC4 soap_in_ns1__sum(struct soap *soap, const char *tag, struct ns1__sum *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sum *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sum, sizeof(struct ns1__sum), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sum(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sum *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sum, 0, sizeof(struct ns1__sum), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sum(struct soap *soap, const struct ns1__sum *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sum);
	if (soap_out_ns1__sum(soap, tag?tag:"ns1:sum", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sum * SOAP_FMAC4 soap_get_ns1__sum(struct soap *soap, struct ns1__sum *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sum(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sumResponse(struct soap *soap, struct ns1__sumResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sumResponse(struct soap *soap, const struct ns1__sumResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sumResponse(struct soap *soap, const char *tag, int id, const struct ns1__sumResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sumResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sumResponse * SOAP_FMAC4 soap_in_ns1__sumResponse(struct soap *soap, const char *tag, struct ns1__sumResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sumResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sumResponse, sizeof(struct ns1__sumResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sumResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sumResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sumResponse, 0, sizeof(struct ns1__sumResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sumResponse(struct soap *soap, const struct ns1__sumResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sumResponse);
	if (soap_out_ns1__sumResponse(soap, tag?tag:"ns1:sumResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sumResponse * SOAP_FMAC4 soap_get_ns1__sumResponse(struct soap *soap, struct ns1__sumResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sumResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__plasmid_USCOREmap(struct soap *soap, struct ns1__plasmid_USCOREmap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__plasmid_USCOREmap(struct soap *soap, const struct ns1__plasmid_USCOREmap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__plasmid_USCOREmapInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__plasmid_USCOREmap(struct soap *soap, const char *tag, int id, const struct ns1__plasmid_USCOREmap *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__plasmid_USCOREmap), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__plasmid_USCOREmapInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__plasmid_USCOREmap * SOAP_FMAC4 soap_in_ns1__plasmid_USCOREmap(struct soap *soap, const char *tag, struct ns1__plasmid_USCOREmap *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__plasmid_USCOREmap *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__plasmid_USCOREmap, sizeof(struct ns1__plasmid_USCOREmap), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__plasmid_USCOREmap(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__plasmid_USCOREmapInputParams(soap, NULL, &a->_params, "ns1:plasmid_mapInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__plasmid_USCOREmap *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__plasmid_USCOREmap, 0, sizeof(struct ns1__plasmid_USCOREmap), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__plasmid_USCOREmap(struct soap *soap, const struct ns1__plasmid_USCOREmap *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__plasmid_USCOREmap);
	if (soap_out_ns1__plasmid_USCOREmap(soap, tag?tag:"ns1:plasmid_map", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__plasmid_USCOREmap * SOAP_FMAC4 soap_get_ns1__plasmid_USCOREmap(struct soap *soap, struct ns1__plasmid_USCOREmap *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__plasmid_USCOREmap(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__plasmid_USCOREmapResponse(struct soap *soap, struct ns1__plasmid_USCOREmapResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__plasmid_USCOREmapResponse(struct soap *soap, const struct ns1__plasmid_USCOREmapResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__plasmid_USCOREmapResponse(struct soap *soap, const char *tag, int id, const struct ns1__plasmid_USCOREmapResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__plasmid_USCOREmapResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__plasmid_USCOREmapResponse * SOAP_FMAC4 soap_in_ns1__plasmid_USCOREmapResponse(struct soap *soap, const char *tag, struct ns1__plasmid_USCOREmapResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__plasmid_USCOREmapResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__plasmid_USCOREmapResponse, sizeof(struct ns1__plasmid_USCOREmapResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__plasmid_USCOREmapResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__plasmid_USCOREmapResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__plasmid_USCOREmapResponse, 0, sizeof(struct ns1__plasmid_USCOREmapResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__plasmid_USCOREmapResponse(struct soap *soap, const struct ns1__plasmid_USCOREmapResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__plasmid_USCOREmapResponse);
	if (soap_out_ns1__plasmid_USCOREmapResponse(soap, tag?tag:"ns1:plasmid_mapResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__plasmid_USCOREmapResponse * SOAP_FMAC4 soap_get_ns1__plasmid_USCOREmapResponse(struct soap *soap, struct ns1__plasmid_USCOREmapResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__plasmid_USCOREmapResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREori_USCOREter(struct soap *soap, struct ns1__find_USCOREori_USCOREter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREori_USCOREter(struct soap *soap, const struct ns1__find_USCOREori_USCOREter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__find_USCOREori_USCOREterInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREori_USCOREter(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREori_USCOREter *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREori_USCOREter), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__find_USCOREori_USCOREterInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREori_USCOREter * SOAP_FMAC4 soap_in_ns1__find_USCOREori_USCOREter(struct soap *soap, const char *tag, struct ns1__find_USCOREori_USCOREter *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREori_USCOREter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREori_USCOREter, sizeof(struct ns1__find_USCOREori_USCOREter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREori_USCOREter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__find_USCOREori_USCOREterInputParams(soap, NULL, &a->_params, "ns1:find_ori_terInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREori_USCOREter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREori_USCOREter, 0, sizeof(struct ns1__find_USCOREori_USCOREter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREori_USCOREter(struct soap *soap, const struct ns1__find_USCOREori_USCOREter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREori_USCOREter);
	if (soap_out_ns1__find_USCOREori_USCOREter(soap, tag?tag:"ns1:find_ori_ter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREori_USCOREter * SOAP_FMAC4 soap_get_ns1__find_USCOREori_USCOREter(struct soap *soap, struct ns1__find_USCOREori_USCOREter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREori_USCOREter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREori_USCOREterResponse(struct soap *soap, struct ns1__find_USCOREori_USCOREterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREori_USCOREterResponse(struct soap *soap, const struct ns1__find_USCOREori_USCOREterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREori_USCOREterResponse(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREori_USCOREterResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREori_USCOREterResponse * SOAP_FMAC4 soap_in_ns1__find_USCOREori_USCOREterResponse(struct soap *soap, const char *tag, struct ns1__find_USCOREori_USCOREterResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREori_USCOREterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse, sizeof(struct ns1__find_USCOREori_USCOREterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREori_USCOREterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREori_USCOREterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse, 0, sizeof(struct ns1__find_USCOREori_USCOREterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREori_USCOREterResponse(struct soap *soap, const struct ns1__find_USCOREori_USCOREterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREori_USCOREterResponse);
	if (soap_out_ns1__find_USCOREori_USCOREterResponse(soap, tag?tag:"ns1:find_ori_terResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREori_USCOREterResponse * SOAP_FMAC4 soap_get_ns1__find_USCOREori_USCOREterResponse(struct soap *soap, struct ns1__find_USCOREori_USCOREterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREori_USCOREterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__median(struct soap *soap, struct ns1__median *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_array = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__median(struct soap *soap, const struct ns1__median *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToarrayIn(soap, &a->_array);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__median(struct soap *soap, const char *tag, int id, const struct ns1__median *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__median), type))
		return soap->error;
	if (soap_out_PointerToarrayIn(soap, "array", -1, &a->_array, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__median * SOAP_FMAC4 soap_in_ns1__median(struct soap *soap, const char *tag, struct ns1__median *a, const char *type)
{
	size_t soap_flag__array = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__median *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__median, sizeof(struct ns1__median), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__median(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__array && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToarrayIn(soap, NULL, &a->_array, "xsd:string"))
				{	soap_flag__array--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__median *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__median, 0, sizeof(struct ns1__median), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__median(struct soap *soap, const struct ns1__median *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__median);
	if (soap_out_ns1__median(soap, tag?tag:"ns1:median", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__median * SOAP_FMAC4 soap_get_ns1__median(struct soap *soap, struct ns1__median *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__median(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__medianResponse(struct soap *soap, struct ns1__medianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__medianResponse(struct soap *soap, const struct ns1__medianResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__medianResponse(struct soap *soap, const char *tag, int id, const struct ns1__medianResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__medianResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__medianResponse * SOAP_FMAC4 soap_in_ns1__medianResponse(struct soap *soap, const char *tag, struct ns1__medianResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__medianResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__medianResponse, sizeof(struct ns1__medianResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__medianResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__medianResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__medianResponse, 0, sizeof(struct ns1__medianResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__medianResponse(struct soap *soap, const struct ns1__medianResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__medianResponse);
	if (soap_out_ns1__medianResponse(soap, tag?tag:"ns1:medianResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__medianResponse * SOAP_FMAC4 soap_get_ns1__medianResponse(struct soap *soap, struct ns1__medianResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__medianResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__splitprintseq(struct soap *soap, struct ns1__splitprintseq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__splitprintseq(struct soap *soap, const struct ns1__splitprintseq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__splitprintseq(struct soap *soap, const char *tag, int id, const struct ns1__splitprintseq *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__splitprintseq), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__splitprintseq * SOAP_FMAC4 soap_in_ns1__splitprintseq(struct soap *soap, const char *tag, struct ns1__splitprintseq *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__splitprintseq *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__splitprintseq, sizeof(struct ns1__splitprintseq), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__splitprintseq(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__splitprintseq *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__splitprintseq, 0, sizeof(struct ns1__splitprintseq), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__splitprintseq(struct soap *soap, const struct ns1__splitprintseq *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__splitprintseq);
	if (soap_out_ns1__splitprintseq(soap, tag?tag:"ns1:splitprintseq", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__splitprintseq * SOAP_FMAC4 soap_get_ns1__splitprintseq(struct soap *soap, struct ns1__splitprintseq *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__splitprintseq(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__splitprintseqResponse(struct soap *soap, struct ns1__splitprintseqResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__splitprintseqResponse(struct soap *soap, const struct ns1__splitprintseqResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__splitprintseqResponse(struct soap *soap, const char *tag, int id, const struct ns1__splitprintseqResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__splitprintseqResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__splitprintseqResponse * SOAP_FMAC4 soap_in_ns1__splitprintseqResponse(struct soap *soap, const char *tag, struct ns1__splitprintseqResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__splitprintseqResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__splitprintseqResponse, sizeof(struct ns1__splitprintseqResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__splitprintseqResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__splitprintseqResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__splitprintseqResponse, 0, sizeof(struct ns1__splitprintseqResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__splitprintseqResponse(struct soap *soap, const struct ns1__splitprintseqResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__splitprintseqResponse);
	if (soap_out_ns1__splitprintseqResponse(soap, tag?tag:"ns1:splitprintseqResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__splitprintseqResponse * SOAP_FMAC4 soap_get_ns1__splitprintseqResponse(struct soap *soap, struct ns1__splitprintseqResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__splitprintseqResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__w_USCOREvalue(struct soap *soap, struct ns1__w_USCOREvalue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__w_USCOREvalue(struct soap *soap, const struct ns1__w_USCOREvalue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__w_USCOREvalueInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__w_USCOREvalue(struct soap *soap, const char *tag, int id, const struct ns1__w_USCOREvalue *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__w_USCOREvalue), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__w_USCOREvalueInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__w_USCOREvalue * SOAP_FMAC4 soap_in_ns1__w_USCOREvalue(struct soap *soap, const char *tag, struct ns1__w_USCOREvalue *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__w_USCOREvalue *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__w_USCOREvalue, sizeof(struct ns1__w_USCOREvalue), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__w_USCOREvalue(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__w_USCOREvalueInputParams(soap, NULL, &a->_params, "ns1:w_valueInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__w_USCOREvalue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__w_USCOREvalue, 0, sizeof(struct ns1__w_USCOREvalue), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__w_USCOREvalue(struct soap *soap, const struct ns1__w_USCOREvalue *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__w_USCOREvalue);
	if (soap_out_ns1__w_USCOREvalue(soap, tag?tag:"ns1:w_value", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__w_USCOREvalue * SOAP_FMAC4 soap_get_ns1__w_USCOREvalue(struct soap *soap, struct ns1__w_USCOREvalue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__w_USCOREvalue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__w_USCOREvalueResponse(struct soap *soap, struct ns1__w_USCOREvalueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__w_USCOREvalueResponse(struct soap *soap, const struct ns1__w_USCOREvalueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__w_USCOREvalueResponse(struct soap *soap, const char *tag, int id, const struct ns1__w_USCOREvalueResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__w_USCOREvalueResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__w_USCOREvalueResponse * SOAP_FMAC4 soap_in_ns1__w_USCOREvalueResponse(struct soap *soap, const char *tag, struct ns1__w_USCOREvalueResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__w_USCOREvalueResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__w_USCOREvalueResponse, sizeof(struct ns1__w_USCOREvalueResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__w_USCOREvalueResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__w_USCOREvalueResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__w_USCOREvalueResponse, 0, sizeof(struct ns1__w_USCOREvalueResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__w_USCOREvalueResponse(struct soap *soap, const struct ns1__w_USCOREvalueResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__w_USCOREvalueResponse);
	if (soap_out_ns1__w_USCOREvalueResponse(soap, tag?tag:"ns1:w_valueResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__w_USCOREvalueResponse * SOAP_FMAC4 soap_get_ns1__w_USCOREvalueResponse(struct soap *soap, struct ns1__w_USCOREvalueResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__w_USCOREvalueResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__P2(struct soap *soap, struct ns1__P2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__P2(struct soap *soap, const struct ns1__P2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__P2InputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__P2(struct soap *soap, const char *tag, int id, const struct ns1__P2 *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__P2), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__P2InputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__P2 * SOAP_FMAC4 soap_in_ns1__P2(struct soap *soap, const char *tag, struct ns1__P2 *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__P2 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__P2, sizeof(struct ns1__P2), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__P2(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__P2InputParams(soap, NULL, &a->_params, "ns1:P2InputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__P2 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__P2, 0, sizeof(struct ns1__P2), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__P2(struct soap *soap, const struct ns1__P2 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__P2);
	if (soap_out_ns1__P2(soap, tag?tag:"ns1:P2", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__P2 * SOAP_FMAC4 soap_get_ns1__P2(struct soap *soap, struct ns1__P2 *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__P2(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__P2Response(struct soap *soap, struct ns1__P2Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__P2Response(struct soap *soap, const struct ns1__P2Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__P2Response(struct soap *soap, const char *tag, int id, const struct ns1__P2Response *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__P2Response), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__P2Response * SOAP_FMAC4 soap_in_ns1__P2Response(struct soap *soap, const char *tag, struct ns1__P2Response *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__P2Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__P2Response, sizeof(struct ns1__P2Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__P2Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__P2Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__P2Response, 0, sizeof(struct ns1__P2Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__P2Response(struct soap *soap, const struct ns1__P2Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__P2Response);
	if (soap_out_ns1__P2Response(soap, tag?tag:"ns1:P2Response", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__P2Response * SOAP_FMAC4 soap_get_ns1__P2Response(struct soap *soap, struct ns1__P2Response *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__P2Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREmva(struct soap *soap, struct ns1__codon_USCOREmva *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_sequence);
	a->_params = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREmva(struct soap *soap, const struct ns1__codon_USCOREmva *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_sequence);
	soap_serialize_PointerTons1__codon_USCOREmvaInputParams(soap, &a->_params);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREmva(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREmva *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREmva), type))
		return soap->error;
	if (soap_out_string(soap, "sequence", -1, &a->_sequence, ""))
		return soap->error;
	if (soap_out_PointerTons1__codon_USCOREmvaInputParams(soap, "params", -1, &a->_params, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREmva * SOAP_FMAC4 soap_in_ns1__codon_USCOREmva(struct soap *soap, const char *tag, struct ns1__codon_USCOREmva *a, const char *type)
{
	size_t soap_flag__sequence = 1;
	size_t soap_flag__params = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREmva *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREmva, sizeof(struct ns1__codon_USCOREmva), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREmva(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__sequence && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_sequence, "xsd:string"))
				{	soap_flag__sequence--;
					continue;
				}
			if (soap_flag__params && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__codon_USCOREmvaInputParams(soap, NULL, &a->_params, "ns1:codon_mvaInputParams"))
				{	soap_flag__params--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREmva *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREmva, 0, sizeof(struct ns1__codon_USCOREmva), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREmva(struct soap *soap, const struct ns1__codon_USCOREmva *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREmva);
	if (soap_out_ns1__codon_USCOREmva(soap, tag?tag:"ns1:codon_mva", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREmva * SOAP_FMAC4 soap_get_ns1__codon_USCOREmva(struct soap *soap, struct ns1__codon_USCOREmva *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREmva(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREmvaResponse(struct soap *soap, struct ns1__codon_USCOREmvaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREmvaResponse(struct soap *soap, const struct ns1__codon_USCOREmvaResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTostring(soap, &a->_result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREmvaResponse(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREmvaResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREmvaResponse), type))
		return soap->error;
	if (soap_out_PointerTostring(soap, "result", -1, &a->_result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREmvaResponse * SOAP_FMAC4 soap_in_ns1__codon_USCOREmvaResponse(struct soap *soap, const char *tag, struct ns1__codon_USCOREmvaResponse *a, const char *type)
{
	size_t soap_flag__result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREmvaResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREmvaResponse, sizeof(struct ns1__codon_USCOREmvaResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREmvaResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTostring(soap, NULL, &a->_result, "xsd:string"))
				{	soap_flag__result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREmvaResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREmvaResponse, 0, sizeof(struct ns1__codon_USCOREmvaResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREmvaResponse(struct soap *soap, const struct ns1__codon_USCOREmvaResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREmvaResponse);
	if (soap_out_ns1__codon_USCOREmvaResponse(soap, tag?tag:"ns1:codon_mvaResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREmvaResponse * SOAP_FMAC4 soap_get_ns1__codon_USCOREmvaResponse(struct soap *soap, struct ns1__codon_USCOREmvaResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREmvaResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_arrayOut(struct soap *soap, struct arrayOut *a)
{	(void)soap;
	(void)soap; /* appease -Wall -Werror */
	a->__size = 0;
	a->__ptr = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_arrayOut(struct soap *soap, struct arrayOut const*a)
{
	int i;
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_arrayOut))
		for (i = 0; i < a->__size; i++)
		{
			soap_serialize_string(soap, a->__ptr + i);
		}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_arrayOut(struct soap *soap, const char *tag, int id, const struct arrayOut *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "xsd:string", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_arrayOut);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_string(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct arrayOut * SOAP_FMAC4 soap_in_arrayOut(struct soap *soap, const char *tag, struct arrayOut *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct arrayOut *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_arrayOut, sizeof(struct arrayOut), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_arrayOut(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_string(soap, NULL, a->__ptr + i, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, NULL, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_string(soap, NULL, p, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct arrayOut *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_arrayOut, 0, sizeof(struct arrayOut), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_arrayOut(struct soap *soap, const struct arrayOut *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_arrayOut);
	if (soap_out_arrayOut(soap, tag?tag:"SOAP-ENC:Array", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct arrayOut * SOAP_FMAC4 soap_get_arrayOut(struct soap *soap, struct arrayOut *p, const char *tag, const char *type)
{
	if ((p = soap_in_arrayOut(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_arrayIn(struct soap *soap, struct arrayIn *a)
{	(void)soap;
	(void)soap; /* appease -Wall -Werror */
	a->__size = 0;
	a->__ptr = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_arrayIn(struct soap *soap, struct arrayIn const*a)
{
	int i;
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_arrayIn))
		for (i = 0; i < a->__size; i++)
		{
			soap_serialize_string(soap, a->__ptr + i);
		}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_arrayIn(struct soap *soap, const char *tag, int id, const struct arrayIn *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "xsd:string", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_arrayIn);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_string(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct arrayIn * SOAP_FMAC4 soap_in_arrayIn(struct soap *soap, const char *tag, struct arrayIn *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct arrayIn *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_arrayIn, sizeof(struct arrayIn), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_arrayIn(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_string(soap, NULL, a->__ptr + i, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, NULL, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_string(soap, NULL, p, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct arrayIn *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_arrayIn, 0, sizeof(struct arrayIn), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_arrayIn(struct soap *soap, const struct arrayIn *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_arrayIn);
	if (soap_out_arrayIn(soap, tag?tag:"SOAP-ENC:Array", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct arrayIn * SOAP_FMAC4 soap_get_arrayIn(struct soap *soap, struct arrayIn *p, const char *tag, const char *type)
{
	if ((p = soap_in_arrayIn(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__S_USCOREvalueInputParams(struct soap *soap, struct ns1__S_USCOREvalueInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->sharp);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__S_USCOREvalueInputParams(struct soap *soap, const struct ns1__S_USCOREvalueInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__S_USCOREvalueInputParams(struct soap *soap, const char *tag, int id, const struct ns1__S_USCOREvalueInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__S_USCOREvalueInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "sharp", -1, &a->sharp, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__S_USCOREvalueInputParams * SOAP_FMAC4 soap_in_ns1__S_USCOREvalueInputParams(struct soap *soap, const char *tag, struct ns1__S_USCOREvalueInputParams *a, const char *type)
{
	size_t soap_flag_sharp = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__S_USCOREvalueInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__S_USCOREvalueInputParams, sizeof(struct ns1__S_USCOREvalueInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__S_USCOREvalueInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_sharp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "sharp", &a->sharp, "xsd:int"))
				{	soap_flag_sharp--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__S_USCOREvalueInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__S_USCOREvalueInputParams, 0, sizeof(struct ns1__S_USCOREvalueInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_sharp > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__S_USCOREvalueInputParams(struct soap *soap, const struct ns1__S_USCOREvalueInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__S_USCOREvalueInputParams);
	if (soap_out_ns1__S_USCOREvalueInputParams(soap, tag?tag:"ns1:S_valueInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__S_USCOREvalueInputParams * SOAP_FMAC4 soap_get_ns1__S_USCOREvalueInputParams(struct soap *soap, struct ns1__S_USCOREvalueInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__S_USCOREvalueInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__scsInputParams(struct soap *soap, struct ns1__scsInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->id);
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->del_USCOREkey);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__scsInputParams(struct soap *soap, const struct ns1__scsInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->id);
	soap_serialize_string(soap, &a->del_USCOREkey);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__scsInputParams(struct soap *soap, const char *tag, int id, const struct ns1__scsInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__scsInputParams), type))
		return soap->error;
	if (a->id)
	{	if (soap_out_string(soap, "id", -1, &a->id, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "id"))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__scsInputParams * SOAP_FMAC4 soap_in_ns1__scsInputParams(struct soap *soap, const char *tag, struct ns1__scsInputParams *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_translate = 1;
	size_t soap_flag_del_USCOREkey = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__scsInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__scsInputParams, sizeof(struct ns1__scsInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__scsInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &a->id, "xsd:string"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__scsInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__scsInputParams, 0, sizeof(struct ns1__scsInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id > 0 || soap_flag_translate > 0 || soap_flag_del_USCOREkey > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__scsInputParams(struct soap *soap, const struct ns1__scsInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__scsInputParams);
	if (soap_out_ns1__scsInputParams(soap, tag?tag:"ns1:scsInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__scsInputParams * SOAP_FMAC4 soap_get_ns1__scsInputParams(struct soap *soap, struct ns1__scsInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__scsInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__signatureInputParams(struct soap *soap, struct ns1__signatureInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->wordlength);
	soap_default_int(soap, &a->bothstrand);
	soap_default_int(soap, &a->oe);
	soap_default_string(soap, &a->seq);
	soap_default_string(soap, &a->memo);
	soap_default_int(soap, &a->header);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__signatureInputParams(struct soap *soap, const struct ns1__signatureInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->seq);
	soap_serialize_string(soap, &a->memo);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__signatureInputParams(struct soap *soap, const char *tag, int id, const struct ns1__signatureInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__signatureInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "wordlength", -1, &a->wordlength, ""))
		return soap->error;
	if (soap_out_int(soap, "bothstrand", -1, &a->bothstrand, ""))
		return soap->error;
	if (soap_out_int(soap, "oe", -1, &a->oe, ""))
		return soap->error;
	if (a->seq)
	{	if (soap_out_string(soap, "seq", -1, &a->seq, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "seq"))
		return soap->error;
	if (a->memo)
	{	if (soap_out_string(soap, "memo", -1, &a->memo, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "memo"))
		return soap->error;
	if (soap_out_int(soap, "header", -1, &a->header, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__signatureInputParams * SOAP_FMAC4 soap_in_ns1__signatureInputParams(struct soap *soap, const char *tag, struct ns1__signatureInputParams *a, const char *type)
{
	size_t soap_flag_wordlength = 1;
	size_t soap_flag_bothstrand = 1;
	size_t soap_flag_oe = 1;
	size_t soap_flag_seq = 1;
	size_t soap_flag_memo = 1;
	size_t soap_flag_header = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__signatureInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__signatureInputParams, sizeof(struct ns1__signatureInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__signatureInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wordlength && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "wordlength", &a->wordlength, "xsd:int"))
				{	soap_flag_wordlength--;
					continue;
				}
			if (soap_flag_bothstrand && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "bothstrand", &a->bothstrand, "xsd:int"))
				{	soap_flag_bothstrand--;
					continue;
				}
			if (soap_flag_oe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "oe", &a->oe, "xsd:int"))
				{	soap_flag_oe--;
					continue;
				}
			if (soap_flag_seq && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "seq", &a->seq, "xsd:string"))
				{	soap_flag_seq--;
					continue;
				}
			if (soap_flag_memo && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "memo", &a->memo, "xsd:string"))
				{	soap_flag_memo--;
					continue;
				}
			if (soap_flag_header && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "header", &a->header, "xsd:int"))
				{	soap_flag_header--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__signatureInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__signatureInputParams, 0, sizeof(struct ns1__signatureInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wordlength > 0 || soap_flag_bothstrand > 0 || soap_flag_oe > 0 || soap_flag_seq > 0 || soap_flag_memo > 0 || soap_flag_header > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__signatureInputParams(struct soap *soap, const struct ns1__signatureInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__signatureInputParams);
	if (soap_out_ns1__signatureInputParams(soap, tag?tag:"ns1:signatureInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__signatureInputParams * SOAP_FMAC4 soap_get_ns1__signatureInputParams(struct soap *soap, struct ns1__signatureInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__signatureInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__lda_USCOREbiasInputParams(struct soap *soap, struct ns1__lda_USCOREbiasInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->variable);
	soap_default_int(soap, &a->coefficients);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__lda_USCOREbiasInputParams(struct soap *soap, const struct ns1__lda_USCOREbiasInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->variable);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__lda_USCOREbiasInputParams(struct soap *soap, const char *tag, int id, const struct ns1__lda_USCOREbiasInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__lda_USCOREbiasInputParams), type))
		return soap->error;
	if (a->variable)
	{	if (soap_out_string(soap, "variable", -1, &a->variable, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "variable"))
		return soap->error;
	if (soap_out_int(soap, "coefficients", -1, &a->coefficients, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__lda_USCOREbiasInputParams * SOAP_FMAC4 soap_in_ns1__lda_USCOREbiasInputParams(struct soap *soap, const char *tag, struct ns1__lda_USCOREbiasInputParams *a, const char *type)
{
	size_t soap_flag_variable = 1;
	size_t soap_flag_coefficients = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__lda_USCOREbiasInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__lda_USCOREbiasInputParams, sizeof(struct ns1__lda_USCOREbiasInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__lda_USCOREbiasInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_variable && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "variable", &a->variable, "xsd:string"))
				{	soap_flag_variable--;
					continue;
				}
			if (soap_flag_coefficients && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "coefficients", &a->coefficients, "xsd:int"))
				{	soap_flag_coefficients--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__lda_USCOREbiasInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__lda_USCOREbiasInputParams, 0, sizeof(struct ns1__lda_USCOREbiasInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_variable > 0 || soap_flag_coefficients > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__lda_USCOREbiasInputParams(struct soap *soap, const struct ns1__lda_USCOREbiasInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__lda_USCOREbiasInputParams);
	if (soap_out_ns1__lda_USCOREbiasInputParams(soap, tag?tag:"ns1:lda_biasInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__lda_USCOREbiasInputParams * SOAP_FMAC4 soap_get_ns1__lda_USCOREbiasInputParams(struct soap *soap, struct ns1__lda_USCOREbiasInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__lda_USCOREbiasInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__kmer_USCOREtableInputParams(struct soap *soap, struct ns1__kmer_USCOREtableInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->k);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__kmer_USCOREtableInputParams(struct soap *soap, const struct ns1__kmer_USCOREtableInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__kmer_USCOREtableInputParams(struct soap *soap, const char *tag, int id, const struct ns1__kmer_USCOREtableInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__kmer_USCOREtableInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "k", -1, &a->k, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__kmer_USCOREtableInputParams * SOAP_FMAC4 soap_in_ns1__kmer_USCOREtableInputParams(struct soap *soap, const char *tag, struct ns1__kmer_USCOREtableInputParams *a, const char *type)
{
	size_t soap_flag_k = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__kmer_USCOREtableInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__kmer_USCOREtableInputParams, sizeof(struct ns1__kmer_USCOREtableInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__kmer_USCOREtableInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_k && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "k", &a->k, "xsd:int"))
				{	soap_flag_k--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__kmer_USCOREtableInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__kmer_USCOREtableInputParams, 0, sizeof(struct ns1__kmer_USCOREtableInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_k > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__kmer_USCOREtableInputParams(struct soap *soap, const struct ns1__kmer_USCOREtableInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__kmer_USCOREtableInputParams);
	if (soap_out_ns1__kmer_USCOREtableInputParams(soap, tag?tag:"ns1:kmer_tableInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__kmer_USCOREtableInputParams * SOAP_FMAC4 soap_get_ns1__kmer_USCOREtableInputParams(struct soap *soap, struct ns1__kmer_USCOREtableInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__kmer_USCOREtableInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREz_USCOREvalueInputParams(struct soap *soap, struct ns1__base_USCOREz_USCOREvalueInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->limit);
	soap_default_string(soap, &a->position);
	soap_default_int(soap, &a->PatLen);
	soap_default_int(soap, &a->upstream);
	soap_default_int(soap, &a->downstream);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREz_USCOREvalueInputParams(struct soap *soap, const struct ns1__base_USCOREz_USCOREvalueInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->position);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREz_USCOREvalueInputParams(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREz_USCOREvalueInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "limit", -1, &a->limit, ""))
		return soap->error;
	if (a->position)
	{	if (soap_out_string(soap, "position", -1, &a->position, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "position"))
		return soap->error;
	if (soap_out_int(soap, "PatLen", -1, &a->PatLen, ""))
		return soap->error;
	if (soap_out_int(soap, "upstream", -1, &a->upstream, ""))
		return soap->error;
	if (soap_out_int(soap, "downstream", -1, &a->downstream, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREz_USCOREvalueInputParams * SOAP_FMAC4 soap_in_ns1__base_USCOREz_USCOREvalueInputParams(struct soap *soap, const char *tag, struct ns1__base_USCOREz_USCOREvalueInputParams *a, const char *type)
{
	size_t soap_flag_limit = 1;
	size_t soap_flag_position = 1;
	size_t soap_flag_PatLen = 1;
	size_t soap_flag_upstream = 1;
	size_t soap_flag_downstream = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREz_USCOREvalueInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams, sizeof(struct ns1__base_USCOREz_USCOREvalueInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREz_USCOREvalueInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_limit && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "limit", &a->limit, "xsd:int"))
				{	soap_flag_limit--;
					continue;
				}
			if (soap_flag_position && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "position", &a->position, "xsd:string"))
				{	soap_flag_position--;
					continue;
				}
			if (soap_flag_PatLen && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "PatLen", &a->PatLen, "xsd:int"))
				{	soap_flag_PatLen--;
					continue;
				}
			if (soap_flag_upstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "upstream", &a->upstream, "xsd:int"))
				{	soap_flag_upstream--;
					continue;
				}
			if (soap_flag_downstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "downstream", &a->downstream, "xsd:int"))
				{	soap_flag_downstream--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREz_USCOREvalueInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams, 0, sizeof(struct ns1__base_USCOREz_USCOREvalueInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_limit > 0 || soap_flag_position > 0 || soap_flag_PatLen > 0 || soap_flag_upstream > 0 || soap_flag_downstream > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREz_USCOREvalueInputParams(struct soap *soap, const struct ns1__base_USCOREz_USCOREvalueInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREz_USCOREvalueInputParams);
	if (soap_out_ns1__base_USCOREz_USCOREvalueInputParams(soap, tag?tag:"ns1:base_z_valueInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREz_USCOREvalueInputParams * SOAP_FMAC4 soap_get_ns1__base_USCOREz_USCOREvalueInputParams(struct soap *soap, struct ns1__base_USCOREz_USCOREvalueInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREz_USCOREvalueInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREcounterInputParams(struct soap *soap, struct ns1__base_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->position);
	soap_default_int(soap, &a->PatLen);
	soap_default_int(soap, &a->upstream);
	soap_default_int(soap, &a->downstream);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREcounterInputParams(struct soap *soap, const struct ns1__base_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->position);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREcounterInputParams(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREcounterInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREcounterInputParams), type))
		return soap->error;
	if (a->position)
	{	if (soap_out_string(soap, "position", -1, &a->position, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "position"))
		return soap->error;
	if (soap_out_int(soap, "PatLen", -1, &a->PatLen, ""))
		return soap->error;
	if (soap_out_int(soap, "upstream", -1, &a->upstream, ""))
		return soap->error;
	if (soap_out_int(soap, "downstream", -1, &a->downstream, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREcounterInputParams * SOAP_FMAC4 soap_in_ns1__base_USCOREcounterInputParams(struct soap *soap, const char *tag, struct ns1__base_USCOREcounterInputParams *a, const char *type)
{
	size_t soap_flag_position = 1;
	size_t soap_flag_PatLen = 1;
	size_t soap_flag_upstream = 1;
	size_t soap_flag_downstream = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREcounterInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREcounterInputParams, sizeof(struct ns1__base_USCOREcounterInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREcounterInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_position && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "position", &a->position, "xsd:string"))
				{	soap_flag_position--;
					continue;
				}
			if (soap_flag_PatLen && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "PatLen", &a->PatLen, "xsd:int"))
				{	soap_flag_PatLen--;
					continue;
				}
			if (soap_flag_upstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "upstream", &a->upstream, "xsd:int"))
				{	soap_flag_upstream--;
					continue;
				}
			if (soap_flag_downstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "downstream", &a->downstream, "xsd:int"))
				{	soap_flag_downstream--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREcounterInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREcounterInputParams, 0, sizeof(struct ns1__base_USCOREcounterInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_position > 0 || soap_flag_PatLen > 0 || soap_flag_upstream > 0 || soap_flag_downstream > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREcounterInputParams(struct soap *soap, const struct ns1__base_USCOREcounterInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREcounterInputParams);
	if (soap_out_ns1__base_USCOREcounterInputParams(soap, tag?tag:"ns1:base_counterInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREcounterInputParams * SOAP_FMAC4 soap_get_ns1__base_USCOREcounterInputParams(struct soap *soap, struct ns1__base_USCOREcounterInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREcounterInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__B1InputParams(struct soap *soap, struct ns1__B1InputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->method);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__B1InputParams(struct soap *soap, const struct ns1__B1InputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->method);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__B1InputParams(struct soap *soap, const char *tag, int id, const struct ns1__B1InputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__B1InputParams), type))
		return soap->error;
	if (a->method)
	{	if (soap_out_string(soap, "method", -1, &a->method, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "method"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__B1InputParams * SOAP_FMAC4 soap_in_ns1__B1InputParams(struct soap *soap, const char *tag, struct ns1__B1InputParams *a, const char *type)
{
	size_t soap_flag_method = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__B1InputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__B1InputParams, sizeof(struct ns1__B1InputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__B1InputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_method && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "method", &a->method, "xsd:string"))
				{	soap_flag_method--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__B1InputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__B1InputParams, 0, sizeof(struct ns1__B1InputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_method > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__B1InputParams(struct soap *soap, const struct ns1__B1InputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__B1InputParams);
	if (soap_out_ns1__B1InputParams(soap, tag?tag:"ns1:B1InputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__B1InputParams * SOAP_FMAC4 soap_get_ns1__B1InputParams(struct soap *soap, struct ns1__B1InputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__B1InputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__cgrInputParams(struct soap *soap, struct ns1__cgrInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->width);
	soap_default_int(soap, &a->level);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__cgrInputParams(struct soap *soap, const struct ns1__cgrInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__cgrInputParams(struct soap *soap, const char *tag, int id, const struct ns1__cgrInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__cgrInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "width", -1, &a->width, ""))
		return soap->error;
	if (soap_out_int(soap, "level", -1, &a->level, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__cgrInputParams * SOAP_FMAC4 soap_in_ns1__cgrInputParams(struct soap *soap, const char *tag, struct ns1__cgrInputParams *a, const char *type)
{
	size_t soap_flag_width = 1;
	size_t soap_flag_level = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__cgrInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__cgrInputParams, sizeof(struct ns1__cgrInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__cgrInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_width && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "width", &a->width, "xsd:int"))
				{	soap_flag_width--;
					continue;
				}
			if (soap_flag_level && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "level", &a->level, "xsd:int"))
				{	soap_flag_level--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__cgrInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__cgrInputParams, 0, sizeof(struct ns1__cgrInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_width > 0 || soap_flag_level > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__cgrInputParams(struct soap *soap, const struct ns1__cgrInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__cgrInputParams);
	if (soap_out_ns1__cgrInputParams(soap, tag?tag:"ns1:cgrInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__cgrInputParams * SOAP_FMAC4 soap_get_ns1__cgrInputParams(struct soap *soap, struct ns1__cgrInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__cgrInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dinucInputParams(struct soap *soap, struct ns1__dinucInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->position);
	soap_default_string(soap, &a->id);
	soap_default_string(soap, &a->output);
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->del_USCOREkey);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dinucInputParams(struct soap *soap, const struct ns1__dinucInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->position);
	soap_serialize_string(soap, &a->id);
	soap_serialize_string(soap, &a->output);
	soap_serialize_string(soap, &a->del_USCOREkey);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dinucInputParams(struct soap *soap, const char *tag, int id, const struct ns1__dinucInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dinucInputParams), type))
		return soap->error;
	if (a->position)
	{	if (soap_out_string(soap, "position", -1, &a->position, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "position"))
		return soap->error;
	if (a->id)
	{	if (soap_out_string(soap, "id", -1, &a->id, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "id"))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dinucInputParams * SOAP_FMAC4 soap_in_ns1__dinucInputParams(struct soap *soap, const char *tag, struct ns1__dinucInputParams *a, const char *type)
{
	size_t soap_flag_position = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_translate = 1;
	size_t soap_flag_del_USCOREkey = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dinucInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dinucInputParams, sizeof(struct ns1__dinucInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dinucInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_position && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "position", &a->position, "xsd:string"))
				{	soap_flag_position--;
					continue;
				}
			if (soap_flag_id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &a->id, "xsd:string"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dinucInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dinucInputParams, 0, sizeof(struct ns1__dinucInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_position > 0 || soap_flag_id > 0 || soap_flag_output > 0 || soap_flag_translate > 0 || soap_flag_del_USCOREkey > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dinucInputParams(struct soap *soap, const struct ns1__dinucInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dinucInputParams);
	if (soap_out_ns1__dinucInputParams(soap, tag?tag:"ns1:dinucInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dinucInputParams * SOAP_FMAC4 soap_get_ns1__dinucInputParams(struct soap *soap, struct ns1__dinucInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dinucInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__caiInputParams(struct soap *soap, struct ns1__caiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->w_USCOREoutput);
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->output);
	soap_default_string(soap, &a->w_USCOREfilename);
	soap_default_string(soap, &a->w_USCOREabsent);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__caiInputParams(struct soap *soap, const struct ns1__caiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->w_USCOREoutput);
	soap_serialize_string(soap, &a->output);
	soap_serialize_string(soap, &a->w_USCOREfilename);
	soap_serialize_string(soap, &a->w_USCOREabsent);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__caiInputParams(struct soap *soap, const char *tag, int id, const struct ns1__caiInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__caiInputParams), type))
		return soap->error;
	if (a->w_USCOREoutput)
	{	if (soap_out_string(soap, "w_output", -1, &a->w_USCOREoutput, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "w_output"))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (a->w_USCOREfilename)
	{	if (soap_out_string(soap, "w_filename", -1, &a->w_USCOREfilename, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "w_filename"))
		return soap->error;
	if (a->w_USCOREabsent)
	{	if (soap_out_string(soap, "w_absent", -1, &a->w_USCOREabsent, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "w_absent"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__caiInputParams * SOAP_FMAC4 soap_in_ns1__caiInputParams(struct soap *soap, const char *tag, struct ns1__caiInputParams *a, const char *type)
{
	size_t soap_flag_w_USCOREoutput = 1;
	size_t soap_flag_translate = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_w_USCOREfilename = 1;
	size_t soap_flag_w_USCOREabsent = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__caiInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__caiInputParams, sizeof(struct ns1__caiInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__caiInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_w_USCOREoutput && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "w_output", &a->w_USCOREoutput, "xsd:string"))
				{	soap_flag_w_USCOREoutput--;
					continue;
				}
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_w_USCOREfilename && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "w_filename", &a->w_USCOREfilename, "xsd:string"))
				{	soap_flag_w_USCOREfilename--;
					continue;
				}
			if (soap_flag_w_USCOREabsent && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "w_absent", &a->w_USCOREabsent, "xsd:string"))
				{	soap_flag_w_USCOREabsent--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__caiInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__caiInputParams, 0, sizeof(struct ns1__caiInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_w_USCOREoutput > 0 || soap_flag_translate > 0 || soap_flag_output > 0 || soap_flag_w_USCOREfilename > 0 || soap_flag_w_USCOREabsent > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__caiInputParams(struct soap *soap, const struct ns1__caiInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__caiInputParams);
	if (soap_out_ns1__caiInputParams(soap, tag?tag:"ns1:caiInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__caiInputParams * SOAP_FMAC4 soap_get_ns1__caiInputParams(struct soap *soap, struct ns1__caiInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__caiInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(struct soap *soap, struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->upstream);
	soap_default_string(soap, &a->codon);
	soap_default_int(soap, &a->downstream);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(struct soap *soap, const struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->codon);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(struct soap *soap, const char *tag, int id, const struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "upstream", -1, &a->upstream, ""))
		return soap->error;
	if (a->codon)
	{	if (soap_out_string(soap, "codon", -1, &a->codon, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "codon"))
		return soap->error;
	if (soap_out_int(soap, "downstream", -1, &a->downstream, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams * SOAP_FMAC4 soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(struct soap *soap, const char *tag, struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *a, const char *type)
{
	size_t soap_flag_upstream = 1;
	size_t soap_flag_codon = 1;
	size_t soap_flag_downstream = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams, sizeof(struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_upstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "upstream", &a->upstream, "xsd:int"))
				{	soap_flag_upstream--;
					continue;
				}
			if (soap_flag_codon && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "codon", &a->codon, "xsd:string"))
				{	soap_flag_codon--;
					continue;
				}
			if (soap_flag_downstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "downstream", &a->downstream, "xsd:int"))
				{	soap_flag_downstream--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams, 0, sizeof(struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_upstream > 0 || soap_flag_codon > 0 || soap_flag_downstream > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(struct soap *soap, const struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams);
	if (soap_out_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, tag?tag:"ns1:filter_cds_by_atgInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams * SOAP_FMAC4 soap_get_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(struct soap *soap, struct ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__filter_USCOREcds_USCOREby_USCOREatgInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcsiInputParams(struct soap *soap, struct ns1__gcsiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->p);
	soap_default_int(soap, &a->window);
	soap_default_int(soap, &a->version);
	soap_default_int(soap, &a->purine);
	soap_default_int(soap, &a->at);
	soap_default_int(soap, &a->keto);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcsiInputParams(struct soap *soap, const struct ns1__gcsiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcsiInputParams(struct soap *soap, const char *tag, int id, const struct ns1__gcsiInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcsiInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "p", -1, &a->p, ""))
		return soap->error;
	if (soap_out_int(soap, "window", -1, &a->window, ""))
		return soap->error;
	if (soap_out_int(soap, "version", -1, &a->version, ""))
		return soap->error;
	if (soap_out_int(soap, "purine", -1, &a->purine, ""))
		return soap->error;
	if (soap_out_int(soap, "at", -1, &a->at, ""))
		return soap->error;
	if (soap_out_int(soap, "keto", -1, &a->keto, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcsiInputParams * SOAP_FMAC4 soap_in_ns1__gcsiInputParams(struct soap *soap, const char *tag, struct ns1__gcsiInputParams *a, const char *type)
{
	size_t soap_flag_p = 1;
	size_t soap_flag_window = 1;
	size_t soap_flag_version = 1;
	size_t soap_flag_purine = 1;
	size_t soap_flag_at = 1;
	size_t soap_flag_keto = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcsiInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcsiInputParams, sizeof(struct ns1__gcsiInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcsiInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_p && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "p", &a->p, "xsd:int"))
				{	soap_flag_p--;
					continue;
				}
			if (soap_flag_window && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "window", &a->window, "xsd:int"))
				{	soap_flag_window--;
					continue;
				}
			if (soap_flag_version && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "version", &a->version, "xsd:int"))
				{	soap_flag_version--;
					continue;
				}
			if (soap_flag_purine && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "purine", &a->purine, "xsd:int"))
				{	soap_flag_purine--;
					continue;
				}
			if (soap_flag_at && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "at", &a->at, "xsd:int"))
				{	soap_flag_at--;
					continue;
				}
			if (soap_flag_keto && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "keto", &a->keto, "xsd:int"))
				{	soap_flag_keto--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcsiInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcsiInputParams, 0, sizeof(struct ns1__gcsiInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_p > 0 || soap_flag_window > 0 || soap_flag_version > 0 || soap_flag_purine > 0 || soap_flag_at > 0 || soap_flag_keto > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcsiInputParams(struct soap *soap, const struct ns1__gcsiInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcsiInputParams);
	if (soap_out_ns1__gcsiInputParams(soap, tag?tag:"ns1:gcsiInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcsiInputParams * SOAP_FMAC4 soap_get_ns1__gcsiInputParams(struct soap *soap, struct ns1__gcsiInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcsiInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__query_USCOREstrandInputParams(struct soap *soap, struct ns1__query_USCOREstrandInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->direction);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__query_USCOREstrandInputParams(struct soap *soap, const struct ns1__query_USCOREstrandInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->direction);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__query_USCOREstrandInputParams(struct soap *soap, const char *tag, int id, const struct ns1__query_USCOREstrandInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__query_USCOREstrandInputParams), type))
		return soap->error;
	if (a->direction)
	{	if (soap_out_string(soap, "direction", -1, &a->direction, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "direction"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__query_USCOREstrandInputParams * SOAP_FMAC4 soap_in_ns1__query_USCOREstrandInputParams(struct soap *soap, const char *tag, struct ns1__query_USCOREstrandInputParams *a, const char *type)
{
	size_t soap_flag_direction = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__query_USCOREstrandInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__query_USCOREstrandInputParams, sizeof(struct ns1__query_USCOREstrandInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__query_USCOREstrandInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_direction && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "direction", &a->direction, "xsd:string"))
				{	soap_flag_direction--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__query_USCOREstrandInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__query_USCOREstrandInputParams, 0, sizeof(struct ns1__query_USCOREstrandInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_direction > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__query_USCOREstrandInputParams(struct soap *soap, const struct ns1__query_USCOREstrandInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__query_USCOREstrandInputParams);
	if (soap_out_ns1__query_USCOREstrandInputParams(soap, tag?tag:"ns1:query_strandInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__query_USCOREstrandInputParams * SOAP_FMAC4 soap_get_ns1__query_USCOREstrandInputParams(struct soap *soap, struct ns1__query_USCOREstrandInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__query_USCOREstrandInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genomicskewInputParams(struct soap *soap, struct ns1__genomicskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->divide);
	soap_default_int(soap, &a->at);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genomicskewInputParams(struct soap *soap, const struct ns1__genomicskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genomicskewInputParams(struct soap *soap, const char *tag, int id, const struct ns1__genomicskewInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genomicskewInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "divide", -1, &a->divide, ""))
		return soap->error;
	if (soap_out_int(soap, "at", -1, &a->at, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genomicskewInputParams * SOAP_FMAC4 soap_in_ns1__genomicskewInputParams(struct soap *soap, const char *tag, struct ns1__genomicskewInputParams *a, const char *type)
{
	size_t soap_flag_divide = 1;
	size_t soap_flag_at = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genomicskewInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genomicskewInputParams, sizeof(struct ns1__genomicskewInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genomicskewInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_divide && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "divide", &a->divide, "xsd:int"))
				{	soap_flag_divide--;
					continue;
				}
			if (soap_flag_at && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "at", &a->at, "xsd:int"))
				{	soap_flag_at--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genomicskewInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genomicskewInputParams, 0, sizeof(struct ns1__genomicskewInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_divide > 0 || soap_flag_at > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genomicskewInputParams(struct soap *soap, const struct ns1__genomicskewInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genomicskewInputParams);
	if (soap_out_ns1__genomicskewInputParams(soap, tag?tag:"ns1:genomicskewInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genomicskewInputParams * SOAP_FMAC4 soap_get_ns1__genomicskewInputParams(struct soap *soap, struct ns1__genomicskewInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genomicskewInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__palindromeInputParams(struct soap *soap, struct ns1__palindromeInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->gtmatch);
	soap_default_string(soap, &a->output);
	soap_default_int(soap, &a->loop);
	soap_default_int(soap, &a->shortest);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__palindromeInputParams(struct soap *soap, const struct ns1__palindromeInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__palindromeInputParams(struct soap *soap, const char *tag, int id, const struct ns1__palindromeInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__palindromeInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "gtmatch", -1, &a->gtmatch, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (soap_out_int(soap, "loop", -1, &a->loop, ""))
		return soap->error;
	if (soap_out_int(soap, "shortest", -1, &a->shortest, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__palindromeInputParams * SOAP_FMAC4 soap_in_ns1__palindromeInputParams(struct soap *soap, const char *tag, struct ns1__palindromeInputParams *a, const char *type)
{
	size_t soap_flag_gtmatch = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_loop = 1;
	size_t soap_flag_shortest = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__palindromeInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__palindromeInputParams, sizeof(struct ns1__palindromeInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__palindromeInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_gtmatch && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "gtmatch", &a->gtmatch, "xsd:int"))
				{	soap_flag_gtmatch--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_loop && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "loop", &a->loop, "xsd:int"))
				{	soap_flag_loop--;
					continue;
				}
			if (soap_flag_shortest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "shortest", &a->shortest, "xsd:int"))
				{	soap_flag_shortest--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__palindromeInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__palindromeInputParams, 0, sizeof(struct ns1__palindromeInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_gtmatch > 0 || soap_flag_output > 0 || soap_flag_loop > 0 || soap_flag_shortest > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__palindromeInputParams(struct soap *soap, const struct ns1__palindromeInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__palindromeInputParams);
	if (soap_out_ns1__palindromeInputParams(soap, tag?tag:"ns1:palindromeInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__palindromeInputParams * SOAP_FMAC4 soap_get_ns1__palindromeInputParams(struct soap *soap, struct ns1__palindromeInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__palindromeInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCORErelative_USCOREentropyInputParams(struct soap *soap, struct ns1__base_USCORErelative_USCOREentropyInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->upstream);
	soap_default_string(soap, &a->position);
	soap_default_int(soap, &a->downstream);
	soap_default_string(soap, &a->output);
	soap_default_int(soap, &a->PatLength);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCORErelative_USCOREentropyInputParams(struct soap *soap, const struct ns1__base_USCORErelative_USCOREentropyInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->position);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCORErelative_USCOREentropyInputParams(struct soap *soap, const char *tag, int id, const struct ns1__base_USCORErelative_USCOREentropyInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "upstream", -1, &a->upstream, ""))
		return soap->error;
	if (a->position)
	{	if (soap_out_string(soap, "position", -1, &a->position, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "position"))
		return soap->error;
	if (soap_out_int(soap, "downstream", -1, &a->downstream, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (soap_out_int(soap, "PatLength", -1, &a->PatLength, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCORErelative_USCOREentropyInputParams * SOAP_FMAC4 soap_in_ns1__base_USCORErelative_USCOREentropyInputParams(struct soap *soap, const char *tag, struct ns1__base_USCORErelative_USCOREentropyInputParams *a, const char *type)
{
	size_t soap_flag_upstream = 1;
	size_t soap_flag_position = 1;
	size_t soap_flag_downstream = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_PatLength = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCORErelative_USCOREentropyInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams, sizeof(struct ns1__base_USCORErelative_USCOREentropyInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCORErelative_USCOREentropyInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_upstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "upstream", &a->upstream, "xsd:int"))
				{	soap_flag_upstream--;
					continue;
				}
			if (soap_flag_position && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "position", &a->position, "xsd:string"))
				{	soap_flag_position--;
					continue;
				}
			if (soap_flag_downstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "downstream", &a->downstream, "xsd:int"))
				{	soap_flag_downstream--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_PatLength && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "PatLength", &a->PatLength, "xsd:int"))
				{	soap_flag_PatLength--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCORErelative_USCOREentropyInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams, 0, sizeof(struct ns1__base_USCORErelative_USCOREentropyInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_upstream > 0 || soap_flag_position > 0 || soap_flag_downstream > 0 || soap_flag_output > 0 || soap_flag_PatLength > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCORErelative_USCOREentropyInputParams(struct soap *soap, const struct ns1__base_USCORErelative_USCOREentropyInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCORErelative_USCOREentropyInputParams);
	if (soap_out_ns1__base_USCORErelative_USCOREentropyInputParams(soap, tag?tag:"ns1:base_relative_entropyInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCORErelative_USCOREentropyInputParams * SOAP_FMAC4 soap_get_ns1__base_USCORErelative_USCOREentropyInputParams(struct soap *soap, struct ns1__base_USCORErelative_USCOREentropyInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCORErelative_USCOREentropyInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__view_USCOREcdsInputParams(struct soap *soap, struct ns1__view_USCOREcdsInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->length);
	soap_default_int(soap, &a->gap);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__view_USCOREcdsInputParams(struct soap *soap, const struct ns1__view_USCOREcdsInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__view_USCOREcdsInputParams(struct soap *soap, const char *tag, int id, const struct ns1__view_USCOREcdsInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__view_USCOREcdsInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "length", -1, &a->length, ""))
		return soap->error;
	if (soap_out_int(soap, "gap", -1, &a->gap, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__view_USCOREcdsInputParams * SOAP_FMAC4 soap_in_ns1__view_USCOREcdsInputParams(struct soap *soap, const char *tag, struct ns1__view_USCOREcdsInputParams *a, const char *type)
{
	size_t soap_flag_length = 1;
	size_t soap_flag_gap = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__view_USCOREcdsInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__view_USCOREcdsInputParams, sizeof(struct ns1__view_USCOREcdsInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__view_USCOREcdsInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_length && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "length", &a->length, "xsd:int"))
				{	soap_flag_length--;
					continue;
				}
			if (soap_flag_gap && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "gap", &a->gap, "xsd:int"))
				{	soap_flag_gap--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__view_USCOREcdsInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__view_USCOREcdsInputParams, 0, sizeof(struct ns1__view_USCOREcdsInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_length > 0 || soap_flag_gap > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__view_USCOREcdsInputParams(struct soap *soap, const struct ns1__view_USCOREcdsInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__view_USCOREcdsInputParams);
	if (soap_out_ns1__view_USCOREcdsInputParams(soap, tag?tag:"ns1:view_cdsInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__view_USCOREcdsInputParams * SOAP_FMAC4 soap_get_ns1__view_USCOREcdsInputParams(struct soap *soap, struct ns1__view_USCOREcdsInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__view_USCOREcdsInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREcounterInputParams(struct soap *soap, struct ns1__codon_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->CDSid);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREcounterInputParams(struct soap *soap, const struct ns1__codon_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->CDSid);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREcounterInputParams(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREcounterInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREcounterInputParams), type))
		return soap->error;
	if (a->CDSid)
	{	if (soap_out_string(soap, "CDSid", -1, &a->CDSid, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "CDSid"))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREcounterInputParams * SOAP_FMAC4 soap_in_ns1__codon_USCOREcounterInputParams(struct soap *soap, const char *tag, struct ns1__codon_USCOREcounterInputParams *a, const char *type)
{
	size_t soap_flag_CDSid = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREcounterInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREcounterInputParams, sizeof(struct ns1__codon_USCOREcounterInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREcounterInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CDSid && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "CDSid", &a->CDSid, "xsd:string"))
				{	soap_flag_CDSid--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREcounterInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREcounterInputParams, 0, sizeof(struct ns1__codon_USCOREcounterInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CDSid > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREcounterInputParams(struct soap *soap, const struct ns1__codon_USCOREcounterInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREcounterInputParams);
	if (soap_out_ns1__codon_USCOREcounterInputParams(soap, tag?tag:"ns1:codon_counterInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREcounterInputParams * SOAP_FMAC4 soap_get_ns1__codon_USCOREcounterInputParams(struct soap *soap, struct ns1__codon_USCOREcounterInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREcounterInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__EwInputParams(struct soap *soap, struct ns1__EwInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->output);
	soap_default_string(soap, &a->del_USCOREkey);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__EwInputParams(struct soap *soap, const struct ns1__EwInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
	soap_serialize_string(soap, &a->del_USCOREkey);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__EwInputParams(struct soap *soap, const char *tag, int id, const struct ns1__EwInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__EwInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__EwInputParams * SOAP_FMAC4 soap_in_ns1__EwInputParams(struct soap *soap, const char *tag, struct ns1__EwInputParams *a, const char *type)
{
	size_t soap_flag_translate = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_del_USCOREkey = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__EwInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__EwInputParams, sizeof(struct ns1__EwInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__EwInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__EwInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__EwInputParams, 0, sizeof(struct ns1__EwInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_translate > 0 || soap_flag_output > 0 || soap_flag_del_USCOREkey > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__EwInputParams(struct soap *soap, const struct ns1__EwInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__EwInputParams);
	if (soap_out_ns1__EwInputParams(soap, tag?tag:"ns1:EwInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__EwInputParams * SOAP_FMAC4 soap_get_ns1__EwInputParams(struct soap *soap, struct ns1__EwInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__EwInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREiteronInputParams(struct soap *soap, struct ns1__find_USCOREiteronInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREiteronInputParams(struct soap *soap, const struct ns1__find_USCOREiteronInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREiteronInputParams(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREiteronInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREiteronInputParams), type))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREiteronInputParams * SOAP_FMAC4 soap_in_ns1__find_USCOREiteronInputParams(struct soap *soap, const char *tag, struct ns1__find_USCOREiteronInputParams *a, const char *type)
{
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREiteronInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREiteronInputParams, sizeof(struct ns1__find_USCOREiteronInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREiteronInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREiteronInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREiteronInputParams, 0, sizeof(struct ns1__find_USCOREiteronInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREiteronInputParams(struct soap *soap, const struct ns1__find_USCOREiteronInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREiteronInputParams);
	if (soap_out_ns1__find_USCOREiteronInputParams(soap, tag?tag:"ns1:find_iteronInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREiteronInputParams * SOAP_FMAC4 soap_get_ns1__find_USCOREiteronInputParams(struct soap *soap, struct ns1__find_USCOREiteronInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREiteronInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__over_USCORElapping_USCOREfinderInputParams(struct soap *soap, struct ns1__over_USCORElapping_USCOREfinderInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__over_USCORElapping_USCOREfinderInputParams(struct soap *soap, const struct ns1__over_USCORElapping_USCOREfinderInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__over_USCORElapping_USCOREfinderInputParams(struct soap *soap, const char *tag, int id, const struct ns1__over_USCORElapping_USCOREfinderInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams), type))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__over_USCORElapping_USCOREfinderInputParams * SOAP_FMAC4 soap_in_ns1__over_USCORElapping_USCOREfinderInputParams(struct soap *soap, const char *tag, struct ns1__over_USCORElapping_USCOREfinderInputParams *a, const char *type)
{
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__over_USCORElapping_USCOREfinderInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams, sizeof(struct ns1__over_USCORElapping_USCOREfinderInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__over_USCORElapping_USCOREfinderInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__over_USCORElapping_USCOREfinderInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams, 0, sizeof(struct ns1__over_USCORElapping_USCOREfinderInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__over_USCORElapping_USCOREfinderInputParams(struct soap *soap, const struct ns1__over_USCORElapping_USCOREfinderInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__over_USCORElapping_USCOREfinderInputParams);
	if (soap_out_ns1__over_USCORElapping_USCOREfinderInputParams(soap, tag?tag:"ns1:over_lapping_finderInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__over_USCORElapping_USCOREfinderInputParams * SOAP_FMAC4 soap_get_ns1__over_USCORElapping_USCOREfinderInputParams(struct soap *soap, struct ns1__over_USCORElapping_USCOREfinderInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__over_USCORElapping_USCOREfinderInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREcompilerInputParams(struct soap *soap, struct ns1__codon_USCOREcompilerInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->id);
	soap_default_string(soap, &a->data);
	soap_default_string(soap, &a->output);
	soap_default_string(soap, &a->del_USCOREkey);
	soap_default_int(soap, &a->startcodon);
	soap_default_int(soap, &a->stopcodon);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREcompilerInputParams(struct soap *soap, const struct ns1__codon_USCOREcompilerInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->id);
	soap_serialize_string(soap, &a->data);
	soap_serialize_string(soap, &a->output);
	soap_serialize_string(soap, &a->del_USCOREkey);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREcompilerInputParams(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREcompilerInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREcompilerInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->id)
	{	if (soap_out_string(soap, "id", -1, &a->id, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "id"))
		return soap->error;
	if (a->data)
	{	if (soap_out_string(soap, "data", -1, &a->data, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "data"))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	if (soap_out_int(soap, "startcodon", -1, &a->startcodon, ""))
		return soap->error;
	if (soap_out_int(soap, "stopcodon", -1, &a->stopcodon, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREcompilerInputParams * SOAP_FMAC4 soap_in_ns1__codon_USCOREcompilerInputParams(struct soap *soap, const char *tag, struct ns1__codon_USCOREcompilerInputParams *a, const char *type)
{
	size_t soap_flag_translate = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_data = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_del_USCOREkey = 1;
	size_t soap_flag_startcodon = 1;
	size_t soap_flag_stopcodon = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREcompilerInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREcompilerInputParams, sizeof(struct ns1__codon_USCOREcompilerInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREcompilerInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &a->id, "xsd:string"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_data && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "data", &a->data, "xsd:string"))
				{	soap_flag_data--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap_flag_startcodon && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "startcodon", &a->startcodon, "xsd:int"))
				{	soap_flag_startcodon--;
					continue;
				}
			if (soap_flag_stopcodon && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "stopcodon", &a->stopcodon, "xsd:int"))
				{	soap_flag_stopcodon--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREcompilerInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREcompilerInputParams, 0, sizeof(struct ns1__codon_USCOREcompilerInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_translate > 0 || soap_flag_id > 0 || soap_flag_data > 0 || soap_flag_output > 0 || soap_flag_del_USCOREkey > 0 || soap_flag_startcodon > 0 || soap_flag_stopcodon > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREcompilerInputParams(struct soap *soap, const struct ns1__codon_USCOREcompilerInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREcompilerInputParams);
	if (soap_out_ns1__codon_USCOREcompilerInputParams(soap, tag?tag:"ns1:codon_compilerInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREcompilerInputParams * SOAP_FMAC4 soap_get_ns1__codon_USCOREcompilerInputParams(struct soap *soap, struct ns1__codon_USCOREcompilerInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREcompilerInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__aauiInputParams(struct soap *soap, struct ns1__aauiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->id);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__aauiInputParams(struct soap *soap, const struct ns1__aauiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->id);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__aauiInputParams(struct soap *soap, const char *tag, int id, const struct ns1__aauiInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__aauiInputParams), type))
		return soap->error;
	if (a->id)
	{	if (soap_out_string(soap, "id", -1, &a->id, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "id"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__aauiInputParams * SOAP_FMAC4 soap_in_ns1__aauiInputParams(struct soap *soap, const char *tag, struct ns1__aauiInputParams *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__aauiInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__aauiInputParams, sizeof(struct ns1__aauiInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__aauiInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &a->id, "xsd:string"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__aauiInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__aauiInputParams, 0, sizeof(struct ns1__aauiInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__aauiInputParams(struct soap *soap, const struct ns1__aauiInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__aauiInputParams);
	if (soap_out_ns1__aauiInputParams(soap, tag?tag:"ns1:aauiInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__aauiInputParams * SOAP_FMAC4 soap_get_ns1__aauiInputParams(struct soap *soap, struct ns1__aauiInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__aauiInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__amino_USCOREcounterInputParams(struct soap *soap, struct ns1__amino_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->CDSid);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__amino_USCOREcounterInputParams(struct soap *soap, const struct ns1__amino_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->CDSid);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__amino_USCOREcounterInputParams(struct soap *soap, const char *tag, int id, const struct ns1__amino_USCOREcounterInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__amino_USCOREcounterInputParams), type))
		return soap->error;
	if (a->CDSid)
	{	if (soap_out_string(soap, "CDSid", -1, &a->CDSid, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "CDSid"))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__amino_USCOREcounterInputParams * SOAP_FMAC4 soap_in_ns1__amino_USCOREcounterInputParams(struct soap *soap, const char *tag, struct ns1__amino_USCOREcounterInputParams *a, const char *type)
{
	size_t soap_flag_CDSid = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__amino_USCOREcounterInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__amino_USCOREcounterInputParams, sizeof(struct ns1__amino_USCOREcounterInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__amino_USCOREcounterInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CDSid && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "CDSid", &a->CDSid, "xsd:string"))
				{	soap_flag_CDSid--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__amino_USCOREcounterInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__amino_USCOREcounterInputParams, 0, sizeof(struct ns1__amino_USCOREcounterInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CDSid > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__amino_USCOREcounterInputParams(struct soap *soap, const struct ns1__amino_USCOREcounterInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__amino_USCOREcounterInputParams);
	if (soap_out_ns1__amino_USCOREcounterInputParams(soap, tag?tag:"ns1:amino_counterInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__amino_USCOREcounterInputParams * SOAP_FMAC4 soap_get_ns1__amino_USCOREcounterInputParams(struct soap *soap, struct ns1__amino_USCOREcounterInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__amino_USCOREcounterInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__seq2pngInputParams(struct soap *soap, struct ns1__seq2pngInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->width);
	soap_default_int(soap, &a->window);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__seq2pngInputParams(struct soap *soap, const struct ns1__seq2pngInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__seq2pngInputParams(struct soap *soap, const char *tag, int id, const struct ns1__seq2pngInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__seq2pngInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "width", -1, &a->width, ""))
		return soap->error;
	if (soap_out_int(soap, "window", -1, &a->window, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__seq2pngInputParams * SOAP_FMAC4 soap_in_ns1__seq2pngInputParams(struct soap *soap, const char *tag, struct ns1__seq2pngInputParams *a, const char *type)
{
	size_t soap_flag_width = 1;
	size_t soap_flag_window = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__seq2pngInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__seq2pngInputParams, sizeof(struct ns1__seq2pngInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__seq2pngInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_width && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "width", &a->width, "xsd:int"))
				{	soap_flag_width--;
					continue;
				}
			if (soap_flag_window && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "window", &a->window, "xsd:int"))
				{	soap_flag_window--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__seq2pngInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__seq2pngInputParams, 0, sizeof(struct ns1__seq2pngInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_width > 0 || soap_flag_window > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__seq2pngInputParams(struct soap *soap, const struct ns1__seq2pngInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__seq2pngInputParams);
	if (soap_out_ns1__seq2pngInputParams(soap, tag?tag:"ns1:seq2pngInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__seq2pngInputParams * SOAP_FMAC4 soap_get_ns1__seq2pngInputParams(struct soap *soap, struct ns1__seq2pngInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__seq2pngInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__ttestInputParams(struct soap *soap, struct ns1__ttestInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->paired);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__ttestInputParams(struct soap *soap, const struct ns1__ttestInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ttestInputParams(struct soap *soap, const char *tag, int id, const struct ns1__ttestInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ttestInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "paired", -1, &a->paired, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__ttestInputParams * SOAP_FMAC4 soap_in_ns1__ttestInputParams(struct soap *soap, const char *tag, struct ns1__ttestInputParams *a, const char *type)
{
	size_t soap_flag_paired = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__ttestInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ttestInputParams, sizeof(struct ns1__ttestInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__ttestInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_paired && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "paired", &a->paired, "xsd:int"))
				{	soap_flag_paired--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__ttestInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ttestInputParams, 0, sizeof(struct ns1__ttestInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_paired > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__ttestInputParams(struct soap *soap, const struct ns1__ttestInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__ttestInputParams);
	if (soap_out_ns1__ttestInputParams(soap, tag?tag:"ns1:ttestInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__ttestInputParams * SOAP_FMAC4 soap_get_ns1__ttestInputParams(struct soap *soap, struct ns1__ttestInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__ttestInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREdnaAboxInputParams(struct soap *soap, struct ns1__find_USCOREdnaAboxInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREdnaAboxInputParams(struct soap *soap, const struct ns1__find_USCOREdnaAboxInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREdnaAboxInputParams(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREdnaAboxInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams), type))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREdnaAboxInputParams * SOAP_FMAC4 soap_in_ns1__find_USCOREdnaAboxInputParams(struct soap *soap, const char *tag, struct ns1__find_USCOREdnaAboxInputParams *a, const char *type)
{
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREdnaAboxInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams, sizeof(struct ns1__find_USCOREdnaAboxInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREdnaAboxInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREdnaAboxInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams, 0, sizeof(struct ns1__find_USCOREdnaAboxInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREdnaAboxInputParams(struct soap *soap, const struct ns1__find_USCOREdnaAboxInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREdnaAboxInputParams);
	if (soap_out_ns1__find_USCOREdnaAboxInputParams(soap, tag?tag:"ns1:find_dnaAboxInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREdnaAboxInputParams * SOAP_FMAC4 soap_get_ns1__find_USCOREdnaAboxInputParams(struct soap *soap, struct ns1__find_USCOREdnaAboxInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREdnaAboxInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__codon_USCOREusageInputParams(struct soap *soap, struct ns1__codon_USCOREusageInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->version);
	soap_default_string(soap, &a->CDSid);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__codon_USCOREusageInputParams(struct soap *soap, const struct ns1__codon_USCOREusageInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->CDSid);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__codon_USCOREusageInputParams(struct soap *soap, const char *tag, int id, const struct ns1__codon_USCOREusageInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__codon_USCOREusageInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "version", -1, &a->version, ""))
		return soap->error;
	if (a->CDSid)
	{	if (soap_out_string(soap, "CDSid", -1, &a->CDSid, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "CDSid"))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__codon_USCOREusageInputParams * SOAP_FMAC4 soap_in_ns1__codon_USCOREusageInputParams(struct soap *soap, const char *tag, struct ns1__codon_USCOREusageInputParams *a, const char *type)
{
	size_t soap_flag_version = 1;
	size_t soap_flag_CDSid = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__codon_USCOREusageInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__codon_USCOREusageInputParams, sizeof(struct ns1__codon_USCOREusageInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__codon_USCOREusageInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_version && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "version", &a->version, "xsd:int"))
				{	soap_flag_version--;
					continue;
				}
			if (soap_flag_CDSid && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "CDSid", &a->CDSid, "xsd:string"))
				{	soap_flag_CDSid--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__codon_USCOREusageInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__codon_USCOREusageInputParams, 0, sizeof(struct ns1__codon_USCOREusageInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_version > 0 || soap_flag_CDSid > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__codon_USCOREusageInputParams(struct soap *soap, const struct ns1__codon_USCOREusageInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__codon_USCOREusageInputParams);
	if (soap_out_ns1__codon_USCOREusageInputParams(soap, tag?tag:"ns1:codon_usageInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__codon_USCOREusageInputParams * SOAP_FMAC4 soap_get_ns1__codon_USCOREusageInputParams(struct soap *soap, struct ns1__codon_USCOREusageInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__codon_USCOREusageInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__buiInputParams(struct soap *soap, struct ns1__buiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->position);
	soap_default_string(soap, &a->id);
	soap_default_string(soap, &a->del_USCOREkey);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__buiInputParams(struct soap *soap, const struct ns1__buiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->position);
	soap_serialize_string(soap, &a->id);
	soap_serialize_string(soap, &a->del_USCOREkey);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__buiInputParams(struct soap *soap, const char *tag, int id, const struct ns1__buiInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__buiInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->position)
	{	if (soap_out_string(soap, "position", -1, &a->position, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "position"))
		return soap->error;
	if (a->id)
	{	if (soap_out_string(soap, "id", -1, &a->id, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "id"))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__buiInputParams * SOAP_FMAC4 soap_in_ns1__buiInputParams(struct soap *soap, const char *tag, struct ns1__buiInputParams *a, const char *type)
{
	size_t soap_flag_translate = 1;
	size_t soap_flag_position = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_del_USCOREkey = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__buiInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__buiInputParams, sizeof(struct ns1__buiInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__buiInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_position && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "position", &a->position, "xsd:string"))
				{	soap_flag_position--;
					continue;
				}
			if (soap_flag_id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &a->id, "xsd:string"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__buiInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__buiInputParams, 0, sizeof(struct ns1__buiInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_translate > 0 || soap_flag_position > 0 || soap_flag_id > 0 || soap_flag_del_USCOREkey > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__buiInputParams(struct soap *soap, const struct ns1__buiInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__buiInputParams);
	if (soap_out_ns1__buiInputParams(soap, tag?tag:"ns1:buiInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__buiInputParams * SOAP_FMAC4 soap_get_ns1__buiInputParams(struct soap *soap, struct ns1__buiInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__buiInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__fopInputParams(struct soap *soap, struct ns1__fopInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->output);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__fopInputParams(struct soap *soap, const struct ns1__fopInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__fopInputParams(struct soap *soap, const char *tag, int id, const struct ns1__fopInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__fopInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__fopInputParams * SOAP_FMAC4 soap_in_ns1__fopInputParams(struct soap *soap, const char *tag, struct ns1__fopInputParams *a, const char *type)
{
	size_t soap_flag_translate = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__fopInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__fopInputParams, sizeof(struct ns1__fopInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__fopInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__fopInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__fopInputParams, 0, sizeof(struct ns1__fopInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_translate > 0 || soap_flag_output > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__fopInputParams(struct soap *soap, const struct ns1__fopInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__fopInputParams);
	if (soap_out_ns1__fopInputParams(soap, tag?tag:"ns1:fopInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__fopInputParams * SOAP_FMAC4 soap_get_ns1__fopInputParams(struct soap *soap, struct ns1__fopInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__fopInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__oligomer_USCOREcounterInputParams(struct soap *soap, struct ns1__oligomer_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->window);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__oligomer_USCOREcounterInputParams(struct soap *soap, const struct ns1__oligomer_USCOREcounterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__oligomer_USCOREcounterInputParams(struct soap *soap, const char *tag, int id, const struct ns1__oligomer_USCOREcounterInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "window", -1, &a->window, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREcounterInputParams * SOAP_FMAC4 soap_in_ns1__oligomer_USCOREcounterInputParams(struct soap *soap, const char *tag, struct ns1__oligomer_USCOREcounterInputParams *a, const char *type)
{
	size_t soap_flag_window = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__oligomer_USCOREcounterInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams, sizeof(struct ns1__oligomer_USCOREcounterInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__oligomer_USCOREcounterInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_window && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "window", &a->window, "xsd:int"))
				{	soap_flag_window--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__oligomer_USCOREcounterInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams, 0, sizeof(struct ns1__oligomer_USCOREcounterInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_window > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__oligomer_USCOREcounterInputParams(struct soap *soap, const struct ns1__oligomer_USCOREcounterInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__oligomer_USCOREcounterInputParams);
	if (soap_out_ns1__oligomer_USCOREcounterInputParams(soap, tag?tag:"ns1:oligomer_counterInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREcounterInputParams * SOAP_FMAC4 soap_get_ns1__oligomer_USCOREcounterInputParams(struct soap *soap, struct ns1__oligomer_USCOREcounterInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__oligomer_USCOREcounterInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__encInputParams(struct soap *soap, struct ns1__encInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->id);
	soap_default_string(soap, &a->del_USCOREkey);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__encInputParams(struct soap *soap, const struct ns1__encInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->id);
	soap_serialize_string(soap, &a->del_USCOREkey);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__encInputParams(struct soap *soap, const char *tag, int id, const struct ns1__encInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__encInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->id)
	{	if (soap_out_string(soap, "id", -1, &a->id, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "id"))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__encInputParams * SOAP_FMAC4 soap_in_ns1__encInputParams(struct soap *soap, const char *tag, struct ns1__encInputParams *a, const char *type)
{
	size_t soap_flag_translate = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_del_USCOREkey = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__encInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__encInputParams, sizeof(struct ns1__encInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__encInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &a->id, "xsd:string"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__encInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__encInputParams, 0, sizeof(struct ns1__encInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_translate > 0 || soap_flag_id > 0 || soap_flag_del_USCOREkey > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__encInputParams(struct soap *soap, const struct ns1__encInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__encInputParams);
	if (soap_out_ns1__encInputParams(soap, tag?tag:"ns1:encInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__encInputParams * SOAP_FMAC4 soap_get_ns1__encInputParams(struct soap *soap, struct ns1__encInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__encInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__icdiInputParams(struct soap *soap, struct ns1__icdiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->id);
	soap_default_string(soap, &a->del_USCOREkey);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__icdiInputParams(struct soap *soap, const struct ns1__icdiInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->id);
	soap_serialize_string(soap, &a->del_USCOREkey);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__icdiInputParams(struct soap *soap, const char *tag, int id, const struct ns1__icdiInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__icdiInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->id)
	{	if (soap_out_string(soap, "id", -1, &a->id, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "id"))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__icdiInputParams * SOAP_FMAC4 soap_in_ns1__icdiInputParams(struct soap *soap, const char *tag, struct ns1__icdiInputParams *a, const char *type)
{
	size_t soap_flag_translate = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_del_USCOREkey = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__icdiInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__icdiInputParams, sizeof(struct ns1__icdiInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__icdiInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_id && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &a->id, "xsd:string"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__icdiInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__icdiInputParams, 0, sizeof(struct ns1__icdiInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_translate > 0 || soap_flag_id > 0 || soap_flag_del_USCOREkey > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__icdiInputParams(struct soap *soap, const struct ns1__icdiInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__icdiInputParams);
	if (soap_out_ns1__icdiInputParams(soap, tag?tag:"ns1:icdiInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__icdiInputParams * SOAP_FMAC4 soap_get_ns1__icdiInputParams(struct soap *soap, struct ns1__icdiInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__icdiInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcwinInputParams(struct soap *soap, struct ns1__gcwinInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->window);
	soap_default_int(soap, &a->at);
	soap_default_int(soap, &a->purine);
	soap_default_string(soap, &a->application);
	soap_default_string(soap, &a->output);
	soap_default_int(soap, &a->keto);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcwinInputParams(struct soap *soap, const struct ns1__gcwinInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->application);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcwinInputParams(struct soap *soap, const char *tag, int id, const struct ns1__gcwinInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcwinInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "window", -1, &a->window, ""))
		return soap->error;
	if (soap_out_int(soap, "at", -1, &a->at, ""))
		return soap->error;
	if (soap_out_int(soap, "purine", -1, &a->purine, ""))
		return soap->error;
	if (a->application)
	{	if (soap_out_string(soap, "application", -1, &a->application, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "application"))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (soap_out_int(soap, "keto", -1, &a->keto, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcwinInputParams * SOAP_FMAC4 soap_in_ns1__gcwinInputParams(struct soap *soap, const char *tag, struct ns1__gcwinInputParams *a, const char *type)
{
	size_t soap_flag_window = 1;
	size_t soap_flag_at = 1;
	size_t soap_flag_purine = 1;
	size_t soap_flag_application = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_keto = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcwinInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcwinInputParams, sizeof(struct ns1__gcwinInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcwinInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_window && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "window", &a->window, "xsd:int"))
				{	soap_flag_window--;
					continue;
				}
			if (soap_flag_at && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "at", &a->at, "xsd:int"))
				{	soap_flag_at--;
					continue;
				}
			if (soap_flag_purine && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "purine", &a->purine, "xsd:int"))
				{	soap_flag_purine--;
					continue;
				}
			if (soap_flag_application && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "application", &a->application, "xsd:string"))
				{	soap_flag_application--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_keto && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "keto", &a->keto, "xsd:int"))
				{	soap_flag_keto--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcwinInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcwinInputParams, 0, sizeof(struct ns1__gcwinInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_window > 0 || soap_flag_at > 0 || soap_flag_purine > 0 || soap_flag_application > 0 || soap_flag_output > 0 || soap_flag_keto > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcwinInputParams(struct soap *soap, const struct ns1__gcwinInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcwinInputParams);
	if (soap_out_ns1__gcwinInputParams(soap, tag?tag:"ns1:gcwinInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcwinInputParams * SOAP_FMAC4 soap_get_ns1__gcwinInputParams(struct soap *soap, struct ns1__gcwinInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcwinInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREpatternInputParams(struct soap *soap, struct ns1__find_USCOREpatternInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREpatternInputParams(struct soap *soap, const struct ns1__find_USCOREpatternInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREpatternInputParams(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREpatternInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREpatternInputParams), type))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREpatternInputParams * SOAP_FMAC4 soap_in_ns1__find_USCOREpatternInputParams(struct soap *soap, const char *tag, struct ns1__find_USCOREpatternInputParams *a, const char *type)
{
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREpatternInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREpatternInputParams, sizeof(struct ns1__find_USCOREpatternInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREpatternInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREpatternInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREpatternInputParams, 0, sizeof(struct ns1__find_USCOREpatternInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREpatternInputParams(struct soap *soap, const struct ns1__find_USCOREpatternInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREpatternInputParams);
	if (soap_out_ns1__find_USCOREpatternInputParams(soap, tag?tag:"ns1:find_patternInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREpatternInputParams * SOAP_FMAC4 soap_get_ns1__find_USCOREpatternInputParams(struct soap *soap, struct ns1__find_USCOREpatternInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREpatternInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__oligomer_USCOREsearchInputParams(struct soap *soap, struct ns1__oligomer_USCOREsearchInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->return_);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__oligomer_USCOREsearchInputParams(struct soap *soap, const struct ns1__oligomer_USCOREsearchInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->return_);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__oligomer_USCOREsearchInputParams(struct soap *soap, const char *tag, int id, const struct ns1__oligomer_USCOREsearchInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams), type))
		return soap->error;
	if (a->return_)
	{	if (soap_out_string(soap, "return", -1, &a->return_, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "return"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREsearchInputParams * SOAP_FMAC4 soap_in_ns1__oligomer_USCOREsearchInputParams(struct soap *soap, const char *tag, struct ns1__oligomer_USCOREsearchInputParams *a, const char *type)
{
	size_t soap_flag_return_ = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__oligomer_USCOREsearchInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams, sizeof(struct ns1__oligomer_USCOREsearchInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__oligomer_USCOREsearchInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_return_ && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "return", &a->return_, "xsd:string"))
				{	soap_flag_return_--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__oligomer_USCOREsearchInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams, 0, sizeof(struct ns1__oligomer_USCOREsearchInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_return_ > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__oligomer_USCOREsearchInputParams(struct soap *soap, const struct ns1__oligomer_USCOREsearchInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__oligomer_USCOREsearchInputParams);
	if (soap_out_ns1__oligomer_USCOREsearchInputParams(soap, tag?tag:"ns1:oligomer_searchInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__oligomer_USCOREsearchInputParams * SOAP_FMAC4 soap_get_ns1__oligomer_USCOREsearchInputParams(struct soap *soap, struct ns1__oligomer_USCOREsearchInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__oligomer_USCOREsearchInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__phxInputParams(struct soap *soap, struct ns1__phxInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->usage);
	soap_default_int(soap, &a->translate);
	soap_default_string(soap, &a->output);
	soap_default_string(soap, &a->del_USCOREkey);
	soap_default_string(soap, &a->tag);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__phxInputParams(struct soap *soap, const struct ns1__phxInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->usage);
	soap_serialize_string(soap, &a->output);
	soap_serialize_string(soap, &a->del_USCOREkey);
	soap_serialize_string(soap, &a->tag);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__phxInputParams(struct soap *soap, const char *tag, int id, const struct ns1__phxInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__phxInputParams), type))
		return soap->error;
	if (a->usage)
	{	if (soap_out_string(soap, "usage", -1, &a->usage, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "usage"))
		return soap->error;
	if (soap_out_int(soap, "translate", -1, &a->translate, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (a->del_USCOREkey)
	{	if (soap_out_string(soap, "del_key", -1, &a->del_USCOREkey, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "del_key"))
		return soap->error;
	if (a->tag)
	{	if (soap_out_string(soap, "tag", -1, &a->tag, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "tag"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__phxInputParams * SOAP_FMAC4 soap_in_ns1__phxInputParams(struct soap *soap, const char *tag, struct ns1__phxInputParams *a, const char *type)
{
	size_t soap_flag_usage = 1;
	size_t soap_flag_translate = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_del_USCOREkey = 1;
	size_t soap_flag_tag = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__phxInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__phxInputParams, sizeof(struct ns1__phxInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__phxInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_usage && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "usage", &a->usage, "xsd:string"))
				{	soap_flag_usage--;
					continue;
				}
			if (soap_flag_translate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "translate", &a->translate, "xsd:int"))
				{	soap_flag_translate--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_del_USCOREkey && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "del_key", &a->del_USCOREkey, "xsd:string"))
				{	soap_flag_del_USCOREkey--;
					continue;
				}
			if (soap_flag_tag && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "tag", &a->tag, "xsd:string"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__phxInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__phxInputParams, 0, sizeof(struct ns1__phxInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_usage > 0 || soap_flag_translate > 0 || soap_flag_output > 0 || soap_flag_del_USCOREkey > 0 || soap_flag_tag > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__phxInputParams(struct soap *soap, const struct ns1__phxInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__phxInputParams);
	if (soap_out_ns1__phxInputParams(soap, tag?tag:"ns1:phxInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__phxInputParams * SOAP_FMAC4 soap_get_ns1__phxInputParams(struct soap *soap, struct ns1__phxInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__phxInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__shuffleseqInputParams(struct soap *soap, struct ns1__shuffleseqInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->k);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__shuffleseqInputParams(struct soap *soap, const struct ns1__shuffleseqInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__shuffleseqInputParams(struct soap *soap, const char *tag, int id, const struct ns1__shuffleseqInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__shuffleseqInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "k", -1, &a->k, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__shuffleseqInputParams * SOAP_FMAC4 soap_in_ns1__shuffleseqInputParams(struct soap *soap, const char *tag, struct ns1__shuffleseqInputParams *a, const char *type)
{
	size_t soap_flag_k = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__shuffleseqInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__shuffleseqInputParams, sizeof(struct ns1__shuffleseqInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__shuffleseqInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_k && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "k", &a->k, "xsd:int"))
				{	soap_flag_k--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__shuffleseqInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__shuffleseqInputParams, 0, sizeof(struct ns1__shuffleseqInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_k > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__shuffleseqInputParams(struct soap *soap, const struct ns1__shuffleseqInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__shuffleseqInputParams);
	if (soap_out_ns1__shuffleseqInputParams(soap, tag?tag:"ns1:shuffleseqInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__shuffleseqInputParams * SOAP_FMAC4 soap_get_ns1__shuffleseqInputParams(struct soap *soap, struct ns1__shuffleseqInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__shuffleseqInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__find_USCOREterInputParams(struct soap *soap, struct ns1__find_USCOREterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_x002dtype);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__find_USCOREterInputParams(struct soap *soap, const struct ns1__find_USCOREterInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_x002dtype);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__find_USCOREterInputParams(struct soap *soap, const char *tag, int id, const struct ns1__find_USCOREterInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__find_USCOREterInputParams), type))
		return soap->error;
	if (a->_x002dtype)
	{	if (soap_out_string(soap, "-type", -1, &a->_x002dtype, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "-type"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__find_USCOREterInputParams * SOAP_FMAC4 soap_in_ns1__find_USCOREterInputParams(struct soap *soap, const char *tag, struct ns1__find_USCOREterInputParams *a, const char *type)
{
	size_t soap_flag__x002dtype = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__find_USCOREterInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__find_USCOREterInputParams, sizeof(struct ns1__find_USCOREterInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__find_USCOREterInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__x002dtype && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "-type", &a->_x002dtype, "xsd:string"))
				{	soap_flag__x002dtype--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__find_USCOREterInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__find_USCOREterInputParams, 0, sizeof(struct ns1__find_USCOREterInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__x002dtype > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__find_USCOREterInputParams(struct soap *soap, const struct ns1__find_USCOREterInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__find_USCOREterInputParams);
	if (soap_out_ns1__find_USCOREterInputParams(soap, tag?tag:"ns1:find_terInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__find_USCOREterInputParams * SOAP_FMAC4 soap_get_ns1__find_USCOREterInputParams(struct soap *soap, struct ns1__find_USCOREterInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__find_USCOREterInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__dnawalkInputParams(struct soap *soap, struct ns1__dnawalkInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->gmap);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__dnawalkInputParams(struct soap *soap, const struct ns1__dnawalkInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__dnawalkInputParams(struct soap *soap, const char *tag, int id, const struct ns1__dnawalkInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__dnawalkInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "gmap", -1, &a->gmap, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__dnawalkInputParams * SOAP_FMAC4 soap_in_ns1__dnawalkInputParams(struct soap *soap, const char *tag, struct ns1__dnawalkInputParams *a, const char *type)
{
	size_t soap_flag_gmap = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__dnawalkInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__dnawalkInputParams, sizeof(struct ns1__dnawalkInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__dnawalkInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_gmap && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "gmap", &a->gmap, "xsd:int"))
				{	soap_flag_gmap--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__dnawalkInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__dnawalkInputParams, 0, sizeof(struct ns1__dnawalkInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_gmap > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__dnawalkInputParams(struct soap *soap, const struct ns1__dnawalkInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__dnawalkInputParams);
	if (soap_out_ns1__dnawalkInputParams(soap, tag?tag:"ns1:dnawalkInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__dnawalkInputParams * SOAP_FMAC4 soap_get_ns1__dnawalkInputParams(struct soap *soap, struct ns1__dnawalkInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__dnawalkInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__base_USCOREinformation_USCOREcontentInputParams(struct soap *soap, struct ns1__base_USCOREinformation_USCOREcontentInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->upstream);
	soap_default_string(soap, &a->position);
	soap_default_int(soap, &a->downstream);
	soap_default_string(soap, &a->output);
	soap_default_int(soap, &a->PatLength);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__base_USCOREinformation_USCOREcontentInputParams(struct soap *soap, const struct ns1__base_USCOREinformation_USCOREcontentInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->position);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__base_USCOREinformation_USCOREcontentInputParams(struct soap *soap, const char *tag, int id, const struct ns1__base_USCOREinformation_USCOREcontentInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "upstream", -1, &a->upstream, ""))
		return soap->error;
	if (a->position)
	{	if (soap_out_string(soap, "position", -1, &a->position, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "position"))
		return soap->error;
	if (soap_out_int(soap, "downstream", -1, &a->downstream, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (soap_out_int(soap, "PatLength", -1, &a->PatLength, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__base_USCOREinformation_USCOREcontentInputParams * SOAP_FMAC4 soap_in_ns1__base_USCOREinformation_USCOREcontentInputParams(struct soap *soap, const char *tag, struct ns1__base_USCOREinformation_USCOREcontentInputParams *a, const char *type)
{
	size_t soap_flag_upstream = 1;
	size_t soap_flag_position = 1;
	size_t soap_flag_downstream = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_PatLength = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__base_USCOREinformation_USCOREcontentInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams, sizeof(struct ns1__base_USCOREinformation_USCOREcontentInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__base_USCOREinformation_USCOREcontentInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_upstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "upstream", &a->upstream, "xsd:int"))
				{	soap_flag_upstream--;
					continue;
				}
			if (soap_flag_position && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "position", &a->position, "xsd:string"))
				{	soap_flag_position--;
					continue;
				}
			if (soap_flag_downstream && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "downstream", &a->downstream, "xsd:int"))
				{	soap_flag_downstream--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_PatLength && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "PatLength", &a->PatLength, "xsd:int"))
				{	soap_flag_PatLength--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__base_USCOREinformation_USCOREcontentInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams, 0, sizeof(struct ns1__base_USCOREinformation_USCOREcontentInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_upstream > 0 || soap_flag_position > 0 || soap_flag_downstream > 0 || soap_flag_output > 0 || soap_flag_PatLength > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__base_USCOREinformation_USCOREcontentInputParams(struct soap *soap, const struct ns1__base_USCOREinformation_USCOREcontentInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__base_USCOREinformation_USCOREcontentInputParams);
	if (soap_out_ns1__base_USCOREinformation_USCOREcontentInputParams(soap, tag?tag:"ns1:base_information_contentInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__base_USCOREinformation_USCOREcontentInputParams * SOAP_FMAC4 soap_get_ns1__base_USCOREinformation_USCOREcontentInputParams(struct soap *soap, struct ns1__base_USCOREinformation_USCOREcontentInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__base_USCOREinformation_USCOREcontentInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__togoWSInputParams(struct soap *soap, struct ns1__togoWSInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->search);
	soap_default_string(soap, &a->db);
	soap_default_string(soap, &a->format);
	soap_default_string(soap, &a->field);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__togoWSInputParams(struct soap *soap, const struct ns1__togoWSInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->search);
	soap_serialize_string(soap, &a->db);
	soap_serialize_string(soap, &a->format);
	soap_serialize_string(soap, &a->field);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__togoWSInputParams(struct soap *soap, const char *tag, int id, const struct ns1__togoWSInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__togoWSInputParams), type))
		return soap->error;
	if (a->search)
	{	if (soap_out_string(soap, "search", -1, &a->search, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "search"))
		return soap->error;
	if (a->db)
	{	if (soap_out_string(soap, "db", -1, &a->db, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "db"))
		return soap->error;
	if (a->format)
	{	if (soap_out_string(soap, "format", -1, &a->format, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "format"))
		return soap->error;
	if (a->field)
	{	if (soap_out_string(soap, "field", -1, &a->field, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "field"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__togoWSInputParams * SOAP_FMAC4 soap_in_ns1__togoWSInputParams(struct soap *soap, const char *tag, struct ns1__togoWSInputParams *a, const char *type)
{
	size_t soap_flag_search = 1;
	size_t soap_flag_db = 1;
	size_t soap_flag_format = 1;
	size_t soap_flag_field = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__togoWSInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__togoWSInputParams, sizeof(struct ns1__togoWSInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__togoWSInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_search && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "search", &a->search, "xsd:string"))
				{	soap_flag_search--;
					continue;
				}
			if (soap_flag_db && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "db", &a->db, "xsd:string"))
				{	soap_flag_db--;
					continue;
				}
			if (soap_flag_format && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "format", &a->format, "xsd:string"))
				{	soap_flag_format--;
					continue;
				}
			if (soap_flag_field && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "field", &a->field, "xsd:string"))
				{	soap_flag_field--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__togoWSInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__togoWSInputParams, 0, sizeof(struct ns1__togoWSInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_search > 0 || soap_flag_db > 0 || soap_flag_format > 0 || soap_flag_field > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__togoWSInputParams(struct soap *soap, const struct ns1__togoWSInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__togoWSInputParams);
	if (soap_out_ns1__togoWSInputParams(soap, tag?tag:"ns1:togoWSInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__togoWSInputParams * SOAP_FMAC4 soap_get_ns1__togoWSInputParams(struct soap *soap, struct ns1__togoWSInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__togoWSInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genome_USCOREmap3InputParams(struct soap *soap, struct ns1__genome_USCOREmap3InputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->width);
	soap_default_string(soap, &a->datafilename);
	soap_default_int(soap, &a->gmap);
	soap_default_string(soap, &a->output);
	soap_default_int(soap, &a->height);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genome_USCOREmap3InputParams(struct soap *soap, const struct ns1__genome_USCOREmap3InputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->datafilename);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genome_USCOREmap3InputParams(struct soap *soap, const char *tag, int id, const struct ns1__genome_USCOREmap3InputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genome_USCOREmap3InputParams), type))
		return soap->error;
	if (soap_out_int(soap, "width", -1, &a->width, ""))
		return soap->error;
	if (a->datafilename)
	{	if (soap_out_string(soap, "datafilename", -1, &a->datafilename, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "datafilename"))
		return soap->error;
	if (soap_out_int(soap, "gmap", -1, &a->gmap, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (soap_out_int(soap, "height", -1, &a->height, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap3InputParams * SOAP_FMAC4 soap_in_ns1__genome_USCOREmap3InputParams(struct soap *soap, const char *tag, struct ns1__genome_USCOREmap3InputParams *a, const char *type)
{
	size_t soap_flag_width = 1;
	size_t soap_flag_datafilename = 1;
	size_t soap_flag_gmap = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_height = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genome_USCOREmap3InputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genome_USCOREmap3InputParams, sizeof(struct ns1__genome_USCOREmap3InputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genome_USCOREmap3InputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_width && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "width", &a->width, "xsd:int"))
				{	soap_flag_width--;
					continue;
				}
			if (soap_flag_datafilename && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "datafilename", &a->datafilename, "xsd:string"))
				{	soap_flag_datafilename--;
					continue;
				}
			if (soap_flag_gmap && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "gmap", &a->gmap, "xsd:int"))
				{	soap_flag_gmap--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap_flag_height && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "height", &a->height, "xsd:int"))
				{	soap_flag_height--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__genome_USCOREmap3InputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__genome_USCOREmap3InputParams, 0, sizeof(struct ns1__genome_USCOREmap3InputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_width > 0 || soap_flag_datafilename > 0 || soap_flag_gmap > 0 || soap_flag_output > 0 || soap_flag_height > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__genome_USCOREmap3InputParams(struct soap *soap, const struct ns1__genome_USCOREmap3InputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__genome_USCOREmap3InputParams);
	if (soap_out_ns1__genome_USCOREmap3InputParams(soap, tag?tag:"ns1:genome_map3InputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__genome_USCOREmap3InputParams * SOAP_FMAC4 soap_get_ns1__genome_USCOREmap3InputParams(struct soap *soap, struct ns1__genome_USCOREmap3InputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__genome_USCOREmap3InputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__gcskewInputParams(struct soap *soap, struct ns1__gcskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->window);
	soap_default_int(soap, &a->slide);
	soap_default_int(soap, &a->cumulative);
	soap_default_int(soap, &a->at);
	soap_default_int(soap, &a->purine);
	soap_default_int(soap, &a->keto);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__gcskewInputParams(struct soap *soap, const struct ns1__gcskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__gcskewInputParams(struct soap *soap, const char *tag, int id, const struct ns1__gcskewInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__gcskewInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "window", -1, &a->window, ""))
		return soap->error;
	if (soap_out_int(soap, "slide", -1, &a->slide, ""))
		return soap->error;
	if (soap_out_int(soap, "cumulative", -1, &a->cumulative, ""))
		return soap->error;
	if (soap_out_int(soap, "at", -1, &a->at, ""))
		return soap->error;
	if (soap_out_int(soap, "purine", -1, &a->purine, ""))
		return soap->error;
	if (soap_out_int(soap, "keto", -1, &a->keto, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__gcskewInputParams * SOAP_FMAC4 soap_in_ns1__gcskewInputParams(struct soap *soap, const char *tag, struct ns1__gcskewInputParams *a, const char *type)
{
	size_t soap_flag_window = 1;
	size_t soap_flag_slide = 1;
	size_t soap_flag_cumulative = 1;
	size_t soap_flag_at = 1;
	size_t soap_flag_purine = 1;
	size_t soap_flag_keto = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__gcskewInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__gcskewInputParams, sizeof(struct ns1__gcskewInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__gcskewInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_window && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "window", &a->window, "xsd:int"))
				{	soap_flag_window--;
					continue;
				}
			if (soap_flag_slide && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "slide", &a->slide, "xsd:int"))
				{	soap_flag_slide--;
					continue;
				}
			if (soap_flag_cumulative && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "cumulative", &a->cumulative, "xsd:int"))
				{	soap_flag_cumulative--;
					continue;
				}
			if (soap_flag_at && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "at", &a->at, "xsd:int"))
				{	soap_flag_at--;
					continue;
				}
			if (soap_flag_purine && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "purine", &a->purine, "xsd:int"))
				{	soap_flag_purine--;
					continue;
				}
			if (soap_flag_keto && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "keto", &a->keto, "xsd:int"))
				{	soap_flag_keto--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__gcskewInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__gcskewInputParams, 0, sizeof(struct ns1__gcskewInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_window > 0 || soap_flag_slide > 0 || soap_flag_cumulative > 0 || soap_flag_at > 0 || soap_flag_purine > 0 || soap_flag_keto > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__gcskewInputParams(struct soap *soap, const struct ns1__gcskewInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__gcskewInputParams);
	if (soap_out_ns1__gcskewInputParams(soap, tag?tag:"ns1:gcskewInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__gcskewInputParams * SOAP_FMAC4 soap_get_ns1__gcskewInputParams(struct soap *soap, struct ns1__gcskewInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__gcskewInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__circular_USCOREmapInputParams(struct soap *soap, struct ns1__circular_USCOREmapInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->gmap);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__circular_USCOREmapInputParams(struct soap *soap, const struct ns1__circular_USCOREmapInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__circular_USCOREmapInputParams(struct soap *soap, const char *tag, int id, const struct ns1__circular_USCOREmapInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__circular_USCOREmapInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "gmap", -1, &a->gmap, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__circular_USCOREmapInputParams * SOAP_FMAC4 soap_in_ns1__circular_USCOREmapInputParams(struct soap *soap, const char *tag, struct ns1__circular_USCOREmapInputParams *a, const char *type)
{
	size_t soap_flag_gmap = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__circular_USCOREmapInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__circular_USCOREmapInputParams, sizeof(struct ns1__circular_USCOREmapInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__circular_USCOREmapInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_gmap && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "gmap", &a->gmap, "xsd:int"))
				{	soap_flag_gmap--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__circular_USCOREmapInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__circular_USCOREmapInputParams, 0, sizeof(struct ns1__circular_USCOREmapInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_gmap > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__circular_USCOREmapInputParams(struct soap *soap, const struct ns1__circular_USCOREmapInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__circular_USCOREmapInputParams);
	if (soap_out_ns1__circular_USCOREmapInputParams(soap, tag?tag:"ns1:circular_mapInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__circular_USCOREmapInputParams * SOAP_FMAC4 soap_get_ns1__circular_USCOREmapInputParams(struct soap *soap, struct ns1__circular_USCOREmapInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__circular_USCOREmapInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__molecular_USCOREweightInputParams(struct soap *soap, struct ns1__molecular_USCOREweightInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->strand);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__molecular_USCOREweightInputParams(struct soap *soap, const struct ns1__molecular_USCOREweightInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->strand);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__molecular_USCOREweightInputParams(struct soap *soap, const char *tag, int id, const struct ns1__molecular_USCOREweightInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__molecular_USCOREweightInputParams), type))
		return soap->error;
	if (a->strand)
	{	if (soap_out_string(soap, "strand", -1, &a->strand, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "strand"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__molecular_USCOREweightInputParams * SOAP_FMAC4 soap_in_ns1__molecular_USCOREweightInputParams(struct soap *soap, const char *tag, struct ns1__molecular_USCOREweightInputParams *a, const char *type)
{
	size_t soap_flag_strand = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__molecular_USCOREweightInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__molecular_USCOREweightInputParams, sizeof(struct ns1__molecular_USCOREweightInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__molecular_USCOREweightInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_strand && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "strand", &a->strand, "xsd:string"))
				{	soap_flag_strand--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__molecular_USCOREweightInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__molecular_USCOREweightInputParams, 0, sizeof(struct ns1__molecular_USCOREweightInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_strand > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__molecular_USCOREweightInputParams(struct soap *soap, const struct ns1__molecular_USCOREweightInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__molecular_USCOREweightInputParams);
	if (soap_out_ns1__molecular_USCOREweightInputParams(soap, tag?tag:"ns1:molecular_weightInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__molecular_USCOREweightInputParams * SOAP_FMAC4 soap_get_ns1__molecular_USCOREweightInputParams(struct soap *soap, struct ns1__molecular_USCOREweightInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__molecular_USCOREweightInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__delta_USCOREgcskewInputParams(struct soap *soap, struct ns1__delta_USCOREgcskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->method);
	soap_default_int(soap, &a->at);
	soap_default_int(soap, &a->purine);
	soap_default_int(soap, &a->keto);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__delta_USCOREgcskewInputParams(struct soap *soap, const struct ns1__delta_USCOREgcskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->method);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__delta_USCOREgcskewInputParams(struct soap *soap, const char *tag, int id, const struct ns1__delta_USCOREgcskewInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__delta_USCOREgcskewInputParams), type))
		return soap->error;
	if (a->method)
	{	if (soap_out_string(soap, "method", -1, &a->method, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "method"))
		return soap->error;
	if (soap_out_int(soap, "at", -1, &a->at, ""))
		return soap->error;
	if (soap_out_int(soap, "purine", -1, &a->purine, ""))
		return soap->error;
	if (soap_out_int(soap, "keto", -1, &a->keto, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__delta_USCOREgcskewInputParams * SOAP_FMAC4 soap_in_ns1__delta_USCOREgcskewInputParams(struct soap *soap, const char *tag, struct ns1__delta_USCOREgcskewInputParams *a, const char *type)
{
	size_t soap_flag_method = 1;
	size_t soap_flag_at = 1;
	size_t soap_flag_purine = 1;
	size_t soap_flag_keto = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__delta_USCOREgcskewInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__delta_USCOREgcskewInputParams, sizeof(struct ns1__delta_USCOREgcskewInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__delta_USCOREgcskewInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_method && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "method", &a->method, "xsd:string"))
				{	soap_flag_method--;
					continue;
				}
			if (soap_flag_at && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "at", &a->at, "xsd:int"))
				{	soap_flag_at--;
					continue;
				}
			if (soap_flag_purine && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "purine", &a->purine, "xsd:int"))
				{	soap_flag_purine--;
					continue;
				}
			if (soap_flag_keto && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "keto", &a->keto, "xsd:int"))
				{	soap_flag_keto--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__delta_USCOREgcskewInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__delta_USCOREgcskewInputParams, 0, sizeof(struct ns1__delta_USCOREgcskewInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_method > 0 || soap_flag_at > 0 || soap_flag_purine > 0 || soap_flag_keto > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__delta_USCOREgcskewInputParams(struct soap *soap, const struct ns1__delta_USCOREgcskewInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__delta_USCOREgcskewInputParams);
	if (soap_out_ns1__delta_USCOREgcskewInputParams(soap, tag?tag:"ns1:delta_gcskewInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__delta_USCOREgcskewInputParams * SOAP_FMAC4 soap_get_ns1__delta_USCOREgcskewInputParams(struct soap *soap, struct ns1__delta_USCOREgcskewInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__delta_USCOREgcskewInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__corInputParams(struct soap *soap, struct ns1__corInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->sorted);
	soap_default_string(soap, &a->method);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__corInputParams(struct soap *soap, const struct ns1__corInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->method);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__corInputParams(struct soap *soap, const char *tag, int id, const struct ns1__corInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__corInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "sorted", -1, &a->sorted, ""))
		return soap->error;
	if (a->method)
	{	if (soap_out_string(soap, "method", -1, &a->method, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "method"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__corInputParams * SOAP_FMAC4 soap_in_ns1__corInputParams(struct soap *soap, const char *tag, struct ns1__corInputParams *a, const char *type)
{
	size_t soap_flag_sorted = 1;
	size_t soap_flag_method = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__corInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__corInputParams, sizeof(struct ns1__corInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__corInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_sorted && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "sorted", &a->sorted, "xsd:int"))
				{	soap_flag_sorted--;
					continue;
				}
			if (soap_flag_method && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "method", &a->method, "xsd:string"))
				{	soap_flag_method--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__corInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__corInputParams, 0, sizeof(struct ns1__corInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_sorted > 0 || soap_flag_method > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__corInputParams(struct soap *soap, const struct ns1__corInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__corInputParams);
	if (soap_out_ns1__corInputParams(soap, tag?tag:"ns1:corInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__corInputParams * SOAP_FMAC4 soap_get_ns1__corInputParams(struct soap *soap, struct ns1__corInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__corInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__geneskewInputParams(struct soap *soap, struct ns1__geneskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->window);
	soap_default_int(soap, &a->slide);
	soap_default_int(soap, &a->cumulative);
	soap_default_string(soap, &a->base);
	soap_default_int(soap, &a->gc3);
	soap_default_string(soap, &a->output);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__geneskewInputParams(struct soap *soap, const struct ns1__geneskewInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->base);
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__geneskewInputParams(struct soap *soap, const char *tag, int id, const struct ns1__geneskewInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__geneskewInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "window", -1, &a->window, ""))
		return soap->error;
	if (soap_out_int(soap, "slide", -1, &a->slide, ""))
		return soap->error;
	if (soap_out_int(soap, "cumulative", -1, &a->cumulative, ""))
		return soap->error;
	if (a->base)
	{	if (soap_out_string(soap, "base", -1, &a->base, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "base"))
		return soap->error;
	if (soap_out_int(soap, "gc3", -1, &a->gc3, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__geneskewInputParams * SOAP_FMAC4 soap_in_ns1__geneskewInputParams(struct soap *soap, const char *tag, struct ns1__geneskewInputParams *a, const char *type)
{
	size_t soap_flag_window = 1;
	size_t soap_flag_slide = 1;
	size_t soap_flag_cumulative = 1;
	size_t soap_flag_base = 1;
	size_t soap_flag_gc3 = 1;
	size_t soap_flag_output = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__geneskewInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__geneskewInputParams, sizeof(struct ns1__geneskewInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__geneskewInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_window && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "window", &a->window, "xsd:int"))
				{	soap_flag_window--;
					continue;
				}
			if (soap_flag_slide && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "slide", &a->slide, "xsd:int"))
				{	soap_flag_slide--;
					continue;
				}
			if (soap_flag_cumulative && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "cumulative", &a->cumulative, "xsd:int"))
				{	soap_flag_cumulative--;
					continue;
				}
			if (soap_flag_base && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "base", &a->base, "xsd:string"))
				{	soap_flag_base--;
					continue;
				}
			if (soap_flag_gc3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "gc3", &a->gc3, "xsd:int"))
				{	soap_flag_gc3--;
					continue;
				}
			if (soap_flag_output && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "output", &a->output, "xsd:string"))
				{	soap_flag_output--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__geneskewInputParams *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__geneskewInputParams, 0, sizeof(struct ns1__geneskewInputParams), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_window > 0 || soap_flag_slide > 0 || soap_flag_cumulative > 0 || soap_flag_base > 0 || soap_flag_gc3 > 0 || soap_flag_output > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__geneskewInputParams(struct soap *soap, const struct ns1__geneskewInputParams *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__geneskewInputParams);
	if (soap_out_ns1__geneskewInputParams(soap, tag?tag:"ns1:geneskewInputParams", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__geneskewInputParams * SOAP_FMAC4 soap_get_ns1__geneskewInputParams(struct soap *soap, struct ns1__geneskewInputParams *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__geneskewInputParams(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__genes_USCOREfrom_USCOREoriInputParams(struct soap *soap, struct ns1__genes_USCOREfrom_USCOREoriInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->window);
	soap_default_int(soap, &a->purine);
	soap_default_string(soap, &a->output);
	soap_default_int(soap, &a->keto);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__genes_USCOREfrom_USCOREoriInputParams(struct soap *soap, const struct ns1__genes_USCOREfrom_USCOREoriInputParams *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->output);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__genes_USCOREfrom_USCOREoriInputParams(struct soap *soap, const char *tag, int id, const struct ns1__genes_USCOREfrom_USCOREoriInputParams *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriInputParams), type))
		return soap->error;
	if (soap_out_int(soap, "window", -1, &a->window, ""))
		return soap->error;
	if (soap_out_int(soap, "purine", -1, &a->purine, ""))
		return soap->error;
	if (a->output)
	{	if (soap_out_string(soap, "output", -1, &a->output, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "output"))
		return soap->error;
	if (soap_out_int(soap, "keto", -1, &a->keto, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__genes_USCOREfrom_USCOREoriInputParams * SOAP_FMAC4 soap_in_ns1__genes_USCOREfrom_USCOREoriInputParams(struct soap *soap, const char *tag, struct ns1__genes_USCOREfrom_USCOREoriInputParams *a, const char *type)
{
	size_t soap_flag_window = 1;
	size_t soap_flag_purine = 1;
	size_t soap_flag_output = 1;
	size_t soap_flag_keto = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__genes_USCOREfrom_USCOREoriInputParams *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__genes_USCOREfrom_USCOREoriInputParams, sizeof(struct ns1__genes_USCOREfrom_USCOREoriInputParams), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__genes_USCOREfrom_USCOREoriInputParams(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_window && 