/* soapServer.c
   Generated by gSOAP 2.8.6 from gae.h

Copyright(C) 2000-2011, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
1) GPL or 2) Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif
#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapServer.c ver 2.8.6 2013-04-04 13:42:58 GMT")


SOAP_FMAC5 int SOAP_FMAC6 soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif
	do
	{
#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif
		if (soap_begin_serve(soap))
		{	if (soap->error >= SOAP_STOP)
				continue;
			return soap->error;
		}
		if (soap_serve_request(soap) || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
		soap_destroy(soap);
		soap_end(soap);
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:codon_mva"))
		return soap_serve_ns1__codon_USCOREmva(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:P2"))
		return soap_serve_ns1__P2(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:w_value"))
		return soap_serve_ns1__w_USCOREvalue(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:splitprintseq"))
		return soap_serve_ns1__splitprintseq(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:median"))
		return soap_serve_ns1__median(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:find_ori_ter"))
		return soap_serve_ns1__find_USCOREori_USCOREter(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:plasmid_map"))
		return soap_serve_ns1__plasmid_USCOREmap(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:sum"))
		return soap_serve_ns1__sum(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:nucleotide_periodicity"))
		return soap_serve_ns1__nucleotide_USCOREperiodicity(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:variance"))
		return soap_serve_ns1__variance(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:amino_info"))
		return soap_serve_ns1__amino_USCOREinfo(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:circular_map"))
		return soap_serve_ns1__circular_USCOREmap(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:togoWS"))
		return soap_serve_ns1__togoWS(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:translate"))
		return soap_serve_ns1__translate(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:phx"))
		return soap_serve_ns1__phx(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:icdi"))
		return soap_serve_ns1__icdi(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:enc"))
		return soap_serve_ns1__enc(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:fop"))
		return soap_serve_ns1__fop(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:bui"))
		return soap_serve_ns1__bui(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:dist_in_cc"))
		return soap_serve_ns1__dist_USCOREin_USCOREcc(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:find_dnaAbox"))
		return soap_serve_ns1__find_USCOREdnaAbox(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:ttest"))
		return soap_serve_ns1__ttest(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:seq2png"))
		return soap_serve_ns1__seq2png(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:amino_counter"))
		return soap_serve_ns1__amino_USCOREcounter(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:aaui"))
		return soap_serve_ns1__aaui(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:codon_compiler"))
		return soap_serve_ns1__codon_USCOREcompiler(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:over_lapping_finder"))
		return soap_serve_ns1__over_USCORElapping_USCOREfinder(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:Ew"))
		return soap_serve_ns1__Ew(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:base_relative_entropy"))
		return soap_serve_ns1__base_USCORErelative_USCOREentropy(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:view_cds"))
		return soap_serve_ns1__view_USCOREcds(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:query_strand"))
		return soap_serve_ns1__query_USCOREstrand(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:genomicskew"))
		return soap_serve_ns1__genomicskew(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:filter_cds_by_atg"))
		return soap_serve_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:gcsi"))
		return soap_serve_ns1__gcsi(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:cai"))
		return soap_serve_ns1__cai(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:maxdex"))
		return soap_serve_ns1__maxdex(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:max"))
		return soap_serve_ns1__max(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:query_arm"))
		return soap_serve_ns1__query_USCOREarm(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:mindex"))
		return soap_serve_ns1__mindex(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:consensus_z"))
		return soap_serve_ns1__consensus_USCOREz(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:genome_map"))
		return soap_serve_ns1__genome_USCOREmap(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:longest_ORF"))
		return soap_serve_ns1__longest_USCOREORF(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:rep_ori_ter"))
		return soap_serve_ns1__rep_USCOREori_USCOREter(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:calc_pI"))
		return soap_serve_ns1__calc_USCOREpI(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:DoubleHelix"))
		return soap_serve_ns1__DoubleHelix(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:base_entropy"))
		return soap_serve_ns1__base_USCOREentropy(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:to_fasta"))
		return soap_serve_ns1__to_USCOREfasta(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:find_dif"))
		return soap_serve_ns1__find_USCOREdif(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:cbi"))
		return soap_serve_ns1__cbi(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:genes_from_ori"))
		return soap_serve_ns1__genes_USCOREfrom_USCOREori(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:geneskew"))
		return soap_serve_ns1__geneskew(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:standard_deviation"))
		return soap_serve_ns1__standard_USCOREdeviation(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:cor"))
		return soap_serve_ns1__cor(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:cumulative"))
		return soap_serve_ns1__cumulative(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:delta_enc"))
		return soap_serve_ns1__delta_USCOREenc(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:delta_gcskew"))
		return soap_serve_ns1__delta_USCOREgcskew(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:molecular_weight"))
		return soap_serve_ns1__molecular_USCOREweight(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:gcskew"))
		return soap_serve_ns1__gcskew(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:genome_map3"))
		return soap_serve_ns1__genome_USCOREmap3(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:seqinfo"))
		return soap_serve_ns1__seqinfo(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:signature"))
		return soap_serve_ns1__signature(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:base_information_content"))
		return soap_serve_ns1__base_USCOREinformation_USCOREcontent(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:dnawalk"))
		return soap_serve_ns1__dnawalk(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:find_ter"))
		return soap_serve_ns1__find_USCOREter(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:shuffleseq"))
		return soap_serve_ns1__shuffleseq(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:oligomer_search"))
		return soap_serve_ns1__oligomer_USCOREsearch(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:find_pattern"))
		return soap_serve_ns1__find_USCOREpattern(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:gcwin"))
		return soap_serve_ns1__gcwin(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:oligomer_counter"))
		return soap_serve_ns1__oligomer_USCOREcounter(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:codon_usage"))
		return soap_serve_ns1__codon_USCOREusage(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:min"))
		return soap_serve_ns1__min(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:find_iteron"))
		return soap_serve_ns1__find_USCOREiteron(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:complement"))
		return soap_serve_ns1__complement(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:mean"))
		return soap_serve_ns1__mean(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:codon_counter"))
		return soap_serve_ns1__codon_USCOREcounter(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:entrez"))
		return soap_serve_ns1__entrez(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:palindrome"))
		return soap_serve_ns1__palindrome(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:least_squares_fit"))
		return soap_serve_ns1__least_USCOREsquares_USCOREfit(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:dinuc"))
		return soap_serve_ns1__dinuc(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:cgr"))
		return soap_serve_ns1__cgr(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:B1"))
		return soap_serve_ns1__B1(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:B2"))
		return soap_serve_ns1__B2(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:base_counter"))
		return soap_serve_ns1__base_USCOREcounter(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:base_z_value"))
		return soap_serve_ns1__base_USCOREz_USCOREvalue(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:kmer_table"))
		return soap_serve_ns1__kmer_USCOREtable(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:lda_bias"))
		return soap_serve_ns1__lda_USCOREbias(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:scs"))
		return soap_serve_ns1__scs(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:leading_strand"))
		return soap_serve_ns1__leading_USCOREstrand(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:S_value"))
		return soap_serve_ns1__S_USCOREvalue(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:help"))
		return soap_serve_ns1__help(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:hydropathy"))
		return soap_serve_ns1__hydropathy(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__codon_USCOREmva(struct soap *soap)
{	struct ns1__codon_USCOREmva soap_tmp_ns1__codon_USCOREmva;
	struct ns1__codon_USCOREmvaResponse soap_tmp_ns1__codon_USCOREmvaResponse;
	char * soap_tmp_string;
	soap_default_ns1__codon_USCOREmvaResponse(soap, &soap_tmp_ns1__codon_USCOREmvaResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__codon_USCOREmvaResponse._result = &soap_tmp_string;
	soap_default_ns1__codon_USCOREmva(soap, &soap_tmp_ns1__codon_USCOREmva);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__codon_USCOREmva(soap, &soap_tmp_ns1__codon_USCOREmva, "ns1:codon_mva", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__codon_USCOREmva(soap, soap_tmp_ns1__codon_USCOREmva._sequence, soap_tmp_ns1__codon_USCOREmva._params, soap_tmp_ns1__codon_USCOREmvaResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__codon_USCOREmvaResponse(soap, &soap_tmp_ns1__codon_USCOREmvaResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__codon_USCOREmvaResponse(soap, &soap_tmp_ns1__codon_USCOREmvaResponse, "ns1:codon_mvaResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__codon_USCOREmvaResponse(soap, &soap_tmp_ns1__codon_USCOREmvaResponse, "ns1:codon_mvaResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__P2(struct soap *soap)
{	struct ns1__P2 soap_tmp_ns1__P2;
	struct ns1__P2Response soap_tmp_ns1__P2Response;
	char * soap_tmp_string;
	soap_default_ns1__P2Response(soap, &soap_tmp_ns1__P2Response);
	soap_tmp_string = NULL;
	soap_tmp_ns1__P2Response._result = &soap_tmp_string;
	soap_default_ns1__P2(soap, &soap_tmp_ns1__P2);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__P2(soap, &soap_tmp_ns1__P2, "ns1:P2", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__P2(soap, soap_tmp_ns1__P2._sequence, soap_tmp_ns1__P2._params, soap_tmp_ns1__P2Response._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__P2Response(soap, &soap_tmp_ns1__P2Response);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__P2Response(soap, &soap_tmp_ns1__P2Response, "ns1:P2Response", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__P2Response(soap, &soap_tmp_ns1__P2Response, "ns1:P2Response", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__w_USCOREvalue(struct soap *soap)
{	struct ns1__w_USCOREvalue soap_tmp_ns1__w_USCOREvalue;
	struct ns1__w_USCOREvalueResponse soap_tmp_ns1__w_USCOREvalueResponse;
	char * soap_tmp_string;
	soap_default_ns1__w_USCOREvalueResponse(soap, &soap_tmp_ns1__w_USCOREvalueResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__w_USCOREvalueResponse._result = &soap_tmp_string;
	soap_default_ns1__w_USCOREvalue(soap, &soap_tmp_ns1__w_USCOREvalue);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__w_USCOREvalue(soap, &soap_tmp_ns1__w_USCOREvalue, "ns1:w_value", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__w_USCOREvalue(soap, soap_tmp_ns1__w_USCOREvalue._sequence, soap_tmp_ns1__w_USCOREvalue._params, soap_tmp_ns1__w_USCOREvalueResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__w_USCOREvalueResponse(soap, &soap_tmp_ns1__w_USCOREvalueResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__w_USCOREvalueResponse(soap, &soap_tmp_ns1__w_USCOREvalueResponse, "ns1:w_valueResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__w_USCOREvalueResponse(soap, &soap_tmp_ns1__w_USCOREvalueResponse, "ns1:w_valueResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__splitprintseq(struct soap *soap)
{	struct ns1__splitprintseq soap_tmp_ns1__splitprintseq;
	struct ns1__splitprintseqResponse soap_tmp_ns1__splitprintseqResponse;
	char * soap_tmp_string;
	soap_default_ns1__splitprintseqResponse(soap, &soap_tmp_ns1__splitprintseqResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__splitprintseqResponse._result = &soap_tmp_string;
	soap_default_ns1__splitprintseq(soap, &soap_tmp_ns1__splitprintseq);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__splitprintseq(soap, &soap_tmp_ns1__splitprintseq, "ns1:splitprintseq", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__splitprintseq(soap, soap_tmp_ns1__splitprintseq._sequence, soap_tmp_ns1__splitprintseqResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__splitprintseqResponse(soap, &soap_tmp_ns1__splitprintseqResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__splitprintseqResponse(soap, &soap_tmp_ns1__splitprintseqResponse, "ns1:splitprintseqResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__splitprintseqResponse(soap, &soap_tmp_ns1__splitprintseqResponse, "ns1:splitprintseqResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__median(struct soap *soap)
{	struct ns1__median soap_tmp_ns1__median;
	struct ns1__medianResponse soap_tmp_ns1__medianResponse;
	char * soap_tmp_string;
	soap_default_ns1__medianResponse(soap, &soap_tmp_ns1__medianResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__medianResponse._result = &soap_tmp_string;
	soap_default_ns1__median(soap, &soap_tmp_ns1__median);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__median(soap, &soap_tmp_ns1__median, "ns1:median", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__median(soap, soap_tmp_ns1__median._array, soap_tmp_ns1__medianResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__medianResponse(soap, &soap_tmp_ns1__medianResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__medianResponse(soap, &soap_tmp_ns1__medianResponse, "ns1:medianResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__medianResponse(soap, &soap_tmp_ns1__medianResponse, "ns1:medianResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__find_USCOREori_USCOREter(struct soap *soap)
{	struct ns1__find_USCOREori_USCOREter soap_tmp_ns1__find_USCOREori_USCOREter;
	struct ns1__find_USCOREori_USCOREterResponse soap_tmp_ns1__find_USCOREori_USCOREterResponse;
	char * soap_tmp_string;
	soap_default_ns1__find_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__find_USCOREori_USCOREterResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__find_USCOREori_USCOREterResponse._result = &soap_tmp_string;
	soap_default_ns1__find_USCOREori_USCOREter(soap, &soap_tmp_ns1__find_USCOREori_USCOREter);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__find_USCOREori_USCOREter(soap, &soap_tmp_ns1__find_USCOREori_USCOREter, "ns1:find_ori_ter", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__find_USCOREori_USCOREter(soap, soap_tmp_ns1__find_USCOREori_USCOREter._sequence, soap_tmp_ns1__find_USCOREori_USCOREter._params, soap_tmp_ns1__find_USCOREori_USCOREterResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__find_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__find_USCOREori_USCOREterResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__find_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__find_USCOREori_USCOREterResponse, "ns1:find_ori_terResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__find_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__find_USCOREori_USCOREterResponse, "ns1:find_ori_terResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__plasmid_USCOREmap(struct soap *soap)
{	struct ns1__plasmid_USCOREmap soap_tmp_ns1__plasmid_USCOREmap;
	struct ns1__plasmid_USCOREmapResponse soap_tmp_ns1__plasmid_USCOREmapResponse;
	char * soap_tmp_string;
	soap_default_ns1__plasmid_USCOREmapResponse(soap, &soap_tmp_ns1__plasmid_USCOREmapResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__plasmid_USCOREmapResponse._result = &soap_tmp_string;
	soap_default_ns1__plasmid_USCOREmap(soap, &soap_tmp_ns1__plasmid_USCOREmap);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__plasmid_USCOREmap(soap, &soap_tmp_ns1__plasmid_USCOREmap, "ns1:plasmid_map", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__plasmid_USCOREmap(soap, soap_tmp_ns1__plasmid_USCOREmap._sequence, soap_tmp_ns1__plasmid_USCOREmap._params, soap_tmp_ns1__plasmid_USCOREmapResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__plasmid_USCOREmapResponse(soap, &soap_tmp_ns1__plasmid_USCOREmapResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__plasmid_USCOREmapResponse(soap, &soap_tmp_ns1__plasmid_USCOREmapResponse, "ns1:plasmid_mapResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__plasmid_USCOREmapResponse(soap, &soap_tmp_ns1__plasmid_USCOREmapResponse, "ns1:plasmid_mapResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__sum(struct soap *soap)
{	struct ns1__sum soap_tmp_ns1__sum;
	struct ns1__sumResponse soap_tmp_ns1__sumResponse;
	char * soap_tmp_string;
	soap_default_ns1__sumResponse(soap, &soap_tmp_ns1__sumResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__sumResponse._result = &soap_tmp_string;
	soap_default_ns1__sum(soap, &soap_tmp_ns1__sum);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__sum(soap, &soap_tmp_ns1__sum, "ns1:sum", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__sum(soap, soap_tmp_ns1__sum._array, soap_tmp_ns1__sumResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__sumResponse(soap, &soap_tmp_ns1__sumResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__sumResponse(soap, &soap_tmp_ns1__sumResponse, "ns1:sumResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__sumResponse(soap, &soap_tmp_ns1__sumResponse, "ns1:sumResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__nucleotide_USCOREperiodicity(struct soap *soap)
{	struct ns1__nucleotide_USCOREperiodicity soap_tmp_ns1__nucleotide_USCOREperiodicity;
	struct ns1__nucleotide_USCOREperiodicityResponse soap_tmp_ns1__nucleotide_USCOREperiodicityResponse;
	char * soap_tmp_string;
	soap_default_ns1__nucleotide_USCOREperiodicityResponse(soap, &soap_tmp_ns1__nucleotide_USCOREperiodicityResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__nucleotide_USCOREperiodicityResponse._result = &soap_tmp_string;
	soap_default_ns1__nucleotide_USCOREperiodicity(soap, &soap_tmp_ns1__nucleotide_USCOREperiodicity);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__nucleotide_USCOREperiodicity(soap, &soap_tmp_ns1__nucleotide_USCOREperiodicity, "ns1:nucleotide_periodicity", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__nucleotide_USCOREperiodicity(soap, soap_tmp_ns1__nucleotide_USCOREperiodicity._sequence, soap_tmp_ns1__nucleotide_USCOREperiodicity._params, soap_tmp_ns1__nucleotide_USCOREperiodicityResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__nucleotide_USCOREperiodicityResponse(soap, &soap_tmp_ns1__nucleotide_USCOREperiodicityResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__nucleotide_USCOREperiodicityResponse(soap, &soap_tmp_ns1__nucleotide_USCOREperiodicityResponse, "ns1:nucleotide_periodicityResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__nucleotide_USCOREperiodicityResponse(soap, &soap_tmp_ns1__nucleotide_USCOREperiodicityResponse, "ns1:nucleotide_periodicityResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__variance(struct soap *soap)
{	struct ns1__variance soap_tmp_ns1__variance;
	struct ns1__varianceResponse soap_tmp_ns1__varianceResponse;
	char * soap_tmp_string;
	soap_default_ns1__varianceResponse(soap, &soap_tmp_ns1__varianceResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__varianceResponse._result = &soap_tmp_string;
	soap_default_ns1__variance(soap, &soap_tmp_ns1__variance);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__variance(soap, &soap_tmp_ns1__variance, "ns1:variance", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__variance(soap, soap_tmp_ns1__variance._array, soap_tmp_ns1__varianceResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__varianceResponse(soap, &soap_tmp_ns1__varianceResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__varianceResponse(soap, &soap_tmp_ns1__varianceResponse, "ns1:varianceResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__varianceResponse(soap, &soap_tmp_ns1__varianceResponse, "ns1:varianceResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__amino_USCOREinfo(struct soap *soap)
{	struct ns1__amino_USCOREinfo soap_tmp_ns1__amino_USCOREinfo;
	struct ns1__amino_USCOREinfoResponse soap_tmp_ns1__amino_USCOREinfoResponse;
	char * soap_tmp_string;
	soap_default_ns1__amino_USCOREinfoResponse(soap, &soap_tmp_ns1__amino_USCOREinfoResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__amino_USCOREinfoResponse._result = &soap_tmp_string;
	soap_default_ns1__amino_USCOREinfo(soap, &soap_tmp_ns1__amino_USCOREinfo);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__amino_USCOREinfo(soap, &soap_tmp_ns1__amino_USCOREinfo, "ns1:amino_info", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__amino_USCOREinfo(soap, soap_tmp_ns1__amino_USCOREinfo._sequence, soap_tmp_ns1__amino_USCOREinfoResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__amino_USCOREinfoResponse(soap, &soap_tmp_ns1__amino_USCOREinfoResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__amino_USCOREinfoResponse(soap, &soap_tmp_ns1__amino_USCOREinfoResponse, "ns1:amino_infoResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__amino_USCOREinfoResponse(soap, &soap_tmp_ns1__amino_USCOREinfoResponse, "ns1:amino_infoResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__circular_USCOREmap(struct soap *soap)
{	struct ns1__circular_USCOREmap soap_tmp_ns1__circular_USCOREmap;
	struct ns1__circular_USCOREmapResponse soap_tmp_ns1__circular_USCOREmapResponse;
	char * soap_tmp_string;
	soap_default_ns1__circular_USCOREmapResponse(soap, &soap_tmp_ns1__circular_USCOREmapResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__circular_USCOREmapResponse._result = &soap_tmp_string;
	soap_default_ns1__circular_USCOREmap(soap, &soap_tmp_ns1__circular_USCOREmap);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__circular_USCOREmap(soap, &soap_tmp_ns1__circular_USCOREmap, "ns1:circular_map", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__circular_USCOREmap(soap, soap_tmp_ns1__circular_USCOREmap._sequence, soap_tmp_ns1__circular_USCOREmap._params, soap_tmp_ns1__circular_USCOREmapResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__circular_USCOREmapResponse(soap, &soap_tmp_ns1__circular_USCOREmapResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__circular_USCOREmapResponse(soap, &soap_tmp_ns1__circular_USCOREmapResponse, "ns1:circular_mapResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__circular_USCOREmapResponse(soap, &soap_tmp_ns1__circular_USCOREmapResponse, "ns1:circular_mapResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__togoWS(struct soap *soap)
{	struct ns1__togoWS soap_tmp_ns1__togoWS;
	struct ns1__togoWSResponse soap_tmp_ns1__togoWSResponse;
	char * soap_tmp_string;
	soap_default_ns1__togoWSResponse(soap, &soap_tmp_ns1__togoWSResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__togoWSResponse._result = &soap_tmp_string;
	soap_default_ns1__togoWS(soap, &soap_tmp_ns1__togoWS);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__togoWS(soap, &soap_tmp_ns1__togoWS, "ns1:togoWS", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__togoWS(soap, soap_tmp_ns1__togoWS._query, soap_tmp_ns1__togoWS._params, soap_tmp_ns1__togoWSResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__togoWSResponse(soap, &soap_tmp_ns1__togoWSResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__togoWSResponse(soap, &soap_tmp_ns1__togoWSResponse, "ns1:togoWSResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__togoWSResponse(soap, &soap_tmp_ns1__togoWSResponse, "ns1:togoWSResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__translate(struct soap *soap)
{	struct ns1__translate soap_tmp_ns1__translate;
	struct ns1__translateResponse soap_tmp_ns1__translateResponse;
	char * soap_tmp_string;
	soap_default_ns1__translateResponse(soap, &soap_tmp_ns1__translateResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__translateResponse._result = &soap_tmp_string;
	soap_default_ns1__translate(soap, &soap_tmp_ns1__translate);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__translate(soap, &soap_tmp_ns1__translate, "ns1:translate", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__translate(soap, soap_tmp_ns1__translate._sequence, soap_tmp_ns1__translateResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__translateResponse(soap, &soap_tmp_ns1__translateResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__translateResponse(soap, &soap_tmp_ns1__translateResponse, "ns1:translateResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__translateResponse(soap, &soap_tmp_ns1__translateResponse, "ns1:translateResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__phx(struct soap *soap)
{	struct ns1__phx soap_tmp_ns1__phx;
	struct ns1__phxResponse soap_tmp_ns1__phxResponse;
	char * soap_tmp_string;
	soap_default_ns1__phxResponse(soap, &soap_tmp_ns1__phxResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__phxResponse._result = &soap_tmp_string;
	soap_default_ns1__phx(soap, &soap_tmp_ns1__phx);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__phx(soap, &soap_tmp_ns1__phx, "ns1:phx", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__phx(soap, soap_tmp_ns1__phx._sequence, soap_tmp_ns1__phx._params, soap_tmp_ns1__phxResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__phxResponse(soap, &soap_tmp_ns1__phxResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__phxResponse(soap, &soap_tmp_ns1__phxResponse, "ns1:phxResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__phxResponse(soap, &soap_tmp_ns1__phxResponse, "ns1:phxResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__icdi(struct soap *soap)
{	struct ns1__icdi soap_tmp_ns1__icdi;
	struct ns1__icdiResponse soap_tmp_ns1__icdiResponse;
	char * soap_tmp_string;
	soap_default_ns1__icdiResponse(soap, &soap_tmp_ns1__icdiResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__icdiResponse._result = &soap_tmp_string;
	soap_default_ns1__icdi(soap, &soap_tmp_ns1__icdi);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__icdi(soap, &soap_tmp_ns1__icdi, "ns1:icdi", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__icdi(soap, soap_tmp_ns1__icdi._sequence, soap_tmp_ns1__icdi._params, soap_tmp_ns1__icdiResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__icdiResponse(soap, &soap_tmp_ns1__icdiResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__icdiResponse(soap, &soap_tmp_ns1__icdiResponse, "ns1:icdiResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__icdiResponse(soap, &soap_tmp_ns1__icdiResponse, "ns1:icdiResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__enc(struct soap *soap)
{	struct ns1__enc soap_tmp_ns1__enc;
	struct ns1__encResponse soap_tmp_ns1__encResponse;
	char * soap_tmp_string;
	soap_default_ns1__encResponse(soap, &soap_tmp_ns1__encResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__encResponse._result = &soap_tmp_string;
	soap_default_ns1__enc(soap, &soap_tmp_ns1__enc);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__enc(soap, &soap_tmp_ns1__enc, "ns1:enc", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__enc(soap, soap_tmp_ns1__enc._sequence, soap_tmp_ns1__enc._params, soap_tmp_ns1__encResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__encResponse(soap, &soap_tmp_ns1__encResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__encResponse(soap, &soap_tmp_ns1__encResponse, "ns1:encResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__encResponse(soap, &soap_tmp_ns1__encResponse, "ns1:encResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__fop(struct soap *soap)
{	struct ns1__fop soap_tmp_ns1__fop;
	struct ns1__fopResponse soap_tmp_ns1__fopResponse;
	char * soap_tmp_string;
	soap_default_ns1__fopResponse(soap, &soap_tmp_ns1__fopResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__fopResponse._result = &soap_tmp_string;
	soap_default_ns1__fop(soap, &soap_tmp_ns1__fop);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__fop(soap, &soap_tmp_ns1__fop, "ns1:fop", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__fop(soap, soap_tmp_ns1__fop._sequence, soap_tmp_ns1__fop._params, soap_tmp_ns1__fopResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__fopResponse(soap, &soap_tmp_ns1__fopResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__fopResponse(soap, &soap_tmp_ns1__fopResponse, "ns1:fopResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__fopResponse(soap, &soap_tmp_ns1__fopResponse, "ns1:fopResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__bui(struct soap *soap)
{	struct ns1__bui soap_tmp_ns1__bui;
	struct ns1__buiResponse soap_tmp_ns1__buiResponse;
	char * soap_tmp_string;
	soap_default_ns1__buiResponse(soap, &soap_tmp_ns1__buiResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__buiResponse._result = &soap_tmp_string;
	soap_default_ns1__bui(soap, &soap_tmp_ns1__bui);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__bui(soap, &soap_tmp_ns1__bui, "ns1:bui", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__bui(soap, soap_tmp_ns1__bui._sequence, soap_tmp_ns1__bui._params, soap_tmp_ns1__buiResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__buiResponse(soap, &soap_tmp_ns1__buiResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__buiResponse(soap, &soap_tmp_ns1__buiResponse, "ns1:buiResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__buiResponse(soap, &soap_tmp_ns1__buiResponse, "ns1:buiResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__dist_USCOREin_USCOREcc(struct soap *soap)
{	struct ns1__dist_USCOREin_USCOREcc soap_tmp_ns1__dist_USCOREin_USCOREcc;
	struct ns1__dist_USCOREin_USCOREccResponse soap_tmp_ns1__dist_USCOREin_USCOREccResponse;
	char * soap_tmp_string;
	soap_default_ns1__dist_USCOREin_USCOREccResponse(soap, &soap_tmp_ns1__dist_USCOREin_USCOREccResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__dist_USCOREin_USCOREccResponse._result = &soap_tmp_string;
	soap_default_ns1__dist_USCOREin_USCOREcc(soap, &soap_tmp_ns1__dist_USCOREin_USCOREcc);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__dist_USCOREin_USCOREcc(soap, &soap_tmp_ns1__dist_USCOREin_USCOREcc, "ns1:dist_in_cc", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__dist_USCOREin_USCOREcc(soap, soap_tmp_ns1__dist_USCOREin_USCOREcc._sequence, soap_tmp_ns1__dist_USCOREin_USCOREcc._position1, soap_tmp_ns1__dist_USCOREin_USCOREcc._position2, soap_tmp_ns1__dist_USCOREin_USCOREccResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__dist_USCOREin_USCOREccResponse(soap, &soap_tmp_ns1__dist_USCOREin_USCOREccResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__dist_USCOREin_USCOREccResponse(soap, &soap_tmp_ns1__dist_USCOREin_USCOREccResponse, "ns1:dist_in_ccResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__dist_USCOREin_USCOREccResponse(soap, &soap_tmp_ns1__dist_USCOREin_USCOREccResponse, "ns1:dist_in_ccResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__find_USCOREdnaAbox(struct soap *soap)
{	struct ns1__find_USCOREdnaAbox soap_tmp_ns1__find_USCOREdnaAbox;
	struct ns1__find_USCOREdnaAboxResponse soap_tmp_ns1__find_USCOREdnaAboxResponse;
	char * soap_tmp_string;
	soap_default_ns1__find_USCOREdnaAboxResponse(soap, &soap_tmp_ns1__find_USCOREdnaAboxResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__find_USCOREdnaAboxResponse._result = &soap_tmp_string;
	soap_default_ns1__find_USCOREdnaAbox(soap, &soap_tmp_ns1__find_USCOREdnaAbox);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__find_USCOREdnaAbox(soap, &soap_tmp_ns1__find_USCOREdnaAbox, "ns1:find_dnaAbox", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__find_USCOREdnaAbox(soap, soap_tmp_ns1__find_USCOREdnaAbox._sequence, soap_tmp_ns1__find_USCOREdnaAbox._params, soap_tmp_ns1__find_USCOREdnaAboxResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__find_USCOREdnaAboxResponse(soap, &soap_tmp_ns1__find_USCOREdnaAboxResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__find_USCOREdnaAboxResponse(soap, &soap_tmp_ns1__find_USCOREdnaAboxResponse, "ns1:find_dnaAboxResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__find_USCOREdnaAboxResponse(soap, &soap_tmp_ns1__find_USCOREdnaAboxResponse, "ns1:find_dnaAboxResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__ttest(struct soap *soap)
{	struct ns1__ttest soap_tmp_ns1__ttest;
	struct ns1__ttestResponse _param_1;
	soap_default_ns1__ttestResponse(soap, &_param_1);
	soap_default_ns1__ttest(soap, &soap_tmp_ns1__ttest);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__ttest(soap, &soap_tmp_ns1__ttest, "ns1:ttest", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__ttest(soap, soap_tmp_ns1__ttest._array1, soap_tmp_ns1__ttest._array2, soap_tmp_ns1__ttest._params, &_param_1);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__ttestResponse(soap, &_param_1);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__ttestResponse(soap, &_param_1, "ns1:ttestResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__ttestResponse(soap, &_param_1, "ns1:ttestResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__seq2png(struct soap *soap)
{	struct ns1__seq2png soap_tmp_ns1__seq2png;
	struct ns1__seq2pngResponse soap_tmp_ns1__seq2pngResponse;
	char * soap_tmp_string;
	soap_default_ns1__seq2pngResponse(soap, &soap_tmp_ns1__seq2pngResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__seq2pngResponse._result = &soap_tmp_string;
	soap_default_ns1__seq2png(soap, &soap_tmp_ns1__seq2png);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__seq2png(soap, &soap_tmp_ns1__seq2png, "ns1:seq2png", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__seq2png(soap, soap_tmp_ns1__seq2png._sequence, soap_tmp_ns1__seq2png._params, soap_tmp_ns1__seq2pngResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__seq2pngResponse(soap, &soap_tmp_ns1__seq2pngResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__seq2pngResponse(soap, &soap_tmp_ns1__seq2pngResponse, "ns1:seq2pngResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__seq2pngResponse(soap, &soap_tmp_ns1__seq2pngResponse, "ns1:seq2pngResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__amino_USCOREcounter(struct soap *soap)
{	struct ns1__amino_USCOREcounter soap_tmp_ns1__amino_USCOREcounter;
	struct ns1__amino_USCOREcounterResponse soap_tmp_ns1__amino_USCOREcounterResponse;
	char * soap_tmp_string;
	soap_default_ns1__amino_USCOREcounterResponse(soap, &soap_tmp_ns1__amino_USCOREcounterResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__amino_USCOREcounterResponse._result = &soap_tmp_string;
	soap_default_ns1__amino_USCOREcounter(soap, &soap_tmp_ns1__amino_USCOREcounter);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__amino_USCOREcounter(soap, &soap_tmp_ns1__amino_USCOREcounter, "ns1:amino_counter", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__amino_USCOREcounter(soap, soap_tmp_ns1__amino_USCOREcounter._sequence, soap_tmp_ns1__amino_USCOREcounter._params, soap_tmp_ns1__amino_USCOREcounterResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__amino_USCOREcounterResponse(soap, &soap_tmp_ns1__amino_USCOREcounterResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__amino_USCOREcounterResponse(soap, &soap_tmp_ns1__amino_USCOREcounterResponse, "ns1:amino_counterResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__amino_USCOREcounterResponse(soap, &soap_tmp_ns1__amino_USCOREcounterResponse, "ns1:amino_counterResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__aaui(struct soap *soap)
{	struct ns1__aaui soap_tmp_ns1__aaui;
	struct ns1__aauiResponse soap_tmp_ns1__aauiResponse;
	char * soap_tmp_string;
	soap_default_ns1__aauiResponse(soap, &soap_tmp_ns1__aauiResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__aauiResponse._result = &soap_tmp_string;
	soap_default_ns1__aaui(soap, &soap_tmp_ns1__aaui);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__aaui(soap, &soap_tmp_ns1__aaui, "ns1:aaui", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__aaui(soap, soap_tmp_ns1__aaui._sequence, soap_tmp_ns1__aaui._params, soap_tmp_ns1__aauiResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__aauiResponse(soap, &soap_tmp_ns1__aauiResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__aauiResponse(soap, &soap_tmp_ns1__aauiResponse, "ns1:aauiResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__aauiResponse(soap, &soap_tmp_ns1__aauiResponse, "ns1:aauiResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__codon_USCOREcompiler(struct soap *soap)
{	struct ns1__codon_USCOREcompiler soap_tmp_ns1__codon_USCOREcompiler;
	struct ns1__codon_USCOREcompilerResponse soap_tmp_ns1__codon_USCOREcompilerResponse;
	char * soap_tmp_string;
	soap_default_ns1__codon_USCOREcompilerResponse(soap, &soap_tmp_ns1__codon_USCOREcompilerResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__codon_USCOREcompilerResponse._result = &soap_tmp_string;
	soap_default_ns1__codon_USCOREcompiler(soap, &soap_tmp_ns1__codon_USCOREcompiler);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__codon_USCOREcompiler(soap, &soap_tmp_ns1__codon_USCOREcompiler, "ns1:codon_compiler", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__codon_USCOREcompiler(soap, soap_tmp_ns1__codon_USCOREcompiler._sequence, soap_tmp_ns1__codon_USCOREcompiler._params, soap_tmp_ns1__codon_USCOREcompilerResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__codon_USCOREcompilerResponse(soap, &soap_tmp_ns1__codon_USCOREcompilerResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__codon_USCOREcompilerResponse(soap, &soap_tmp_ns1__codon_USCOREcompilerResponse, "ns1:codon_compilerResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__codon_USCOREcompilerResponse(soap, &soap_tmp_ns1__codon_USCOREcompilerResponse, "ns1:codon_compilerResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__over_USCORElapping_USCOREfinder(struct soap *soap)
{	struct ns1__over_USCORElapping_USCOREfinder soap_tmp_ns1__over_USCORElapping_USCOREfinder;
	struct ns1__over_USCORElapping_USCOREfinderResponse soap_tmp_ns1__over_USCORElapping_USCOREfinderResponse;
	char * soap_tmp_string;
	soap_default_ns1__over_USCORElapping_USCOREfinderResponse(soap, &soap_tmp_ns1__over_USCORElapping_USCOREfinderResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__over_USCORElapping_USCOREfinderResponse._result = &soap_tmp_string;
	soap_default_ns1__over_USCORElapping_USCOREfinder(soap, &soap_tmp_ns1__over_USCORElapping_USCOREfinder);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__over_USCORElapping_USCOREfinder(soap, &soap_tmp_ns1__over_USCORElapping_USCOREfinder, "ns1:over_lapping_finder", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__over_USCORElapping_USCOREfinder(soap, soap_tmp_ns1__over_USCORElapping_USCOREfinder._sequence, soap_tmp_ns1__over_USCORElapping_USCOREfinder._params, soap_tmp_ns1__over_USCORElapping_USCOREfinderResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__over_USCORElapping_USCOREfinderResponse(soap, &soap_tmp_ns1__over_USCORElapping_USCOREfinderResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__over_USCORElapping_USCOREfinderResponse(soap, &soap_tmp_ns1__over_USCORElapping_USCOREfinderResponse, "ns1:over_lapping_finderResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__over_USCORElapping_USCOREfinderResponse(soap, &soap_tmp_ns1__over_USCORElapping_USCOREfinderResponse, "ns1:over_lapping_finderResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__Ew(struct soap *soap)
{	struct ns1__Ew soap_tmp_ns1__Ew;
	struct ns1__EwResponse soap_tmp_ns1__EwResponse;
	char * soap_tmp_string;
	soap_default_ns1__EwResponse(soap, &soap_tmp_ns1__EwResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__EwResponse._result = &soap_tmp_string;
	soap_default_ns1__Ew(soap, &soap_tmp_ns1__Ew);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__Ew(soap, &soap_tmp_ns1__Ew, "ns1:Ew", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__Ew(soap, soap_tmp_ns1__Ew._sequence, soap_tmp_ns1__Ew._params, soap_tmp_ns1__EwResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__EwResponse(soap, &soap_tmp_ns1__EwResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__EwResponse(soap, &soap_tmp_ns1__EwResponse, "ns1:EwResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__EwResponse(soap, &soap_tmp_ns1__EwResponse, "ns1:EwResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__base_USCORErelative_USCOREentropy(struct soap *soap)
{	struct ns1__base_USCORErelative_USCOREentropy soap_tmp_ns1__base_USCORErelative_USCOREentropy;
	struct ns1__base_USCORErelative_USCOREentropyResponse soap_tmp_ns1__base_USCORErelative_USCOREentropyResponse;
	char * soap_tmp_string;
	soap_default_ns1__base_USCORErelative_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCORErelative_USCOREentropyResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__base_USCORErelative_USCOREentropyResponse._result = &soap_tmp_string;
	soap_default_ns1__base_USCORErelative_USCOREentropy(soap, &soap_tmp_ns1__base_USCORErelative_USCOREentropy);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__base_USCORErelative_USCOREentropy(soap, &soap_tmp_ns1__base_USCORErelative_USCOREentropy, "ns1:base_relative_entropy", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__base_USCORErelative_USCOREentropy(soap, soap_tmp_ns1__base_USCORErelative_USCOREentropy._sequence, soap_tmp_ns1__base_USCORErelative_USCOREentropy._params, soap_tmp_ns1__base_USCORErelative_USCOREentropyResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__base_USCORErelative_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCORErelative_USCOREentropyResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__base_USCORErelative_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCORErelative_USCOREentropyResponse, "ns1:base_relative_entropyResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__base_USCORErelative_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCORErelative_USCOREentropyResponse, "ns1:base_relative_entropyResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__view_USCOREcds(struct soap *soap)
{	struct ns1__view_USCOREcds soap_tmp_ns1__view_USCOREcds;
	struct ns1__view_USCOREcdsResponse soap_tmp_ns1__view_USCOREcdsResponse;
	char * soap_tmp_string;
	soap_default_ns1__view_USCOREcdsResponse(soap, &soap_tmp_ns1__view_USCOREcdsResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__view_USCOREcdsResponse._result = &soap_tmp_string;
	soap_default_ns1__view_USCOREcds(soap, &soap_tmp_ns1__view_USCOREcds);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__view_USCOREcds(soap, &soap_tmp_ns1__view_USCOREcds, "ns1:view_cds", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__view_USCOREcds(soap, soap_tmp_ns1__view_USCOREcds._sequence, soap_tmp_ns1__view_USCOREcds._params, soap_tmp_ns1__view_USCOREcdsResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__view_USCOREcdsResponse(soap, &soap_tmp_ns1__view_USCOREcdsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__view_USCOREcdsResponse(soap, &soap_tmp_ns1__view_USCOREcdsResponse, "ns1:view_cdsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__view_USCOREcdsResponse(soap, &soap_tmp_ns1__view_USCOREcdsResponse, "ns1:view_cdsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__query_USCOREstrand(struct soap *soap)
{	struct ns1__query_USCOREstrand soap_tmp_ns1__query_USCOREstrand;
	struct ns1__query_USCOREstrandResponse soap_tmp_ns1__query_USCOREstrandResponse;
	char * soap_tmp_string;
	soap_default_ns1__query_USCOREstrandResponse(soap, &soap_tmp_ns1__query_USCOREstrandResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__query_USCOREstrandResponse._result = &soap_tmp_string;
	soap_default_ns1__query_USCOREstrand(soap, &soap_tmp_ns1__query_USCOREstrand);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__query_USCOREstrand(soap, &soap_tmp_ns1__query_USCOREstrand, "ns1:query_strand", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__query_USCOREstrand(soap, soap_tmp_ns1__query_USCOREstrand._sequence, soap_tmp_ns1__query_USCOREstrand._position, soap_tmp_ns1__query_USCOREstrand._params, soap_tmp_ns1__query_USCOREstrandResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__query_USCOREstrandResponse(soap, &soap_tmp_ns1__query_USCOREstrandResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__query_USCOREstrandResponse(soap, &soap_tmp_ns1__query_USCOREstrandResponse, "ns1:query_strandResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__query_USCOREstrandResponse(soap, &soap_tmp_ns1__query_USCOREstrandResponse, "ns1:query_strandResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__genomicskew(struct soap *soap)
{	struct ns1__genomicskew soap_tmp_ns1__genomicskew;
	struct ns1__genomicskewResponse soap_tmp_ns1__genomicskewResponse;
	char * soap_tmp_string;
	soap_default_ns1__genomicskewResponse(soap, &soap_tmp_ns1__genomicskewResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__genomicskewResponse._result = &soap_tmp_string;
	soap_default_ns1__genomicskew(soap, &soap_tmp_ns1__genomicskew);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__genomicskew(soap, &soap_tmp_ns1__genomicskew, "ns1:genomicskew", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__genomicskew(soap, soap_tmp_ns1__genomicskew._sequence, soap_tmp_ns1__genomicskew._params, soap_tmp_ns1__genomicskewResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__genomicskewResponse(soap, &soap_tmp_ns1__genomicskewResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__genomicskewResponse(soap, &soap_tmp_ns1__genomicskewResponse, "ns1:genomicskewResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__genomicskewResponse(soap, &soap_tmp_ns1__genomicskewResponse, "ns1:genomicskewResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__filter_USCOREcds_USCOREby_USCOREatg(struct soap *soap)
{	struct ns1__filter_USCOREcds_USCOREby_USCOREatg soap_tmp_ns1__filter_USCOREcds_USCOREby_USCOREatg;
	struct ns1__filter_USCOREcds_USCOREby_USCOREatgResponse _param_2;
	soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, &_param_2);
	soap_default_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, &soap_tmp_ns1__filter_USCOREcds_USCOREby_USCOREatg);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, &soap_tmp_ns1__filter_USCOREcds_USCOREby_USCOREatg, "ns1:filter_cds_by_atg", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__filter_USCOREcds_USCOREby_USCOREatg(soap, soap_tmp_ns1__filter_USCOREcds_USCOREby_USCOREatg._sequence, soap_tmp_ns1__filter_USCOREcds_USCOREby_USCOREatg._params, &_param_2);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, &_param_2);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, &_param_2, "ns1:filter_cds_by_atgResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__filter_USCOREcds_USCOREby_USCOREatgResponse(soap, &_param_2, "ns1:filter_cds_by_atgResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__gcsi(struct soap *soap)
{	struct ns1__gcsi soap_tmp_ns1__gcsi;
	struct ns1__gcsiResponse soap_tmp_ns1__gcsiResponse;
	char * soap_tmp_string;
	soap_default_ns1__gcsiResponse(soap, &soap_tmp_ns1__gcsiResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__gcsiResponse._result = &soap_tmp_string;
	soap_default_ns1__gcsi(soap, &soap_tmp_ns1__gcsi);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__gcsi(soap, &soap_tmp_ns1__gcsi, "ns1:gcsi", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__gcsi(soap, soap_tmp_ns1__gcsi._sequence, soap_tmp_ns1__gcsi._params, soap_tmp_ns1__gcsiResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__gcsiResponse(soap, &soap_tmp_ns1__gcsiResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__gcsiResponse(soap, &soap_tmp_ns1__gcsiResponse, "ns1:gcsiResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__gcsiResponse(soap, &soap_tmp_ns1__gcsiResponse, "ns1:gcsiResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__cai(struct soap *soap)
{	struct ns1__cai soap_tmp_ns1__cai;
	struct ns1__caiResponse soap_tmp_ns1__caiResponse;
	char * soap_tmp_string;
	soap_default_ns1__caiResponse(soap, &soap_tmp_ns1__caiResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__caiResponse._result = &soap_tmp_string;
	soap_default_ns1__cai(soap, &soap_tmp_ns1__cai);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__cai(soap, &soap_tmp_ns1__cai, "ns1:cai", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__cai(soap, soap_tmp_ns1__cai._sequence, soap_tmp_ns1__cai._params, soap_tmp_ns1__caiResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__caiResponse(soap, &soap_tmp_ns1__caiResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__caiResponse(soap, &soap_tmp_ns1__caiResponse, "ns1:caiResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__caiResponse(soap, &soap_tmp_ns1__caiResponse, "ns1:caiResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__maxdex(struct soap *soap)
{	struct ns1__maxdex soap_tmp_ns1__maxdex;
	struct ns1__maxdexResponse soap_tmp_ns1__maxdexResponse;
	char * soap_tmp_string;
	soap_default_ns1__maxdexResponse(soap, &soap_tmp_ns1__maxdexResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__maxdexResponse._result = &soap_tmp_string;
	soap_default_ns1__maxdex(soap, &soap_tmp_ns1__maxdex);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__maxdex(soap, &soap_tmp_ns1__maxdex, "ns1:maxdex", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__maxdex(soap, soap_tmp_ns1__maxdex._array, soap_tmp_ns1__maxdexResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__maxdexResponse(soap, &soap_tmp_ns1__maxdexResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__maxdexResponse(soap, &soap_tmp_ns1__maxdexResponse, "ns1:maxdexResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__maxdexResponse(soap, &soap_tmp_ns1__maxdexResponse, "ns1:maxdexResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__max(struct soap *soap)
{	struct ns1__max soap_tmp_ns1__max;
	struct ns1__maxResponse soap_tmp_ns1__maxResponse;
	char * soap_tmp_string;
	soap_default_ns1__maxResponse(soap, &soap_tmp_ns1__maxResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__maxResponse._result = &soap_tmp_string;
	soap_default_ns1__max(soap, &soap_tmp_ns1__max);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__max(soap, &soap_tmp_ns1__max, "ns1:max", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__max(soap, soap_tmp_ns1__max._array, soap_tmp_ns1__maxResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__maxResponse(soap, &soap_tmp_ns1__maxResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__maxResponse(soap, &soap_tmp_ns1__maxResponse, "ns1:maxResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__maxResponse(soap, &soap_tmp_ns1__maxResponse, "ns1:maxResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__query_USCOREarm(struct soap *soap)
{	struct ns1__query_USCOREarm soap_tmp_ns1__query_USCOREarm;
	struct ns1__query_USCOREarmResponse soap_tmp_ns1__query_USCOREarmResponse;
	char * soap_tmp_string;
	soap_default_ns1__query_USCOREarmResponse(soap, &soap_tmp_ns1__query_USCOREarmResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__query_USCOREarmResponse._result = &soap_tmp_string;
	soap_default_ns1__query_USCOREarm(soap, &soap_tmp_ns1__query_USCOREarm);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__query_USCOREarm(soap, &soap_tmp_ns1__query_USCOREarm, "ns1:query_arm", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__query_USCOREarm(soap, soap_tmp_ns1__query_USCOREarm._sequence, soap_tmp_ns1__query_USCOREarm._position, soap_tmp_ns1__query_USCOREarmResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__query_USCOREarmResponse(soap, &soap_tmp_ns1__query_USCOREarmResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__query_USCOREarmResponse(soap, &soap_tmp_ns1__query_USCOREarmResponse, "ns1:query_armResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__query_USCOREarmResponse(soap, &soap_tmp_ns1__query_USCOREarmResponse, "ns1:query_armResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__mindex(struct soap *soap)
{	struct ns1__mindex soap_tmp_ns1__mindex;
	struct ns1__mindexResponse soap_tmp_ns1__mindexResponse;
	char * soap_tmp_string;
	soap_default_ns1__mindexResponse(soap, &soap_tmp_ns1__mindexResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__mindexResponse._result = &soap_tmp_string;
	soap_default_ns1__mindex(soap, &soap_tmp_ns1__mindex);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__mindex(soap, &soap_tmp_ns1__mindex, "ns1:mindex", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__mindex(soap, soap_tmp_ns1__mindex._array, soap_tmp_ns1__mindexResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__mindexResponse(soap, &soap_tmp_ns1__mindexResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__mindexResponse(soap, &soap_tmp_ns1__mindexResponse, "ns1:mindexResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__mindexResponse(soap, &soap_tmp_ns1__mindexResponse, "ns1:mindexResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__consensus_USCOREz(struct soap *soap)
{	struct ns1__consensus_USCOREz soap_tmp_ns1__consensus_USCOREz;
	struct ns1__consensus_USCOREzResponse soap_tmp_ns1__consensus_USCOREzResponse;
	char * soap_tmp_string;
	soap_default_ns1__consensus_USCOREzResponse(soap, &soap_tmp_ns1__consensus_USCOREzResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__consensus_USCOREzResponse._result = &soap_tmp_string;
	soap_default_ns1__consensus_USCOREz(soap, &soap_tmp_ns1__consensus_USCOREz);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__consensus_USCOREz(soap, &soap_tmp_ns1__consensus_USCOREz, "ns1:consensus_z", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__consensus_USCOREz(soap, soap_tmp_ns1__consensus_USCOREz._array_USCOREseq, soap_tmp_ns1__consensus_USCOREz._params, soap_tmp_ns1__consensus_USCOREzResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__consensus_USCOREzResponse(soap, &soap_tmp_ns1__consensus_USCOREzResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__consensus_USCOREzResponse(soap, &soap_tmp_ns1__consensus_USCOREzResponse, "ns1:consensus_zResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__consensus_USCOREzResponse(soap, &soap_tmp_ns1__consensus_USCOREzResponse, "ns1:consensus_zResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__genome_USCOREmap(struct soap *soap)
{	struct ns1__genome_USCOREmap soap_tmp_ns1__genome_USCOREmap;
	struct ns1__genome_USCOREmapResponse soap_tmp_ns1__genome_USCOREmapResponse;
	char * soap_tmp_string;
	soap_default_ns1__genome_USCOREmapResponse(soap, &soap_tmp_ns1__genome_USCOREmapResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__genome_USCOREmapResponse._result = &soap_tmp_string;
	soap_default_ns1__genome_USCOREmap(soap, &soap_tmp_ns1__genome_USCOREmap);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__genome_USCOREmap(soap, &soap_tmp_ns1__genome_USCOREmap, "ns1:genome_map", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__genome_USCOREmap(soap, soap_tmp_ns1__genome_USCOREmap._sequence, soap_tmp_ns1__genome_USCOREmap._params, soap_tmp_ns1__genome_USCOREmapResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__genome_USCOREmapResponse(soap, &soap_tmp_ns1__genome_USCOREmapResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__genome_USCOREmapResponse(soap, &soap_tmp_ns1__genome_USCOREmapResponse, "ns1:genome_mapResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__genome_USCOREmapResponse(soap, &soap_tmp_ns1__genome_USCOREmapResponse, "ns1:genome_mapResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__longest_USCOREORF(struct soap *soap)
{	struct ns1__longest_USCOREORF soap_tmp_ns1__longest_USCOREORF;
	struct ns1__longest_USCOREORFResponse soap_tmp_ns1__longest_USCOREORFResponse;
	char * soap_tmp_string;
	soap_default_ns1__longest_USCOREORFResponse(soap, &soap_tmp_ns1__longest_USCOREORFResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__longest_USCOREORFResponse._result = &soap_tmp_string;
	soap_default_ns1__longest_USCOREORF(soap, &soap_tmp_ns1__longest_USCOREORF);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__longest_USCOREORF(soap, &soap_tmp_ns1__longest_USCOREORF, "ns1:longest_ORF", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__longest_USCOREORF(soap, soap_tmp_ns1__longest_USCOREORF._sequence, soap_tmp_ns1__longest_USCOREORFResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__longest_USCOREORFResponse(soap, &soap_tmp_ns1__longest_USCOREORFResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__longest_USCOREORFResponse(soap, &soap_tmp_ns1__longest_USCOREORFResponse, "ns1:longest_ORFResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__longest_USCOREORFResponse(soap, &soap_tmp_ns1__longest_USCOREORFResponse, "ns1:longest_ORFResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__rep_USCOREori_USCOREter(struct soap *soap)
{	struct ns1__rep_USCOREori_USCOREter soap_tmp_ns1__rep_USCOREori_USCOREter;
	struct ns1__rep_USCOREori_USCOREterResponse soap_tmp_ns1__rep_USCOREori_USCOREterResponse;
	char * soap_tmp_string;
	soap_default_ns1__rep_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__rep_USCOREori_USCOREterResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__rep_USCOREori_USCOREterResponse._result = &soap_tmp_string;
	soap_default_ns1__rep_USCOREori_USCOREter(soap, &soap_tmp_ns1__rep_USCOREori_USCOREter);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__rep_USCOREori_USCOREter(soap, &soap_tmp_ns1__rep_USCOREori_USCOREter, "ns1:rep_ori_ter", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__rep_USCOREori_USCOREter(soap, soap_tmp_ns1__rep_USCOREori_USCOREter._sequence, soap_tmp_ns1__rep_USCOREori_USCOREter._params, soap_tmp_ns1__rep_USCOREori_USCOREterResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__rep_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__rep_USCOREori_USCOREterResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__rep_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__rep_USCOREori_USCOREterResponse, "ns1:rep_ori_terResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__rep_USCOREori_USCOREterResponse(soap, &soap_tmp_ns1__rep_USCOREori_USCOREterResponse, "ns1:rep_ori_terResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__calc_USCOREpI(struct soap *soap)
{	struct ns1__calc_USCOREpI soap_tmp_ns1__calc_USCOREpI;
	struct ns1__calc_USCOREpIResponse soap_tmp_ns1__calc_USCOREpIResponse;
	char * soap_tmp_string;
	soap_default_ns1__calc_USCOREpIResponse(soap, &soap_tmp_ns1__calc_USCOREpIResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__calc_USCOREpIResponse._result = &soap_tmp_string;
	soap_default_ns1__calc_USCOREpI(soap, &soap_tmp_ns1__calc_USCOREpI);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__calc_USCOREpI(soap, &soap_tmp_ns1__calc_USCOREpI, "ns1:calc_pI", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__calc_USCOREpI(soap, soap_tmp_ns1__calc_USCOREpI._sequence, soap_tmp_ns1__calc_USCOREpIResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__calc_USCOREpIResponse(soap, &soap_tmp_ns1__calc_USCOREpIResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__calc_USCOREpIResponse(soap, &soap_tmp_ns1__calc_USCOREpIResponse, "ns1:calc_pIResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__calc_USCOREpIResponse(soap, &soap_tmp_ns1__calc_USCOREpIResponse, "ns1:calc_pIResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__DoubleHelix(struct soap *soap)
{	struct ns1__DoubleHelix soap_tmp_ns1__DoubleHelix;
	struct ns1__DoubleHelixResponse soap_tmp_ns1__DoubleHelixResponse;
	char * soap_tmp_string;
	soap_default_ns1__DoubleHelixResponse(soap, &soap_tmp_ns1__DoubleHelixResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__DoubleHelixResponse._result = &soap_tmp_string;
	soap_default_ns1__DoubleHelix(soap, &soap_tmp_ns1__DoubleHelix);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__DoubleHelix(soap, &soap_tmp_ns1__DoubleHelix, "ns1:DoubleHelix", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__DoubleHelix(soap, soap_tmp_ns1__DoubleHelix._sequence, soap_tmp_ns1__DoubleHelix._params, soap_tmp_ns1__DoubleHelixResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__DoubleHelixResponse(soap, &soap_tmp_ns1__DoubleHelixResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__DoubleHelixResponse(soap, &soap_tmp_ns1__DoubleHelixResponse, "ns1:DoubleHelixResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__DoubleHelixResponse(soap, &soap_tmp_ns1__DoubleHelixResponse, "ns1:DoubleHelixResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__base_USCOREentropy(struct soap *soap)
{	struct ns1__base_USCOREentropy soap_tmp_ns1__base_USCOREentropy;
	struct ns1__base_USCOREentropyResponse soap_tmp_ns1__base_USCOREentropyResponse;
	char * soap_tmp_string;
	soap_default_ns1__base_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCOREentropyResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__base_USCOREentropyResponse._result = &soap_tmp_string;
	soap_default_ns1__base_USCOREentropy(soap, &soap_tmp_ns1__base_USCOREentropy);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__base_USCOREentropy(soap, &soap_tmp_ns1__base_USCOREentropy, "ns1:base_entropy", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__base_USCOREentropy(soap, soap_tmp_ns1__base_USCOREentropy._sequence, soap_tmp_ns1__base_USCOREentropy._params, soap_tmp_ns1__base_USCOREentropyResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__base_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCOREentropyResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__base_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCOREentropyResponse, "ns1:base_entropyResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__base_USCOREentropyResponse(soap, &soap_tmp_ns1__base_USCOREentropyResponse, "ns1:base_entropyResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__to_USCOREfasta(struct soap *soap)
{	struct ns1__to_USCOREfasta soap_tmp_ns1__to_USCOREfasta;
	struct ns1__to_USCOREfastaResponse soap_tmp_ns1__to_USCOREfastaResponse;
	char * soap_tmp_string;
	soap_default_ns1__to_USCOREfastaResponse(soap, &soap_tmp_ns1__to_USCOREfastaResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__to_USCOREfastaResponse._result = &soap_tmp_string;
	soap_default_ns1__to_USCOREfasta(soap, &soap_tmp_ns1__to_USCOREfasta);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__to_USCOREfasta(soap, &soap_tmp_ns1__to_USCOREfasta, "ns1:to_fasta", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__to_USCOREfasta(soap, soap_tmp_ns1__to_USCOREfasta._sequence, soap_tmp_ns1__to_USCOREfasta._params, soap_tmp_ns1__to_USCOREfastaResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__to_USCOREfastaResponse(soap, &soap_tmp_ns1__to_USCOREfastaResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__to_USCOREfastaResponse(soap, &soap_tmp_ns1__to_USCOREfastaResponse, "ns1:to_fastaResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__to_USCOREfastaResponse(soap, &soap_tmp_ns1__to_USCOREfastaResponse, "ns1:to_fastaResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__find_USCOREdif(struct soap *soap)
{	struct ns1__find_USCOREdif soap_tmp_ns1__find_USCOREdif;
	struct ns1__find_USCOREdifResponse _param_3;
	soap_default_ns1__find_USCOREdifResponse(soap, &_param_3);
	soap_default_ns1__find_USCOREdif(soap, &soap_tmp_ns1__find_USCOREdif);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__find_USCOREdif(soap, &soap_tmp_ns1__find_USCOREdif, "ns1:find_dif", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__find_USCOREdif(soap, soap_tmp_ns1__find_USCOREdif._sequence, soap_tmp_ns1__find_USCOREdif._params, &_param_3);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__find_USCOREdifResponse(soap, &_param_3);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__find_USCOREdifResponse(soap, &_param_3, "ns1:find_difResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__find_USCOREdifResponse(soap, &_param_3, "ns1:find_difResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__cbi(struct soap *soap)
{	struct ns1__cbi soap_tmp_ns1__cbi;
	struct ns1__cbiResponse soap_tmp_ns1__cbiResponse;
	char * soap_tmp_string;
	soap_default_ns1__cbiResponse(soap, &soap_tmp_ns1__cbiResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__cbiResponse._result = &soap_tmp_string;
	soap_default_ns1__cbi(soap, &soap_tmp_ns1__cbi);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__cbi(soap, &soap_tmp_ns1__cbi, "ns1:cbi", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__cbi(soap, soap_tmp_ns1__cbi._sequence, soap_tmp_ns1__cbi._params, soap_tmp_ns1__cbiResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__cbiResponse(soap, &soap_tmp_ns1__cbiResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__cbiResponse(soap, &soap_tmp_ns1__cbiResponse, "ns1:cbiResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__cbiResponse(soap, &soap_tmp_ns1__cbiResponse, "ns1:cbiResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__genes_USCOREfrom_USCOREori(struct soap *soap)
{	struct ns1__genes_USCOREfrom_USCOREori soap_tmp_ns1__genes_USCOREfrom_USCOREori;
	struct ns1__genes_USCOREfrom_USCOREoriResponse _param_4;
	soap_default_ns1__genes_USCOREfrom_USCOREoriResponse(soap, &_param_4);
	soap_default_ns1__genes_USCOREfrom_USCOREori(soap, &soap_tmp_ns1__genes_USCOREfrom_USCOREori);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__genes_USCOREfrom_USCOREori(soap, &soap_tmp_ns1__genes_USCOREfrom_USCOREori, "ns1:genes_from_ori", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__genes_USCOREfrom_USCOREori(soap, soap_tmp_ns1__genes_USCOREfrom_USCOREori._sequence, soap_tmp_ns1__genes_USCOREfrom_USCOREori._direction, soap_tmp_ns1__genes_USCOREfrom_USCOREori._params, &_param_4);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__genes_USCOREfrom_USCOREoriResponse(soap, &_param_4);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__genes_USCOREfrom_USCOREoriResponse(soap, &_param_4, "ns1:genes_from_oriResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__genes_USCOREfrom_USCOREoriResponse(soap, &_param_4, "ns1:genes_from_oriResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__geneskew(struct soap *soap)
{	struct ns1__geneskew soap_tmp_ns1__geneskew;
	struct ns1__geneskewResponse soap_tmp_ns1__geneskewResponse;
	char * soap_tmp_string;
	soap_default_ns1__geneskewResponse(soap, &soap_tmp_ns1__geneskewResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__geneskewResponse._result = &soap_tmp_string;
	soap_default_ns1__geneskew(soap, &soap_tmp_ns1__geneskew);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__geneskew(soap, &soap_tmp_ns1__geneskew, "ns1:geneskew", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__geneskew(soap, soap_tmp_ns1__geneskew._sequence, soap_tmp_ns1__geneskew._params, soap_tmp_ns1__geneskewResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__geneskewResponse(soap, &soap_tmp_ns1__geneskewResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__geneskewResponse(soap, &soap_tmp_ns1__geneskewResponse, "ns1:geneskewResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__geneskewResponse(soap, &soap_tmp_ns1__geneskewResponse, "ns1:geneskewResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__standard_USCOREdeviation(struct soap *soap)
{	struct ns1__standard_USCOREdeviation soap_tmp_ns1__standard_USCOREdeviation;
	struct ns1__standard_USCOREdeviationResponse soap_tmp_ns1__standard_USCOREdeviationResponse;
	char * soap_tmp_string;
	soap_default_ns1__standard_USCOREdeviationResponse(soap, &soap_tmp_ns1__standard_USCOREdeviationResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__standard_USCOREdeviationResponse._result = &soap_tmp_string;
	soap_default_ns1__standard_USCOREdeviation(soap, &soap_tmp_ns1__standard_USCOREdeviation);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__standard_USCOREdeviation(soap, &soap_tmp_ns1__standard_USCOREdeviation, "ns1:standard_deviation", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__standard_USCOREdeviation(soap, soap_tmp_ns1__standard_USCOREdeviation._array, soap_tmp_ns1__standard_USCOREdeviationResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__standard_USCOREdeviationResponse(soap, &soap_tmp_ns1__standard_USCOREdeviationResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__standard_USCOREdeviationResponse(soap, &soap_tmp_ns1__standard_USCOREdeviationResponse, "ns1:standard_deviationResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__standard_USCOREdeviationResponse(soap, &soap_tmp_ns1__standard_USCOREdeviationResponse, "ns1:standard_deviationResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__cor(struct soap *soap)
{	struct ns1__cor soap_tmp_ns1__cor;
	struct ns1__corResponse _param_5;
	soap_default_ns1__corResponse(soap, &_param_5);
	soap_default_ns1__cor(soap, &soap_tmp_ns1__cor);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__cor(soap, &soap_tmp_ns1__cor, "ns1:cor", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__cor(soap, soap_tmp_ns1__cor._array1, soap_tmp_ns1__cor._array2, soap_tmp_ns1__cor._params, &_param_5);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__corResponse(soap, &_param_5);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__corResponse(soap, &_param_5, "ns1:corResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__corResponse(soap, &_param_5, "ns1:corResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__cumulative(struct soap *soap)
{	struct ns1__cumulative soap_tmp_ns1__cumulative;
	struct ns1__cumulativeResponse _param_6;
	soap_default_ns1__cumulativeResponse(soap, &_param_6);
	soap_default_ns1__cumulative(soap, &soap_tmp_ns1__cumulative);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__cumulative(soap, &soap_tmp_ns1__cumulative, "ns1:cumulative", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__cumulative(soap, soap_tmp_ns1__cumulative._array, &_param_6);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__cumulativeResponse(soap, &_param_6);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__cumulativeResponse(soap, &_param_6, "ns1:cumulativeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__cumulativeResponse(soap, &_param_6, "ns1:cumulativeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__delta_USCOREenc(struct soap *soap)
{	struct ns1__delta_USCOREenc soap_tmp_ns1__delta_USCOREenc;
	struct ns1__delta_USCOREencResponse soap_tmp_ns1__delta_USCOREencResponse;
	char * soap_tmp_string;
	soap_default_ns1__delta_USCOREencResponse(soap, &soap_tmp_ns1__delta_USCOREencResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__delta_USCOREencResponse._result = &soap_tmp_string;
	soap_default_ns1__delta_USCOREenc(soap, &soap_tmp_ns1__delta_USCOREenc);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__delta_USCOREenc(soap, &soap_tmp_ns1__delta_USCOREenc, "ns1:delta_enc", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__delta_USCOREenc(soap, soap_tmp_ns1__delta_USCOREenc._sequence, soap_tmp_ns1__delta_USCOREencResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__delta_USCOREencResponse(soap, &soap_tmp_ns1__delta_USCOREencResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__delta_USCOREencResponse(soap, &soap_tmp_ns1__delta_USCOREencResponse, "ns1:delta_encResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__delta_USCOREencResponse(soap, &soap_tmp_ns1__delta_USCOREencResponse, "ns1:delta_encResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__delta_USCOREgcskew(struct soap *soap)
{	struct ns1__delta_USCOREgcskew soap_tmp_ns1__delta_USCOREgcskew;
	struct ns1__delta_USCOREgcskewResponse soap_tmp_ns1__delta_USCOREgcskewResponse;
	char * soap_tmp_string;
	soap_default_ns1__delta_USCOREgcskewResponse(soap, &soap_tmp_ns1__delta_USCOREgcskewResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__delta_USCOREgcskewResponse._result = &soap_tmp_string;
	soap_default_ns1__delta_USCOREgcskew(soap, &soap_tmp_ns1__delta_USCOREgcskew);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__delta_USCOREgcskew(soap, &soap_tmp_ns1__delta_USCOREgcskew, "ns1:delta_gcskew", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__delta_USCOREgcskew(soap, soap_tmp_ns1__delta_USCOREgcskew._sequence, soap_tmp_ns1__delta_USCOREgcskew._params, soap_tmp_ns1__delta_USCOREgcskewResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__delta_USCOREgcskewResponse(soap, &soap_tmp_ns1__delta_USCOREgcskewResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__delta_USCOREgcskewResponse(soap, &soap_tmp_ns1__delta_USCOREgcskewResponse, "ns1:delta_gcskewResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__delta_USCOREgcskewResponse(soap, &soap_tmp_ns1__delta_USCOREgcskewResponse, "ns1:delta_gcskewResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__molecular_USCOREweight(struct soap *soap)
{	struct ns1__molecular_USCOREweight soap_tmp_ns1__molecular_USCOREweight;
	struct ns1__molecular_USCOREweightResponse soap_tmp_ns1__molecular_USCOREweightResponse;
	char * soap_tmp_string;
	soap_default_ns1__molecular_USCOREweightResponse(soap, &soap_tmp_ns1__molecular_USCOREweightResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__molecular_USCOREweightResponse._result = &soap_tmp_string;
	soap_default_ns1__molecular_USCOREweight(soap, &soap_tmp_ns1__molecular_USCOREweight);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__molecular_USCOREweight(soap, &soap_tmp_ns1__molecular_USCOREweight, "ns1:molecular_weight", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__molecular_USCOREweight(soap, soap_tmp_ns1__molecular_USCOREweight._sequence, soap_tmp_ns1__molecular_USCOREweight._params, soap_tmp_ns1__molecular_USCOREweightResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__molecular_USCOREweightResponse(soap, &soap_tmp_ns1__molecular_USCOREweightResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__molecular_USCOREweightResponse(soap, &soap_tmp_ns1__molecular_USCOREweightResponse, "ns1:molecular_weightResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__molecular_USCOREweightResponse(soap, &soap_tmp_ns1__molecular_USCOREweightResponse, "ns1:molecular_weightResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__gcskew(struct soap *soap)
{	struct ns1__gcskew soap_tmp_ns1__gcskew;
	struct ns1__gcskewResponse soap_tmp_ns1__gcskewResponse;
	char * soap_tmp_string;
	soap_default_ns1__gcskewResponse(soap, &soap_tmp_ns1__gcskewResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__gcskewResponse._result = &soap_tmp_string;
	soap_default_ns1__gcskew(soap, &soap_tmp_ns1__gcskew);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__gcskew(soap, &soap_tmp_ns1__gcskew, "ns1:gcskew", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__gcskew(soap, soap_tmp_ns1__gcskew._sequence, soap_tmp_ns1__gcskew._params, soap_tmp_ns1__gcskewResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__gcskewResponse(soap, &soap_tmp_ns1__gcskewResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__gcskewResponse(soap, &soap_tmp_ns1__gcskewResponse, "ns1:gcskewResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__gcskewResponse(soap, &soap_tmp_ns1__gcskewResponse, "ns1:gcskewResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__genome_USCOREmap3(struct soap *soap)
{	struct ns1__genome_USCOREmap3 soap_tmp_ns1__genome_USCOREmap3;
	struct ns1__genome_USCOREmap3Response soap_tmp_ns1__genome_USCOREmap3Response;
	char * soap_tmp_string;
	soap_default_ns1__genome_USCOREmap3Response(soap, &soap_tmp_ns1__genome_USCOREmap3Response);
	soap_tmp_string = NULL;
	soap_tmp_ns1__genome_USCOREmap3Response._result = &soap_tmp_string;
	soap_default_ns1__genome_USCOREmap3(soap, &soap_tmp_ns1__genome_USCOREmap3);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__genome_USCOREmap3(soap, &soap_tmp_ns1__genome_USCOREmap3, "ns1:genome_map3", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__genome_USCOREmap3(soap, soap_tmp_ns1__genome_USCOREmap3._sequence, soap_tmp_ns1__genome_USCOREmap3._params, soap_tmp_ns1__genome_USCOREmap3Response._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__genome_USCOREmap3Response(soap, &soap_tmp_ns1__genome_USCOREmap3Response);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__genome_USCOREmap3Response(soap, &soap_tmp_ns1__genome_USCOREmap3Response, "ns1:genome_map3Response", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__genome_USCOREmap3Response(soap, &soap_tmp_ns1__genome_USCOREmap3Response, "ns1:genome_map3Response", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__seqinfo(struct soap *soap)
{	struct ns1__seqinfo soap_tmp_ns1__seqinfo;
	struct ns1__seqinfoResponse soap_tmp_ns1__seqinfoResponse;
	char * soap_tmp_string;
	soap_default_ns1__seqinfoResponse(soap, &soap_tmp_ns1__seqinfoResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__seqinfoResponse._result = &soap_tmp_string;
	soap_default_ns1__seqinfo(soap, &soap_tmp_ns1__seqinfo);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__seqinfo(soap, &soap_tmp_ns1__seqinfo, "ns1:seqinfo", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__seqinfo(soap, soap_tmp_ns1__seqinfo._sequence, soap_tmp_ns1__seqinfoResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__seqinfoResponse(soap, &soap_tmp_ns1__seqinfoResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__seqinfoResponse(soap, &soap_tmp_ns1__seqinfoResponse, "ns1:seqinfoResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__seqinfoResponse(soap, &soap_tmp_ns1__seqinfoResponse, "ns1:seqinfoResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__signature(struct soap *soap)
{	struct ns1__signature soap_tmp_ns1__signature;
	struct ns1__signatureResponse soap_tmp_ns1__signatureResponse;
	char * soap_tmp_string;
	soap_default_ns1__signatureResponse(soap, &soap_tmp_ns1__signatureResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__signatureResponse._result = &soap_tmp_string;
	soap_default_ns1__signature(soap, &soap_tmp_ns1__signature);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__signature(soap, &soap_tmp_ns1__signature, "ns1:signature", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__signature(soap, soap_tmp_ns1__signature._sequence, soap_tmp_ns1__signature._params, soap_tmp_ns1__signatureResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__signatureResponse(soap, &soap_tmp_ns1__signatureResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__signatureResponse(soap, &soap_tmp_ns1__signatureResponse, "ns1:signatureResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__signatureResponse(soap, &soap_tmp_ns1__signatureResponse, "ns1:signatureResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__base_USCOREinformation_USCOREcontent(struct soap *soap)
{	struct ns1__base_USCOREinformation_USCOREcontent soap_tmp_ns1__base_USCOREinformation_USCOREcontent;
	struct ns1__base_USCOREinformation_USCOREcontentResponse soap_tmp_ns1__base_USCOREinformation_USCOREcontentResponse;
	char * soap_tmp_string;
	soap_default_ns1__base_USCOREinformation_USCOREcontentResponse(soap, &soap_tmp_ns1__base_USCOREinformation_USCOREcontentResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__base_USCOREinformation_USCOREcontentResponse._result = &soap_tmp_string;
	soap_default_ns1__base_USCOREinformation_USCOREcontent(soap, &soap_tmp_ns1__base_USCOREinformation_USCOREcontent);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__base_USCOREinformation_USCOREcontent(soap, &soap_tmp_ns1__base_USCOREinformation_USCOREcontent, "ns1:base_information_content", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__base_USCOREinformation_USCOREcontent(soap, soap_tmp_ns1__base_USCOREinformation_USCOREcontent._sequence, soap_tmp_ns1__base_USCOREinformation_USCOREcontent._params, soap_tmp_ns1__base_USCOREinformation_USCOREcontentResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__base_USCOREinformation_USCOREcontentResponse(soap, &soap_tmp_ns1__base_USCOREinformation_USCOREcontentResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__base_USCOREinformation_USCOREcontentResponse(soap, &soap_tmp_ns1__base_USCOREinformation_USCOREcontentResponse, "ns1:base_information_contentResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__base_USCOREinformation_USCOREcontentResponse(soap, &soap_tmp_ns1__base_USCOREinformation_USCOREcontentResponse, "ns1:base_information_contentResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__dnawalk(struct soap *soap)
{	struct ns1__dnawalk soap_tmp_ns1__dnawalk;
	struct ns1__dnawalkResponse soap_tmp_ns1__dnawalkResponse;
	char * soap_tmp_string;
	soap_default_ns1__dnawalkResponse(soap, &soap_tmp_ns1__dnawalkResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__dnawalkResponse._result = &soap_tmp_string;
	soap_default_ns1__dnawalk(soap, &soap_tmp_ns1__dnawalk);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__dnawalk(soap, &soap_tmp_ns1__dnawalk, "ns1:dnawalk", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__dnawalk(soap, soap_tmp_ns1__dnawalk._sequence, soap_tmp_ns1__dnawalk._params, soap_tmp_ns1__dnawalkResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__dnawalkResponse(soap, &soap_tmp_ns1__dnawalkResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__dnawalkResponse(soap, &soap_tmp_ns1__dnawalkResponse, "ns1:dnawalkResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__dnawalkResponse(soap, &soap_tmp_ns1__dnawalkResponse, "ns1:dnawalkResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__find_USCOREter(struct soap *soap)
{	struct ns1__find_USCOREter soap_tmp_ns1__find_USCOREter;
	struct ns1__find_USCOREterResponse _param_7;
	soap_default_ns1__find_USCOREterResponse(soap, &_param_7);
	soap_default_ns1__find_USCOREter(soap, &soap_tmp_ns1__find_USCOREter);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__find_USCOREter(soap, &soap_tmp_ns1__find_USCOREter, "ns1:find_ter", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__find_USCOREter(soap, soap_tmp_ns1__find_USCOREter._sequence, soap_tmp_ns1__find_USCOREter._params, &_param_7);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__find_USCOREterResponse(soap, &_param_7);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__find_USCOREterResponse(soap, &_param_7, "ns1:find_terResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__find_USCOREterResponse(soap, &_param_7, "ns1:find_terResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__shuffleseq(struct soap *soap)
{	struct ns1__shuffleseq soap_tmp_ns1__shuffleseq;
	struct ns1__shuffleseqResponse soap_tmp_ns1__shuffleseqResponse;
	char * soap_tmp_string;
	soap_default_ns1__shuffleseqResponse(soap, &soap_tmp_ns1__shuffleseqResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__shuffleseqResponse._result = &soap_tmp_string;
	soap_default_ns1__shuffleseq(soap, &soap_tmp_ns1__shuffleseq);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__shuffleseq(soap, &soap_tmp_ns1__shuffleseq, "ns1:shuffleseq", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__shuffleseq(soap, soap_tmp_ns1__shuffleseq._sequence, soap_tmp_ns1__shuffleseq._params, soap_tmp_ns1__shuffleseqResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__shuffleseqResponse(soap, &soap_tmp_ns1__shuffleseqResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__shuffleseqResponse(soap, &soap_tmp_ns1__shuffleseqResponse, "ns1:shuffleseqResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__shuffleseqResponse(soap, &soap_tmp_ns1__shuffleseqResponse, "ns1:shuffleseqResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__oligomer_USCOREsearch(struct soap *soap)
{	struct ns1__oligomer_USCOREsearch soap_tmp_ns1__oligomer_USCOREsearch;
	struct ns1__oligomer_USCOREsearchResponse _param_8;
	soap_default_ns1__oligomer_USCOREsearchResponse(soap, &_param_8);
	soap_default_ns1__oligomer_USCOREsearch(soap, &soap_tmp_ns1__oligomer_USCOREsearch);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__oligomer_USCOREsearch(soap, &soap_tmp_ns1__oligomer_USCOREsearch, "ns1:oligomer_search", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__oligomer_USCOREsearch(soap, soap_tmp_ns1__oligomer_USCOREsearch._sequence, soap_tmp_ns1__oligomer_USCOREsearch._oligomer, soap_tmp_ns1__oligomer_USCOREsearch._params, &_param_8);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__oligomer_USCOREsearchResponse(soap, &_param_8);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__oligomer_USCOREsearchResponse(soap, &_param_8, "ns1:oligomer_searchResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__oligomer_USCOREsearchResponse(soap, &_param_8, "ns1:oligomer_searchResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__find_USCOREpattern(struct soap *soap)
{	struct ns1__find_USCOREpattern soap_tmp_ns1__find_USCOREpattern;
	struct ns1__find_USCOREpatternResponse soap_tmp_ns1__find_USCOREpatternResponse;
	char * soap_tmp_string;
	soap_default_ns1__find_USCOREpatternResponse(soap, &soap_tmp_ns1__find_USCOREpatternResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__find_USCOREpatternResponse._result = &soap_tmp_string;
	soap_default_ns1__find_USCOREpattern(soap, &soap_tmp_ns1__find_USCOREpattern);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__find_USCOREpattern(soap, &soap_tmp_ns1__find_USCOREpattern, "ns1:find_pattern", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__find_USCOREpattern(soap, soap_tmp_ns1__find_USCOREpattern._sequence, soap_tmp_ns1__find_USCOREpattern._pattern, soap_tmp_ns1__find_USCOREpattern._params, soap_tmp_ns1__find_USCOREpatternResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__find_USCOREpatternResponse(soap, &soap_tmp_ns1__find_USCOREpatternResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__find_USCOREpatternResponse(soap, &soap_tmp_ns1__find_USCOREpatternResponse, "ns1:find_patternResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__find_USCOREpatternResponse(soap, &soap_tmp_ns1__find_USCOREpatternResponse, "ns1:find_patternResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__gcwin(struct soap *soap)
{	struct ns1__gcwin soap_tmp_ns1__gcwin;
	struct ns1__gcwinResponse soap_tmp_ns1__gcwinResponse;
	char * soap_tmp_string;
	soap_default_ns1__gcwinResponse(soap, &soap_tmp_ns1__gcwinResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__gcwinResponse._result = &soap_tmp_string;
	soap_default_ns1__gcwin(soap, &soap_tmp_ns1__gcwin);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__gcwin(soap, &soap_tmp_ns1__gcwin, "ns1:gcwin", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__gcwin(soap, soap_tmp_ns1__gcwin._sequence, soap_tmp_ns1__gcwin._params, soap_tmp_ns1__gcwinResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__gcwinResponse(soap, &soap_tmp_ns1__gcwinResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__gcwinResponse(soap, &soap_tmp_ns1__gcwinResponse, "ns1:gcwinResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__gcwinResponse(soap, &soap_tmp_ns1__gcwinResponse, "ns1:gcwinResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__oligomer_USCOREcounter(struct soap *soap)
{	struct ns1__oligomer_USCOREcounter soap_tmp_ns1__oligomer_USCOREcounter;
	struct ns1__oligomer_USCOREcounterResponse soap_tmp_ns1__oligomer_USCOREcounterResponse;
	char * soap_tmp_string;
	soap_default_ns1__oligomer_USCOREcounterResponse(soap, &soap_tmp_ns1__oligomer_USCOREcounterResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__oligomer_USCOREcounterResponse._result = &soap_tmp_string;
	soap_default_ns1__oligomer_USCOREcounter(soap, &soap_tmp_ns1__oligomer_USCOREcounter);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__oligomer_USCOREcounter(soap, &soap_tmp_ns1__oligomer_USCOREcounter, "ns1:oligomer_counter", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__oligomer_USCOREcounter(soap, soap_tmp_ns1__oligomer_USCOREcounter._sequence, soap_tmp_ns1__oligomer_USCOREcounter._oligomer, soap_tmp_ns1__oligomer_USCOREcounter._params, soap_tmp_ns1__oligomer_USCOREcounterResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__oligomer_USCOREcounterResponse(soap, &soap_tmp_ns1__oligomer_USCOREcounterResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__oligomer_USCOREcounterResponse(soap, &soap_tmp_ns1__oligomer_USCOREcounterResponse, "ns1:oligomer_counterResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__oligomer_USCOREcounterResponse(soap, &soap_tmp_ns1__oligomer_USCOREcounterResponse, "ns1:oligomer_counterResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__codon_USCOREusage(struct soap *soap)
{	struct ns1__codon_USCOREusage soap_tmp_ns1__codon_USCOREusage;
	struct ns1__codon_USCOREusageResponse soap_tmp_ns1__codon_USCOREusageResponse;
	char * soap_tmp_string;
	soap_default_ns1__codon_USCOREusageResponse(soap, &soap_tmp_ns1__codon_USCOREusageResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__codon_USCOREusageResponse._result = &soap_tmp_string;
	soap_default_ns1__codon_USCOREusage(soap, &soap_tmp_ns1__codon_USCOREusage);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__codon_USCOREusage(soap, &soap_tmp_ns1__codon_USCOREusage, "ns1:codon_usage", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__codon_USCOREusage(soap, soap_tmp_ns1__codon_USCOREusage._sequence, soap_tmp_ns1__codon_USCOREusage._params, soap_tmp_ns1__codon_USCOREusageResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__codon_USCOREusageResponse(soap, &soap_tmp_ns1__codon_USCOREusageResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__codon_USCOREusageResponse(soap, &soap_tmp_ns1__codon_USCOREusageResponse, "ns1:codon_usageResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__codon_USCOREusageResponse(soap, &soap_tmp_ns1__codon_USCOREusageResponse, "ns1:codon_usageResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__min(struct soap *soap)
{	struct ns1__min soap_tmp_ns1__min;
	struct ns1__minResponse soap_tmp_ns1__minResponse;
	char * soap_tmp_string;
	soap_default_ns1__minResponse(soap, &soap_tmp_ns1__minResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__minResponse._result = &soap_tmp_string;
	soap_default_ns1__min(soap, &soap_tmp_ns1__min);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__min(soap, &soap_tmp_ns1__min, "ns1:min", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__min(soap, soap_tmp_ns1__min._array, soap_tmp_ns1__minResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__minResponse(soap, &soap_tmp_ns1__minResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__minResponse(soap, &soap_tmp_ns1__minResponse, "ns1:minResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__minResponse(soap, &soap_tmp_ns1__minResponse, "ns1:minResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__find_USCOREiteron(struct soap *soap)
{	struct ns1__find_USCOREiteron soap_tmp_ns1__find_USCOREiteron;
	struct ns1__find_USCOREiteronResponse soap_tmp_ns1__find_USCOREiteronResponse;
	char * soap_tmp_string;
	soap_default_ns1__find_USCOREiteronResponse(soap, &soap_tmp_ns1__find_USCOREiteronResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__find_USCOREiteronResponse._result = &soap_tmp_string;
	soap_default_ns1__find_USCOREiteron(soap, &soap_tmp_ns1__find_USCOREiteron);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__find_USCOREiteron(soap, &soap_tmp_ns1__find_USCOREiteron, "ns1:find_iteron", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__find_USCOREiteron(soap, soap_tmp_ns1__find_USCOREiteron._sequence, soap_tmp_ns1__find_USCOREiteron._params, soap_tmp_ns1__find_USCOREiteronResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__find_USCOREiteronResponse(soap, &soap_tmp_ns1__find_USCOREiteronResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__find_USCOREiteronResponse(soap, &soap_tmp_ns1__find_USCOREiteronResponse, "ns1:find_iteronResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__find_USCOREiteronResponse(soap, &soap_tmp_ns1__find_USCOREiteronResponse, "ns1:find_iteronResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__complement(struct soap *soap)
{	struct ns1__complement soap_tmp_ns1__complement;
	struct ns1__complementResponse soap_tmp_ns1__complementResponse;
	char * soap_tmp_string;
	soap_default_ns1__complementResponse(soap, &soap_tmp_ns1__complementResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__complementResponse._result = &soap_tmp_string;
	soap_default_ns1__complement(soap, &soap_tmp_ns1__complement);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__complement(soap, &soap_tmp_ns1__complement, "ns1:complement", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__complement(soap, soap_tmp_ns1__complement._sequence, soap_tmp_ns1__complementResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__complementResponse(soap, &soap_tmp_ns1__complementResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__complementResponse(soap, &soap_tmp_ns1__complementResponse, "ns1:complementResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__complementResponse(soap, &soap_tmp_ns1__complementResponse, "ns1:complementResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__mean(struct soap *soap)
{	struct ns1__mean soap_tmp_ns1__mean;
	struct ns1__meanResponse soap_tmp_ns1__meanResponse;
	char * soap_tmp_string;
	soap_default_ns1__meanResponse(soap, &soap_tmp_ns1__meanResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__meanResponse._result = &soap_tmp_string;
	soap_default_ns1__mean(soap, &soap_tmp_ns1__mean);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__mean(soap, &soap_tmp_ns1__mean, "ns1:mean", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__mean(soap, soap_tmp_ns1__mean._array, soap_tmp_ns1__meanResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__meanResponse(soap, &soap_tmp_ns1__meanResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__meanResponse(soap, &soap_tmp_ns1__meanResponse, "ns1:meanResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__meanResponse(soap, &soap_tmp_ns1__meanResponse, "ns1:meanResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__codon_USCOREcounter(struct soap *soap)
{	struct ns1__codon_USCOREcounter soap_tmp_ns1__codon_USCOREcounter;
	struct ns1__codon_USCOREcounterResponse soap_tmp_ns1__codon_USCOREcounterResponse;
	char * soap_tmp_string;
	soap_default_ns1__codon_USCOREcounterResponse(soap, &soap_tmp_ns1__codon_USCOREcounterResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__codon_USCOREcounterResponse._result = &soap_tmp_string;
	soap_default_ns1__codon_USCOREcounter(soap, &soap_tmp_ns1__codon_USCOREcounter);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__codon_USCOREcounter(soap, &soap_tmp_ns1__codon_USCOREcounter, "ns1:codon_counter", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__codon_USCOREcounter(soap, soap_tmp_ns1__codon_USCOREcounter._sequence, soap_tmp_ns1__codon_USCOREcounter._params, soap_tmp_ns1__codon_USCOREcounterResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__codon_USCOREcounterResponse(soap, &soap_tmp_ns1__codon_USCOREcounterResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__codon_USCOREcounterResponse(soap, &soap_tmp_ns1__codon_USCOREcounterResponse, "ns1:codon_counterResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__codon_USCOREcounterResponse(soap, &soap_tmp_ns1__codon_USCOREcounterResponse, "ns1:codon_counterResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__entrez(struct soap *soap)
{	struct ns1__entrez soap_tmp_ns1__entrez;
	struct ns1__entrezResponse soap_tmp_ns1__entrezResponse;
	char * soap_tmp_string;
	soap_default_ns1__entrezResponse(soap, &soap_tmp_ns1__entrezResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__entrezResponse._result = &soap_tmp_string;
	soap_default_ns1__entrez(soap, &soap_tmp_ns1__entrez);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__entrez(soap, &soap_tmp_ns1__entrez, "ns1:entrez", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__entrez(soap, soap_tmp_ns1__entrez._database, soap_tmp_ns1__entrez._query, soap_tmp_ns1__entrezResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__entrezResponse(soap, &soap_tmp_ns1__entrezResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__entrezResponse(soap, &soap_tmp_ns1__entrezResponse, "ns1:entrezResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__entrezResponse(soap, &soap_tmp_ns1__entrezResponse, "ns1:entrezResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__palindrome(struct soap *soap)
{	struct ns1__palindrome soap_tmp_ns1__palindrome;
	struct ns1__palindromeResponse soap_tmp_ns1__palindromeResponse;
	char * soap_tmp_string;
	soap_default_ns1__palindromeResponse(soap, &soap_tmp_ns1__palindromeResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__palindromeResponse._result = &soap_tmp_string;
	soap_default_ns1__palindrome(soap, &soap_tmp_ns1__palindrome);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__palindrome(soap, &soap_tmp_ns1__palindrome, "ns1:palindrome", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__palindrome(soap, soap_tmp_ns1__palindrome._sequence, soap_tmp_ns1__palindrome._params, soap_tmp_ns1__palindromeResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__palindromeResponse(soap, &soap_tmp_ns1__palindromeResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__palindromeResponse(soap, &soap_tmp_ns1__palindromeResponse, "ns1:palindromeResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__palindromeResponse(soap, &soap_tmp_ns1__palindromeResponse, "ns1:palindromeResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__least_USCOREsquares_USCOREfit(struct soap *soap)
{	struct ns1__least_USCOREsquares_USCOREfit soap_tmp_ns1__least_USCOREsquares_USCOREfit;
	struct ns1__least_USCOREsquares_USCOREfitResponse _param_9;
	soap_default_ns1__least_USCOREsquares_USCOREfitResponse(soap, &_param_9);
	soap_default_ns1__least_USCOREsquares_USCOREfit(soap, &soap_tmp_ns1__least_USCOREsquares_USCOREfit);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__least_USCOREsquares_USCOREfit(soap, &soap_tmp_ns1__least_USCOREsquares_USCOREfit, "ns1:least_squares_fit", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__least_USCOREsquares_USCOREfit(soap, soap_tmp_ns1__least_USCOREsquares_USCOREfit._array, &_param_9);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__least_USCOREsquares_USCOREfitResponse(soap, &_param_9);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__least_USCOREsquares_USCOREfitResponse(soap, &_param_9, "ns1:least_squares_fitResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__least_USCOREsquares_USCOREfitResponse(soap, &_param_9, "ns1:least_squares_fitResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__dinuc(struct soap *soap)
{	struct ns1__dinuc soap_tmp_ns1__dinuc;
	struct ns1__dinucResponse soap_tmp_ns1__dinucResponse;
	char * soap_tmp_string;
	soap_default_ns1__dinucResponse(soap, &soap_tmp_ns1__dinucResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__dinucResponse._result = &soap_tmp_string;
	soap_default_ns1__dinuc(soap, &soap_tmp_ns1__dinuc);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__dinuc(soap, &soap_tmp_ns1__dinuc, "ns1:dinuc", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__dinuc(soap, soap_tmp_ns1__dinuc._sequence, soap_tmp_ns1__dinuc._params, soap_tmp_ns1__dinucResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__dinucResponse(soap, &soap_tmp_ns1__dinucResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__dinucResponse(soap, &soap_tmp_ns1__dinucResponse, "ns1:dinucResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__dinucResponse(soap, &soap_tmp_ns1__dinucResponse, "ns1:dinucResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__cgr(struct soap *soap)
{	struct ns1__cgr soap_tmp_ns1__cgr;
	struct ns1__cgrResponse soap_tmp_ns1__cgrResponse;
	char * soap_tmp_string;
	soap_default_ns1__cgrResponse(soap, &soap_tmp_ns1__cgrResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__cgrResponse._result = &soap_tmp_string;
	soap_default_ns1__cgr(soap, &soap_tmp_ns1__cgr);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__cgr(soap, &soap_tmp_ns1__cgr, "ns1:cgr", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__cgr(soap, soap_tmp_ns1__cgr._sequence, soap_tmp_ns1__cgr._params, soap_tmp_ns1__cgrResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__cgrResponse(soap, &soap_tmp_ns1__cgrResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__cgrResponse(soap, &soap_tmp_ns1__cgrResponse, "ns1:cgrResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__cgrResponse(soap, &soap_tmp_ns1__cgrResponse, "ns1:cgrResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__B1(struct soap *soap)
{	struct ns1__B1 soap_tmp_ns1__B1;
	struct ns1__B1Response soap_tmp_ns1__B1Response;
	char * soap_tmp_string;
	soap_default_ns1__B1Response(soap, &soap_tmp_ns1__B1Response);
	soap_tmp_string = NULL;
	soap_tmp_ns1__B1Response._result = &soap_tmp_string;
	soap_default_ns1__B1(soap, &soap_tmp_ns1__B1);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__B1(soap, &soap_tmp_ns1__B1, "ns1:B1", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__B1(soap, soap_tmp_ns1__B1._sequence, soap_tmp_ns1__B1._params, soap_tmp_ns1__B1Response._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__B1Response(soap, &soap_tmp_ns1__B1Response);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__B1Response(soap, &soap_tmp_ns1__B1Response, "ns1:B1Response", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__B1Response(soap, &soap_tmp_ns1__B1Response, "ns1:B1Response", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__B2(struct soap *soap)
{	struct ns1__B2 soap_tmp_ns1__B2;
	struct ns1__B2Response soap_tmp_ns1__B2Response;
	char * soap_tmp_string;
	soap_default_ns1__B2Response(soap, &soap_tmp_ns1__B2Response);
	soap_tmp_string = NULL;
	soap_tmp_ns1__B2Response._result = &soap_tmp_string;
	soap_default_ns1__B2(soap, &soap_tmp_ns1__B2);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__B2(soap, &soap_tmp_ns1__B2, "ns1:B2", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__B2(soap, soap_tmp_ns1__B2._sequence, soap_tmp_ns1__B2Response._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__B2Response(soap, &soap_tmp_ns1__B2Response);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__B2Response(soap, &soap_tmp_ns1__B2Response, "ns1:B2Response", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__B2Response(soap, &soap_tmp_ns1__B2Response, "ns1:B2Response", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__base_USCOREcounter(struct soap *soap)
{	struct ns1__base_USCOREcounter soap_tmp_ns1__base_USCOREcounter;
	struct ns1__base_USCOREcounterResponse soap_tmp_ns1__base_USCOREcounterResponse;
	char * soap_tmp_string;
	soap_default_ns1__base_USCOREcounterResponse(soap, &soap_tmp_ns1__base_USCOREcounterResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__base_USCOREcounterResponse._result = &soap_tmp_string;
	soap_default_ns1__base_USCOREcounter(soap, &soap_tmp_ns1__base_USCOREcounter);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__base_USCOREcounter(soap, &soap_tmp_ns1__base_USCOREcounter, "ns1:base_counter", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__base_USCOREcounter(soap, soap_tmp_ns1__base_USCOREcounter._sequence, soap_tmp_ns1__base_USCOREcounter._params, soap_tmp_ns1__base_USCOREcounterResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__base_USCOREcounterResponse(soap, &soap_tmp_ns1__base_USCOREcounterResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__base_USCOREcounterResponse(soap, &soap_tmp_ns1__base_USCOREcounterResponse, "ns1:base_counterResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__base_USCOREcounterResponse(soap, &soap_tmp_ns1__base_USCOREcounterResponse, "ns1:base_counterResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__base_USCOREz_USCOREvalue(struct soap *soap)
{	struct ns1__base_USCOREz_USCOREvalue soap_tmp_ns1__base_USCOREz_USCOREvalue;
	struct ns1__base_USCOREz_USCOREvalueResponse soap_tmp_ns1__base_USCOREz_USCOREvalueResponse;
	char * soap_tmp_string;
	soap_default_ns1__base_USCOREz_USCOREvalueResponse(soap, &soap_tmp_ns1__base_USCOREz_USCOREvalueResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__base_USCOREz_USCOREvalueResponse._result = &soap_tmp_string;
	soap_default_ns1__base_USCOREz_USCOREvalue(soap, &soap_tmp_ns1__base_USCOREz_USCOREvalue);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__base_USCOREz_USCOREvalue(soap, &soap_tmp_ns1__base_USCOREz_USCOREvalue, "ns1:base_z_value", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__base_USCOREz_USCOREvalue(soap, soap_tmp_ns1__base_USCOREz_USCOREvalue._sequence, soap_tmp_ns1__base_USCOREz_USCOREvalue._params, soap_tmp_ns1__base_USCOREz_USCOREvalueResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__base_USCOREz_USCOREvalueResponse(soap, &soap_tmp_ns1__base_USCOREz_USCOREvalueResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__base_USCOREz_USCOREvalueResponse(soap, &soap_tmp_ns1__base_USCOREz_USCOREvalueResponse, "ns1:base_z_valueResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__base_USCOREz_USCOREvalueResponse(soap, &soap_tmp_ns1__base_USCOREz_USCOREvalueResponse, "ns1:base_z_valueResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__kmer_USCOREtable(struct soap *soap)
{	struct ns1__kmer_USCOREtable soap_tmp_ns1__kmer_USCOREtable;
	struct ns1__kmer_USCOREtableResponse soap_tmp_ns1__kmer_USCOREtableResponse;
	char * soap_tmp_string;
	soap_default_ns1__kmer_USCOREtableResponse(soap, &soap_tmp_ns1__kmer_USCOREtableResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__kmer_USCOREtableResponse._result = &soap_tmp_string;
	soap_default_ns1__kmer_USCOREtable(soap, &soap_tmp_ns1__kmer_USCOREtable);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__kmer_USCOREtable(soap, &soap_tmp_ns1__kmer_USCOREtable, "ns1:kmer_table", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__kmer_USCOREtable(soap, soap_tmp_ns1__kmer_USCOREtable._sequence, soap_tmp_ns1__kmer_USCOREtable._params, soap_tmp_ns1__kmer_USCOREtableResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__kmer_USCOREtableResponse(soap, &soap_tmp_ns1__kmer_USCOREtableResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__kmer_USCOREtableResponse(soap, &soap_tmp_ns1__kmer_USCOREtableResponse, "ns1:kmer_tableResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__kmer_USCOREtableResponse(soap, &soap_tmp_ns1__kmer_USCOREtableResponse, "ns1:kmer_tableResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__lda_USCOREbias(struct soap *soap)
{	struct ns1__lda_USCOREbias soap_tmp_ns1__lda_USCOREbias;
	struct ns1__lda_USCOREbiasResponse soap_tmp_ns1__lda_USCOREbiasResponse;
	char * soap_tmp_string;
	soap_default_ns1__lda_USCOREbiasResponse(soap, &soap_tmp_ns1__lda_USCOREbiasResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__lda_USCOREbiasResponse._result = &soap_tmp_string;
	soap_default_ns1__lda_USCOREbias(soap, &soap_tmp_ns1__lda_USCOREbias);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__lda_USCOREbias(soap, &soap_tmp_ns1__lda_USCOREbias, "ns1:lda_bias", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__lda_USCOREbias(soap, soap_tmp_ns1__lda_USCOREbias._sequence, soap_tmp_ns1__lda_USCOREbias._params, soap_tmp_ns1__lda_USCOREbiasResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__lda_USCOREbiasResponse(soap, &soap_tmp_ns1__lda_USCOREbiasResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__lda_USCOREbiasResponse(soap, &soap_tmp_ns1__lda_USCOREbiasResponse, "ns1:lda_biasResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__lda_USCOREbiasResponse(soap, &soap_tmp_ns1__lda_USCOREbiasResponse, "ns1:lda_biasResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__scs(struct soap *soap)
{	struct ns1__scs soap_tmp_ns1__scs;
	struct ns1__scsResponse soap_tmp_ns1__scsResponse;
	char * soap_tmp_string;
	soap_default_ns1__scsResponse(soap, &soap_tmp_ns1__scsResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__scsResponse._result = &soap_tmp_string;
	soap_default_ns1__scs(soap, &soap_tmp_ns1__scs);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__scs(soap, &soap_tmp_ns1__scs, "ns1:scs", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__scs(soap, soap_tmp_ns1__scs._sequence, soap_tmp_ns1__scs._params, soap_tmp_ns1__scsResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__scsResponse(soap, &soap_tmp_ns1__scsResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__scsResponse(soap, &soap_tmp_ns1__scsResponse, "ns1:scsResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__scsResponse(soap, &soap_tmp_ns1__scsResponse, "ns1:scsResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__leading_USCOREstrand(struct soap *soap)
{	struct ns1__leading_USCOREstrand soap_tmp_ns1__leading_USCOREstrand;
	struct ns1__leading_USCOREstrandResponse _param_10;
	soap_default_ns1__leading_USCOREstrandResponse(soap, &_param_10);
	soap_default_ns1__leading_USCOREstrand(soap, &soap_tmp_ns1__leading_USCOREstrand);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__leading_USCOREstrand(soap, &soap_tmp_ns1__leading_USCOREstrand, "ns1:leading_strand", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__leading_USCOREstrand(soap, soap_tmp_ns1__leading_USCOREstrand._sequence, &_param_10);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__leading_USCOREstrandResponse(soap, &_param_10);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__leading_USCOREstrandResponse(soap, &_param_10, "ns1:leading_strandResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__leading_USCOREstrandResponse(soap, &_param_10, "ns1:leading_strandResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__S_USCOREvalue(struct soap *soap)
{	struct ns1__S_USCOREvalue soap_tmp_ns1__S_USCOREvalue;
	struct ns1__S_USCOREvalueResponse soap_tmp_ns1__S_USCOREvalueResponse;
	char * soap_tmp_string;
	soap_default_ns1__S_USCOREvalueResponse(soap, &soap_tmp_ns1__S_USCOREvalueResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__S_USCOREvalueResponse._result = &soap_tmp_string;
	soap_default_ns1__S_USCOREvalue(soap, &soap_tmp_ns1__S_USCOREvalue);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__S_USCOREvalue(soap, &soap_tmp_ns1__S_USCOREvalue, "ns1:S_value", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__S_USCOREvalue(soap, soap_tmp_ns1__S_USCOREvalue._sequence, soap_tmp_ns1__S_USCOREvalue._params, soap_tmp_ns1__S_USCOREvalueResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__S_USCOREvalueResponse(soap, &soap_tmp_ns1__S_USCOREvalueResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__S_USCOREvalueResponse(soap, &soap_tmp_ns1__S_USCOREvalueResponse, "ns1:S_valueResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__S_USCOREvalueResponse(soap, &soap_tmp_ns1__S_USCOREvalueResponse, "ns1:S_valueResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__help(struct soap *soap)
{	struct ns1__help soap_tmp_ns1__help;
	struct ns1__helpResponse soap_tmp_ns1__helpResponse;
	char * soap_tmp_string;
	soap_default_ns1__helpResponse(soap, &soap_tmp_ns1__helpResponse);
	soap_tmp_string = NULL;
	soap_tmp_ns1__helpResponse._result = &soap_tmp_string;
	soap_default_ns1__help(soap, &soap_tmp_ns1__help);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__help(soap, &soap_tmp_ns1__help, "ns1:help", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__help(soap, soap_tmp_ns1__help._keywords, soap_tmp_ns1__helpResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__helpResponse(soap, &soap_tmp_ns1__helpResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__helpResponse(soap, &soap_tmp_ns1__helpResponse, "ns1:helpResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__helpResponse(soap, &soap_tmp_ns1__helpResponse, "ns1:helpResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__hydropathy(struct soap *soap)
{	struct ns1__hydropathy soap_tmp_ns1__hydropathy;
	struct ns1__hydropathyResponse soap_tmp_ns1__hydropathyResponse;
	float soap_tmp_float;
	soap_default_ns1__hydropathyResponse(soap, &soap_tmp_ns1__hydropathyResponse);
	soap_default_float(soap, &soap_tmp_float);
	soap_tmp_ns1__hydropathyResponse._result = &soap_tmp_float;
	soap_default_ns1__hydropathy(soap, &soap_tmp_ns1__hydropathy);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_ns1__hydropathy(soap, &soap_tmp_ns1__hydropathy, "ns1:hydropathy", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__hydropathy(soap, soap_tmp_ns1__hydropathy._sequence, soap_tmp_ns1__hydropathyResponse._result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__hydropathyResponse(soap, &soap_tmp_ns1__hydropathyResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__hydropathyResponse(soap, &soap_tmp_ns1__hydropathyResponse, "ns1:hydropathyResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__hydropathyResponse(soap, &soap_tmp_ns1__hydropathyResponse, "ns1:hydropathyResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapServer.c */
