<%namespace name="ie" file="ie.mako"/>

<%

    # Sets ID and sets up a lot of other variables
    ie_request.load_deploy_config()
    ie_request.attr.docker_port = 8765

    docker_input_filename = "/XSeeker/input/input.{}".format(hda.ext)

    user_file = ie_request.volume(
        docker_input_filename,
        hda.file_name,
        mode='ro'
    )

    # Launch the IE. This builds and runs the docker command in the background.
    ie_request.launch(
        volumes=[user_file],
    )


    ## General IE specific
    # Access URLs for the notebook from within galaxy.
    notebook_access_url = ie_request.url_template('${PROXY_URL}//')

%>
<html>
    <head>
        ${ ie.load_default_js() }
        ${ ie.load_default_app() }
    </head>
    <body style="margin: 0px">

        <script type="text/javascript">

        ${ ie.default_javascript_variables() }

        var notebook_access_url = '${ notebook_access_url }';

        function message_failed_connection() {
            toastr.error("Could not connect to . Please contact your administrator.", "Security warning", {
                closeButton: true,
                timeOut: 20000,
                tapToDismiss: true
            });
        }

        function load_notebook(notebook_access_url) {
            // Test notebook_login_url for accessibility, executing the login+load function whenever
            // we've successfully connected to the IE.
            IES.test_ie_availability(notebook_access_url, function() {
                IES.append_notebook(notebook_access_url);
            });
        }

        IES.load_when_ready(ie_readiness_url, function(){
            load_notebook(notebook_access_url);
        });

        </script>
        <div id="main" width="100%" height="100%">
        </div>
    </body>
</html>
