diff --git a/lib/galaxy/datatypes/text.py b/lib/galaxy/datatypes/text.py
index b1884da52b..4ad1006c56 100644
--- a/lib/galaxy/datatypes/text.py
+++ b/lib/galaxy/datatypes/text.py
@@ -804,3 +804,38 @@ class Gfa1(Text):
                 return False
             found_valid_lines = True
         return found_valid_lines
+
+
+@build_sniff_from_prefix
+class SQL(Text):
+    """Class describing an html file"""
+    file_ext = "sql"
+
+    def set_peek(self, dataset, is_multi_byte=False):
+        if not dataset.dataset.purged:
+            dataset.peek = "SQL file"
+            dataset.blurb = nice_size(dataset.get_size())
+        else:
+            dataset.peek = "file does not exist"
+            dataset.blurb = "file purged from disk"
+
+    def get_mime(self):
+        """Returns the mime type of the datatype"""
+        return "application/sql"
+
+    def sniff_prefix(self, file_prefix):
+        """
+        Uses some patterns usualy encountered in sql files to guess
+        it's type
+        """
+        start = file_prefix.string_io().read(42).strip()
+        return any(
+            header in start
+            for header in (
+                "CREATE DATABASE",
+                "INSERT INTO",
+                "CREATE TABLE",
+                "BEGIN TRANSACTION"
+            )
+        )
+
