#!/home/lain/R/bin/Rscript

ZIP <- FALSE

file.copy("../convert/recreate_rdata_from_galaxy/20-01-2021.rdata", "../convert/recreate_rdata_from_galaxy/20-01-2021.rdata.old")
load("../convert/recreate_rdata_from_galaxy/20-01-2021.rdata", rdata <- new.env())

listOFlistArguments <- rdata$listOFlistArguments
diffrep <- rdata$diffrep
variableMetadata <- rdata$variableMetadata
xa <- rdata$xa
if (ZIP) {
	zipfile <- normalizePath("../convert/recreate_rdata_from_galaxy/20-01-2021.zip", mustWork=TRUE)
	singlefile <- rdata$singlefile
} else {
	singles <- list.files("../convert/recreate_rdata_from_galaxy/")
	singles <- singles[singles != "20-01-2021.rdata"]
    singles <- singles[singles != "20-01-2021.rdata.old"]
	singlefile <- list()
	for (single in singles) {
		singlefile[tools::file_path_sans_ext(single)] <- normalizePath(paste0("../convert/recreate_rdata_from_galaxy/", single))
	}
	zipfile <- NULL
	print(singlefile)
}

save(
    zipfile,
    listOFlistArguments,
    diffrep,
    variableMetadata,
    xa,
    singlefile,
    file="../convert/recreate_rdata_from_galaxy/20-01-2021.rdata"
    ,version=2
)