#!/home/lain/R/bin/Rscript

ZIP <- FALSE

file.copy("../convert/yann.rdata", "../convert/yann.rdata.old")
load("../convert/yann.rdata", rdata <- new.env())

listOFlistArguments <- rdata$listOFlistArguments
diffrep <- rdata$diffrep
variableMetadata <- rdata$variableMetadata
xa <- rdata$xa
if (ZIP) {
	zipfile <- normalizePath("../convert/yann.zip", mustWork=TRUE)
	singlefile <- rdata$singlefile
} else {
	singles <- list.files("../convert/")
	singles <- singles[singles != "yann.rdata"]
	singlefile <- list()
	for (single in singles) {
		singlefile[tools::file_path_sans_ext(single)] <- normalizePath(paste0("../convert/", single))
	}
	zipfile <- NULL
	print(singlefile)
}

save(
    zipfile,
    listOFlistArguments,
    diffrep,
    variableMetadata,
    xa,
    singlefile,
    file="../convert/yann.rdata"
    ,version=2
)