

class XSeekerDatabase(SQlite):
    """Class describing an XSeeker Sqlite database """
    MetadataElement(
        name="xseeker_version",
        default="1.0.0",
        param=MetadataParameter,
        desc="XSeeker Version",
        readonly=True,
        visible=True,
        no_value="1.0.0"
    )
    file_ext = "xseeker.sqlite"
    edam_format = "format_3622"
    edam_data = "data_3498"

    def set_meta(self, dataset, overwrite=True, **kwd):
        super(XSeekerDatabase, self).set_meta(dataset, overwrite=overwrite, **kwd)
        try:
            conn = sqlite.connect(dataset.file_name)
            c = conn.cursor()
            tables_query = "SELECT database_version FROM XSeeker_tagging_table"
            result = c.execute(tables_query).fetchall()
            for version, in result:
                dataset.metadata.xseeker_vesrion = version
            # TODO: Can/should we detect even more attributes, such as use of PED file, what was input annotation type, etc.
        except Exception as e:
            log.warning('%s, set_meta Exception: %s', self, e)

    def sniff(self, filename):
        if super(XSeekerDatabase, self).sniff(filename):
            table_names = [
                "XSeeker_tagging_table"
            ]
            return self.sniff_table_names(filename, table_names)
        return False

    def set_peek(self, dataset, is_multi_byte=False):
        if not dataset.dataset.purged:
            dataset.peek = "XSeeker SQLite Database, version %s" % (dataset.metadata.xseeker_version or 'unknown')
            dataset.blurb = nice_size(dataset.get_size())
        else:
            dataset.peek = 'file does not exist'
            dataset.blurb = 'file purged from disk'

    def display_peek(self, dataset):
        try:
            return dataset.peek
        except Exception:
            return "XSeeker SQLite Database, version %s" % (dataset.metadata.xseeker_version or 'unknown')

