#!/home/lain/R/bin/Rscript

ZIP <- FALSE

file.copy("../convert/recreate_rdata_from_galaxy/test.rdata", "../convert/recreate_rdata_from_galaxy/test.rdata.old")
load("../convert/recreate_rdata_from_galaxy/test.rdata", rdata <- new.env())

listOFlistArguments <- rdata$listOFlistArguments
diffrep <- rdata$diffrep
variableMetadata <- rdata$variableMetadata
xa <- rdata$xa
if (ZIP) {
	zipfile <- normalizePath("../convert/recreate_rdata_from_galaxy/test.zip", mustWork=TRUE)
	singlefile <- rdata$singlefile
} else {
	singles <- list.files("../convert/recreate_rdata_from_galaxy/")
	singles <- singles[singles != "test.rdata"]
    singles <- singles[singles != "test.rdata.old"]
	singlefile <- list()
	for (single in singles) {
		singlefile[tools::file_path_sans_ext(single)] <- normalizePath(paste0("../convert/recreate_rdata_from_galaxy/", single))
	}
	zipfile <- NULL
	print(singlefile)
}

save(
    zipfile,
    listOFlistArguments,
    diffrep,
    variableMetadata,
    xa,
    singlefile,
    file="../convert/recreate_rdata_from_galaxy/test.rdata"
    ,version=2
)