#!/bin/bash

QT_DIR=""
INSTALL_DIR=""
#OPT="Linux_x86_64"


checkDir()
{
	echo -n "checking for "$1" ... "
	if [ -f $QT_DIR/$1 ]; then
		echo $QT_DIR/$1
		return 1
	else
		echo "not found!"
		return 0
	fi
}

echo
cat license.txt
echo
echo -n "Do you agree to this license?! (y/n) "
read license_accepted
echo

if [ "$license_accepted" != "y" ] && [ "$license_accepted" != "yes" ]; then
	echo "License was not accepted, aborting."
	exit 1
fi

echo -n "Please enter *absolute* path to install target-directory: "

read INSTALL_DIR
if [ ! -d $INSTALL_DIR ]; then 
	mkdir $INSTALL_DIR
fi

if [ ! -d $INSTALL_DIR ]; then
	echo
	echo "[Error:] The desired install-directory does not exist and could also not be created!"
	echo "Perhaps there was a typo or you do not have permission to create this folder."
	echo "Aborting install."
	echo
	exit 1
fi

# if [ -f /usr/lib/libQtCore.so.4 ] && [ -f  /usr/lib/libQtGui.so.4 ]; then
# 	QT_DIR=/usr/lib 
# else 
# 	echo "Please enter absolute path to the directory containing"
# 	echo -n "your Qt4 libraries (version>=4.3.5): "
# 	read QT_DIR
# fi

# checkDir libQtCore.so.4; ok=$?;
# checkDir libQtGui.so.4;  if [ $ok = 1 ]; then let ok $?; fi
# #checkDir libQtOpenGL.so; if [ $ok = 1 ]; then ok=$?; fi
# 
# if [ $ok != 1 ]; then
# 	echo "Aborting installation due to missing Qt4!"
# 	exit 1
# fi

cd bin
programs=`ls *.bin`
cd ..
for i in $programs; do
	chmod +x ${i:0:${#i}-4}
done


mv * $INSTALL_DIR/

if [ -f $INSTALL_DIR/CADDSuite-description.txt ]; then
	echo
	echo
	cat $INSTALL_DIR/CADDSuite-description.txt
fi

echo
echo "Installation finished."
echo "You can find all installed programs in $INSTALL_DIR."
echo
