from ftplib import FTP
import sys

# Get accession number from argument
accession = sys.argv[1]
prefix = accession[0:2].uppercase()
middle = accession[3:5]
suffix = accession[6:8]

# NCBI SRA FTP site
ftp = FTP('ftp.ncbi.nlm.nih.gov')

# Open stdout and transfer requested SRA as a file
ftp.login()
ftp.retrbinary('/sra/sra-instant/reads/ByRun/sra/' + 
        prefix + '/' +
        prefix + middle + '/' +
        prefix + middle + suffix + '/' +
        prefix + middle + suffix + '.sra', sys.stdout)
ftp.quit()
