#!/usr/bin/perl -w
use strict;
my $fas_file=shift;
my $ann_file=shift;
my $out_file=shift;

open(OUT,">$out_file");

my %seqS=();
my $id="";
open(IN,$fas_file);
while(<IN>)
{
	if ($_=~/^>(.*)/)
	{
		$id=$1;
		$id=(split(/\s+/,$id))[0];
	}else{
		$seqS{$id}.=$_;
	}
}

my %decode=();
open(IN,$ann_file);
while(<IN>)
{
	last if $_=~/^\#\#FASTA/;
	next if $_=~/^\#/;
	my ($id1,$id2)=(split(/\t/))[0,-1];
	$id2=(split(/\;/,$id2))[0];
	my @vl=(split(/\_/,$id1));
	$id1="";
	foreach my $v (@vl)
	{
		if ($v eq "length")
		{
			chop($id1);
			last;
		}
		$id1.="$v\_"; 
	}
	$id2=~s/ID=//;
	$decode{$id2}=$id1;
}
foreach my $seq (sort keys %seqS)
{
	print OUT ">$decode{$seq}\z\z\z$seq\n$seqS{$seq}\n";
}

