#!/bin/sh
gnuplot << EOF
reset
set style fill solid 1.00 noborder
set style histogram rowstacked
set style data histograms
set ylabel "Bits x direction of regulation"
set key outside
set xrange [-0.5: 3.5]
set xtics("t0 vs t1" 0, "t1 vs t2" 1, "m0 vs m1" 2, "m1 vs m2" 3)
set xtics rotate by -45




set terminal postscript eps color 24
set output 'TESTOUTPUT/patterns-1.eps'
plot 'TESTOUTPUT/patterns-1.logo' u 1 notitle lc rgbcolor "#000000", '' u 2 notitle lc rgbcolor "#008800", '' u 3 notitle lc rgbcolor "#00FF00", '' u 7 t "++" lc rgbcolor "#FF0000", '' u 8 t "+" lc rgbcolor "#880000", '' u 9 t "0" lc rgbcolor "#000000", '' u 10 t "-" lc rgbcolor "#008800", '' u 11 t "--" lc rgbcolor "#00FF00", '' u 4 notitle lc rgbcolor "#000000", '' u 5 notitle lc rgbcolor "#880000", '' u 6 notitle lc rgbcolor "#FF0000"
EOF
