########################################################
#
# creation date : 07/06/16
# last modification : 07/06/16
# author : Dr Nicolas Beaume
# owner : IRRI
#
########################################################

library("miscTools")
# scatterplot of the prediction vs target
r2.plot <- function(true, predicted) {
  # the scatterplot
  plot(true, predicted, xlab="trait value", ylab="predicted value", main="", pch=16, 
       ylim=c(min(min(true), min(predicted)), max(max(true), max(predicted))))
  # add a red lines with ideal case
  lines(true, true, col="red")
}

############################ main #############################
# load argument
cmd <- commandArgs(trailingOnly = T)
source(cmd[1])
# load prediction and target
phenotype <- read.table(phenotype, sep="\t", h=T)[,1] 
predicted <- read.table(predicted, sep = "\t", h=T)[,2]
# plot in a pdf that will be available in galaxy history panel
pdf(out)
r2.plot(phenotype, predicted = predicted)
dev.off()