#!/bin/bash

SCRIPTDIR=$(dirname "$(readlink -f "$0")")
python $SCRIPTDIR"/cdhit_analysis.py" "$@"

# sanity check
printf "Conda env: %s\n" "$CONDA_DEFAULT_ENV"
printf "Python version: %s\n" "$(python --version | awk '{print $2}')"
printf "Matplotlib version: %s\n" "$(python -c 'import matplotlib; print(matplotlib.__version__)')"
printf "Pandas version: %s\n" "$(python -c 'import pandas; print(pandas.__version__)')"
printf "Openpyxl version: %s\n" "$(python -c 'import openpyxl; print(openpyxl.__version__)')"
printf "Bash version: %s\n" "${BASH_VERSION}"
printf "SCRIPTDIR: %s\n\n" "$SCRIPTDIR"