#!/usr/bin/python
#-*- coding: utf-8 -*-
#Libraries:
import os, os.path, argparse, sys, gzip, re

##### MAIN
def __main__():
  ### Arguments:
  parser = argparse.ArgumentParser(description='''Launch Ssuis_serotypingPipeline.pl with correct argument''', epilog="""This script needs few options use -h to see it.""")
  parser.add_argument('--fastq_file', dest='ffile')
  parser.add_argument('--fastq_file2', dest='ffile2')
  parser.add_argument('--scoreName', dest='sname')
  parser.add_argument('--output2', dest='o2')
  parser.add_argument('--output3', dest='o3')
  parser.add_argument('--output4', dest='o4')
  parser.add_argument('--output5', dest='o5')
  parser.add_argument('--output6', dest='o6')
  parser.add_argument('--output7', dest='o7')
  parser.add_argument('--output8', dest='o8')
  parser.add_argument('--serotype_db', dest='sd')
  parser.add_argument('--serotype_definitions', dest='sdef')
  parser.add_argument('--cps2K', dest='cps')
  parser.add_argument('--Virulence_db', dest='Vdb')
  parser.add_argument('--recN_db', dest='recdb')
  parser.add_argument('--MLST_definitions', dest='MLSTdef')
  parser.add_argument('--MLST_db', dest='MLSTdb') 
  parser.add_argument('--ends', dest='ends')
  parser.add_argument('--forward', dest='f')
  parser.add_argument('--reverse', dest='r')

  ### Get argument in variable:
  options = parser.parse_args()
  ffile = options.ffile
  ffile2 = options.ffile2
  sname = options.sname
  output2 = options.o2
  output3 = options.o3
  output4 = options.o4
  output5 = options.o5
  output6 = options.o6
  output7 = options.o7
  output8 = options.o8
  sd = options.sd
  sdef = options.sdef
  cps = options.cps
  Vdb = options.Vdb
  recdb = options.recdb
  MLSTdef = options.MLSTdef
  MLSTdb = options.MLSTdb
  ends = options.ends
  f = options.f
  r = options.r
  
  # Need to clone repo from git : https://github.com/streplab/SsuisSerotyping_pipeline.git
  way_pipeline = "/nfs/bin/SsuisSerotyping_pipeline/"
  input_path = os.path.splitext(output2)[0]+"_input_file_test/"
  output_path = os.path.splitext(output2)[0]+"_Results/"
  os.system("mkdir -p "+input_path)
  fdir = input_path

  if ends == "se":
    f = "SINGLE"
    r = "SINGLE"
    os.system("cp "+ffile+" "+input_path+"/file_test.fastq")

  elif ends == "pe":
    os.system("cp "+ffile+" "+input_path+"/file_test"+f+".fastq")
    os.system("cp "+ffile2+" "+input_path+"/file_test"+r+".fastq")

  if sd is None:
    os.system("perl "+way_pipeline+"/Ssuis_serotypingPipeline.pl --fastq_directory "+str(fdir)+" --scoreName "+output_path+"Results --ends "+str(ends)+" --forward "+str(f)+" --reverse "+str(r))
  else:
    os.system("perl "+way_pipeline+"/Ssuis_serotypingPipeline.pl --fastq_directory "+str(fdir)+" --scoreName "+output_path+"Results --serotype_db "+str(sd)+" --serotype_definitions "+str(sdef)+" --cps2K "+str(cps)+" --Virulence_db "+str(Vdb)+" --recN_db "+str(recdb)+" --MLST_definitions "+str(MLSTdef)+" --MLST_db "+str(MLSTdb)+" --ends "+str(ends)+" --forward "+str(f)+" --reverse "+str(r))
  
  os.system("rm -r "+fdir)
  os.system("mv "+output_path+"/Results_FinalResults.txt "+sname)
  os.system("mv "+output_path+"/Results_MLSTResults.txt "+output2)
  os.system("mv "+output_path+"/Results_recN__fullgenes__recN_full__results.txt "+output3)
  os.system("mv "+output_path+"/Results_speciesConfirmation.txt "+output4)
  os.system("mv "+output_path+"/Results_FinalSerotypingResults.txt "+output5)
  os.system("mv "+output_path+"/Results_InitialCapsuleResults.txt "+output6)
  os.system("mv "+output_path+"/Results_VirulenceFactors__fullgenes__Virulence__results.txt "+output7)
  os.system("mv "+output_path+"/Results_VirulenceFactorResults.txt "+output8)
#### MAIN END
if __name__ == "__main__": __main__() 

