package datastructures;

import java.util.Scanner;

public class AnnotationLine implements Comparable<Object>{
	
	String seqName, chrom, gene;
	int start, end;
	
	public AnnotationLine(String seqName, String chrom, String gene, 
											int start, int end){
		this.seqName = seqName;
		this.chrom = chrom;
		this.gene = gene;
		this.start = start;
		this.end = end;
	}

	public AnnotationLine(String line){
		Scanner s = new Scanner(line);
		seqName = s.next();
		this.chrom = s.next();
		this.start = s.nextInt();
		this.end = s.nextInt();
		this.gene = s.next();
	}
	
	public String seqName() {
		return seqName;
	}

	public String chrom() {
		return chrom;
	}

	public String gene() {
		return gene;
	}

	public int start() {
		return start;
	}

	public int end() {
		return end;
	}

	public static AnnotationLine targetLine(String chrom, int tstart, int tend){
		return new AnnotationLine("000\t"+chrom+"\t"+tstart+"\t"+tend+"\tdummy");
	}
	
	public int compareTo(Object otherLine) {
		AnnotationLine other = (AnnotationLine)otherLine;
		
		if(chrom.compareTo(other.chrom()) < 0 
								&& !other.gene.equals("dummy"))
			return -1;
		else if(chrom.compareTo(other.chrom()) > 0 
								&& !other.chrom().equals("dummy"))
			return 1;
		else{
			/*
			 * 1. Eine Region überlappt mit einem Gen, wenn einer der folgenden 
			 * 3 Fälle eintritt:
			 * a) Targetanfang kleiner als Genanfang und Targetende größer als 
			 * Genende. (Gen ganz im Target enthalten)
			 * b) Targetanfang liegt zwischen Genanfang und Genende.
			 * c) Targetende liegt zwischen Genanfang und Genende.
			 */
			
			// Für Targetsuche
			if(this.gene().equals("dummy") && 
					this.chrom().equals(other.chrom()) && (
					(this.start() <= other.start() && this.end() >= other.end()) ||
					(this.start() >= other.start() && this.start() <= other.end()) ||
					(this.end() >= other.start() && this.end() <= other.end())
					)	
			)
				return 0;
			// Für Gensuche zu Insertzwecken.
			else if(start < other.start())
				return -1;
			else if(start > other.start())
				return 1;
			else{
				if(end < other.end())
					return -1;
				else if(end > other.end())
					return 1;
				else return 0;
			}
		}
	}
	
	public String toString(){
		return seqName +"\t" + chrom + "\t" + start + "\t" + end + "\t" + gene;
	}
	
}
