package datastructures;

public enum Format{
	type("type"),
	sam("sam"), 
	maq("maq"), 
	megablast("megablast"), 
	eland("eland"), 
	roche("roche"),
	genome("genome"),
	target("target"),
	invalid("invalid");
	
	private String f;
	
	Format(String format){
		this.f = format;
	}
	
	public Format compile(String f){
		this.f = f;
		try{
			return  Format.valueOf(this.f);
		}catch(IllegalArgumentException iae){
			return invalid;
		}
	}
		
	public boolean equals(Format other){
		return this.f.equals(other.f);
	}
};
