package datastructures;

import java.util.Vector;

/**
 * @author Ali Abdallah
 * @version 01.2011
 * @since jdk 1.6.0
 */

public class GenomeFrame extends Frame{
	
	int limit;
	Vector<Integer> hits;

	public GenomeFrame(int start, int length) {
		super(start, length);
		limit = end;
		hits = new Vector<Integer>(length);
		hits.setSize(length);
		for(int i = 0; i < length; i++){
			hits.set(i, 0);
		}
	}
	
	public int getHit(int base){
		if(base-start < hits.size())
			return hits.get(base-start);
		else
			return -1;
	}
	
	public void setHit(int base, int bhits){
		if(base-start < hits.size()){
			hits.set(base-start, bhits);
		}
	}
	
	public boolean contains(ReadFrame r){
		return (start <= r.start() && end >= r.end());
	}
	
	public boolean overlaps(ReadFrame r){
		return (end >= r.start() && end < r.end());
	}
	
	
	
	public void addBases(int nr){
		for(int i = 0; i < nr; i++){
			hits.add(1);
		}
	}
	
	public String toString(){
		return start+":"+end+" ("+limit+")";
	}


	public void updateHits(ReadFrame read) {
		for(int base = read.start(); base <= read.end(); base++){
			setHit(base, getHit(base)+1);
		}
	}

	public void updateFrameFromRightEnd(ReadFrame readF) {
		// TODO Auto-generated method stub
		for(int i = end+1; i <= readF.end(); i++)
			hits.add(0);
		end = readF.end();	
	}

	public boolean limitExceeded(ReadFrame readF) {
		return readF.start() > limit;
	}

	public void updateFrameFromBothEnds(ReadFrame readF, int length) {
		for(int i = end-readF.start()+1; i < length; i++ )
			hits.add(0);
		for(int i = 0; i < readF.start()-start; i++)
			hits.remove(0);
		start = readF.start();
		end = start+length-1;
		limit = end;
	}
	
}
