package datastructures;

import java.util.Scanner;

import exceptions.ChromosomeFormatException;
import exceptions.ChromosomeNotFoundException;
import exceptions.NullOrNegativeRangeException;
import exceptions.RangeFormatException;
import exceptions.RangeLimitNotFoundException;

/**
 * Represents a target Line from the target file.
 * 
 * @author Ali Abdallah
 * @version 19.07.2011
 * @since Java 1.6
 */

public class TargetLine {
	
	String line;
	String chrom;
	int start, end;

	public TargetLine(String line) throws 	RangeFormatException, 
											ChromosomeFormatException, 
											ChromosomeNotFoundException, 
											RangeLimitNotFoundException, 
											NullOrNegativeRangeException {
		this.line = line;
		Scanner s = new Scanner(line);
		if(s.hasNext()){
			chrom = s.next(); 
			if(!(chrom.toLowerCase().startsWith("chr") || chrom.equals("*")))
				throw new ChromosomeFormatException(chrom);
		}
		else
			throw new ChromosomeNotFoundException();
		
		if(s.hasNextInt()){
			start = s.nextInt();
			if(start < 0){
				throw new RangeFormatException("Start position of the target must be a " +
										 "positive integer.");
			}
		}
		else if(!s.hasNext())
			throw new RangeLimitNotFoundException("No target range start found!");
		else	
			throw new RangeFormatException("Target start position" +
									 " is not an integer. It must be a positive" +
									 " integer."+ " Found: "+start);
		
		if(s.hasNextInt()){
			end = s.nextInt();
			if(end < 0){
				throw new RangeFormatException("Target end position must be a positive " +
										 "integer."+ " Found: "+end);
			}
		}
		else if(!s.hasNext())
			throw new RangeLimitNotFoundException("No range end found!");
		else	
			throw new RangeFormatException("Found: "+end+". End position ist not an integer. " +
									 "It must be a positive integer.");
		
		if(start >= end)
			throw new NullOrNegativeRangeException("Target line \""+line+"\"");
	}
	
	public String chrom(){
		return chrom;
	}
	
	public int start(){
		return start;
	}
	
	public int end(){
		return end;
	}
	
	public String toString(){
		return line;
	}
	
}
