package datastructures;

import java.util.Scanner;

public class GenomeLine implements Line {

	boolean misformat = false;
	String seqName, chrom, gene;
	int start, end;
	
	//fw.write(field(1)+"\t"+field(3)+"\t"
	//		+field(5)+"\t"+field(6)+"\t"+field(13)+"\r\n");

	public GenomeLine(String line){
		Scanner s = new Scanner(line);
		if(line.startsWith("#")) misformat = true;
		else
		try{
			seqName = s.next();s.next();
			chrom = s.next();s.next();
			start = s.nextInt();
			end = s.nextInt();s.next();s.next();s.next();s.next();s.next();s.next();
			gene = s.next();}
		catch(Exception e){
			misformat = true;
		}
	}
	
	public boolean valid(){
		return misformat == false;
	}
	
	public String chrom() {
		return chrom;
	}

	public int end() {
		return end;
	}

	public int start() {
		return start;
	}
	
	public String gene(){
		return gene;
	}
	
	public String seqName(){
		return seqName;
	}
	
	public String toString(){
		return seqName + "\t" + chrom + "\t" + start + "\t" + end + "\t" + gene;
	}

}
