package datastructures;


// Basic node stored in AVL trees
// Note that this class is not accessible outside
// of package DataStructures

class AVLNode
{
    // Constructors
	@SuppressWarnings("unchecked")
	AVLNode( Comparable theElement )
    {
        this( theElement, null, null );
    }

    @SuppressWarnings("unchecked")
	AVLNode( Comparable theElement, AVLNode lt, AVLNode rt )
    {
        element  = theElement;
        left     = lt;
        right    = rt;
        height   = 0;
    }

        // Friendly data; accessible by other package routines
    @SuppressWarnings("unchecked")
	Comparable element;      // The data in the node
    AVLNode    left;         // Left child
    AVLNode    right;        // Right child
    int        height;       // Height
}
