# Finding outliers by standard deviation

# Get samples whose pc1 OR pc2 values lie more than 'numsds' s.devs
# away from the sample median for that pc.
outliers_by_sd = function(pca_data, xsamples, numsds) {
  pc1_outliers = find_outliers(pca_data$values[, 1], numsds)
  pc2_outliers = find_outliers(pca_data$values[, 2], numsds)
  all_outliers = union(pc1_outliers, pc2_outliers)
  return(all_outliers)
}

# compute outliers
# Returns indices of all samples which lie more than
# 'numsds' s.devs away from the sample median
find_outliers = function(input_data, numsds) {
  lower = median(input_data) - numsds*sd(input_data)
  upper = median(input_data) + numsds*sd(input_data)
  
  outliers = which(input_data < lower | input_data > upper)
  return(outliers)
}