#!/usr/bin/env Rscript

# Setup R error handling to go to stderr
options( show.error.messages=F, error = function () { cat( geterrmessage(), file=stderr() ); q( "no", 1, F ) } )

# we need that to not crash galaxy with an UTF8 error on German LC settings.
loc <- Sys.setlocale("LC_MESSAGES", "en_US.UTF-8")

## Get parameters ##
suppressPackageStartupMessages(require(argparse))

parser <- ArgumentParser(description='Run the circleCor function')

parser$add_argument('--input_rdata', dest='input_rdata', required=TRUE, help="Input RData file")
parser$add_argument('--blocks_vec', dest='blocks_vec', required=TRUE, help="Blocks vector")
parser$add_argument('--responses_var', dest='responses_var', required=TRUE, help="Responses variables")
parser$add_argument('--x_min', dest='x_min', type='double', required=TRUE, help="X min")
parser$add_argument('--x_max', dest='x_max', type='double', required=TRUE, help="X max")
parser$add_argument('--y_min', dest='y_min', type='double', required=TRUE, help="Y min")
parser$add_argument('--y_max', dest='y_max', type='double', required=TRUE, help="Y max")
parser$add_argument('--output_var', dest='output_var', required=TRUE, help="Output variables file")
parser$add_argument('--output_pdf', dest='output_pdf', required=TRUE, help="Output PDF file")

args <- parser$parse_args()

## Print parameters
print("Input RData:")
print(args$input_rdata)
print("Blocks vector:")
print(args$blocks_vec)
print("Response variables:")
print(args$responses_var)
print("X min:")
print(args$x_min)
print("X max:")
print(args$x_max)
print("Y min:")
print(args$y_min)
print("Y max:")
print(args$y_max)
print("Output variables file:")
print(args$output_var)
print("Output PDF file:")
print(args$output_pdf)

names_blocks = strsplit(args$blocks_vec, ",")[[1]]
names_response_variables = strsplit(args$responses_var, ",")[[1]]

print("names_blocks:")
print(names_blocks)
print("names_response_variables:")
print(names_response_variables)

## Loading libraries
suppressPackageStartupMessages(require(visCorVar))

# R script call
source_local <- function(fname)
{
    argv <- commandArgs(trailingOnly = FALSE)
    base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
    source(paste(base_dir, fname, sep="/"))
}

# Loading input Rdata file
# loads res_matCorAddVar object
load(args$input_rdata)

mat_cor_comp1 = res_matCorAddVar$mat_cor_comp1
mat_cor_comp2 = res_matCorAddVar$mat_cor_comp2
cutoff_comp = res_matCorAddVar$cutoff_comp
comp = res_matCorAddVar$comp
list_vec_index_block_select  = res_matCorAddVar$list_vec_index_block_select
list_vec_names_blocks = res_matCorAddVar$list_vec_names_blocks
list_cor_comp_selected_var_resp_var = res_matCorAddVar$list_cor_comp_selected_var_resp_var
res_compute_cor_var_interest = res_matCorAddVar$res_compute_cor_var_interest
res_block_splsda = res_matCorAddVar$res_block_splsda

#
print("mat_cor_comp1:")
print(mat_cor_comp1)
print("mat_cor_comp2:")
print(mat_cor_comp2)
print("cutoff_comp:")
print(cutoff_comp)
print("comp:")
print(comp)
print("list_vec_index_block_select:")
print(list_vec_index_block_select)
print("list_vec_names_blocks:")
print(list_vec_names_blocks)
print("list_cor_comp_selected_var_resp_var:")
print(list_cor_comp_selected_var_resp_var)
print("res_compute_cor_var_interest:")
print(res_compute_cor_var_interest)

# Open output pdf file
pdf(args$output_pdf, width=8, height=7)
mar = c(5, 5, 2, 8)
par(mar = mar)

selected_variables = circleCor(list_dataframe_cor_comp_var_global = list_cor_comp_selected_var_resp_var,
                               list_vec_index_block_select = list_vec_index_block_select,
                               mat_cor_comp1 = mat_cor_comp1,
                               mat_cor_comp2 = mat_cor_comp2,
                               names_blocks = names_blocks,
                               names_response_variables = names_response_variables,
                               comp = comp,
                               cutoff = 0.80,
                               min.X = args$x_min,
                               max.X = args$x_max,
                               min.Y = args$y_min,
                               max.Y = args$y_max,
                               # vec_col = vec_col,
                               rad.in = 0.5,
                               cex = 0.7,
                               cex_legend = 0.8,
                               pos = c(1.2, 0),
                               pch = 20)

dev.off()

write(selected_variables, file=args$output_var, ncolumns=1)