options(show.error.messages=F,warn=-1, error=function(){cat(geterrmessage(),file=stderr());q("no",1,F)})
sink(stdout(), type = "message")
sink(stdout() ,type = "output")
suppressWarnings(suppressMessages(library(affy)))
suppressWarnings(suppressMessages(library(affyPLM)))
suppressWarnings(suppressMessages(library(batch)))
suppressWarnings(suppressMessages(library(annotate)))
suppressWarnings(suppressMessages(library(limma)))
suppressWarnings(suppressMessages(library(markdown)))
suppressWarnings(suppressMessages(library(knitr)))
source_local <- function(fname){
    argv <- commandArgs(trailingOnly = FALSE)
    base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
    source(paste(base_dir, fname, sep="/"))
}
file_path <- function(fname){
  argv <- commandArgs(trailingOnly = FALSE)
  base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
  pato <- paste(base_dir, fname, sep="/")
  return(pato)
}
base_dir <- function(){
  argv <- commandArgs(trailingOnly = FALSE)
  base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
  return(base_dir)
}
source_local("Affymetrix_Preprocessing_Functions.R")  
listArguments = parseCommandArgs(evaluate=FALSE)
thefunctions=listArguments[["thefunctions"]]
listArguments[["thefunctions"]]=NULL
h=listArguments[["h"]]
listArguments[["h"]]=NULL
w=listArguments[["w"]]
listArguments[["w"]]=NULL
if (!is.null(listArguments[["image"]])){
    load(listArguments[["image"]])
    listArguments[["image"]]=NULL
}
listArguments[["rawdata"]]=MicroArray_Object$affy_object
if(datasetsource=="intern"){
designo<-MicroArray_Object$designo
}

if(datasetsource=="extern"){
listArguments<-append(listArguments,list(datasetsource=datasetsource,listfullnames=listfullnames))
}
Prepro_object<-do.call(thefunctions,listArguments)
if(datasetsource=="extern"){
rownames(Prepro_object$data.bg@phenoData@data)<-listfullnames
colnames(exprs(Prepro_object$data.bg))<-listfullnames
colnames(exprs(Prepro_object$data.sm))<-listfullnames
colnames(exprs(Prepro_object$data.norm))<-listfullnames
colnames(exprs(Prepro_object$data.bg))<-listfullnames
colnames(exprs(Prepro_object$data.norm))<-listfullnames
rownames(Prepro_object$data.norm@phenoData@data)<-listfullnames
rownames(Prepro_object$data.norm@protocolData@data)<-listfullnames
}

png(filename ="boxplot_before_NM.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
boxplot((na.omit(as.data.frame(exprs(Prepro_object$data.bg)))), main="Boxplot of  intensities before Normalization",col="red",las=2,mar=c(15,2,1,1))
invisible(dev.off())

png(filename ="boxplot_after_NM.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
boxplot((na.omit(as.data.frame(exprs(Prepro_object$data.sm)))), main="Boxplot of  intensities After Normalization",col="red",ylab="(intensities)",las=2,mar=c(15,2,1,1))
invisible(dev.off())

png(filename ="MA_plot.png",width = w, height = h)
MAplot((Prepro_object$data.norm) ,
        show.statistics = F, span = 2/3, family.loess = "gaussian",
        cex = 2, plot.method = as.character("smoothScatter"),
        azdd.loess = TRUE, lwd = 1, lty = 1, loess.col = "red")

invisible(dev.off())

png(filename = "densities_plot_before_NM.png",width = w, height = h)
plotDensities(exprs(Prepro_object$data.bg),log=T)
invisible(dev.off())

png(filename = "densities_plot_after_NM.png",width = w, height = h)
plotDensities(exprs(Prepro_object$data.norm),log=T)
invisible(dev.off())

AffymetrixRmd=file_path("Affymetrix.Rmd")
Style=file_path("look.css")
suppressWarnings(suppressMessages(markdownToHTML(AffymetrixRmd,output="PreprocessingPlots.html",quiet = T, stylesheet=Style)))
#suppressWarnings(suppressMessages(knit2html(AffymetrixRmd,output="PreprocessingPlots.html",quiet = T)))
rm(listArguments)
save.image("MicroArray.Preprocessing.RData")
sink()
sink()
