options(show.error.messages=F,warn=-1, error=function(){cat(geterrmessage(),file=stderr());q("no",1,F)})
sink(stdout(), type = "message")
sink(stdout() ,type = "output")
suppressWarnings(suppressMessages(library(limma)))
suppressWarnings(suppressMessages(library(batch)))
suppressWarnings(suppressMessages(library(marray)))
suppressWarnings(suppressMessages(library(IDPmisc)))
suppressWarnings(suppressMessages(library(markdown)))
suppressWarnings(suppressMessages(library(knitr)))
source_local <- function(fname){
    argv <- commandArgs(trailingOnly = FALSE)
    base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
    source(paste(base_dir, fname, sep="/"))
}
file_path <- function(fname){
  argv <- commandArgs(trailingOnly = FALSE)
  base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
  pato <- paste(base_dir, fname, sep="/")
  return(pato)
}
base_dir <- function(){
  argv <- commandArgs(trailingOnly = FALSE)
  base_dir <- dirname(substring(argv[grep("--file=", argv)], 8))
  return(base_dir)
}
source_local("Agilent_One_Color_Preprocessing_Functions.R")
listArguments = parseCommandArgs(evaluate=FALSE)
print(listArguments)
load(listArguments[["image"]])
names(listArguments)[which(names(listArguments)=="image")]="data"
listArguments[["data"]]=MicroArray_Object$RFile
if(datasetsource=="intern"){
designo<-MicroArray_Object$designo
}
thefunction=listArguments[["thefunction"]]
listArguments[["thefunction"]]=NULL
listArguments[["thefunctions"]]=NULL
h=listArguments[["h"]]
listArguments[["h"]]=NULL
w=listArguments[["w"]]
listArguments[["w"]]=NULL
Prepro_object<-do.call(thefunction,listArguments)
if(datasetsource=="extern"){
colnames(MicroArray_Object[[1]]$E)<-listfullnames
colnames(Prepro_object$dataBG$E)<-listfullnames
colnames(Prepro_object$dataNBA$E)<-listfullnames
colnames(MicroArray_Object[[1]]@.Data[[1]])<-listcelsnames[-1]
colnames(MicroArray_Object[[1]]@.Data[[2]])<-listcelsnames[-1]
rownames(MicroArray_Object[[1]]@.Data[[3]])<-listcelsnames[-1]
MicroArray_Object[[1]]@.Data[[3]]$FileName<-listfullnames
colnames(Prepro_object$dataBG@.Data[[1]])<-listcelsnames[-1]
Prepro_object$dataBG@.Data[[2]]$FileName<-listfullnames
colnames(Prepro_object$dataNBA[[1]])<-listcelsnames[-1]
Prepro_object$dataNBA[[2]]$FileName<-listfullnames
}

png(filename ="boxplot_before_BG.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
boxplot(log2(na.omit(as.data.frame(MicroArray_Object[[1]]$E))), main="Boxplot of log2( intensities) before Background Correction",col="red",ylab="log2( intensities)",xlab="",las=2,mar=c(15,2,1,1))
invisible(dev.off())

png(filename ="boxplot_after_BG.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
boxplot(log2(na.omit(as.data.frame(Prepro_object$dataBG$E))), main="Boxplot of log2( intensities) After Background Correction",col="red",ylab="log2( intensities)",xlab="",las=2,mar=c(15,2,1,1))
invisible(dev.off())

png(filename ="boxplot_after_NBA.png",width = w, height = h, units = "px", pointsize = 14, bg = "white")
boxplot(log2(na.omit(as.data.frame(Prepro_object$dataNBA$E))), main="Boxplot of log2( intensities) After Normalization Between Arrays",col="red",ylab="log2(R intensities)",xlab="",las=2,mar=c(15,2,1,1))
invisible(dev.off())

png(filename = "densities_plot_before_BG.png",width = w, height = h)
plotDensities(MicroArray_Object[[1]],log=T)
invisible(dev.off())

png(filename = "densities_plot_after_BG.png",width = w, height = h)
plotDensities(Prepro_object$dataBG,log=T)
invisible(dev.off())


png(filename = "densities_plot_after_NBA.png",width = w, height = h)
plotDensities(Prepro_object$dataNBA,log=T)
invisible(dev.off())

OneColorRmd=file_path("OneColor.Rmd")
Style=file_path("look.css")
suppressWarnings(suppressMessages(knit2html(OneColorRmd,output="PreprocessingPlots.html",quiet = T)))
#suppressWarnings(suppressMessages(markdownToHTML(OneColorRmd,output="PreprocessingPlots.html",quiet = T, stylesheet=Style)))
# suppressWarnings(suppressMessages(knit2html(OneColorRmd,output="PreprocessingPlots.html",quiet = T, stylesheet=Style)))
rm(listArguments)
save.image("MicroArray.Preprocessing.RData")
sink()
sink()