"""
"""

__author__ = 'mkh'

if __name__ == '__main__':
    import argparse
    import os
    from shutil import copyfile
    import sys

    parser = argparse.ArgumentParser(description='Fake IPS.')

    parser.add_argument('-dp', action='store_true')
    parser.add_argument('--input')
    parser.add_argument('--seqtype', default='p')
    parser.add_argument('-f', dest='formats', default='tsv')
    parser.add_argument('--applications')
    parser.add_argument('--tempdir')
    parser.add_argument('--pathways', action='store_true')
    parser.add_argument('--goterms', action='store_true')
    parser.add_argument('--iprlookup', action='store_true')
    parser.add_argument('--mode')
    parser.add_argument('--clusterrunid')
    parser.add_argument('--output-file-base', dest='output_file_base')
    parser.add_argument('-o', dest='output_file', default="/tmp/junk")

    args = parser.parse_args()
    formats = args.formats.split(',')
    src_data_dir = os.path.dirname(__file__) + '/data-' + args.seqtype

    for ext in formats:
        if ext in ['html', 'svg']:
            ext += '.tar.gz'
        copyfile(src_data_dir + '/' + '__base__' + '.' + ext, args.output_file_base + '.' + ext)
