/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.datasources.providers.RMDDataState;
import org.broadinstitute.sting.gatk.datasources.providers.RODMetaDataContainer;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;

class WindowedData {
    private final TreeMap<Integer, RODMetaDataContainer> mapping = new TreeMap();
    private GenomeLoc currentLoc;
    private List<RMDDataState> states;
    private final ShardDataProvider provider;
    private static Logger logger = Logger.getLogger(WindowedData.class);

    public WindowedData(ShardDataProvider provider) {
        this.provider = provider;
    }

    private void getStates(ShardDataProvider provider, SAMRecord rec) {
        int stop = Integer.MAX_VALUE;
        if (provider.hasReference()) {
            stop = provider.getReference().getSequenceDictionary().getSequence(rec.getReferenceIndex()).getSequenceLength();
        }
        GenomeLoc range = provider.getGenomeLocParser().createGenomeLoc(rec.getReferenceName(), rec.getAlignmentStart(), stop);
        this.states = new ArrayList<RMDDataState>();
        if (provider != null && provider.getReferenceOrderedData() != null) {
            for (ReferenceOrderedDataSource dataSource : provider.getReferenceOrderedData()) {
                this.states.add(new RMDDataState(dataSource, dataSource.seek(range)));
            }
        }
    }

    WindowedData(List<RMDDataState> states) {
        this.states = states;
        this.provider = null;
    }

    public ReadMetaDataTracker getTracker(SAMRecord rec) {
        this.updatePosition(rec);
        return new ReadMetaDataTracker(this.provider.getGenomeLocParser(), rec, this.mapping);
    }

    private void updatePosition(SAMRecord rec) {
        if (this.states == null) {
            this.getStates(this.provider, rec);
        }
        this.currentLoc = this.provider.getGenomeLocParser().createGenomeLoc(rec);
        while (this.mapping.size() > 0 && this.mapping.firstKey() < this.currentLoc.getStart()) {
            this.mapping.pollFirstEntry();
        }
        for (RMDDataState state : this.states) {
            while (state.iterator.hasNext() && state.iterator.peekNextLocation().isBefore(this.currentLoc)) {
                state.iterator.next();
            }
            while (state.iterator.hasNext() && state.iterator.peekNextLocation().overlapsP(this.currentLoc)) {
                RODRecordList list = (RODRecordList)state.iterator.next();
                for (GATKFeature datum : list) {
                    if (!this.mapping.containsKey(list.getLocation().getStart())) {
                        this.mapping.put(list.getLocation().getStart(), new RODMetaDataContainer());
                    }
                    this.mapping.get(list.getLocation().getStart()).addEntry(datum);
                }
            }
        }
    }

    public void close() {
        if (this.states == null) {
            return;
        }
        for (RMDDataState state : this.states) {
            state.dataSource.close(state.iterator);
        }
        this.states = null;
    }
}

