/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.AbstractBAMFileIndex;

public class LinearIndex {
    public static final int MAX_LINEAR_INDEX_SIZE = AbstractBAMFileIndex.MAX_LINEAR_INDEX_SIZE;
    public static final int BAM_LIDX_SHIFT = 14;
    private final int mReferenceSequence;
    private final int mIndexStart;
    private final long[] mIndexEntries;

    public LinearIndex(int referenceSequence, int indexStart, long[] indexEntries) {
        this.mReferenceSequence = referenceSequence;
        this.mIndexStart = indexStart;
        this.mIndexEntries = indexEntries;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public int size() {
        return this.mIndexEntries.length;
    }

    public long get(int index) {
        return this.mIndexEntries[index - this.mIndexStart];
    }

    public static int convertToLinearIndexOffset(int contigPos) {
        int indexPos = contigPos <= 0 ? 0 : contigPos - 1;
        return indexPos >> 14;
    }

    public long getMinimumOffset(int startPos) {
        int start = startPos <= 0 ? 0 : startPos - 1;
        int regionLinearBin = start >> 14;
        long minimumOffset = 0L;
        if (regionLinearBin < this.mIndexEntries.length - this.mIndexStart) {
            minimumOffset = this.mIndexEntries[regionLinearBin - this.mIndexStart];
        }
        return minimumOffset;
    }

    protected long[] getIndexEntries() {
        return this.mIndexEntries;
    }

    protected int getIndexStart() {
        return this.mIndexStart;
    }
}

