/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.InputStream;
import net.sf.samtools.util.AsciiLineReaderImpl;
import net.sf.samtools.util.BufferedLineReader;
import net.sf.samtools.util.LineReader;

public class AsciiLineReader
implements LineReader {
    private final LineReader readerImpl;
    private static boolean useAsciiLineReaderImpl = !AsciiLineReader.isLinux();

    private static boolean isMacOs() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    private static boolean isLinux() {
        return "Linux".equals(System.getProperty("os.name"));
    }

    public AsciiLineReader(InputStream is) {
        this.readerImpl = useAsciiLineReaderImpl ? new AsciiLineReaderImpl(is) : new BufferedLineReader(is);
    }

    public AsciiLineReader(InputStream is, int bufferSize) {
        this.readerImpl = useAsciiLineReaderImpl ? new AsciiLineReaderImpl(is, bufferSize) : new BufferedLineReader(is, bufferSize);
    }

    @Override
    public String readLine() {
        return this.readerImpl.readLine();
    }

    @Override
    public int getLineNumber() {
        return this.readerImpl.getLineNumber();
    }

    @Override
    public int peek() {
        return this.readerImpl.peek();
    }

    @Override
    public void close() {
        this.readerImpl.close();
    }
}

