/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.introspection.JexlPropertyGet;
import org.apache.commons.jexl2.introspection.JexlPropertySet;
import org.apache.commons.jexl2.introspection.Uberspect;
import org.apache.commons.jexl2.parser.ASTAdditiveNode;
import org.apache.commons.jexl2.parser.ASTAdditiveOperator;
import org.apache.commons.jexl2.parser.ASTAmbiguous;
import org.apache.commons.jexl2.parser.ASTAndNode;
import org.apache.commons.jexl2.parser.ASTArrayAccess;
import org.apache.commons.jexl2.parser.ASTArrayLiteral;
import org.apache.commons.jexl2.parser.ASTAssignment;
import org.apache.commons.jexl2.parser.ASTBitwiseAndNode;
import org.apache.commons.jexl2.parser.ASTBitwiseComplNode;
import org.apache.commons.jexl2.parser.ASTBitwiseOrNode;
import org.apache.commons.jexl2.parser.ASTBitwiseXorNode;
import org.apache.commons.jexl2.parser.ASTBlock;
import org.apache.commons.jexl2.parser.ASTConstructorNode;
import org.apache.commons.jexl2.parser.ASTDivNode;
import org.apache.commons.jexl2.parser.ASTEQNode;
import org.apache.commons.jexl2.parser.ASTERNode;
import org.apache.commons.jexl2.parser.ASTEmptyFunction;
import org.apache.commons.jexl2.parser.ASTFalseNode;
import org.apache.commons.jexl2.parser.ASTFloatLiteral;
import org.apache.commons.jexl2.parser.ASTForeachStatement;
import org.apache.commons.jexl2.parser.ASTFunctionNode;
import org.apache.commons.jexl2.parser.ASTGENode;
import org.apache.commons.jexl2.parser.ASTGTNode;
import org.apache.commons.jexl2.parser.ASTIdentifier;
import org.apache.commons.jexl2.parser.ASTIfStatement;
import org.apache.commons.jexl2.parser.ASTIntegerLiteral;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.ASTLENode;
import org.apache.commons.jexl2.parser.ASTLTNode;
import org.apache.commons.jexl2.parser.ASTMapEntry;
import org.apache.commons.jexl2.parser.ASTMapLiteral;
import org.apache.commons.jexl2.parser.ASTMethodNode;
import org.apache.commons.jexl2.parser.ASTModNode;
import org.apache.commons.jexl2.parser.ASTMulNode;
import org.apache.commons.jexl2.parser.ASTNENode;
import org.apache.commons.jexl2.parser.ASTNRNode;
import org.apache.commons.jexl2.parser.ASTNotNode;
import org.apache.commons.jexl2.parser.ASTNullLiteral;
import org.apache.commons.jexl2.parser.ASTOrNode;
import org.apache.commons.jexl2.parser.ASTReference;
import org.apache.commons.jexl2.parser.ASTSizeFunction;
import org.apache.commons.jexl2.parser.ASTSizeMethod;
import org.apache.commons.jexl2.parser.ASTStringLiteral;
import org.apache.commons.jexl2.parser.ASTTernaryNode;
import org.apache.commons.jexl2.parser.ASTTrueNode;
import org.apache.commons.jexl2.parser.ASTUnaryMinusNode;
import org.apache.commons.jexl2.parser.ASTWhileStatement;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.ParserVisitor;
import org.apache.commons.jexl2.parser.SimpleNode;
import org.apache.commons.logging.Log;

public class Interpreter
implements ParserVisitor {
    protected final Log logger;
    protected final Uberspect uberspect;
    protected final JexlArithmetic arithmetic;
    protected final Map<String, Object> functions;
    protected Map<String, Object> functors;
    protected final JexlContext context;
    protected final boolean strict;
    protected boolean silent;
    protected final boolean cache;
    protected Object[] registers = null;
    protected static final Object[] EMPTY_PARAMS = new Object[0];

    public Interpreter(JexlEngine jexl, JexlContext aContext) {
        this.logger = jexl.logger;
        this.uberspect = jexl.uberspect;
        this.arithmetic = jexl.arithmetic;
        this.functions = jexl.functions;
        this.strict = !this.arithmetic.isLenient();
        this.silent = jexl.silent;
        this.cache = jexl.cache != null;
        this.context = aContext;
        this.functors = null;
    }

    public void setSilent(boolean flag) {
        this.silent = flag;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public Object interpret(JexlNode node) {
        try {
            return node.jjtAccept(this, null);
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn(xjexl.getMessage(), xjexl.getCause());
                return null;
            }
            throw xjexl;
        }
    }

    protected Uberspect getUberspect() {
        return this.uberspect;
    }

    protected void setRegisters(Object[] theRegisters) {
        this.registers = theRegisters;
    }

    protected JexlNode findNullOperand(RuntimeException xrt, JexlNode node, Object left, Object right) {
        if (xrt instanceof NullPointerException && "jexl.null" == xrt.getMessage()) {
            if (left == null) {
                return node.jjtGetChild(0);
            }
            if (right == null) {
                return node.jjtGetChild(1);
            }
        }
        return node;
    }

    protected Object unknownVariable(JexlException xjexl) {
        if (this.strict) {
            throw xjexl;
        }
        if (!this.silent) {
            this.logger.warn(xjexl.getMessage());
        }
        return null;
    }

    protected Object invocationFailed(JexlException xjexl) {
        if (this.strict) {
            throw xjexl;
        }
        if (!this.silent) {
            this.logger.warn(xjexl.getMessage(), xjexl.getCause());
        }
        return null;
    }

    protected Object resolveNamespace(String prefix, JexlNode node) {
        Object[] args;
        Constructor<?> ctor;
        Object namespace;
        if (this.functors != null && (namespace = this.functors.get(prefix)) != null) {
            return namespace;
        }
        namespace = this.functions.get(prefix);
        if (namespace == null) {
            throw new JexlException(node, "no such function namespace " + prefix);
        }
        if (namespace instanceof Class && (ctor = this.uberspect.getConstructor(namespace, args = new Object[]{this.context}, node)) != null) {
            try {
                namespace = ctor.newInstance(args);
                if (this.functors == null) {
                    this.functors = new HashMap<String, Object>();
                }
                this.functors.put(prefix, namespace);
            }
            catch (Exception xinst) {
                throw new JexlException(node, "unable to instantiate namespace " + prefix, (Throwable)xinst);
            }
        }
        return namespace;
    }

    public Object visit(ASTAdditiveNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        int size = node.jjtGetNumChildren();
        for (int c = 2; c < size; c += 2) {
            Object right = node.jjtGetChild(c).jjtAccept(this, data);
            try {
                JexlNode op = node.jjtGetChild(c - 1);
                if (op instanceof ASTAdditiveOperator) {
                    String which = ((ASTAdditiveOperator)op).image;
                    if ("+".equals(which)) {
                        left = this.arithmetic.add(left, right);
                        continue;
                    }
                    if ("-".equals(which)) {
                        left = this.arithmetic.subtract(left, right);
                        continue;
                    }
                    throw new UnsupportedOperationException("unknown operator " + which);
                }
                throw new IllegalArgumentException("unknown operator " + op);
            }
            catch (RuntimeException xrt) {
                JexlNode xnode = this.findNullOperand(xrt, node, left, right);
                throw new JexlException(xnode, "+/- error", (Throwable)xrt);
            }
        }
        return left;
    }

    public Object visit(ASTAdditiveOperator node, Object data) {
        throw new UnsupportedOperationException("Shoud not be called.");
    }

    public Object visit(ASTAndNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            boolean leftValue = this.arithmetic.toBoolean(left);
            if (!leftValue) {
                return Boolean.FALSE;
            }
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(0), "boolean coercion error", (Throwable)xrt);
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            boolean rightValue = this.arithmetic.toBoolean(right);
            if (!rightValue) {
                return Boolean.FALSE;
            }
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(1), "boolean coercion error", (Throwable)xrt);
        }
        return Boolean.TRUE;
    }

    public Object visit(ASTArrayAccess node, Object data) {
        Object object = node.jjtGetChild(0).jjtAccept(this, data);
        int numChildren = node.jjtGetNumChildren();
        for (int i = 1; i < numChildren; ++i) {
            JexlNode nindex = node.jjtGetChild(i);
            Object index = nindex.jjtAccept(this, null);
            object = this.getAttribute(object, index, nindex);
        }
        return object;
    }

    public Object visit(ASTArrayLiteral node, Object data) {
        int childCount = node.jjtGetNumChildren();
        Object[] array = new Object[childCount];
        for (int i = 0; i < childCount; ++i) {
            Object entry;
            array[i] = entry = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return this.arithmetic.narrowArrayType(array);
    }

    public Object visit(ASTAssignment node, Object data) {
        JexlNode left = node.jjtGetChild(0);
        if (!(left instanceof ASTReference)) {
            throw new JexlException(left, "illegal assignment form");
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        JexlNode objectNode = null;
        Object object = null;
        JexlNode propertyNode = null;
        Object property = null;
        boolean isVariable = true;
        int v = 0;
        StringBuilder variableName = null;
        int last = left.jjtGetNumChildren() - 1;
        for (int c = 0; c < last; ++c) {
            objectNode = left.jjtGetChild(c);
            object = objectNode.jjtAccept(this, object);
            if (object != null) continue;
            if (isVariable &= objectNode instanceof ASTIdentifier) {
                if (v == 0) {
                    variableName = new StringBuilder(left.jjtGetChild((int)0).image);
                    v = 1;
                }
                while (v <= c) {
                    variableName.append('.');
                    variableName.append(left.jjtGetChild((int)v).image);
                    ++v;
                }
                object = this.context.get(variableName.toString());
                if (object == null) continue;
                isVariable = false;
                continue;
            }
            throw new JexlException(objectNode, "illegal assignment form");
        }
        propertyNode = left.jjtGetChild(last);
        if (propertyNode instanceof ASTIdentifier) {
            property = ((ASTIdentifier)propertyNode).image;
            if (isVariable && object == null) {
                if (variableName != null) {
                    if (last > 0) {
                        variableName.append('.');
                    }
                    variableName.append(property);
                    property = variableName.toString();
                }
                this.context.set(String.valueOf(property), right);
                return right;
            }
        } else if (propertyNode instanceof ASTIntegerLiteral) {
            property = this.visit((ASTIntegerLiteral)propertyNode, null);
            if (isVariable && object == null) {
                if (variableName != null) {
                    if (last > 0) {
                        variableName.append('.');
                    }
                    variableName.append(property);
                    property = variableName.toString();
                }
                this.context.set(String.valueOf(property), right);
                return right;
            }
        } else if (propertyNode instanceof ASTArrayAccess) {
            objectNode = propertyNode;
            ASTArrayAccess narray = (ASTArrayAccess)objectNode;
            Object nobject = narray.jjtGetChild(0).jjtAccept(this, object);
            if (nobject == null) {
                throw new JexlException(objectNode, "array element is null");
            }
            object = nobject;
            last = narray.jjtGetNumChildren() - 1;
            for (int i = 1; i < last; ++i) {
                objectNode = narray.jjtGetChild(i);
                Object index = objectNode.jjtAccept(this, null);
                object = this.getAttribute(object, index, objectNode);
            }
            property = narray.jjtGetChild(last).jjtAccept(this, null);
        } else {
            throw new JexlException(objectNode, "illegal assignment form");
        }
        if (property == null) {
            throw new JexlException(propertyNode, "property is null");
        }
        if (object == null) {
            throw new JexlException(objectNode, "bean is null");
        }
        this.setAttribute(object, property, right, propertyNode);
        return right;
    }

    public Object visit(ASTBitwiseAndNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        int n = 0;
        try {
            long l = this.arithmetic.toLong(left);
            n = 1;
            long r = this.arithmetic.toLong(right);
            return l & r;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(n), "long coercion error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBitwiseComplNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            long l = this.arithmetic.toLong(left);
            return l ^ 0xFFFFFFFFFFFFFFFFL;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(0), "long coercion error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBitwiseOrNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        int n = 0;
        try {
            long l = this.arithmetic.toLong(left);
            n = 1;
            long r = this.arithmetic.toLong(right);
            return l | r;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(n), "long coercion error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBitwiseXorNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        int n = 0;
        try {
            long l = this.arithmetic.toLong(left);
            n = 1;
            long r = this.arithmetic.toLong(right);
            return l ^ r;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(n), "long coercion error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBlock node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        for (int i = 0; i < numChildren; ++i) {
            result = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return result;
    }

    public Object visit(ASTDivNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.divide(left, right);
        }
        catch (RuntimeException xrt) {
            if (!this.strict && xrt instanceof ArithmeticException) {
                return new Double(0.0);
            }
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "divide error", (Throwable)xrt);
        }
    }

    public Object visit(ASTEmptyFunction node, Object data) {
        Object o = node.jjtGetChild(0).jjtAccept(this, data);
        if (o == null) {
            return Boolean.TRUE;
        }
        if (o instanceof String && "".equals(o)) {
            return Boolean.TRUE;
        }
        if (o.getClass().isArray() && ((Object[])o).length == 0) {
            return Boolean.TRUE;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return Boolean.TRUE;
        }
        if (o instanceof Map && ((Map)o).isEmpty()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTEQNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.equals(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node, "== error", (Throwable)xrt);
        }
    }

    public Object visit(ASTFalseNode node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTFloatLiteral node, Object data) {
        Float value = (Float)node.jjtGetValue();
        if (value == null) {
            value = Float.valueOf(node.image);
            node.jjtSetValue(value);
        }
        return value;
    }

    public Object visit(ASTForeachStatement node, Object data) {
        Object result = null;
        ASTReference loopReference = (ASTReference)node.jjtGetChild(0);
        ASTIdentifier loopVariable = (ASTIdentifier)loopReference.jjtGetChild(0);
        Object iterableValue = node.jjtGetChild(1).jjtAccept(this, data);
        if (iterableValue != null && node.jjtGetNumChildren() >= 3) {
            JexlNode statement = node.jjtGetChild(2);
            Iterator<?> itemsIterator = this.getUberspect().getIterator(iterableValue, node);
            if (itemsIterator != null) {
                while (itemsIterator.hasNext()) {
                    Object value = itemsIterator.next();
                    this.context.set(loopVariable.image, value);
                    result = statement.jjtAccept(this, data);
                }
            }
        }
        return result;
    }

    public Object visit(ASTGENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.greaterThanOrEqual(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node, ">= error", (Throwable)xrt);
        }
    }

    public Object visit(ASTGTNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.greaterThan(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node, "> error", (Throwable)xrt);
        }
    }

    public Object visit(ASTERNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.matches(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node, "=~ error", (Throwable)xrt);
        }
    }

    public Object visit(ASTIdentifier node, Object data) {
        String name = node.image;
        if (data == null) {
            Object value;
            if (this.registers != null) {
                if (this.registers[0].equals(name)) {
                    return this.registers[1];
                }
                if (this.registers[2].equals(name)) {
                    return this.registers[3];
                }
            }
            if ((value = this.context.get(name)) == null && !(node.jjtGetParent() instanceof ASTReference) && !this.context.has(name)) {
                JexlException xjexl = new JexlException(node, "undefined variable " + name);
                return this.unknownVariable(xjexl);
            }
            return value;
        }
        return this.getAttribute(data, name, node);
    }

    public Object visit(ASTIfStatement node, Object data) {
        int n = 0;
        try {
            Object result = null;
            Object expression = node.jjtGetChild(0).jjtAccept(this, data);
            if (this.arithmetic.toBoolean(expression)) {
                n = 1;
                result = node.jjtGetChild(1).jjtAccept(this, data);
            } else if (node.jjtGetNumChildren() == 3) {
                n = 2;
                result = node.jjtGetChild(2).jjtAccept(this, data);
            }
            return result;
        }
        catch (JexlException error) {
            throw error;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(n), "if error", (Throwable)xrt);
        }
    }

    public Object visit(ASTIntegerLiteral node, Object data) {
        if (data != null) {
            Integer value = Integer.valueOf(node.image);
            return this.getAttribute(data, value, node);
        }
        Integer value = (Integer)node.jjtGetValue();
        if (value == null) {
            value = Integer.valueOf(node.image);
            node.jjtSetValue(value);
        }
        return value;
    }

    public Object visit(ASTJexlScript node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        for (int i = 0; i < numChildren; ++i) {
            JexlNode child = node.jjtGetChild(i);
            result = child.jjtAccept(this, data);
        }
        return result;
    }

    public Object visit(ASTLENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.lessThanOrEqual(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node, "<= error", (Throwable)xrt);
        }
    }

    public Object visit(ASTLTNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.lessThan(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node, "< error", (Throwable)xrt);
        }
    }

    public Object visit(ASTMapEntry node, Object data) {
        Object key = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return new Object[]{key, value};
    }

    public Object visit(ASTMapLiteral node, Object data) {
        int childCount = node.jjtGetNumChildren();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < childCount; ++i) {
            Object[] entry = (Object[])node.jjtGetChild(i).jjtAccept(this, data);
            map.put(entry[0], entry[1]);
        }
        return map;
    }

    public Object visit(ASTMethodNode node, Object data) {
        if (data == null) {
            if (node.jjtGetParent().jjtGetChild(0) == node) {
                data = this.resolveNamespace(null, node);
                if (data == null) {
                    throw new JexlException(node, "no default function namespace");
                }
            } else {
                throw new JexlException(node, "attempting to call method on null");
            }
        }
        String methodName = ((ASTIdentifier)node.jjtGetChild((int)0)).image;
        int argc = node.jjtGetNumChildren() - 1;
        Object[] argv = new Object[argc];
        for (int i = 0; i < argc; ++i) {
            argv[i] = node.jjtGetChild(i + 1).jjtAccept(this, null);
        }
        JexlException xjexl = null;
        try {
            Object eval;
            JexlMethod me;
            Object cached;
            if (this.cache && (cached = node.jjtGetValue()) instanceof JexlMethod && !(me = (JexlMethod)cached).tryFailed(eval = me.tryInvoke(methodName, data, argv))) {
                return eval;
            }
            JexlMethod vm = this.uberspect.getMethod(data, methodName, argv, node);
            if (vm == null) {
                if (this.arithmetic.narrowArguments(argv)) {
                    vm = this.uberspect.getMethod(data, methodName, argv, node);
                }
                if (vm == null) {
                    xjexl = new JexlException(node, "unknown or ambiguous method", null);
                }
            }
            if (xjexl == null) {
                Object eval2 = vm.invoke(data, argv);
                if (this.cache && vm.isCacheable()) {
                    node.jjtSetValue(vm);
                }
                return eval2;
            }
        }
        catch (InvocationTargetException e) {
            xjexl = new JexlException(node, "method invocation error", e.getCause());
        }
        catch (Exception e) {
            xjexl = new JexlException(node, "method error", (Throwable)e);
        }
        return this.invocationFailed(xjexl);
    }

    public Object visit(ASTConstructorNode node, Object data) {
        Object cobject = node.jjtGetChild(0).jjtAccept(this, data);
        int argc = node.jjtGetNumChildren() - 1;
        Object[] argv = new Object[argc];
        for (int i = 0; i < argc; ++i) {
            argv[i] = node.jjtGetChild(i + 1).jjtAccept(this, null);
        }
        JexlException xjexl = null;
        try {
            Constructor<?> ctor = this.uberspect.getConstructor(cobject, argv, node);
            if (ctor == null) {
                if (this.arithmetic.narrowArguments(argv)) {
                    ctor = this.uberspect.getConstructor(cobject, argv, node);
                }
                if (ctor == null) {
                    xjexl = new JexlException(node, "unknown constructor", null);
                }
            }
            if (xjexl == null) {
                return ctor.newInstance(argv);
            }
        }
        catch (InvocationTargetException e) {
            xjexl = new JexlException(node, "constructor invocation error", e.getCause());
        }
        catch (Exception e) {
            xjexl = new JexlException(node, "constructor error", (Throwable)e);
        }
        return this.invocationFailed(xjexl);
    }

    public Object visit(ASTFunctionNode node, Object data) {
        String prefix = ((ASTIdentifier)node.jjtGetChild((int)0)).image;
        Object namespace = this.resolveNamespace(prefix, node);
        String function = ((ASTIdentifier)node.jjtGetChild((int)1)).image;
        int argc = node.jjtGetNumChildren() - 2;
        Object[] argv = new Object[argc];
        for (int i = 0; i < argc; ++i) {
            argv[i] = node.jjtGetChild(i + 2).jjtAccept(this, null);
        }
        JexlException xjexl = null;
        try {
            Object eval;
            JexlMethod me;
            Object cached;
            if (this.cache && (cached = node.jjtGetValue()) instanceof JexlMethod && !(me = (JexlMethod)cached).tryFailed(eval = me.tryInvoke(function, namespace, argv))) {
                return eval;
            }
            JexlMethod vm = this.uberspect.getMethod(namespace, function, argv, node);
            if (vm == null) {
                if (this.arithmetic.narrowArguments(argv)) {
                    vm = this.uberspect.getMethod(namespace, function, argv, node);
                }
                if (vm == null) {
                    xjexl = new JexlException(node, "unknown function", null);
                }
            }
            if (xjexl == null) {
                Object eval2 = vm.invoke(namespace, argv);
                if (this.cache && vm.isCacheable()) {
                    node.jjtSetValue(vm);
                }
                return eval2;
            }
        }
        catch (InvocationTargetException e) {
            xjexl = new JexlException(node, "function invocation error", e.getCause());
        }
        catch (Exception e) {
            xjexl = new JexlException(node, "function error", (Throwable)e);
        }
        return this.invocationFailed(xjexl);
    }

    public Object visit(ASTModNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.mod(left, right);
        }
        catch (RuntimeException xrt) {
            if (!this.strict && xrt instanceof ArithmeticException) {
                return new Double(0.0);
            }
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "% error", (Throwable)xrt);
        }
    }

    public Object visit(ASTMulNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.multiply(left, right);
        }
        catch (RuntimeException xrt) {
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "* error", (Throwable)xrt);
        }
    }

    public Object visit(ASTNENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.equals(left, right) ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (RuntimeException xrt) {
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "!= error", (Throwable)xrt);
        }
    }

    public Object visit(ASTNRNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.matches(left, right) ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node, "!~ error", (Throwable)xrt);
        }
    }

    public Object visit(ASTNotNode node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        return this.arithmetic.toBoolean(val) ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object visit(ASTNullLiteral node, Object data) {
        return null;
    }

    public Object visit(ASTOrNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            boolean leftValue = this.arithmetic.toBoolean(left);
            if (leftValue) {
                return Boolean.TRUE;
            }
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(0), "boolean coercion error", (Throwable)xrt);
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            boolean rightValue = this.arithmetic.toBoolean(right);
            if (rightValue) {
                return Boolean.TRUE;
            }
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(1), "boolean coercion error", (Throwable)xrt);
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTReference node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        StringBuilder variableName = null;
        boolean isVariable = true;
        int v = 0;
        for (int c = 0; c < numChildren; ++c) {
            JexlNode theNode = node.jjtGetChild(c);
            result = theNode.jjtAccept(this, result);
            if (result != null || !(isVariable &= theNode instanceof ASTIdentifier)) continue;
            if (v == 0) {
                variableName = new StringBuilder(node.jjtGetChild((int)0).image);
                v = 1;
            }
            while (v <= c) {
                variableName.append('.');
                variableName.append(node.jjtGetChild((int)v).image);
                ++v;
            }
            result = this.context.get(variableName.toString());
        }
        if (result == null && isVariable && !(node.jjtGetParent() instanceof ASTTernaryNode) && !this.context.has(variableName.toString())) {
            JexlException xjexl = new JexlException(node, "undefined variable " + variableName.toString());
            return this.unknownVariable(xjexl);
        }
        return result;
    }

    public Object visit(ASTSizeFunction node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        if (val == null) {
            throw new JexlException(node, "size() : argument is null", null);
        }
        return this.sizeOf(node, val);
    }

    public Object visit(ASTSizeMethod node, Object data) {
        return this.sizeOf(node, data);
    }

    public Object visit(ASTStringLiteral node, Object data) {
        return node.image;
    }

    public Object visit(ASTTernaryNode node, Object data) {
        Object condition = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 3) {
            if (condition != null && this.arithmetic.toBoolean(condition)) {
                return node.jjtGetChild(1).jjtAccept(this, data);
            }
            return node.jjtGetChild(2).jjtAccept(this, data);
        }
        if (condition != null && !Boolean.FALSE.equals(condition)) {
            return condition;
        }
        return node.jjtGetChild(1).jjtAccept(this, data);
    }

    public Object visit(ASTTrueNode node, Object data) {
        return Boolean.TRUE;
    }

    public Object visit(ASTUnaryMinusNode node, Object data) {
        JexlNode valNode = node.jjtGetChild(0);
        Object val = valNode.jjtAccept(this, data);
        if (val instanceof Byte) {
            byte valueAsByte = (Byte)val;
            return -valueAsByte;
        }
        if (val instanceof Short) {
            short valueAsShort = (Short)val;
            return -valueAsShort;
        }
        if (val instanceof Integer) {
            int valueAsInt = (Integer)val;
            return -valueAsInt;
        }
        if (val instanceof Long) {
            long valueAsLong = (Long)val;
            return -valueAsLong;
        }
        if (val instanceof Float) {
            float valueAsFloat = ((Float)val).floatValue();
            return new Float(-valueAsFloat);
        }
        if (val instanceof Double) {
            double valueAsDouble = (Double)val;
            return new Double(-valueAsDouble);
        }
        if (val instanceof BigDecimal) {
            BigDecimal valueAsBigD = (BigDecimal)val;
            return valueAsBigD.negate();
        }
        if (val instanceof BigInteger) {
            BigInteger valueAsBigI = (BigInteger)val;
            return valueAsBigI.negate();
        }
        throw new JexlException(valNode, "not a number");
    }

    public Object visit(ASTWhileStatement node, Object data) {
        Object result = null;
        JexlNode expressionNode = node.jjtGetChild(0);
        while (this.arithmetic.toBoolean(expressionNode.jjtAccept(this, data))) {
            result = node.jjtGetChild(1).jjtAccept(this, data);
        }
        return result;
    }

    private int sizeOf(JexlNode node, Object val) {
        if (val instanceof Collection) {
            return ((Collection)val).size();
        }
        if (val.getClass().isArray()) {
            return Array.getLength(val);
        }
        if (val instanceof Map) {
            return ((Map)val).size();
        }
        if (val instanceof String) {
            return ((String)val).length();
        }
        Object[] params = new Object[]{};
        JexlMethod vm = this.uberspect.getMethod(val, "size", EMPTY_PARAMS, node);
        if (vm != null && vm.getReturnType() == Integer.TYPE) {
            Integer result;
            try {
                result = (Integer)vm.invoke(val, params);
            }
            catch (Exception e) {
                throw new JexlException(node, "size() : error executing", (Throwable)e);
            }
            return result;
        }
        throw new JexlException(node, "size() : unsupported type : " + val.getClass(), null);
    }

    public Object getAttribute(Object object, Object attribute) {
        return this.getAttribute(object, attribute, null);
    }

    protected Object getAttribute(Object object, Object attribute, JexlNode node) {
        block8: {
            Object value;
            JexlPropertyGet vg;
            Object cached;
            if (object == null) {
                throw new JexlException(node, "object is null");
            }
            if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertyGet && !(vg = (JexlPropertyGet)cached).tryFailed(value = vg.tryInvoke(object, attribute))) {
                return value;
            }
            JexlPropertyGet vg2 = this.uberspect.getPropertyGet(object, attribute, node);
            if (vg2 != null) {
                try {
                    Object value2 = vg2.invoke(object);
                    if (node != null && this.cache && vg2.isCacheable()) {
                        node.jjtSetValue(vg2);
                    }
                    return value2;
                }
                catch (Exception xany) {
                    if (node == null) {
                        throw new RuntimeException(xany);
                    }
                    JexlException xjexl = new JexlException(node, "get object property error", (Throwable)xany);
                    if (this.strict) {
                        throw xjexl;
                    }
                    if (this.silent) break block8;
                    this.logger.warn(xjexl.getMessage());
                }
            }
        }
        return null;
    }

    public void setAttribute(Object object, Object attribute, Object value) {
        this.setAttribute(object, attribute, value, null);
    }

    protected void setAttribute(Object object, Object attribute, Object value, JexlNode node) {
        Object eval;
        JexlPropertySet setter;
        Object cached;
        if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertySet && !(setter = (JexlPropertySet)cached).tryFailed(eval = setter.tryInvoke(object, attribute, value))) {
            return;
        }
        JexlException xjexl = null;
        JexlPropertySet vs = this.uberspect.getPropertySet(object, attribute, value, node);
        if (vs != null) {
            try {
                vs.invoke(object, value);
                if (node != null && this.cache && vs.isCacheable()) {
                    node.jjtSetValue(vs);
                }
                return;
            }
            catch (RuntimeException xrt) {
                if (node == null) {
                    throw xrt;
                }
                xjexl = new JexlException(node, "set object property error", (Throwable)xrt);
            }
            catch (Exception xany) {
                if (node == null) {
                    throw new RuntimeException(xany);
                }
                xjexl = new JexlException(node, "set object property error", (Throwable)xany);
            }
        }
        if (xjexl == null) {
            String error = "unable to set object property, class: " + object.getClass().getName() + ", property: " + attribute;
            if (node == null) {
                throw new UnsupportedOperationException(error);
            }
            xjexl = new JexlException(node, error, null);
        }
        if (this.strict) {
            throw xjexl;
        }
        if (!this.silent) {
            this.logger.warn(xjexl.getMessage());
        }
    }

    public Object visit(SimpleNode node, Object data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(ASTAmbiguous node, Object data) {
        throw new UnsupportedOperationException("unexpected type of node");
    }
}

