/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.fastq;

import edu.unc.bioinf.ubu.fastq.FastqOutputFile;
import edu.unc.bioinf.ubu.fastq.FastqRecord;
import edu.unc.bioinf.ubu.fastq.Sam2FastqOptions;
import edu.unc.bioinf.ubu.sam.ReverseComplementor;
import java.io.File;
import java.io.IOException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class Sam2Fastq {
    private FastqOutputFile output1;
    private FastqOutputFile output2;
    private ReverseComplementor reverseComplementor = new ReverseComplementor();
    private boolean shouldIdentifyEndByReadId = false;
    private String end1Suffix;
    private String end2Suffix;

    public void convert(String inputSam, String outputFastq1, String outputFastq2) throws IOException {
        String last1Read = "";
        String last2Read = "";
        SAMFileReader reader = new SAMFileReader(new File(inputSam));
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.output1 = new FastqOutputFile();
        this.output1.init(outputFastq1);
        this.output2 = new FastqOutputFile();
        this.output2.init(outputFastq2);
        int output1Count = 0;
        int output2Count = 0;
        int lineCnt = 0;
        for (SAMRecord read : reader) {
            if (this.isFirstInPair(read)) {
                if (!read.getReadName().equals(last1Read)) {
                    this.output1.write(this.samReadToFastqRecord(read));
                    last1Read = read.getReadName();
                    ++output1Count;
                }
            } else if (this.isSecondInPair(read) && !read.getReadName().equals(last2Read)) {
                this.output2.write(this.samReadToFastqRecord(read));
                last2Read = read.getReadName();
                ++output2Count;
            }
            if (++lineCnt % 1000000 != 0) continue;
            System.out.println("record: " + lineCnt);
        }
        this.output1.close();
        this.output2.close();
        if (output1Count != output2Count) {
            throw new IllegalStateException("Non-symmetrical read counts found for " + inputSam + ".  Your reads may not be paired properly.");
        }
    }

    public void convert(String inputSam, String outputFastq) throws IOException {
        String last1Read = "";
        SAMFileReader reader = new SAMFileReader(new File(inputSam));
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.output1 = new FastqOutputFile();
        this.output1.init(outputFastq);
        int lineCnt = 0;
        for (SAMRecord read : reader) {
            if (!read.getReadName().equals(last1Read)) {
                this.output1.write(this.samReadToFastqRecord(read));
                last1Read = read.getReadName();
            }
            if (++lineCnt % 1000000 != 0) continue;
            System.out.println("record: " + lineCnt);
        }
        this.output1.close();
    }

    private FastqRecord samReadToFastqRecord(SAMRecord read) {
        String bases = read.getReadString();
        String qualities = read.getBaseQualityString();
        if (read.getReadNegativeStrandFlag()) {
            bases = this.reverseComplementor.reverseComplement(bases);
            qualities = this.reverseComplementor.reverse(qualities);
        }
        FastqRecord fastq = new FastqRecord("@" + read.getReadName(), bases, qualities);
        return fastq;
    }

    private boolean isFirstInPair(SAMRecord read) {
        boolean isFirstInPair = this.shouldIdentifyEndByReadId ? read.getReadName().endsWith(this.end1Suffix) : read.getFirstOfPairFlag();
        return isFirstInPair;
    }

    private boolean isSecondInPair(SAMRecord read) {
        boolean isSecondInPair = this.shouldIdentifyEndByReadId ? read.getReadName().endsWith(this.end2Suffix) : read.getSecondOfPairFlag();
        return isSecondInPair;
    }

    public void setEndSuffixes(String end1Suffix, String end2Suffix) {
        this.shouldIdentifyEndByReadId = true;
        this.end1Suffix = end1Suffix;
        this.end2Suffix = end2Suffix;
    }

    public static void run(String[] args) throws IOException {
        Sam2FastqOptions options = new Sam2FastqOptions();
        options.parseOptions(args);
        if (options.isValid()) {
            long s = System.currentTimeMillis();
            System.out.println("sam2fastq starting");
            Sam2Fastq sam2Fastq = new Sam2Fastq();
            if (options.isPairedEnd()) {
                if (options.shouldIdEndByReadName()) {
                    sam2Fastq.setEndSuffixes(options.getEnd1Suffix(), options.getEnd2Suffix());
                }
                sam2Fastq.convert(options.getInputFile(), options.getFastq1(), options.getFastq2());
            } else {
                sam2Fastq.convert(options.getInputFile(), options.getFastq1());
            }
            long e = System.currentTimeMillis();
            System.out.println("sam2fastq done.  Elapsed secs: " + (e - s) / 1000L);
        }
    }
}

