/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.IsoformGeneMap;
import edu.unc.bioinf.ubu.sam.SamMultiMappingReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMRecord;

public class GeneReadCounter {
    private Map<String, Long> totalGeneCounts = new HashMap<String, Long>();
    private Map<String, Long> uniqueGeneCounts = new HashMap<String, Long>();
    private IsoformGeneMap isoformGeneMap = new IsoformGeneMap();
    private static final Long ONE = 1L;
    private static final Long ZERO = 0L;

    public void count(IsoformGeneMap isoformGeneMap, String inputSam, String outputFile) throws IOException {
        this.isoformGeneMap = isoformGeneMap;
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, false));
        this.countGenes(inputSam);
        this.outputCounts(writer);
        writer.close();
    }

    private void countGenes(String inputFile) {
        SamMultiMappingReader reader = new SamMultiMappingReader(inputFile);
        for (List<SAMRecord> reads : reader) {
            HashSet<String> genes = new HashSet<String>();
            boolean isUnique = true;
            String prevGenomeCoords = null;
            for (SAMRecord read : reads) {
                String isoform = read.getReferenceName();
                genes.add(this.isoformGeneMap.getGene(isoform));
                String genomeCoords = read.getStringAttribute("XG");
                if (prevGenomeCoords != null && !genomeCoords.equals(prevGenomeCoords)) {
                    isUnique = false;
                }
                prevGenomeCoords = genomeCoords;
            }
            for (String gene : genes) {
                this.incrementCount(this.totalGeneCounts, gene);
                if (!isUnique) continue;
                this.incrementCount(this.uniqueGeneCounts, gene);
            }
        }
    }

    private void outputCounts(BufferedWriter writer) throws IOException {
        List<String> genes = this.isoformGeneMap.getSortedGeneList();
        for (String gene : genes) {
            StringBuffer line = new StringBuffer();
            long totalCount = this.getCount(this.totalGeneCounts, gene);
            long uniqueCount = this.getCount(this.uniqueGeneCounts, gene);
            line.append(gene);
            line.append('\t');
            line.append(totalCount);
            line.append('\t');
            line.append(uniqueCount);
            line.append('\n');
            writer.write(line.toString());
        }
    }

    private void incrementCount(Map<String, Long> counts, String gene) {
        Long count = counts.get(gene);
        if (count == null) {
            counts.put(gene, ONE);
        } else {
            counts.put(gene, count + 1L);
        }
    }

    private long getCount(Map<String, Long> counts, String gene) {
        Long count = counts.get(gene);
        if (count == null) {
            count = ZERO;
        }
        return count;
    }

    public static void main(String[] args) throws IOException {
        String isoformGeneFile = args[0];
        String input = args[1];
        String output = args[2];
        long s = System.currentTimeMillis();
        IsoformGeneMap isoformGeneMap = new IsoformGeneMap();
        isoformGeneMap.init(isoformGeneFile);
        new GeneReadCounter().count(isoformGeneMap, input, output);
        long e = System.currentTimeMillis();
        System.out.println("Done.  Elapsed secs: " + (e - s) / 1000L);
    }
}

