/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.Coordinate;
import edu.unc.bioinf.ubu.sam.IsoformOrderLoader;
import edu.unc.bioinf.ubu.sam.ReadBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;

public class Isoform {
    private static final String FORWARD_STRAND = "+";
    private static final String REVERSE_STRAND = "-";
    private String isoformId;
    private Coordinate genomicCoord;
    private List<Coordinate> exons;
    private Strand strand;
    private int length;

    public Isoform(String isoformId, Coordinate genomicCoord, String strand, List<Coordinate> exons) {
        this.isoformId = isoformId;
        this.genomicCoord = genomicCoord;
        this.exons = exons;
        this.length = this.calcLength();
        if (strand.equals(FORWARD_STRAND)) {
            this.strand = Strand.FORWARD;
        } else if (strand.equals(REVERSE_STRAND)) {
            this.strand = Strand.REVERSE;
        } else {
            throw new IllegalArgumentException("Invalid strand: " + strand + " for isoform: " + isoformId);
        }
    }

    public boolean containsWithinGenomicRange(int genomicStartPos, int genomicEndPos) {
        return this.genomicCoord.contains(genomicStartPos) && this.genomicCoord.contains(genomicEndPos);
    }

    public boolean isNegativeStrand() {
        return this.strand == Strand.REVERSE;
    }

    public boolean isPositiveStrand() {
        return this.strand == Strand.FORWARD;
    }

    public int getLength() {
        return this.length;
    }

    private int calcLength() {
        int length = 0;
        for (Coordinate exon : this.exons) {
            length += exon.getLength();
        }
        return length;
    }

    public Coordinate getGenomicCoordinate() {
        return this.genomicCoord;
    }

    public String getIsoformId() {
        return this.isoformId;
    }

    public String toString() {
        return this.isoformId + "," + this.genomicCoord;
    }

    private Coordinate getTranscriptCoordinates(int blockIsoformStart, int blockIsoformStop) {
        return new Coordinate(blockIsoformStart, blockIsoformStop);
    }

    public List<Coordinate> match(SAMRecord read) {
        ArrayList<Coordinate> transcriptCoordinates = new ArrayList<Coordinate>();
        boolean isFirstBlock = true;
        int prevBlockIsoformStop = 0;
        for (ReadBlock block : ReadBlock.getReadBlocks(read)) {
            if (block.getType() == CigarOperator.M) {
                boolean isBlockMatch = false;
                int blockGenomeStart = block.getReferenceStart();
                int blockGenomeStop = blockGenomeStart + block.getLength() - 1;
                int exonStartInIsoform = 1;
                for (Coordinate exon : this.exons) {
                    if (exon.contains(blockGenomeStart) && exon.contains(blockGenomeStop)) {
                        int blockIsoformStart = blockGenomeStart - exon.getStart() + exonStartInIsoform;
                        int blockIsoformStop = blockGenomeStop - exon.getStart() + exonStartInIsoform;
                        if (isFirstBlock || blockIsoformStart == prevBlockIsoformStop + 1) {
                            transcriptCoordinates.add(this.getTranscriptCoordinates(blockIsoformStart, blockIsoformStop));
                            isBlockMatch = true;
                            prevBlockIsoformStop = blockIsoformStop;
                            break;
                        }
                    }
                    exonStartInIsoform += exon.getLength();
                }
                if (!isBlockMatch) {
                    return Collections.EMPTY_LIST;
                }
                isFirstBlock = false;
                continue;
            }
            if (block.getType() == CigarOperator.D) {
                prevBlockIsoformStop += block.getLength();
                continue;
            }
            if (block.getType() == CigarOperator.I || block.getType() != CigarOperator.S) continue;
            return Collections.EMPTY_LIST;
        }
        return transcriptCoordinates;
    }

    public static class IsoformOrderComparator
    implements Comparator<Isoform> {
        private IsoformOrderLoader isoformOrderLoader;

        public IsoformOrderComparator(IsoformOrderLoader isoformOrderLoader) {
            this.isoformOrderLoader = isoformOrderLoader;
        }

        @Override
        public int compare(Isoform isoform1, Isoform isoform2) {
            return this.isoformOrderLoader.getOrder(isoform1.getIsoformId()).compareTo(this.isoformOrderLoader.getOrder(isoform2.getIsoformId()));
        }
    }

    public static enum Strand {
        FORWARD,
        REVERSE;

    }
}

