/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.sam;

import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.cga.tools.sam.PushbackIterator;

public class ParallelSAMIterator
implements CloseableIterator<List<List<SAMRecord>>> {
    private SAMFileReader reader1;
    private SAMFileReader reader2;
    PushbackIterator<SAMRecord> i1;
    PushbackIterator<SAMRecord> i2;
    List<SAMRecord> alignments1;
    List<SAMRecord> alignments2;
    private static final List<SAMRecord> emptyList = new ArrayList<SAMRecord>();

    public ParallelSAMIterator(SAMFileReader r1, SAMFileReader r2) {
        this.reader1 = r1;
        this.reader2 = r2;
        this.checkSortOrder(r1, "End 1");
        this.checkSortOrder(r2, "End 2");
        this.i1 = new PushbackIterator<SAMRecord>(r1.iterator());
        this.i2 = new PushbackIterator<SAMRecord>(r2.iterator());
        this.alignments1 = this.nextGroup(this.i1);
        this.alignments2 = this.nextGroup(this.i2);
    }

    @Override
    public boolean hasNext() {
        return this.alignments1.size() > 0 || this.alignments2.size() > 0;
    }

    @Override
    public List<List<SAMRecord>> next() {
        String end2Name;
        ArrayList<List<SAMRecord>> result = new ArrayList<List<SAMRecord>>(2);
        if (this.alignments1.size() == 0) {
            result.add(this.alignments1);
            result.add(this.alignments2);
            this.alignments2 = this.nextGroup(this.i2);
            return result;
        }
        if (this.alignments2.size() == 0) {
            result.add(this.alignments1);
            result.add(this.alignments2);
            this.alignments1 = this.nextGroup(this.i1);
            return result;
        }
        String end1Name = this.alignments1.get(0).getReadName();
        int cmp = end1Name.compareTo(end2Name = this.alignments2.get(0).getReadName());
        if (cmp < 0) {
            result.add(this.alignments1);
            result.add(emptyList);
            this.alignments1 = this.nextGroup(this.i1);
        } else if (cmp > 0) {
            result.add(emptyList);
            result.add(this.alignments2);
            this.alignments2 = this.nextGroup(this.i2);
        } else {
            result.add(this.alignments1);
            result.add(this.alignments2);
            this.alignments1 = this.nextGroup(this.i1);
            this.alignments2 = this.nextGroup(this.i2);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ParallelSAMIterator does not support remove() operation.");
    }

    @Override
    public void close() {
        this.reader1.close();
        this.reader2.close();
    }

    private List<SAMRecord> nextGroup(PushbackIterator<SAMRecord> i) {
        ArrayList<SAMRecord> result = new ArrayList<SAMRecord>();
        if (!i.hasNext()) {
            return result;
        }
        SAMRecord r = i.next();
        String readName = r.getReadName();
        result.add(r);
        while (i.hasNext()) {
            r = i.next();
            if (!r.getReadName().equals(readName)) {
                i.pushback(r);
                break;
            }
            result.add(r);
        }
        return result;
    }

    private void checkSortOrder(SAMFileReader reader, String fileName) {
        if (reader.getFileHeader() == null) {
            System.out.println("WARNING: File " + fileName + " has no header. Assuming that file is sorted by read name.");
        }
        switch (reader.getFileHeader().getSortOrder()) {
            case coordinate: {
                throw new RuntimeException("File " + fileName + " is sorted by coordinate. Sort it by read name first.");
            }
            case unsorted: {
                System.out.println("WARNING: file " + fileName + " has sorting order tag set to 'unsorted'. " + "Assuming that it is sorted by read name.");
                break;
            }
            case queryname: {
                break;
            }
            default: {
                throw new RuntimeException("File " + fileName + ": unknown sorting order (" + (Object)((Object)reader.getFileHeader().getSortOrder()) + ")");
            }
        }
    }
}

