/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.picard.filter.SamRecordFilter;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.filters.FilterManager;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Downsample;
import org.broadinstitute.sting.gatk.walkers.RMD;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.gatk.walkers.WalkerName;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;

public class WalkerManager
extends PluginManager<Walker> {
    private ResourceBundle helpText = TextFormattingUtils.loadResourceBundle("StingText");

    public WalkerManager() {
        super(Walker.class, "walker", "Walker");
    }

    public Map<String, Collection<Class<? extends Walker>>> getWalkerNamesByPackage(boolean visibleWalkersOnly) {
        HashMap walkersByPackage = new HashMap();
        for (Class walker : this.getPlugins()) {
            String walkerPackage;
            if (visibleWalkersOnly && WalkerManager.isHidden(walker)) continue;
            String string = walkerPackage = walker.getPackage() != null ? walker.getPackage().getName() : "";
            if (!walkersByPackage.containsKey(walkerPackage)) {
                walkersByPackage.put(walkerPackage, new ArrayList());
            }
            ((Collection)walkersByPackage.get(walkerPackage)).add(walker);
        }
        return Collections.unmodifiableMap(walkersByPackage);
    }

    public String getPackageDisplayName(String packageName) {
        String displayName = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (displayName.trim().equals("")) {
            displayName = "<unpackaged>";
        }
        return displayName;
    }

    public String getPackageSummaryText(String packageName) {
        String key = String.format("%s.%s", packageName, "help.summary");
        if (!this.helpText.containsKey(key)) {
            return "";
        }
        return this.helpText.getString(key);
    }

    public String getWalkerSummaryText(Class<? extends Walker> walkerType) {
        String walkerSummary = String.format("%s.%s", walkerType.getName(), "help.summary");
        if (!this.helpText.containsKey(walkerSummary)) {
            return "";
        }
        return this.helpText.getString(walkerSummary);
    }

    public String getWalkerSummaryText(Walker walker) {
        return this.getWalkerSummaryText(walker.getClass());
    }

    public String getWalkerDescriptionText(Class<? extends Walker> walkerType) {
        String walkerDescription = String.format("%s.%s", walkerType.getName(), "help.description");
        if (!this.helpText.containsKey(walkerDescription)) {
            return "";
        }
        return this.helpText.getString(walkerDescription);
    }

    public String getWalkerDescriptionText(Walker walker) {
        return this.getWalkerDescriptionText(walker.getClass());
    }

    public Class<? extends Walker> getWalkerClassByName(String walkerName) {
        return this.getPluginsByName().get(walkerName);
    }

    public static DataSource getWalkerDataSource(Class<? extends Walker> walkerClass) {
        By byDataSource = walkerClass.getAnnotation(By.class);
        if (byDataSource == null) {
            throw new ReviewedStingException("Unable to find By annotation for walker class " + walkerClass.getName());
        }
        return byDataSource.value();
    }

    public static DataSource getWalkerDataSource(Walker walker) {
        return WalkerManager.getWalkerDataSource(walker.getClass());
    }

    public static List<RMD> getAllowsMetaData(Class<? extends Walker> walkerClass) {
        return Collections.emptyList();
    }

    public static boolean isAllowed(Class<? extends Walker> walkerClass, DataSource dataSource) {
        Allows allowsDataSource = WalkerManager.getWalkerAllowed(walkerClass);
        if (allowsDataSource == null) {
            return true;
        }
        return Arrays.asList(allowsDataSource.value()).contains((Object)dataSource);
    }

    public static boolean isAllowed(Walker walker, DataSource dataSource) {
        return WalkerManager.isAllowed(walker.getClass(), dataSource);
    }

    public static boolean isAllowed(Class<? extends Walker> walkerClass, ReferenceOrderedDataSource rod) {
        return true;
    }

    public static boolean isAllowed(Walker walker, ReferenceOrderedDataSource rod) {
        return WalkerManager.isAllowed(walker.getClass(), rod);
    }

    public static boolean isRequired(Class<? extends Walker> walkerClass, DataSource dataSource) {
        Requires requiresDataSource = WalkerManager.getWalkerRequirements(walkerClass);
        return Arrays.asList(requiresDataSource.value()).contains((Object)dataSource);
    }

    public static boolean isRequired(Walker walker, DataSource dataSource) {
        return WalkerManager.isRequired(walker.getClass(), dataSource);
    }

    public static List<RMD> getRequiredMetaData(Class<? extends Walker> walkerClass) {
        return Collections.emptyList();
    }

    public static List<RMD> getRequiredMetaData(Walker walker) {
        return WalkerManager.getRequiredMetaData(walker.getClass());
    }

    public static boolean isHidden(Class<? extends Walker> walkerType) {
        return walkerType.isAnnotationPresent(Hidden.class);
    }

    public static List<ReadFilter> getReadFilters(Class<? extends Walker> walkerClass, FilterManager filterManager) {
        ArrayList<ReadFilter> filters = new ArrayList<ReadFilter>();
        for (Class<? extends ReadFilter> filterType : WalkerManager.getReadFilterTypes(walkerClass)) {
            filters.add(filterManager.createFilterByType(filterType));
        }
        return filters;
    }

    public static List<ReadFilter> getReadFilters(Walker walker, FilterManager filterManager) {
        return WalkerManager.getReadFilters(walker.getClass(), filterManager);
    }

    public static DownsamplingMethod getDownsamplingMethod(Class<? extends Walker> walkerClass) {
        DownsamplingMethod downsamplingMethod = null;
        if (walkerClass.isAnnotationPresent(Downsample.class)) {
            Downsample downsampleParameters = walkerClass.getAnnotation(Downsample.class);
            DownsampleType type = downsampleParameters.by();
            Integer toCoverage = downsampleParameters.toCoverage() >= 0 ? Integer.valueOf(downsampleParameters.toCoverage()) : null;
            Double toFraction = downsampleParameters.toFraction() >= 0.0 ? Double.valueOf(downsampleParameters.toFraction()) : null;
            downsamplingMethod = new DownsamplingMethod(type, toCoverage, toFraction);
        }
        return downsamplingMethod;
    }

    public static BAQ.QualityMode getBAQQualityMode(Walker walker) {
        return walker.getClass().getAnnotation(BAQMode.class).QualityMode();
    }

    public static BAQ.ApplicationTime getBAQApplicationTime(Walker walker) {
        return walker.getClass().getAnnotation(BAQMode.class).ApplicationTime();
    }

    public static DownsamplingMethod getDownsamplingMethod(Walker walker) {
        return WalkerManager.getDownsamplingMethod(walker.getClass());
    }

    @Override
    public String getName(Class<? extends Walker> walkerType) {
        String walkerName = "";
        walkerName = walkerType.getAnnotation(WalkerName.class) != null ? walkerType.getAnnotation(WalkerName.class).value().trim() : super.getName(walkerType);
        return walkerName;
    }

    private static Requires getWalkerRequirements(Class<? extends Walker> walkerClass) {
        Requires requiresDataSource = walkerClass.getAnnotation(Requires.class);
        if (requiresDataSource == null) {
            throw new ReviewedStingException("Unable to find data types required by walker class " + walkerClass.getName());
        }
        return requiresDataSource;
    }

    private static Requires getWalkerRequirements(Walker walker) {
        return WalkerManager.getWalkerRequirements(walker.getClass());
    }

    private static Allows getWalkerAllowed(Class<? extends Walker> walkerClass) {
        Allows allowsDataSource = walkerClass.getAnnotation(Allows.class);
        return allowsDataSource;
    }

    private static Allows getWalkerAllowed(Walker walker) {
        return WalkerManager.getWalkerAllowed(walker.getClass());
    }

    public static Collection<Class<? extends ReadFilter>> getReadFilterTypes(Class<?> walkerClass) {
        ArrayList<Class<? extends ReadFilter>> filterTypes = new ArrayList<Class<? extends ReadFilter>>();
        while (walkerClass != null) {
            if (walkerClass.isAnnotationPresent(ReadFilters.class)) {
                for (Class<? extends SamRecordFilter> c : walkerClass.getAnnotation(ReadFilters.class).value()) {
                    if (filterTypes.contains(c)) continue;
                    filterTypes.add(c);
                }
            }
            walkerClass = walkerClass.getSuperclass();
        }
        return filterTypes;
    }

    public static Collection<Class<? extends ReadFilter>> getReadFilterTypes(Walker walker) {
        return WalkerManager.getReadFilterTypes(walker.getClass());
    }
}

