/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.broad.tribble.util.BlockCompressedStreamConstants;
import org.broadinstitute.sting.gatk.datasources.reads.BAMAccessPlan;
import org.broadinstitute.sting.gatk.datasources.reads.BGZFBlockLoadingDispatcher;
import org.broadinstitute.sting.gatk.datasources.reads.BlockInputStream;
import org.broadinstitute.sting.gatk.datasources.reads.FileHandleCache;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class BlockLoader
implements Runnable {
    private BGZFBlockLoadingDispatcher dispatcher;
    private final FileHandleCache fileHandleCache;
    private final boolean decompress;
    private final ByteBuffer inputBuffer;

    public BlockLoader(BGZFBlockLoadingDispatcher dispatcher, FileHandleCache fileHandleCache, boolean decompress) {
        this.dispatcher = dispatcher;
        this.fileHandleCache = fileHandleCache;
        this.decompress = decompress;
        this.inputBuffer = ByteBuffer.allocateDirect(65536 + BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length);
        this.inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void run() {
        while (true) {
            BAMAccessPlan accessPlan = null;
            try {
                accessPlan = this.dispatcher.claimNextWorkRequest();
                FileInputStream inputStream = this.fileHandleCache.claimFileInputStream(accessPlan.getReader());
                ByteBuffer compressedBlock = this.readBGZFBlock(inputStream, accessPlan.getBlockAddress());
                long nextBlockAddress = this.position(inputStream);
                this.fileHandleCache.releaseFileInputStream(accessPlan.getReader(), inputStream);
                ByteBuffer block = this.decompress ? this.decompressBGZFBlock(compressedBlock) : compressedBlock;
                int bytesCopied = block.remaining();
                BlockInputStream bamInputStream = accessPlan.getInputStream();
                bamInputStream.copyIntoBuffer(block, accessPlan, nextBlockAddress);
                continue;
            }
            catch (Throwable error) {
                if (accessPlan == null || accessPlan.getInputStream() == null) continue;
                accessPlan.getInputStream().reportException(error);
                continue;
            }
            break;
        }
    }

    private ByteBuffer readBGZFBlock(FileInputStream inputStream, long blockAddress) throws IOException {
        FileChannel channel = inputStream.getChannel();
        channel.position(blockAddress);
        int uncompressedDataSize = 0;
        int bufferSize = 0;
        do {
            this.inputBuffer.clear();
            this.inputBuffer.limit(18);
            channel.read(this.inputBuffer);
            this.inputBuffer.flip();
            if (this.inputBuffer.remaining() != 18) {
                throw new ReviewedStingException("BUG: unable to read a the complete block header in one pass.");
            }
            if (this.unpackUByte8(this.inputBuffer, 0) != 31 || this.unpackUByte8(this.inputBuffer, 1) != 139 || this.unpackUByte8(this.inputBuffer, 3) != 4 || this.unpackUInt16(this.inputBuffer, 10) != 6 || this.unpackUByte8(this.inputBuffer, 12) != 66 || this.unpackUByte8(this.inputBuffer, 13) != 67) {
                throw new ReviewedStingException("BUG: Started reading compressed block at incorrect position");
            }
            this.inputBuffer.position(16);
            bufferSize = this.unpackUInt16(this.inputBuffer, 16) + 1;
            this.inputBuffer.limit(bufferSize);
            this.inputBuffer.position(18);
            channel.read(this.inputBuffer);
        } while ((uncompressedDataSize = this.inputBuffer.getInt(this.inputBuffer.limit() - 4)) == 0 && channel.position() < channel.size());
        this.inputBuffer.flip();
        return this.inputBuffer;
    }

    private ByteBuffer decompressBGZFBlock(ByteBuffer bgzfBlock) throws DataFormatException {
        int compressedBufferSize = bgzfBlock.remaining();
        bgzfBlock.position(bgzfBlock.limit() - 4);
        int uncompressedBufferSize = bgzfBlock.getInt();
        byte[] uncompressedContent = new byte[uncompressedBufferSize];
        bgzfBlock.limit(compressedBufferSize - 8);
        bgzfBlock.position(18);
        byte[] compressedContent = new byte[bgzfBlock.remaining()];
        ByteBuffer.wrap(compressedContent).put(bgzfBlock);
        Inflater inflater = new Inflater(true);
        inflater.setInput(compressedContent);
        int bytesUncompressed = inflater.inflate(uncompressedContent);
        if (bytesUncompressed != uncompressedBufferSize) {
            throw new ReviewedStingException("Error decompressing block");
        }
        return ByteBuffer.wrap(uncompressedContent);
    }

    private long position(FileInputStream inputStream) throws IOException {
        return inputStream.getChannel().position();
    }

    private int unpackUByte8(ByteBuffer buffer, int position) {
        return buffer.get(position) & 0xFF;
    }

    private int unpackUInt16(ByteBuffer buffer, int position) {
        return buffer.getShort(position) & 0xFFFF;
    }
}

