/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.SAMFileSpan;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShard;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardBalancer;

public class ReadShardBalancer
extends ShardBalancer {
    @Override
    public Iterator<Shard> iterator() {
        return new Iterator<Shard>(){
            private Shard nextShard = null;
            private FilePointer currentFilePointer;
            private Map<SAMReaderID, GATKBAMFileSpan> position;
            {
                this.position = ReadShardBalancer.this.readsDataSource.getCurrentPosition();
                if (ReadShardBalancer.this.filePointers.hasNext()) {
                    this.currentFilePointer = (FilePointer)ReadShardBalancer.this.filePointers.next();
                }
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.nextShard != null;
            }

            @Override
            public Shard next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next read shard available");
                }
                Shard currentShard = this.nextShard;
                this.advance();
                return currentShard;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove from shard balancing iterator");
            }

            private void advance() {
                this.nextShard = null;
                HashMap<SAMReaderID, SAMFileSpan> selectedReaders = new HashMap<SAMReaderID, SAMFileSpan>();
                while (selectedReaders.size() == 0 && this.currentFilePointer != null) {
                    SortedMap<SAMReaderID, SAMFileSpan> shardPosition = this.currentFilePointer.fileSpans;
                    for (SAMReaderID id : shardPosition.keySet()) {
                        GATKBAMFileSpan fileSpan = new GATKBAMFileSpan(((SAMFileSpan)shardPosition.get(id)).removeContentsBefore(this.position.get(id)));
                        selectedReaders.put(id, fileSpan);
                    }
                    if (!this.isEmpty(selectedReaders)) {
                        ReadShard shard = new ReadShard(ReadShardBalancer.this.parser, ReadShardBalancer.this.readsDataSource, selectedReaders, this.currentFilePointer.locations, this.currentFilePointer.isRegionUnmapped);
                        ReadShardBalancer.this.readsDataSource.fillShard(shard);
                        if (!((Shard)shard).isBufferEmpty()) {
                            this.nextShard = shard;
                            break;
                        }
                    }
                    selectedReaders.clear();
                    this.currentFilePointer = ReadShardBalancer.this.filePointers.hasNext() ? (FilePointer)ReadShardBalancer.this.filePointers.next() : null;
                }
                this.position = ReadShardBalancer.this.readsDataSource.getCurrentPosition();
            }

            private boolean isEmpty(Map<SAMReaderID, SAMFileSpan> selectedSpans) {
                for (SAMFileSpan fileSpan : selectedSpans.values()) {
                    if (fileSpan.isEmpty()) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

