/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.ArrayList;
import java.util.Collection;
import org.broadinstitute.sting.gatk.io.storage.Storage;

public class OutputMergeTask {
    private final Collection<MergeOperation<?>> mergeOperations = new ArrayList();

    public <StreamType> void addMergeOperation(StreamType targetStream, Storage<StreamType> temporaryStorage) {
        this.mergeOperations.add(new MergeOperation<StreamType>(targetStream, temporaryStorage));
    }

    public synchronized void merge() {
        for (MergeOperation<?> mergeOperation : this.mergeOperations) {
            mergeOperation.temporaryStorage.mergeInto(mergeOperation.targetStream);
        }
    }

    private class MergeOperation<StreamType> {
        public final StreamType targetStream;
        public final Storage<StreamType> temporaryStorage;

        public MergeOperation(StreamType targetStream, Storage<StreamType> temporaryStorage) {
            this.targetStream = targetStream;
            this.temporaryStorage = temporaryStorage;
        }
    }
}

