/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDataManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class CovariateKeySet {
    private Object[][] mismatchesKeySet;
    private Object[][] insertionsKeySet;
    private Object[][] deletionsKeySet;
    private int nextCovariateIndex;
    private static String mismatchesCovariateName = "M";
    private static String insertionsCovariateName = "I";
    private static String deletionsCovariateName = "D";

    public CovariateKeySet(int readLength, int numberOfCovariates) {
        this.mismatchesKeySet = new Object[readLength][++numberOfCovariates];
        this.insertionsKeySet = new Object[readLength][numberOfCovariates];
        this.deletionsKeySet = new Object[readLength][numberOfCovariates];
        this.initializeCovariateKeySet(this.mismatchesKeySet, mismatchesCovariateName);
        this.initializeCovariateKeySet(this.insertionsKeySet, insertionsCovariateName);
        this.initializeCovariateKeySet(this.deletionsKeySet, deletionsCovariateName);
        this.nextCovariateIndex = 0;
    }

    public void addCovariate(CovariateValues covariate) {
        this.transposeCovariateValues(this.mismatchesKeySet, covariate.getMismatches());
        this.transposeCovariateValues(this.insertionsKeySet, covariate.getInsertions());
        this.transposeCovariateValues(this.deletionsKeySet, covariate.getDeletions());
        ++this.nextCovariateIndex;
    }

    public static RecalDataManager.BaseRecalibrationType getErrorModelFromString(String modelString) {
        if (modelString.equals(mismatchesCovariateName)) {
            return RecalDataManager.BaseRecalibrationType.BASE_SUBSTITUTION;
        }
        if (modelString.equals(insertionsCovariateName)) {
            return RecalDataManager.BaseRecalibrationType.BASE_INSERTION;
        }
        if (modelString.equals(deletionsCovariateName)) {
            return RecalDataManager.BaseRecalibrationType.BASE_DELETION;
        }
        throw new ReviewedStingException("Unrecognized Base Recalibration model string: " + modelString);
    }

    public Object[] getKeySet(int readPosition, RecalDataManager.BaseRecalibrationType errorModel) {
        switch (errorModel) {
            case BASE_SUBSTITUTION: {
                return this.getMismatchesKeySet(readPosition);
            }
            case BASE_INSERTION: {
                return this.getInsertionsKeySet(readPosition);
            }
            case BASE_DELETION: {
                return this.getDeletionsKeySet(readPosition);
            }
        }
        throw new ReviewedStingException("Unrecognized Base Recalibration type: " + (Object)((Object)errorModel));
    }

    public Object[] getMismatchesKeySet(int readPosition) {
        return this.mismatchesKeySet[readPosition];
    }

    public Object[] getInsertionsKeySet(int readPosition) {
        return this.insertionsKeySet[readPosition];
    }

    public Object[] getDeletionsKeySet(int readPosition) {
        return this.deletionsKeySet[readPosition];
    }

    private void transposeCovariateValues(Object[][] keySet, Object[] covariateValues) {
        for (int i = 0; i < covariateValues.length; ++i) {
            keySet[i][this.nextCovariateIndex] = covariateValues[i];
        }
    }

    private void initializeCovariateKeySet(Object[][] keySet, String covariateName) {
        int readLength = keySet.length;
        int lastCovariateIndex = keySet[0].length - 1;
        for (int i = 0; i < readLength; ++i) {
            keySet[i][lastCovariateIndex] = covariateName;
        }
    }
}

