/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.recalibration.Dinuc;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.recalibration.StandardCovariate;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class DinucCovariate
implements StandardCovariate {
    private static final byte NO_CALL = 78;
    private static final Dinuc NO_DINUC = new Dinuc(78, 78);
    private HashMap<Integer, Dinuc> dinucHashMap;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        byte[] BASES = new byte[]{65, 67, 71, 84};
        this.dinucHashMap = new HashMap();
        for (byte byte1 : BASES) {
            for (byte byte2 : BASES) {
                this.dinucHashMap.put(Dinuc.hashBytes(byte1, byte2), new Dinuc(byte1, byte2));
            }
        }
        this.dinucHashMap.put(Dinuc.hashBytes((byte)78, (byte)78), NO_DINUC);
    }

    @Override
    public void getValues(GATKSAMRecord read, Comparable[] comparable) {
        HashMap<Integer, Dinuc> dinucHashMapRef = this.dinucHashMap;
        int readLength = read.getReadLength();
        boolean negativeStrand = read.getReadNegativeStrandFlag();
        byte[] bases = read.getReadBases();
        int offset = 0;
        if (negativeStrand) {
            bases = BaseUtils.simpleReverseComplement(bases);
        }
        comparable[0] = NO_DINUC;
        byte prevBase = bases[0];
        ++offset;
        while (offset < readLength) {
            byte base = bases[offset];
            comparable[offset] = BaseUtils.isRegularBase(prevBase) ? (Comparable)dinucHashMapRef.get(Dinuc.hashBytes(prevBase, base)) : NO_DINUC;
            ++offset;
            prevBase = base;
        }
        if (negativeStrand) {
            DinucCovariate.reverse(comparable);
        }
    }

    @Override
    public final Comparable getValue(String str) {
        byte[] bytes = str.getBytes();
        Dinuc returnDinuc = this.dinucHashMap.get(Dinuc.hashBytes(bytes[0], bytes[1]));
        if (returnDinuc.compareTo(NO_DINUC) == 0) {
            return null;
        }
        return returnDinuc;
    }

    private static void reverse(Comparable[] array) {
        int arrayLength = array.length;
        int l = 0;
        for (int r = arrayLength - 1; l < r; ++l, --r) {
            Comparable temp = array[l];
            array[l] = array[r];
            array[r] = temp;
        }
    }
}

