/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MathUtils {
    public static final double[] log10Cache;
    private static final double[] jacobianLogTable;
    private static final double JACOBIAN_LOG_TABLE_STEP = 0.001;
    private static final double MAX_JACOBIAN_TOLERANCE = 10.0;
    private static final int JACOBIAN_LOG_TABLE_SIZE = 10001;
    private static final int MAXN = 11000;
    private static final int LOG10_CACHE_SIZE = 44000;
    private static final double zero = 0.0;
    private static final double one = 1.0;
    private static final double half = 0.5;
    private static final double a0 = 0.07721566490153287;
    private static final double a1 = 0.3224670334241136;
    private static final double a2 = 0.06735230105312927;
    private static final double a3 = 0.020580808432516733;
    private static final double a4 = 0.007385550860814029;
    private static final double a5 = 0.0028905138367341563;
    private static final double a6 = 0.0011927076318336207;
    private static final double a7 = 5.100697921535113E-4;
    private static final double a8 = 2.2086279071390839E-4;
    private static final double a9 = 1.0801156724758394E-4;
    private static final double a10 = 2.5214456545125733E-5;
    private static final double a11 = 4.4864094961891516E-5;
    private static final double tc = 1.4616321449683622;
    private static final double tf = -0.12148629053584961;
    private static final double tt = -3.638676997039505E-18;
    private static final double t0 = 0.48383612272381005;
    private static final double t1 = -0.1475877229945939;
    private static final double t2 = 0.06462494023913339;
    private static final double t3 = -0.032788541075985965;
    private static final double t4 = 0.01797067508118204;
    private static final double t5 = -0.010314224129834144;
    private static final double t6 = 0.006100538702462913;
    private static final double t7 = -0.0036845201678113826;
    private static final double t8 = 0.0022596478090061247;
    private static final double t9 = -0.0014034646998923284;
    private static final double t10 = 8.81081882437654E-4;
    private static final double t11 = -5.385953053567405E-4;
    private static final double t12 = 3.1563207090362595E-4;
    private static final double t13 = -3.1275416837512086E-4;
    private static final double t14 = 3.355291926355191E-4;
    private static final double u0 = -0.07721566490153287;
    private static final double u1 = 0.6328270640250934;
    private static final double u2 = 1.4549225013723477;
    private static final double u3 = 0.9777175279633727;
    private static final double u4 = 0.22896372806469245;
    private static final double u5 = 0.013381091853678766;
    private static final double v1 = 2.4559779371304113;
    private static final double v2 = 2.128489763798934;
    private static final double v3 = 0.7692851504566728;
    private static final double v4 = 0.10422264559336913;
    private static final double v5 = 0.003217092422824239;
    private static final double s0 = -0.07721566490153287;
    private static final double s1 = 0.21498241596060885;
    private static final double s2 = 0.325778796408931;
    private static final double s3 = 0.14635047265246445;
    private static final double s4 = 0.02664227030336386;
    private static final double s5 = 0.0018402845140733772;
    private static final double s6 = 3.194753265841009E-5;
    private static final double r1 = 1.3920053346762105;
    private static final double r2 = 0.7219355475671381;
    private static final double r3 = 0.17193386563280308;
    private static final double r4 = 0.01864591917156529;
    private static final double r5 = 7.779424963818936E-4;
    private static final double r6 = 7.326684307446256E-6;
    private static final double w0 = 0.4189385332046727;
    private static final double w1 = 0.08333333333333297;
    private static final double w2 = -0.0027777777772877554;
    private static final double w3 = 7.936505586430196E-4;
    private static final double w4 = -5.9518755745034E-4;
    private static final double w5 = 8.363399189962821E-4;
    private static final double w6 = -0.0016309293409657527;

    private MathUtils() {
    }

    public static int fastRound(double d) {
        return d > 0.0 ? (int)(d + 0.5) : (int)(d - 0.5);
    }

    public static double approximateLog10SumLog10(double[] vals) {
        return MathUtils.approximateLog10SumLog10(vals, vals.length);
    }

    public static double approximateLog10SumLog10(double[] vals, int endIndex) {
        int maxElementIndex = MathUtils.maxElementIndex(vals, endIndex);
        double approxSum = vals[maxElementIndex];
        if (approxSum == Double.NEGATIVE_INFINITY) {
            return approxSum;
        }
        for (int i = 0; i < endIndex; ++i) {
            double diff;
            if (i == maxElementIndex || vals[i] == Double.NEGATIVE_INFINITY || !((diff = approxSum - vals[i]) < 10.0)) continue;
            int ind = MathUtils.fastRound(diff / 0.001);
            approxSum += jacobianLogTable[ind];
        }
        return approxSum;
    }

    public static double approximateLog10SumLog10(double small, double big) {
        if (small > big) {
            double t = big;
            big = small;
            small = t;
        }
        if (small == Double.NEGATIVE_INFINITY || big == Double.NEGATIVE_INFINITY) {
            return big;
        }
        double diff = big - small;
        if (diff >= 10.0) {
            return big;
        }
        int ind = MathUtils.fastRound(diff / 0.001);
        return big + jacobianLogTable[ind];
    }

    public static double sum(Collection<Number> numbers) {
        return MathUtils.sum(numbers, false);
    }

    public static double sum(Collection<Number> numbers, boolean ignoreNan) {
        double sum = 0.0;
        for (Number n : numbers) {
            if (ignoreNan && Double.isNaN(n.doubleValue())) continue;
            sum += n.doubleValue();
        }
        return sum;
    }

    public static int nonNanSize(Collection<Number> numbers) {
        int size = 0;
        for (Number n : numbers) {
            size += Double.isNaN(n.doubleValue()) ? 0 : 1;
        }
        return size;
    }

    public static double average(Collection<Integer> x) {
        return (double)MathUtils.sum(x) / (double)x.size();
    }

    public static double average(Collection<Number> numbers, boolean ignoreNan) {
        if (ignoreNan) {
            return MathUtils.sum(numbers, true) / (double)MathUtils.nonNanSize(numbers);
        }
        return MathUtils.sum(numbers, false) / (double)MathUtils.nonNanSize(numbers);
    }

    public static double variance(Collection<Number> numbers, Number mean, boolean ignoreNan) {
        double mn = mean.doubleValue();
        double var = 0.0;
        for (Number n : numbers) {
            var += !ignoreNan || !Double.isNaN(n.doubleValue()) ? (n.doubleValue() - mn) * (n.doubleValue() - mn) : 0.0;
        }
        if (ignoreNan) {
            return var / (double)(MathUtils.nonNanSize(numbers) - 1);
        }
        return var / (double)(numbers.size() - 1);
    }

    public static double variance(Collection<Number> numbers, Number mean) {
        return MathUtils.variance(numbers, mean, false);
    }

    public static double variance(Collection<Number> numbers, boolean ignoreNan) {
        return MathUtils.variance(numbers, MathUtils.average(numbers, ignoreNan), ignoreNan);
    }

    public static double variance(Collection<Number> numbers) {
        return MathUtils.variance(numbers, MathUtils.average(numbers, false), false);
    }

    public static double sum(double[] values) {
        double s = 0.0;
        for (double v : values) {
            s += v;
        }
        return s;
    }

    public static long sum(int[] x) {
        long total = 0L;
        for (int v : x) {
            total += (long)v;
        }
        return total;
    }

    public static double log10CumulativeSumLog10(double[] log10p, int upTo) {
        return MathUtils.log10sumLog10(log10p, 0, upTo);
    }

    public static double[] toLog10(double[] prRealSpace) {
        double[] log10s = new double[prRealSpace.length];
        for (int i = 0; i < prRealSpace.length; ++i) {
            log10s[i] = Math.log10(prRealSpace[i]);
        }
        return log10s;
    }

    public static double log10sumLog10(double[] log10p, int start) {
        return MathUtils.log10sumLog10(log10p, start, log10p.length);
    }

    public static double log10sumLog10(double[] log10p, int start, int finish) {
        double sum = 0.0;
        double maxValue = Utils.findMaxEntry(log10p);
        for (int i = start; i < finish; ++i) {
            sum += Math.pow(10.0, log10p[i] - maxValue);
        }
        return Math.log10(sum) + maxValue;
    }

    public static double sumDoubles(List<Double> values) {
        double s = 0.0;
        for (double v : values) {
            s += v;
        }
        return s;
    }

    public static int sumIntegers(List<Integer> values) {
        int s = 0;
        for (int v : values) {
            s += v;
        }
        return s;
    }

    public static double sumLog10(double[] log10values) {
        return Math.pow(10.0, MathUtils.log10sumLog10(log10values));
    }

    public static double log10sumLog10(double[] log10values) {
        return MathUtils.log10sumLog10(log10values, 0);
    }

    public static boolean wellFormedDouble(double val) {
        return !Double.isInfinite(val) && !Double.isNaN(val);
    }

    public static double bound(double value, double minBoundary, double maxBoundary) {
        return Math.max(Math.min(value, maxBoundary), minBoundary);
    }

    public static boolean isBounded(double val, double lower, double upper) {
        return val >= lower && val <= upper;
    }

    public static boolean isPositive(double val) {
        return !MathUtils.isNegativeOrZero(val);
    }

    public static boolean isPositiveOrZero(double val) {
        return MathUtils.isBounded(val, 0.0, Double.POSITIVE_INFINITY);
    }

    public static boolean isNegativeOrZero(double val) {
        return MathUtils.isBounded(val, Double.NEGATIVE_INFINITY, 0.0);
    }

    public static boolean isNegative(double val) {
        return !MathUtils.isPositiveOrZero(val);
    }

    public static byte compareDoubles(double a, double b) {
        return MathUtils.compareDoubles(a, b, 1.0E-6);
    }

    public static byte compareDoubles(double a, double b, double epsilon) {
        if (Math.abs(a - b) < epsilon) {
            return 0;
        }
        if (a > b) {
            return -1;
        }
        return 1;
    }

    public static byte compareFloats(float a, float b) {
        return MathUtils.compareFloats(a, b, 1.0E-6f);
    }

    public static byte compareFloats(float a, float b, float epsilon) {
        if (Math.abs(a - b) < epsilon) {
            return 0;
        }
        if (a > b) {
            return -1;
        }
        return 1;
    }

    public static double NormalDistribution(double mean, double sd, double x) {
        double a = 1.0 / (sd * Math.sqrt(Math.PI * 2));
        double b = Math.exp(-1.0 * (Math.pow(x - mean, 2.0) / (2.0 * sd * sd)));
        return a * b;
    }

    public static double binomialCoefficient(int n, int k) {
        return Math.pow(10.0, MathUtils.log10BinomialCoefficient(n, k));
    }

    public static double binomialProbability(int n, int k, double p) {
        return Math.pow(10.0, MathUtils.log10BinomialProbability(n, k, Math.log10(p)));
    }

    public static double binomialCumulativeProbability(int start, int end, int total, double probHit) {
        double cumProb = 0.0;
        BigDecimal probCache = BigDecimal.ZERO;
        for (int hits = start; hits < end; ++hits) {
            double prevProb = cumProb;
            double probability = MathUtils.binomialProbability(total, hits, probHit);
            cumProb += probability;
            if (!(probability > 0.0) || !(cumProb - prevProb < probability / 2.0)) continue;
            probCache = probCache.add(new BigDecimal(prevProb));
            cumProb = 0.0;
            --hits;
        }
        return probCache.add(new BigDecimal(cumProb)).doubleValue();
    }

    public static double multinomialCoefficient(int[] k) {
        int n = 0;
        for (int xi : k) {
            n += xi;
        }
        return Math.pow(10.0, MathUtils.log10MultinomialCoefficient(n, k));
    }

    public static double multinomialProbability(int[] k, double[] p) {
        if (p.length != k.length) {
            throw new UserException.BadArgumentValue("p and k", "Array of log10 probabilities must have the same size as the array of number of sucesses: " + p.length + ", " + k.length);
        }
        int n = 0;
        double[] log10P = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            log10P[i] = Math.log10(p[i]);
            n += k[i];
        }
        return Math.pow(10.0, MathUtils.log10MultinomialProbability(n, k, log10P));
    }

    public static double rms(byte[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (byte i : x) {
            rms += (double)(i * i);
        }
        return Math.sqrt(rms /= (double)x.length);
    }

    public static double rms(int[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (int i : x) {
            rms += (double)(i * i);
        }
        return Math.sqrt(rms /= (double)x.length);
    }

    public static double rms(Double[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (Double i : x) {
            rms += i * i;
        }
        return Math.sqrt(rms /= (double)x.length);
    }

    public static double rms(Collection<Integer> l) {
        if (l.size() == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (int i : l) {
            rms += (double)(i * i);
        }
        return Math.sqrt(rms /= (double)l.size());
    }

    public static double distanceSquared(double[] x, double[] y) {
        double dist = 0.0;
        for (int iii = 0; iii < x.length; ++iii) {
            dist += (x[iii] - y[iii]) * (x[iii] - y[iii]);
        }
        return dist;
    }

    public static double round(double num, int digits) {
        double result = num * Math.pow(10.0, digits);
        result = Math.round(result);
        return result /= Math.pow(10.0, digits);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput) {
        return MathUtils.normalizeFromLog10(array, takeLog10OfOutput, false);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput, boolean keepInLogSpace) {
        int i;
        double maxValue = Utils.findMaxEntry(array);
        if (keepInLogSpace) {
            int i2 = 0;
            while (i2 < array.length) {
                int n = i2++;
                array[n] = array[n] - maxValue;
            }
            return array;
        }
        double[] normalized = new double[array.length];
        for (int i3 = 0; i3 < array.length; ++i3) {
            normalized[i3] = Math.pow(10.0, array[i3] - maxValue);
        }
        double sum = 0.0;
        for (i = 0; i < array.length; ++i) {
            sum += normalized[i];
        }
        for (i = 0; i < array.length; ++i) {
            double x = normalized[i] / sum;
            if (takeLog10OfOutput) {
                x = Math.log10(x);
            }
            normalized[i] = x;
        }
        return normalized;
    }

    public static double[] normalizeFromLog10(double[] array) {
        return MathUtils.normalizeFromLog10(array, false);
    }

    public static int maxElementIndex(double[] array) {
        return MathUtils.maxElementIndex(array, array.length);
    }

    public static int maxElementIndex(double[] array, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int maxI = -1;
        for (int i = 0; i < endIndex; ++i) {
            if (maxI != -1 && !(array[i] > array[maxI])) continue;
            maxI = i;
        }
        return maxI;
    }

    public static int maxElementIndex(int[] array) {
        return MathUtils.maxElementIndex(array, array.length);
    }

    public static int maxElementIndex(int[] array, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int maxI = -1;
        for (int i = 0; i < endIndex; ++i) {
            if (maxI != -1 && array[i] <= array[maxI]) continue;
            maxI = i;
        }
        return maxI;
    }

    public static double arrayMax(double[] array) {
        return array[MathUtils.maxElementIndex(array)];
    }

    public static double arrayMin(double[] array) {
        return array[MathUtils.minElementIndex(array)];
    }

    public static int arrayMin(int[] array) {
        return array[MathUtils.minElementIndex(array)];
    }

    public static byte arrayMin(byte[] array) {
        return array[MathUtils.minElementIndex(array)];
    }

    public static int minElementIndex(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int minI = -1;
        for (int i = 0; i < array.length; ++i) {
            if (minI != -1 && !(array[i] < array[minI])) continue;
            minI = i;
        }
        return minI;
    }

    public static int minElementIndex(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int minI = -1;
        for (int i = 0; i < array.length; ++i) {
            if (minI != -1 && array[i] >= array[minI]) continue;
            minI = i;
        }
        return minI;
    }

    public static int minElementIndex(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int minI = -1;
        for (int i = 0; i < array.length; ++i) {
            if (minI != -1 && array[i] >= array[minI]) continue;
            minI = i;
        }
        return minI;
    }

    public static int arrayMaxInt(List<Integer> array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        if (array.size() == 0) {
            throw new IllegalArgumentException("Array size cannot be 0!");
        }
        int m = array.get(0);
        for (int e : array) {
            m = Math.max(m, e);
        }
        return m;
    }

    public static double arrayMaxDouble(List<Double> array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        if (array.size() == 0) {
            throw new IllegalArgumentException("Array size cannot be 0!");
        }
        double m = array.get(0);
        for (double e : array) {
            m = Math.max(m, e);
        }
        return m;
    }

    public static double average(List<Long> vals, int maxI) {
        long sum = 0L;
        int i = 0;
        for (long x : vals) {
            if (i > maxI) break;
            sum += x;
            ++i;
        }
        return 1.0 * (double)sum / (double)i;
    }

    public static double averageDouble(List<Double> vals, int maxI) {
        double sum = 0.0;
        int i = 0;
        for (double x : vals) {
            if (i > maxI) break;
            sum += x;
            ++i;
        }
        return 1.0 * sum / (double)i;
    }

    public static double average(List<Long> vals) {
        return MathUtils.average(vals, vals.size());
    }

    public static double average(int[] x) {
        int sum = 0;
        for (int v : x) {
            sum += v;
        }
        return (double)sum / (double)x.length;
    }

    public static byte average(byte[] vals) {
        int sum = 0;
        for (byte v : vals) {
            sum += v;
        }
        return (byte)Math.floor(sum / vals.length);
    }

    public static double averageDouble(List<Double> vals) {
        return MathUtils.averageDouble(vals, vals.size());
    }

    public static Integer[] sortPermutation(int[] A) {
        Integer[] permutation = new Integer[A.length];
        for (int i = 0; i < A.length; ++i) {
            permutation[i] = i;
        }
        class Comparator
        implements java.util.Comparator<Integer> {
            final /* synthetic */ int[] val$A;

            Comparator(int[] nArray) {
                this.val$A = nArray;
            }

            @Override
            public int compare(Integer a, Integer b) {
                if (this.val$A[a] < this.val$A[b]) {
                    return -1;
                }
                if (this.val$A[a] == this.val$A[b]) {
                    return 0;
                }
                if (this.val$A[a] > this.val$A[b]) {
                    return 1;
                }
                return 0;
            }
        }
        Arrays.sort(permutation, new Comparator(A));
        return permutation;
    }

    public static Integer[] sortPermutation(double[] A) {
        Integer[] permutation = new Integer[A.length];
        for (int i = 0; i < A.length; ++i) {
            permutation[i] = i;
        }
        class Comparator
        implements java.util.Comparator<Integer> {
            final /* synthetic */ double[] val$A;

            Comparator(double[] dArray) {
                this.val$A = dArray;
            }

            @Override
            public int compare(Integer a, Integer b) {
                if (this.val$A[a] < this.val$A[b]) {
                    return -1;
                }
                if (this.val$A[a] == this.val$A[b]) {
                    return 0;
                }
                if (this.val$A[a] > this.val$A[b]) {
                    return 1;
                }
                return 0;
            }
        }
        Arrays.sort(permutation, new Comparator(A));
        return permutation;
    }

    public static <T extends Comparable> Integer[] sortPermutation(List<T> A) {
        Object[] data = A.toArray();
        Integer[] permutation = new Integer[A.size()];
        for (int i = 0; i < A.size(); ++i) {
            permutation[i] = i;
        }
        class Comparator
        implements java.util.Comparator<Integer> {
            final /* synthetic */ Object[] val$data;

            Comparator(Object[] objectArray) {
                this.val$data = objectArray;
            }

            @Override
            public int compare(Integer a, Integer b) {
                return ((Comparable)this.val$data[a]).compareTo(this.val$data[b]);
            }
        }
        Arrays.sort(permutation, new Comparator(data));
        return permutation;
    }

    public static int[] permuteArray(int[] array, Integer[] permutation) {
        int[] output = new int[array.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = array[permutation[i]];
        }
        return output;
    }

    public static double[] permuteArray(double[] array, Integer[] permutation) {
        double[] output = new double[array.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = array[permutation[i]];
        }
        return output;
    }

    public static Object[] permuteArray(Object[] array, Integer[] permutation) {
        Object[] output = new Object[array.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = array[permutation[i]];
        }
        return output;
    }

    public static String[] permuteArray(String[] array, Integer[] permutation) {
        String[] output = new String[array.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = array[permutation[i]];
        }
        return output;
    }

    public static <T> List<T> permuteList(List<T> list, Integer[] permutation) {
        ArrayList<T> output = new ArrayList<T>();
        for (int i = 0; i < permutation.length; ++i) {
            output.add(list.get(permutation[i]));
        }
        return output;
    }

    public static <T> List<T> randomSubset(List<T> list, int N) {
        if (list.size() <= N) {
            return list;
        }
        int[] idx = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            idx[i] = GenomeAnalysisEngine.getRandomGenerator().nextInt();
        }
        Integer[] perm = MathUtils.sortPermutation(idx);
        ArrayList<T> ans = new ArrayList<T>();
        for (int i = 0; i < N; ++i) {
            ans.add(list.get(perm[i]));
        }
        return ans;
    }

    @Requires(value={"array != null", "n>=0"})
    @Ensures(value={"result != null", "result.length == Math.min(n, array.length)"})
    public static Object[] randomSubset(Object[] array, int n) {
        if (array.length <= n) {
            return (Object[])array.clone();
        }
        Object[] shuffledArray = MathUtils.arrayShuffle(array);
        Object[] result = new Object[n];
        System.arraycopy(shuffledArray, 0, result, 0, n);
        return result;
    }

    public static double percentage(double x, double base) {
        return base > 0.0 ? x / base * 100.0 : 0.0;
    }

    public static double percentage(int x, int base) {
        return base > 0 ? (double)x / (double)base * 100.0 : 0.0;
    }

    public static double percentage(long x, long base) {
        return base > 0L ? (double)x / (double)base * 100.0 : 0.0;
    }

    public static int countOccurrences(char c, String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            count += s.charAt(i) == c ? 1 : 0;
        }
        return count;
    }

    public static <T> int countOccurrences(T x, List<T> l) {
        int count = 0;
        for (T y : l) {
            if (!x.equals(y)) continue;
            ++count;
        }
        return count;
    }

    public static int countOccurrences(byte element, byte[] array) {
        int count = 0;
        for (byte y : array) {
            if (element != y) continue;
            ++count;
        }
        return count;
    }

    public static Collection<Double> getNMaxElements(double[] array, int n) {
        ArrayList<Double> maxN = new ArrayList<Double>(n);
        double lastMax = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            double max = Double.MIN_VALUE;
            for (double x : array) {
                max = Math.min(lastMax, Math.max(x, max));
            }
            maxN.add(max);
            lastMax = max;
        }
        return maxN;
    }

    public static ArrayList<Integer> sampleIndicesWithReplacement(int n, int k) {
        ArrayList<Integer> chosen_balls = new ArrayList<Integer>(k);
        for (int i = 0; i < k; ++i) {
            chosen_balls.add(GenomeAnalysisEngine.getRandomGenerator().nextInt(n));
        }
        return chosen_balls;
    }

    public static ArrayList<Integer> sampleIndicesWithoutReplacement(int n, int k) {
        ArrayList<Integer> chosen_balls = new ArrayList<Integer>(k);
        for (int i = 0; i < n; ++i) {
            chosen_balls.add(i);
        }
        Collections.shuffle(chosen_balls, GenomeAnalysisEngine.getRandomGenerator());
        return new ArrayList<Integer>(chosen_balls.subList(0, k));
    }

    public static <T> ArrayList<T> sliceListByIndices(List<Integer> indices, List<T> list) {
        ArrayList<T> subset = new ArrayList<T>();
        for (int i : indices) {
            subset.add(list.get(i));
        }
        return subset;
    }

    public static Comparable orderStatisticSearch(int orderStat, List<Comparable> list) {
        Comparable x = list.get(orderStat);
        ListIterator<Comparable> iterator = list.listIterator();
        ArrayList<Comparable> lessThanX = new ArrayList<Comparable>();
        ArrayList<Comparable> equalToX = new ArrayList<Comparable>();
        ArrayList<Comparable> greaterThanX = new ArrayList<Comparable>();
        for (Comparable y : list) {
            if (x.compareTo(y) > 0) {
                lessThanX.add(y);
                continue;
            }
            if (x.compareTo(y) < 0) {
                greaterThanX.add(y);
                continue;
            }
            equalToX.add(y);
        }
        if (lessThanX.size() > orderStat) {
            return MathUtils.orderStatisticSearch(orderStat, lessThanX);
        }
        if (lessThanX.size() + equalToX.size() >= orderStat) {
            return Integer.valueOf(orderStat);
        }
        return MathUtils.orderStatisticSearch(orderStat - lessThanX.size() - equalToX.size(), greaterThanX);
    }

    public static Object getMedian(List<Comparable> list) {
        return MathUtils.orderStatisticSearch((int)Math.ceil(list.size() / 2), list);
    }

    public static byte getQScoreOrderStatistic(List<SAMRecord> reads, List<Integer> offsets, int k) {
        if (reads.size() == 0) {
            return 0;
        }
        ArrayList<SAMRecord> lessThanQReads = new ArrayList<SAMRecord>();
        ArrayList<SAMRecord> equalToQReads = new ArrayList<SAMRecord>();
        ArrayList<SAMRecord> greaterThanQReads = new ArrayList<SAMRecord>();
        ArrayList<Integer> lessThanQOffsets = new ArrayList<Integer>();
        ArrayList<Integer> greaterThanQOffsets = new ArrayList<Integer>();
        byte qk = reads.get(k).getBaseQualities()[offsets.get(k)];
        for (int iter = 0; iter < reads.size(); ++iter) {
            SAMRecord read = reads.get(iter);
            int offset = offsets.get(iter);
            byte quality = read.getBaseQualities()[offset];
            if (quality < qk) {
                lessThanQReads.add(read);
                lessThanQOffsets.add(offset);
                continue;
            }
            if (quality > qk) {
                greaterThanQReads.add(read);
                greaterThanQOffsets.add(offset);
                continue;
            }
            equalToQReads.add(reads.get(iter));
        }
        if (lessThanQReads.size() > k) {
            return MathUtils.getQScoreOrderStatistic(lessThanQReads, lessThanQOffsets, k);
        }
        if (equalToQReads.size() + lessThanQReads.size() >= k) {
            return qk;
        }
        return MathUtils.getQScoreOrderStatistic(greaterThanQReads, greaterThanQOffsets, k - lessThanQReads.size() - equalToQReads.size());
    }

    public static byte getQScoreMedian(List<SAMRecord> reads, List<Integer> offsets) {
        return MathUtils.getQScoreOrderStatistic(reads, offsets, (int)Math.floor((double)reads.size() / 2.0));
    }

    public static long sum(Collection<Integer> x) {
        long sum = 0L;
        for (int v : x) {
            sum += (long)v;
        }
        return sum;
    }

    public static double rate(long n, long d) {
        return (double)n / (1.0 * (double)Math.max(d, 1L));
    }

    public static double rate(int n, int d) {
        return (double)n / (1.0 * (double)Math.max(d, 1));
    }

    public static long inverseRate(long n, long d) {
        return n == 0L ? 0L : d / Math.max(n, 1L);
    }

    public static long inverseRate(int n, int d) {
        return n == 0 ? 0L : (long)(d / Math.max(n, 1));
    }

    public static double ratio(int num, int denom) {
        return (double)num / (double)Math.max(denom, 1);
    }

    public static double ratio(long num, long denom) {
        return (double)num / (double)Math.max(denom, 1L);
    }

    public static double max(double x0, double x1, double x2) {
        double a = Math.max(x0, x1);
        return Math.max(a, x2);
    }

    public static double phredScaleToProbability(byte q) {
        return Math.pow(10.0, (double)(-q) / 10.0);
    }

    public static double phredScaleToLog10Probability(byte q) {
        return (double)(-q) / 10.0;
    }

    public static byte probabilityToPhredScale(double p) {
        return (byte)(-10.0 * Math.log10(p));
    }

    public static double log10ProbabilityToPhredScale(double log10p) {
        return -10.0 * log10p;
    }

    public static double lnToLog10(double ln) {
        return ln * Math.log10(Math.exp(1.0));
    }

    private static final int HI(double x) {
        return (int)(Double.doubleToLongBits(x) >> 32);
    }

    private static final int LO(double x) {
        return (int)Double.doubleToLongBits(x);
    }

    private static double lnGamma(double x) {
        double r;
        int hx = MathUtils.HI(x);
        int lx = MathUtils.LO(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x7FF00000) {
            return Double.POSITIVE_INFINITY;
        }
        if ((ix | lx) == 0 || hx < 0) {
            return Double.NaN;
        }
        if (ix < 999292928) {
            return -Math.log(x);
        }
        if ((ix - 0x3FF00000 | lx) == 0 || (ix - 0x40000000 | lx) == 0) {
            r = 0.0;
        } else if (ix < 0x40000000) {
            int i;
            double y;
            if (ix <= 1072483532) {
                r = -Math.log(x);
                if (ix >= 1072130372) {
                    y = 1.0 - x;
                    i = 0;
                } else if (ix >= 1070442081) {
                    y = x - 0.46163214496836225;
                    i = 1;
                } else {
                    y = x;
                    i = 2;
                }
            } else {
                r = 0.0;
                if (ix >= 1073460419) {
                    y = 2.0 - x;
                    i = 0;
                } else if (ix >= 1072936132) {
                    y = x - 1.4616321449683622;
                    i = 1;
                } else {
                    y = x - 1.0;
                    i = 2;
                }
            }
            switch (i) {
                case 0: {
                    double z = y * y;
                    double p1 = 0.07721566490153287 + z * (0.06735230105312927 + z * (0.007385550860814029 + z * (0.0011927076318336207 + z * (2.2086279071390839E-4 + z * 2.5214456545125733E-5))));
                    double p2 = z * (0.3224670334241136 + z * (0.020580808432516733 + z * (0.0028905138367341563 + z * (5.100697921535113E-4 + z * (1.0801156724758394E-4 + z * 4.4864094961891516E-5)))));
                    double p = y * p1 + p2;
                    r += p - 0.5 * y;
                    break;
                }
                case 1: {
                    double z = y * y;
                    double w = z * y;
                    double p1 = 0.48383612272381005 + w * (-0.032788541075985965 + w * (0.006100538702462913 + w * (-0.0014034646998923284 + w * 3.1563207090362595E-4)));
                    double p2 = -0.1475877229945939 + w * (0.01797067508118204 + w * (-0.0036845201678113826 + w * (8.81081882437654E-4 + w * -3.1275416837512086E-4)));
                    double p3 = 0.06462494023913339 + w * (-0.010314224129834144 + w * (0.0022596478090061247 + w * (-5.385953053567405E-4 + w * 3.355291926355191E-4)));
                    double p = z * p1 - (-3.638676997039505E-18 - w * (p2 + y * p3));
                    r += -0.12148629053584961 + p;
                    break;
                }
                case 2: {
                    double p1 = y * (-0.07721566490153287 + y * (0.6328270640250934 + y * (1.4549225013723477 + y * (0.9777175279633727 + y * (0.22896372806469245 + y * 0.013381091853678766)))));
                    double p2 = 1.0 + y * (2.4559779371304113 + y * (2.128489763798934 + y * (0.7692851504566728 + y * (0.10422264559336913 + y * 0.003217092422824239))));
                    r += -0.5 * y + p1 / p2;
                }
            }
        } else if (ix < 0x40200000) {
            int i = (int)x;
            double t = 0.0;
            double y = x - (double)i;
            double p = y * (-0.07721566490153287 + y * (0.21498241596060885 + y * (0.325778796408931 + y * (0.14635047265246445 + y * (0.02664227030336386 + y * (0.0018402845140733772 + y * 3.194753265841009E-5))))));
            double q = 1.0 + y * (1.3920053346762105 + y * (0.7219355475671381 + y * (0.17193386563280308 + y * (0.01864591917156529 + y * (7.779424963818936E-4 + y * 7.326684307446256E-6)))));
            r = 0.5 * y + p / q;
            double z = 1.0;
            switch (i) {
                case 7: {
                    z *= y + 6.0;
                }
                case 6: {
                    z *= y + 5.0;
                }
                case 5: {
                    z *= y + 4.0;
                }
                case 4: {
                    z *= y + 3.0;
                }
                case 3: {
                    r += Math.log(z *= y + 2.0);
                }
            }
        } else if (ix < 1133510656) {
            double t = Math.log(x);
            double z = 1.0 / x;
            double y = z * z;
            double w = 0.4189385332046727 + z * (0.08333333333333297 + y * (-0.0027777777772877554 + y * (7.936505586430196E-4 + y * (-5.9518755745034E-4 + y * (8.363399189962821E-4 + y * -0.0016309293409657527)))));
            r = (x - 0.5) * (t - 1.0) + w;
        } else {
            r = x * (Math.log(x) - 1.0);
        }
        return r;
    }

    public static double log10Gamma(double x) {
        return MathUtils.lnToLog10(MathUtils.lnGamma(x));
    }

    public static double log10BinomialCoefficient(int n, int k) {
        return MathUtils.log10Gamma(n + 1) - MathUtils.log10Gamma(k + 1) - MathUtils.log10Gamma(n - k + 1);
    }

    public static double log10BinomialProbability(int n, int k, double log10p) {
        double log10OneMinusP = Math.log10(1.0 - Math.pow(10.0, log10p));
        return MathUtils.log10BinomialCoefficient(n, k) + log10p * (double)k + log10OneMinusP * (double)(n - k);
    }

    public static double log10MultinomialCoefficient(int n, int[] k) {
        double denominator = 0.0;
        for (int x : k) {
            denominator += MathUtils.log10Gamma(x + 1);
        }
        return MathUtils.log10Gamma(n + 1) - denominator;
    }

    public static double log10MultinomialProbability(int n, int[] k, double[] log10p) {
        if (log10p.length != k.length) {
            throw new UserException.BadArgumentValue("p and k", "Array of log10 probabilities must have the same size as the array of number of sucesses: " + log10p.length + ", " + k.length);
        }
        double log10Prod = 0.0;
        for (int i = 0; i < log10p.length; ++i) {
            log10Prod += log10p[i] * (double)k[i];
        }
        return MathUtils.log10MultinomialCoefficient(n, k) + log10Prod;
    }

    public static double factorial(int x) {
        return Math.pow(10.0, MathUtils.log10Gamma(x + 1));
    }

    public static double log10Factorial(int x) {
        return MathUtils.log10Gamma(x + 1);
    }

    @Requires(value={"a.length == b.length"})
    @Ensures(value={"result.length == a.length"})
    public static int[] addArrays(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    public static Object[] arrayShuffle(Object[] array) {
        int n = array.length;
        Object[] shuffled = (Object[])array.clone();
        for (int i = 0; i < n; ++i) {
            int j = i + GenomeAnalysisEngine.getRandomGenerator().nextInt(n - i);
            Object tmp = shuffled[i];
            shuffled[i] = shuffled[j];
            shuffled[j] = tmp;
        }
        return shuffled;
    }

    public static <E extends Number> Double[] vectorSum(E[] v1, E[] v2) {
        if (v1.length != v2.length) {
            throw new UserException("BUG: vectors v1, v2 of different size in vectorSum()");
        }
        Double[] result = new Double[v1.length];
        for (int k = 0; k < v1.length; ++k) {
            result[k] = ((Number)v1[k]).doubleValue() + ((Number)v2[k]).doubleValue();
        }
        return result;
    }

    public static <E extends Number> Double[] scalarTimesVector(E a, E[] v1) {
        Double[] result = new Double[v1.length];
        for (int k = 0; k < v1.length; ++k) {
            result[k] = a.doubleValue() * ((Number)v1[k]).doubleValue();
        }
        return result;
    }

    public static <E extends Number> Double dotProduct(E[] v1, E[] v2) {
        if (v1.length != v2.length) {
            throw new UserException("BUG: vectors v1, v2 of different size in vectorSum()");
        }
        Double result = 0.0;
        for (int k = 0; k < v1.length; ++k) {
            result = result + ((Number)v1[k]).doubleValue() * ((Number)v2[k]).doubleValue();
        }
        return result;
    }

    public static double[] vectorLog10(double[] v1) {
        double[] result = new double[v1.length];
        for (int k = 0; k < v1.length; ++k) {
            result[k] = Math.log10(v1[k]);
        }
        return result;
    }

    public static Double[] vectorLog10(Double[] v1) {
        Double[] result = new Double[v1.length];
        for (int k = 0; k < v1.length; ++k) {
            result[k] = Math.log10(v1[k]);
        }
        return result;
    }

    public static long intFrom(BitSet bitSet) {
        long number = 0L;
        int bitIndex = bitSet.nextSetBit(0);
        while (bitIndex >= 0) {
            number |= 1L << bitIndex;
            bitIndex = bitSet.nextSetBit(bitIndex + 1);
        }
        return number;
    }

    public static BitSet bitSetFrom(long number) {
        BitSet bitSet = new BitSet();
        int bitIndex = 0;
        while (number > 0L) {
            if (number % 2L > 0L) {
                bitSet.set(bitIndex);
            }
            ++bitIndex;
            number /= 2L;
        }
        return bitSet;
    }

    public static String dnaFrom(BitSet bitSet) {
        long number = MathUtils.intFrom(bitSet);
        long preContext = 0L;
        long nextContext = 4L;
        int i = 1;
        while (nextContext <= number) {
            preContext = nextContext;
            nextContext = (long)((double)nextContext + Math.pow(4.0, ++i));
        }
        number -= preContext;
        String dna = "";
        while (number > 0L) {
            byte base = (byte)(number % 4L);
            switch (base) {
                case 0: {
                    dna = "A" + dna;
                    break;
                }
                case 1: {
                    dna = "C" + dna;
                    break;
                }
                case 2: {
                    dna = "G" + dna;
                    break;
                }
                case 3: {
                    dna = "T" + dna;
                }
            }
            number /= 4L;
        }
        for (int j = dna.length(); j < i; ++j) {
            dna = "A" + dna;
        }
        return dna;
    }

    public static BitSet bitSetFrom(String dna) {
        if (dna.length() > 31) {
            throw new ReviewedStingException(String.format("DNA Length cannot be bigger than 31. dna: %s (%d)", dna, dna.length()));
        }
        long baseTen = 0L;
        long preContext = 0L;
        for (int i = 0; i < dna.length(); ++i) {
            baseTen *= 4L;
            switch (dna.charAt(i)) {
                case 'A': {
                    baseTen += 0L;
                    break;
                }
                case 'C': {
                    ++baseTen;
                    break;
                }
                case 'G': {
                    baseTen += 2L;
                    break;
                }
                case 'T': {
                    baseTen += 3L;
                }
            }
            if (i <= 0) continue;
            preContext = (long)((double)preContext + Math.pow(4.0, i));
        }
        return MathUtils.bitSetFrom(baseTen + preContext);
    }

    static {
        int k;
        log10Cache = new double[44000];
        jacobianLogTable = new double[10001];
        MathUtils.log10Cache[0] = Double.NEGATIVE_INFINITY;
        for (k = 1; k < 44000; ++k) {
            MathUtils.log10Cache[k] = Math.log10(k);
        }
        for (k = 0; k < 10001; ++k) {
            MathUtils.jacobianLogTable[k] = Math.log10(1.0 + Math.pow(10.0, -((double)k) * 0.001));
        }
    }

    public static class RunningAverage {
        private double mean = 0.0;
        private double s = 0.0;
        private long obs_count = 0L;

        public void add(double obs) {
            ++this.obs_count;
            double oldMean = this.mean;
            this.mean += (obs - this.mean) / (double)this.obs_count;
            this.s += (obs - oldMean) * (obs - this.mean);
        }

        public void addAll(Collection<Number> col) {
            for (Number o : col) {
                this.add(o.doubleValue());
            }
        }

        public double mean() {
            return this.mean;
        }

        public double stddev() {
            return Math.sqrt(this.s / (double)(this.obs_count - 1L));
        }

        public double var() {
            return this.s / (double)(this.obs_count - 1L);
        }

        public long observationCount() {
            return this.obs_count;
        }

        public RunningAverage clone() {
            RunningAverage ra = new RunningAverage();
            ra.mean = this.mean;
            ra.s = this.s;
            ra.obs_count = this.obs_count;
            return ra;
        }

        public void merge(RunningAverage other) {
            if (this.obs_count > 0L || other.obs_count > 0L) {
                this.mean = (this.mean * (double)this.obs_count + other.mean * (double)other.obs_count) / (double)(this.obs_count + other.obs_count);
                this.s += other.s;
            }
            this.obs_count += other.obs_count;
        }
    }
}

