/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.util.BAMInputStream;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.RuntimeEOFException;
import net.sf.samtools.util.SeekableStream;
import org.broadinstitute.sting.gatk.datasources.reads.BGZFBlockLoadingDispatcher;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderPosition;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BlockInputStream
extends SeekableStream
implements BAMInputStream {
    private final BGZFBlockLoadingDispatcher dispatcher;
    private final SAMReaderID reader;
    private final long length;
    private Throwable error;
    private SAMReaderPosition position;
    private final ByteBuffer buffer;
    private LinkedList<Integer> blockOffsets = new LinkedList();
    private LinkedList<Long> blockPositions = new LinkedList();
    private final Object lock = new Object();
    private final BlockCompressedInputStream validatingInputStream;
    private boolean bufferFilled = false;

    BlockInputStream(BGZFBlockLoadingDispatcher dispatcher, SAMReaderID reader, boolean validate) {
        this.reader = reader;
        this.length = reader.samFile.length();
        this.buffer = ByteBuffer.wrap(new byte[65536]);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.limit(0);
        this.dispatcher = dispatcher;
        this.position = new SAMReaderPosition(reader, this, new GATKBAMFileSpan(new GATKChunk(0L, Long.MAX_VALUE)));
        this.blockOffsets.add(0);
        this.blockPositions.add(0L);
        try {
            if (validate) {
                System.out.printf("BlockInputStream %s: BGZF block validation mode activated%n", this);
                this.validatingInputStream = new BlockCompressedInputStream(reader.samFile);
                this.validatingInputStream.available();
            } else {
                this.validatingInputStream = null;
            }
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to validate against Picard input stream", ex);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePointer() {
        long filePointer;
        Object object = this.lock;
        synchronized (object) {
            int blockIndex = 0;
            while (blockIndex + 1 < this.blockOffsets.size() && this.buffer.position() >= this.blockOffsets.get(blockIndex + 1)) {
                ++blockIndex;
            }
            filePointer = this.blockPositions.get(blockIndex) + (long)(this.buffer.position() - this.blockOffsets.get(blockIndex));
        }
        return filePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long target) {
        Object object = this.lock;
        synchronized (object) {
            this.clearBuffers();
            this.position.advancePosition(target);
            if (target < this.position.getBlockAddress() << 16) {
                this.blockOffsets.clear();
                this.blockOffsets.add(0);
                this.blockPositions.clear();
                this.blockPositions.add(target);
            } else {
                this.waitForBufferFill();
                Iterator<Integer> blockOffsetIterator = this.blockOffsets.descendingIterator();
                Iterator<Long> blockPositionIterator = this.blockPositions.descendingIterator();
                while (blockOffsetIterator.hasNext() && blockPositionIterator.hasNext()) {
                    int blockOffset = blockOffsetIterator.next();
                    long blockPosition = blockPositionIterator.next();
                    if (blockPosition >> 16 != target >> 16 || (blockPosition & 0xFFFFL) >= (target & 0xFFFFL)) continue;
                    this.buffer.position(blockOffset + (int)(target & 0xFFFFL) - (int)(blockPosition & 0xFFFFL));
                    break;
                }
            }
            if (this.validatingInputStream != null) {
                try {
                    this.validatingInputStream.seek(target);
                }
                catch (IOException ex) {
                    throw new ReviewedStingException("Unable to validate against Picard input stream", ex);
                }
            }
        }
    }

    private void clearBuffers() {
        this.position.reset();
        this.buffer.clear();
        this.buffer.limit(0);
        this.blockOffsets.clear();
        this.blockOffsets.add(0);
        while (this.blockPositions.size() > 1) {
            this.blockPositions.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eof() {
        Object object = this.lock;
        synchronized (object) {
            return this.position != null && (this.position.getBlockAddress() < 0L || this.position.getBlockAddress() >= this.length);
        }
    }

    @Override
    public void setCheckCrcs(boolean check) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitAccessPlan(SAMReaderPosition position) {
        Object object = this.lock;
        synchronized (object) {
            if (this.position != null && position.getBlockAddress() < this.position.getBlockAddress()) {
                position.advancePosition(this.position.getBlockAddress() << 16);
            }
        }
        this.position = position;
    }

    private void compactBuffer() {
        int bytesToRemove = 0;
        while (this.blockOffsets.size() > 1 && this.buffer.position() >= this.blockOffsets.get(1)) {
            this.blockOffsets.remove();
            this.blockPositions.remove();
            bytesToRemove = this.blockOffsets.peek();
        }
        if (this.buffer.remaining() == 0 && this.blockOffsets.size() > 1 && this.buffer.position() >= this.blockOffsets.peek()) {
            bytesToRemove += this.buffer.position();
            this.blockOffsets.remove();
            this.blockPositions.remove();
        }
        int finalBufferStart = this.buffer.position() - bytesToRemove;
        int finalBufferSize = this.buffer.remaining();
        this.buffer.position(bytesToRemove);
        this.buffer.compact();
        this.buffer.position(finalBufferStart);
        this.buffer.limit(finalBufferStart + finalBufferSize);
        for (int i = 0; i < this.blockOffsets.size(); ++i) {
            this.blockOffsets.set(i, this.blockOffsets.get(i) - bytesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyIntoBuffer(ByteBuffer incomingBuffer, SAMReaderPosition position, long filePosition) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.compactBuffer();
                this.buffer.limit(this.buffer.capacity());
                long lastBlockAddress = position.getBlockAddress();
                int blockOffsetStart = position.getFirstOffsetInBlock();
                int blockOffsetEnd = position.getLastOffsetInBlock();
                long endOfRead = blockOffsetEnd < incomingBuffer.remaining() ? lastBlockAddress << 16 | (long)blockOffsetEnd : filePosition << 16;
                byte[] validBytes = null;
                if (this.validatingInputStream != null) {
                    validBytes = new byte[incomingBuffer.remaining()];
                    byte[] currentBytes = new byte[incomingBuffer.remaining()];
                    int pos = incomingBuffer.position();
                    int lim = incomingBuffer.limit();
                    incomingBuffer.get(currentBytes);
                    incomingBuffer.limit(lim);
                    incomingBuffer.position(pos);
                    long currentFilePointer = this.validatingInputStream.getFilePointer();
                    this.validatingInputStream.seek(lastBlockAddress << 16);
                    this.validatingInputStream.read(validBytes);
                    this.validatingInputStream.seek(currentFilePointer);
                    if (!Arrays.equals(validBytes, currentBytes)) {
                        throw new ReviewedStingException(String.format("Bytes being inserted into BlockInputStream %s are incorrect", this));
                    }
                }
                this.position = position;
                position.advancePosition(filePosition << 16);
                if (this.buffer.remaining() < incomingBuffer.remaining()) {
                    this.lock.wait();
                }
                this.blockOffsets.removeLast();
                this.blockOffsets.add(this.buffer.position());
                this.blockPositions.removeLast();
                this.blockPositions.add(lastBlockAddress << 16 | (long)blockOffsetStart);
                incomingBuffer.position(blockOffsetStart);
                incomingBuffer.limit(Math.min(incomingBuffer.limit(), blockOffsetEnd));
                this.buffer.put(incomingBuffer);
                this.blockOffsets.add(this.buffer.position());
                this.blockPositions.add(endOfRead);
                this.buffer.flip();
                this.bufferFilled = true;
                this.lock.notify();
            }
            catch (Exception ex) {
                this.reportException(ex);
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportException(Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            this.error = t;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForErrors() {
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                ReviewedStingException toThrow = new ReviewedStingException(String.format("Thread %s, BlockInputStream %s: Unable to retrieve BAM data from disk", Thread.currentThread().getId(), this), this.error);
                toThrow.setStackTrace(this.error.getStackTrace());
                throw toThrow;
            }
        }
    }

    @Override
    public int read() {
        byte[] singleByte = new byte[1];
        this.read(singleByte);
        return singleByte[0];
    }

    @Override
    public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] bytes, int offset, int length) {
        int remaining;
        Object object = this.lock;
        synchronized (object) {
            int numBytesToCopy;
            for (remaining = length; remaining > 0; remaining -= numBytesToCopy) {
                this.checkForErrors();
                this.waitForBufferFill();
                if (this.buffer.remaining() == 0) break;
                numBytesToCopy = Math.min(this.buffer.remaining(), remaining);
                this.buffer.get(bytes, length - remaining + offset, numBytesToCopy);
            }
            if (length - remaining > 0) {
                this.lock.notify();
            }
        }
        return this.eof() ? -1 : length - remaining;
    }

    @Override
    public void close() {
        if (this.validatingInputStream != null) {
            try {
                this.validatingInputStream.close();
            }
            catch (IOException ex) {
                throw new ReviewedStingException("Unable to validate against Picard input stream", ex);
            }
        }
    }

    @Override
    public String getSource() {
        return this.reader.getSamFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBufferFill() {
        Object object = this.lock;
        synchronized (object) {
            this.bufferFilled = false;
            if (this.buffer.remaining() == 0 && !this.eof()) {
                this.dispatcher.queueBlockLoad(this.position);
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    throw new ReviewedStingException("Interrupt occurred waiting for buffer to fill", ex);
                }
                if (this.bufferFilled && this.buffer.remaining() == 0) {
                    throw new RuntimeEOFException("No more data left in InputStream");
                }
            }
        }
    }
}

