/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.ReadProperties;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.iterators.AllReadsSelector;
import org.broadinstitute.sting.gatk.iterators.LocusIterator;
import org.broadinstitute.sting.gatk.iterators.NRandomReadSelector;
import org.broadinstitute.sting.gatk.iterators.ReadSelector;
import org.broadinstitute.sting.gatk.iterators.SamplePartitioner;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.ExtendedEventPileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileupImpl;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class LocusIteratorByState
extends LocusIterator {
    private static Logger logger = Logger.getLogger(LocusIteratorByState.class);
    private boolean hasExtendedEvents = false;
    private final GenomeLocParser genomeLocParser;
    private final ArrayList<String> samples;
    private final ReadStateManager readStates;
    private ReadProperties readInfo;
    private AlignmentContext nextAlignmentContext;

    public LocusIteratorByState(Iterator<SAMRecord> samIterator, ReadProperties readInformation, GenomeLocParser genomeLocParser, Collection<String> samples) {
        this.readInfo = readInformation;
        this.genomeLocParser = genomeLocParser;
        this.samples = new ArrayList<String>(samples);
        this.readStates = new ReadStateManager(samIterator, readInformation.getDownsamplingMethod());
        if (this.samples.isEmpty() && samIterator.hasNext()) {
            throw new IllegalArgumentException("samples list must not be empty");
        }
    }

    public static final Collection<String> sampleListForSAMWithoutReadGroups() {
        ArrayList<String> samples = new ArrayList<String>();
        samples.add(null);
        return samples;
    }

    @Override
    public Iterator<AlignmentContext> iterator() {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        this.lazyLoadNextAlignmentContext();
        return this.nextAlignmentContext != null;
    }

    private GenomeLoc getLocation() {
        return this.readStates.isEmpty() ? null : this.readStates.getFirst().getLocation(this.genomeLocParser);
    }

    @Override
    public AlignmentContext next() {
        this.lazyLoadNextAlignmentContext();
        if (!this.hasNext()) {
            throw new NoSuchElementException("LocusIteratorByState: out of elements.");
        }
        AlignmentContext currentAlignmentContext = this.nextAlignmentContext;
        this.nextAlignmentContext = null;
        return currentAlignmentContext;
    }

    private void lazyLoadNextAlignmentContext() {
        while (this.nextAlignmentContext == null && this.readStates.hasNext()) {
            Iterator<SAMRecordState> iterator;
            boolean hasBeenSampled;
            this.readStates.collectPendingReads();
            int size = 0;
            int nDeletions = 0;
            int nInsertions = 0;
            int nMQ0Reads = 0;
            if (this.readInfo.generateExtendedEvents() && this.hasExtendedEvents) {
                HashMap<String, ReadBackedExtendedEventPileupImpl> fullExtendedEventPileup = new HashMap<String, ReadBackedExtendedEventPileupImpl>();
                GenomeLoc loc = this.genomeLocParser.incPos(this.getLocation(), -1);
                hasBeenSampled = false;
                for (String sample : this.samples) {
                    iterator = this.readStates.iterator(sample);
                    ArrayList<ExtendedEventPileupElement> indelPile = new ArrayList<ExtendedEventPileupElement>(this.readStates.size(sample));
                    hasBeenSampled |= loc.getStart() <= this.readStates.getDownsamplingExtent(sample);
                    size = 0;
                    nDeletions = 0;
                    nInsertions = 0;
                    nMQ0Reads = 0;
                    int maxDeletionLength = 0;
                    while (iterator.hasNext()) {
                        SAMRecordState state = iterator.next();
                        if (state.hadIndel()) {
                            ++size;
                            if (state.getEventBases() == null) {
                                ++nDeletions;
                                maxDeletionLength = Math.max(maxDeletionLength, state.getEventLength());
                            } else {
                                ++nInsertions;
                            }
                            indelPile.add(new ExtendedEventPileupElement((GATKSAMRecord)state.getRead(), state.getReadEventStartOffset(), state.getEventLength(), state.getEventBases()));
                        } else if (state.getCurrentCigarOperator() != CigarOperator.N && (state.getCurrentCigarOperator() != CigarOperator.D || this.readInfo.includeReadsWithDeletionAtLoci())) {
                            ++size;
                            indelPile.add(new ExtendedEventPileupElement((GATKSAMRecord)state.getRead(), state.getReadOffset() - 1, -1));
                        }
                        if (state.getRead().getMappingQuality() != 0) continue;
                        ++nMQ0Reads;
                    }
                    if (indelPile.size() == 0) continue;
                    fullExtendedEventPileup.put(sample, new ReadBackedExtendedEventPileupImpl(loc, indelPile, size, maxDeletionLength, nInsertions, nDeletions, nMQ0Reads));
                }
                this.hasExtendedEvents = false;
                this.nextAlignmentContext = new AlignmentContext(loc, (ReadBackedPileup)new ReadBackedExtendedEventPileupImpl(loc, (Map<String, ? extends ReadBackedExtendedEventPileupImpl>)fullExtendedEventPileup), hasBeenSampled);
                continue;
            }
            GenomeLoc location = this.getLocation();
            HashMap<String, ReadBackedPileupImpl> fullPileup = new HashMap<String, ReadBackedPileupImpl>();
            hasBeenSampled = false;
            for (String sample : this.samples) {
                iterator = this.readStates.iterator(sample);
                ArrayList<PileupElement> pile = new ArrayList<PileupElement>(this.readStates.size(sample));
                hasBeenSampled |= location.getStart() <= this.readStates.getDownsamplingExtent(sample);
                size = 0;
                nDeletions = 0;
                nMQ0Reads = 0;
                while (iterator.hasNext()) {
                    SAMRecordState state = iterator.next();
                    if (state.getCurrentCigarOperator() != CigarOperator.D && state.getCurrentCigarOperator() != CigarOperator.N) {
                        if (LocusIteratorByState.filterBaseInRead((GATKSAMRecord)state.getRead(), location.getStart())) continue;
                        pile.add(new PileupElement((GATKSAMRecord)state.getRead(), state.getReadOffset()));
                        ++size;
                    } else if (this.readInfo.includeReadsWithDeletionAtLoci() && state.getCurrentCigarOperator() != CigarOperator.N) {
                        ++size;
                        pile.add(new PileupElement((GATKSAMRecord)state.getRead(), -1));
                        ++nDeletions;
                    }
                    if (state.getRead().getMappingQuality() != 0) continue;
                    ++nMQ0Reads;
                }
                if (pile.size() == 0) continue;
                fullPileup.put(sample, new ReadBackedPileupImpl(location, (List<PileupElement>)pile, size, nDeletions, nMQ0Reads));
            }
            this.updateReadStates();
            if (fullPileup.isEmpty()) continue;
            this.nextAlignmentContext = new AlignmentContext(location, (ReadBackedPileup)new ReadBackedPileupImpl(location, (Map<String, ReadBackedPileupImpl>)fullPileup), hasBeenSampled);
        }
    }

    private boolean readIsPastCurrentPosition(SAMRecord read) {
        if (this.readStates.isEmpty()) {
            return false;
        }
        SAMRecordState state = this.readStates.getFirst();
        SAMRecord ourRead = state.getRead();
        return read.getReferenceIndex() > ourRead.getReferenceIndex() || read.getAlignmentStart() > state.getGenomePosition();
    }

    private static boolean filterBaseInRead(GATKSAMRecord rec, long pos) {
        return ReadUtils.isBaseInsideAdaptor(rec, pos);
    }

    private void updateReadStates() {
        for (String sample : this.samples) {
            Iterator<SAMRecordState> it = this.readStates.iterator(sample);
            while (it.hasNext()) {
                SAMRecordState state = it.next();
                CigarOperator op = state.stepForwardOnGenome();
                if (state.hadIndel() && this.readInfo.generateExtendedEvents()) {
                    this.hasExtendedEvents = true;
                    continue;
                }
                if (op != null) continue;
                it.remove();
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    private static class Counter {
        private int count;

        public Counter(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public void decrement() {
            --this.count;
        }
    }

    private class ReadStateManager {
        private final PeekableIterator<SAMRecord> iterator;
        private final DownsamplingMethod downsamplingMethod;
        private final SamplePartitioner samplePartitioner;
        private final Map<String, PerSampleReadStateManager> readStatesBySample = new HashMap<String, PerSampleReadStateManager>();
        private final int targetCoverage;
        private int totalReadStates = 0;

        public ReadStateManager(Iterator<SAMRecord> source, DownsamplingMethod downsamplingMethod) {
            this.iterator = new PeekableIterator<SAMRecord>(source);
            this.downsamplingMethod = downsamplingMethod.type != null ? downsamplingMethod : DownsamplingMethod.NONE;
            switch (this.downsamplingMethod.type) {
                case BY_SAMPLE: {
                    if (downsamplingMethod.toCoverage == null) {
                        throw new UserException.BadArgumentValue("dcov", "Downsampling coverage (-dcov) must be specified when downsampling by sample");
                    }
                    this.targetCoverage = downsamplingMethod.toCoverage;
                    break;
                }
                default: {
                    this.targetCoverage = Integer.MAX_VALUE;
                }
            }
            HashMap<String, ReadSelector> readSelectors = new HashMap<String, ReadSelector>();
            for (String sample : LocusIteratorByState.this.samples) {
                this.readStatesBySample.put(sample, new PerSampleReadStateManager());
                readSelectors.put(sample, downsamplingMethod.type == DownsampleType.BY_SAMPLE ? new NRandomReadSelector(null, this.targetCoverage) : new AllReadsSelector());
            }
            this.samplePartitioner = new SamplePartitioner(readSelectors);
        }

        public Iterator<SAMRecordState> iterator(final String sample) {
            return new Iterator<SAMRecordState>(){
                private Iterator<SAMRecordState> wrappedIterator;
                {
                    this.wrappedIterator = ((PerSampleReadStateManager)ReadStateManager.this.readStatesBySample.get(sample)).iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.wrappedIterator.hasNext();
                }

                @Override
                public SAMRecordState next() {
                    return this.wrappedIterator.next();
                }

                @Override
                public void remove() {
                    this.wrappedIterator.remove();
                    ReadStateManager.this.totalReadStates--;
                }
            };
        }

        public boolean isEmpty() {
            return this.totalReadStates == 0;
        }

        public int size() {
            return this.totalReadStates;
        }

        public int size(String sample) {
            return this.readStatesBySample.get(sample).size();
        }

        public int getDownsamplingExtent(String sample) {
            return this.readStatesBySample.get(sample).getDownsamplingExtent();
        }

        public SAMRecordState getFirst() {
            for (String sample : LocusIteratorByState.this.samples) {
                PerSampleReadStateManager reads = this.readStatesBySample.get(sample);
                if (reads.isEmpty()) continue;
                return reads.peek();
            }
            return null;
        }

        public boolean hasNext() {
            return this.totalReadStates > 0 || this.iterator.hasNext();
        }

        public void collectPendingReads() {
            if (!this.iterator.hasNext()) {
                return;
            }
            if (LocusIteratorByState.this.readStates.size() == 0) {
                int firstContigIndex = this.iterator.peek().getReferenceIndex();
                int firstAlignmentStart = this.iterator.peek().getAlignmentStart();
                while (this.iterator.hasNext() && this.iterator.peek().getReferenceIndex() == firstContigIndex && this.iterator.peek().getAlignmentStart() == firstAlignmentStart) {
                    this.samplePartitioner.submitRead(this.iterator.next());
                }
            } else {
                if (LocusIteratorByState.this.readIsPastCurrentPosition(this.iterator.peek())) {
                    return;
                }
                while (this.iterator.hasNext() && !LocusIteratorByState.this.readIsPastCurrentPosition(this.iterator.peek())) {
                    this.samplePartitioner.submitRead(this.iterator.next());
                }
            }
            this.samplePartitioner.complete();
            for (String sample : LocusIteratorByState.this.samples) {
                ReadSelector aggregator = this.samplePartitioner.getSelectedReads(sample);
                ArrayList<SAMRecord> newReads = new ArrayList<SAMRecord>(aggregator.getSelectedReads());
                PerSampleReadStateManager statesBySample = this.readStatesBySample.get(sample);
                int numReads = statesBySample.size();
                int downsamplingExtent = aggregator.getDownsamplingExtent();
                if (numReads + newReads.size() <= this.targetCoverage || this.downsamplingMethod.type == DownsampleType.NONE) {
                    long readLimit = aggregator.getNumReadsSeen();
                    this.addReadsToSample(statesBySample, newReads, readLimit);
                    statesBySample.specifyNewDownsamplingExtent(downsamplingExtent);
                    continue;
                }
                int[] counts = statesBySample.getCountsPerAlignmentStart();
                int[] updatedCounts = new int[counts.length];
                System.arraycopy(counts, 0, updatedCounts, 0, counts.length);
                boolean readPruned = true;
                while (numReads + newReads.size() > this.targetCoverage && readPruned) {
                    readPruned = false;
                    for (int alignmentStart = updatedCounts.length - 1; numReads + newReads.size() > this.targetCoverage && alignmentStart >= 0; --alignmentStart) {
                        if (updatedCounts[alignmentStart] <= 1) continue;
                        int n = alignmentStart;
                        updatedCounts[n] = updatedCounts[n] - 1;
                        --numReads;
                        readPruned = true;
                    }
                }
                if (numReads == this.targetCoverage) {
                    updatedCounts[0] = updatedCounts[0] - 1;
                    --numReads;
                }
                BitSet toPurge = new BitSet(LocusIteratorByState.this.readStates.size());
                int readOffset = 0;
                for (int i = 0; i < updatedCounts.length; ++i) {
                    int n = counts[i];
                    int k = updatedCounts[i];
                    for (Integer purgedElement : MathUtils.sampleIndicesWithoutReplacement(n, n - k)) {
                        toPurge.set(readOffset + purgedElement);
                    }
                    readOffset += counts[i];
                }
                downsamplingExtent = Math.max(downsamplingExtent, statesBySample.purge(toPurge));
                this.addReadsToSample(statesBySample, newReads, this.targetCoverage - numReads);
                statesBySample.specifyNewDownsamplingExtent(downsamplingExtent);
            }
            this.samplePartitioner.reset();
        }

        private void addReadsToSample(PerSampleReadStateManager readStates, Collection<SAMRecord> reads, long maxReads) {
            if (reads.isEmpty()) {
                return;
            }
            LinkedList<SAMRecordState> newReadStates = new LinkedList<SAMRecordState>();
            int readCount = 0;
            for (SAMRecord read : reads) {
                if ((long)readCount >= maxReads) continue;
                SAMRecordState state = new SAMRecordState(read, LocusIteratorByState.this.readInfo.generateExtendedEvents());
                state.stepForwardOnGenome();
                newReadStates.add(state);
                if (state.hadIndel()) {
                    LocusIteratorByState.this.hasExtendedEvents = true;
                }
                ++readCount;
            }
            readStates.addStatesAtNextAlignmentStart(newReadStates);
        }

        private class PerSampleReadStateManager
        implements Iterable<SAMRecordState> {
            private final Queue<SAMRecordState> readStates = new LinkedList<SAMRecordState>();
            private final Deque<Counter> readStateCounter = new LinkedList<Counter>();
            private int downsamplingExtent = 0;

            private PerSampleReadStateManager() {
            }

            public void addStatesAtNextAlignmentStart(Collection<SAMRecordState> states) {
                this.readStates.addAll(states);
                this.readStateCounter.add(new Counter(states.size()));
                ReadStateManager.this.totalReadStates += states.size();
            }

            public boolean isEmpty() {
                return this.readStates.isEmpty();
            }

            public SAMRecordState peek() {
                return this.readStates.peek();
            }

            public int size() {
                return this.readStates.size();
            }

            public void specifyNewDownsamplingExtent(int downsamplingExtent) {
                this.downsamplingExtent = Math.max(this.downsamplingExtent, downsamplingExtent);
            }

            public int getDownsamplingExtent() {
                return this.downsamplingExtent;
            }

            public int[] getCountsPerAlignmentStart() {
                int[] counts = new int[this.readStateCounter.size()];
                int index = 0;
                for (Counter counter : this.readStateCounter) {
                    counts[index++] = counter.getCount();
                }
                return counts;
            }

            @Override
            public Iterator<SAMRecordState> iterator() {
                return new Iterator<SAMRecordState>(){
                    private Iterator<SAMRecordState> wrappedIterator;
                    {
                        this.wrappedIterator = PerSampleReadStateManager.this.readStates.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.wrappedIterator.hasNext();
                    }

                    @Override
                    public SAMRecordState next() {
                        return this.wrappedIterator.next();
                    }

                    @Override
                    public void remove() {
                        this.wrappedIterator.remove();
                        Counter counter = (Counter)PerSampleReadStateManager.this.readStateCounter.peek();
                        counter.decrement();
                        if (counter.getCount() == 0) {
                            PerSampleReadStateManager.this.readStateCounter.remove();
                        }
                    }
                };
            }

            public int purge(BitSet elements) {
                int downsamplingExtent = 0;
                if (elements.isEmpty() || this.readStates.isEmpty()) {
                    return downsamplingExtent;
                }
                Iterator readStateIterator = this.readStates.iterator();
                Iterator<Counter> counterIterator = this.readStateCounter.iterator();
                Counter currentCounter = counterIterator.next();
                int readIndex = 0;
                long alignmentStartCounter = currentCounter.getCount();
                int toPurge = elements.nextSetBit(0);
                int removedCount = 0;
                while (readStateIterator.hasNext() && toPurge >= 0) {
                    SAMRecordState state = (SAMRecordState)readStateIterator.next();
                    downsamplingExtent = Math.max(downsamplingExtent, state.getRead().getAlignmentEnd());
                    if (readIndex == toPurge) {
                        readStateIterator.remove();
                        currentCounter.decrement();
                        if (currentCounter.getCount() == 0) {
                            counterIterator.remove();
                        }
                        ++removedCount;
                        toPurge = elements.nextSetBit(toPurge + 1);
                    }
                    ++readIndex;
                    if (--alignmentStartCounter != 0L || !counterIterator.hasNext()) continue;
                    currentCounter = counterIterator.next();
                    alignmentStartCounter = currentCounter.getCount();
                }
                ReadStateManager.this.totalReadStates -= removedCount;
                return downsamplingExtent;
            }
        }
    }

    private static class SAMRecordState {
        SAMRecord read;
        int readOffset = -1;
        int genomeOffset = -1;
        Cigar cigar = null;
        int cigarOffset = -1;
        CigarElement curElement = null;
        int nCigarElements = 0;
        int cigarElementCounter = -1;
        boolean generateExtendedEvents = true;
        byte[] insertedBases = null;
        int eventLength = -1;
        byte eventDelayedFlag = 0;
        int eventStart = -1;

        public SAMRecordState(SAMRecord read, boolean extended) {
            this.read = read;
            this.cigar = read.getCigar();
            this.nCigarElements = this.cigar.numCigarElements();
            this.generateExtendedEvents = extended;
        }

        public SAMRecord getRead() {
            return this.read;
        }

        public int getReadOffset() {
            return this.readOffset;
        }

        public int getGenomeOffset() {
            return this.genomeOffset;
        }

        public int getGenomePosition() {
            return this.read.getAlignmentStart() + this.getGenomeOffset();
        }

        public GenomeLoc getLocation(GenomeLocParser genomeLocParser) {
            return genomeLocParser.createGenomeLoc(this.read.getReferenceName(), this.getGenomePosition());
        }

        public CigarOperator getCurrentCigarOperator() {
            return this.curElement.getOperator();
        }

        public boolean hadIndel() {
            return this.eventLength > 0;
        }

        public int getEventLength() {
            return this.eventLength;
        }

        public byte[] getEventBases() {
            return this.insertedBases;
        }

        public int getReadEventStartOffset() {
            return this.eventStart;
        }

        public String toString() {
            return String.format("%s ro=%d go=%d co=%d cec=%d %s", this.read.getReadName(), this.readOffset, this.genomeOffset, this.cigarOffset, this.cigarElementCounter, this.curElement);
        }

        public CigarOperator stepForwardOnGenome() {
            if (this.curElement == null || ++this.cigarElementCounter > this.curElement.getLength()) {
                ++this.cigarOffset;
                if (this.cigarOffset < this.nCigarElements) {
                    this.curElement = this.cigar.getCigarElement(this.cigarOffset);
                    this.cigarElementCounter = 0;
                    return this.stepForwardOnGenome();
                }
                ++this.genomeOffset;
                if (this.generateExtendedEvents && this.eventDelayedFlag > 0) {
                    this.eventDelayedFlag = (byte)(this.eventDelayedFlag - 1);
                    if (this.eventDelayedFlag == 0) {
                        this.eventLength = -1;
                        this.insertedBases = null;
                        this.eventStart = -1;
                    }
                }
                return null;
            }
            boolean done = false;
            switch (this.curElement.getOperator()) {
                case H: 
                case P: {
                    this.cigarElementCounter = this.curElement.getLength();
                    break;
                }
                case I: {
                    if (this.generateExtendedEvents) {
                        if (this.eventDelayedFlag > 1) {
                            throw new UserException.MalformedBAM(this.read, "Adjacent I/D events in read " + this.read.getReadName());
                        }
                        this.insertedBases = Arrays.copyOfRange(this.read.getReadBases(), this.readOffset + 1, this.readOffset + 1 + this.curElement.getLength());
                        this.eventLength = this.curElement.getLength();
                        this.eventStart = this.readOffset;
                        this.eventDelayedFlag = (byte)2;
                    }
                }
                case S: {
                    this.cigarElementCounter = this.curElement.getLength();
                    this.readOffset += this.curElement.getLength();
                    break;
                }
                case D: {
                    if (this.generateExtendedEvents && this.cigarElementCounter == 1) {
                        if (this.eventDelayedFlag > 1) {
                            throw new UserException.MalformedBAM(this.read, "Adjacent I/D events in read " + this.read.getReadName());
                        }
                        this.eventLength = this.curElement.getLength();
                        this.eventDelayedFlag = (byte)2;
                        this.eventStart = this.readOffset;
                        this.insertedBases = null;
                    }
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                case N: {
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                case M: {
                    ++this.readOffset;
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Case statement didn't deal with cigar op: " + (Object)((Object)this.curElement.getOperator()));
                }
            }
            if (this.generateExtendedEvents && this.eventDelayedFlag > 0 && done) {
                this.eventDelayedFlag = (byte)(this.eventDelayedFlag - 1);
                if (this.eventDelayedFlag == 0) {
                    this.eventLength = -1;
                    this.insertedBases = null;
                    this.eventStart = -1;
                }
            }
            return done ? this.curElement.getOperator() : this.stepForwardOnGenome();
        }
    }
}

