/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class RODRecordListImpl
extends AbstractList<GATKFeature>
implements Comparable<RODRecordList>,
Cloneable,
RODRecordList,
HasGenomeLocation {
    private List<GATKFeature> records;
    private GenomeLoc location = null;
    private String name = null;

    public RODRecordListImpl(String name) {
        this.records = new ArrayList<GATKFeature>();
        this.name = name;
    }

    public RODRecordListImpl(String name, Collection<GATKFeature> data, GenomeLoc loc) {
        this.records = new ArrayList<GATKFeature>(data == null ? 0 : data.size());
        this.name = name;
        this.location = loc;
        if (data == null || data.size() == 0) {
            return;
        }
        for (GATKFeature r : data) {
            this.records.add(r);
            if (r == null) continue;
            if (!this.name.equals(r.getName())) {
                throw new ReviewedStingException("Attempt to add GATKFeature with non-matching name " + r.getName() + " to the track " + name);
            }
            if (this.location == null || this.location.overlapsP(r.getLocation())) continue;
            throw new ReviewedStingException("Attempt to add GATKFeature that lies outside of specified interval " + this.location + "; offending GATKFeature:\n" + r.toString());
        }
    }

    @Override
    public GenomeLoc getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<GATKFeature> iterator() {
        return this.records.iterator();
    }

    @Override
    public void clear() {
        this.records.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public boolean add(GATKFeature record) {
        this.add(record, false);
        return true;
    }

    @Override
    public GATKFeature get(int i) {
        return this.records.get(i);
    }

    public void add(GATKFeature record, boolean allowNameMismatch) {
        if (record != null && !allowNameMismatch && !this.name.equals(record.getName())) {
            throw new ReviewedStingException("Attempt to add GATKFeature with non-matching name " + record.getName() + " to the track " + this.name);
        }
        this.records.add(record);
    }

    public void add(RODRecordList records) {
        this.add(records, false);
    }

    public void add(RODRecordList records, boolean allowNameMismatch) {
        for (GATKFeature record : records) {
            this.add(record, allowNameMismatch);
        }
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public int compareTo(RODRecordList that) {
        return this.getLocation().compareTo(that.getLocation());
    }
}

