/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.resourcemanagement;

import org.broadinstitute.sting.utils.exceptions.UserException;

public class ThreadAllocation {
    private final int numCPUThreads;
    private final int numIOThreads;

    public int getNumCPUThreads() {
        return this.numCPUThreads;
    }

    public int getNumIOThreads() {
        return this.numIOThreads;
    }

    public ThreadAllocation() {
        this(1, null, null);
    }

    public ThreadAllocation(int totalThreads, Integer numCPUThreads, Integer numIOThreads) {
        if (numCPUThreads == null && numIOThreads == null) {
            this.numCPUThreads = totalThreads;
            this.numIOThreads = 0;
        } else if (numIOThreads == null) {
            if (numCPUThreads > totalThreads) {
                throw new UserException(String.format("Invalid thread allocation.  User requested %d threads in total, but the count of cpu threads (%d) is higher than the total threads", totalThreads, numCPUThreads));
            }
            this.numCPUThreads = numCPUThreads;
            this.numIOThreads = totalThreads - numCPUThreads;
        } else if (numCPUThreads == null) {
            if (numIOThreads > totalThreads) {
                throw new UserException(String.format("Invalid thread allocation.  User requested %d threads in total, but the count of io threads (%d) is higher than the total threads", totalThreads, numIOThreads));
            }
            this.numCPUThreads = Math.max(1, totalThreads - numIOThreads);
            this.numIOThreads = numIOThreads;
        } else {
            if (numCPUThreads + numIOThreads != totalThreads) {
                throw new UserException(String.format("Invalid thread allocation.  User requested %d threads in total, but the count of cpu threads (%d) + the count of io threads (%d) does not match", totalThreads, numCPUThreads, numIOThreads));
            }
            this.numCPUThreads = numCPUThreads;
            this.numIOThreads = numIOThreads;
        }
    }
}

