/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.activeregion;

import java.util.ArrayList;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.activeregion.ActiveRead;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ActiveRegion
implements HasGenomeLocation {
    private final ArrayList<ActiveRead> reads = new ArrayList();
    private byte[] reference = null;
    private final GenomeLoc loc;
    private GenomeLoc referenceLoc = null;
    private final GenomeLocParser genomeLocParser;
    public final boolean isActive;

    public ActiveRegion(GenomeLoc loc, boolean isActive, GenomeLocParser genomeLocParser) {
        this.loc = loc;
        this.isActive = isActive;
        this.genomeLocParser = genomeLocParser;
        this.referenceLoc = loc;
    }

    public void add(GATKSAMRecord read, boolean isPrimaryRegion) {
        this.referenceLoc = this.referenceLoc.union(this.genomeLocParser.createGenomeLoc(read));
        this.reads.add(new ActiveRead(read, isPrimaryRegion));
    }

    public ArrayList<ActiveRead> getReads() {
        return this.reads;
    }

    public byte[] getReference(IndexedFastaSequenceFile referenceReader) {
        if (this.reference == null) {
            this.reference = referenceReader.getSubsequenceAt(this.referenceLoc.getContig(), this.referenceLoc.getStart(), this.referenceLoc.getStop()).getBases();
        }
        return this.reference;
    }

    @Override
    public GenomeLoc getLocation() {
        return this.loc;
    }

    public GenomeLoc getReferenceLocation() {
        return this.referenceLoc;
    }

    public int size() {
        return this.reads.size();
    }
}

