/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.assembly;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Counts
implements Cloneable {
    private int totalEdgeCount = 0;
    private List<Integer> edgeCounts = new ArrayList<Integer>();
    private boolean isTerminatedAtRepeat = false;
    private boolean isSorted = false;

    public void incrementEdgeCounts(int count) {
        this.totalEdgeCount += count;
        this.edgeCounts.add(count);
        this.isSorted = false;
    }

    public int getTotalEdgeCount() {
        return this.totalEdgeCount;
    }

    public int getMedianEdgeCount() {
        if (this.edgeCounts.size() == 0) {
            return 0;
        }
        if (!this.isSorted) {
            Collections.sort(this.edgeCounts);
        }
        return this.edgeCounts.get(this.edgeCounts.size() / 2);
    }

    public int getMinEdgeCount() {
        if (this.edgeCounts.size() == 0) {
            return 0;
        }
        if (!this.isSorted) {
            Collections.sort(this.edgeCounts);
        }
        return this.edgeCounts.get(0);
    }

    public int getNumEdges() {
        return this.edgeCounts.size();
    }

    public void setTerminatedAtRepeat(boolean isTerminatedAtRepeat) {
        this.isTerminatedAtRepeat = isTerminatedAtRepeat;
    }

    public boolean isTerminatedAtRepeat() {
        return this.isTerminatedAtRepeat;
    }

    public Object clone() {
        Counts clone = new Counts();
        clone.edgeCounts.addAll(this.edgeCounts);
        clone.totalEdgeCount = this.totalEdgeCount;
        return clone;
    }

    public String toString() {
        return "_numedges:" + this.getNumEdges() + "_totaledgecounts:" + this.getTotalEdgeCount() + "_medianedgecount:" + this.getMedianEdgeCount() + "_minedgecount:" + this.getMinEdgeCount() + "_terminatedatrepeat:" + this.isTerminatedAtRepeat;
    }
}

