/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.fastq;

import edu.unc.bioinf.ubu.fastq.FastqInputFile;
import edu.unc.bioinf.ubu.fastq.FastqOutputFile;
import edu.unc.bioinf.ubu.fastq.FastqRecord;

@Deprecated
public class FastqFilter {
    private int maxCachedLines = 100;
    private String filename1;
    private String filename2;
    private String matchFilename1;
    private String matchFilename2;
    private FastqInputFile file1;
    private FastqInputFile file2;
    private FastqOutputFile matchFile1;
    private FastqOutputFile matchFile2;

    public FastqFilter(String filename1, String filename2, String matchFilename1, String matchFilename2, int maxCachedLines) {
        this.filename1 = filename1;
        this.filename2 = filename2;
        this.matchFilename1 = matchFilename1;
        this.matchFilename2 = matchFilename2;
        this.maxCachedLines = maxCachedLines;
        this.init();
    }

    public String getInputFile1() {
        return this.filename1;
    }

    public String getInputFile2() {
        return this.filename2;
    }

    public String getMatchFile1() {
        return this.matchFilename1;
    }

    public String getMatchFile2() {
        return this.matchFilename2;
    }

    public void init(FastqInputFile file1, FastqInputFile file2, FastqOutputFile matchFile1, FastqOutputFile matchFile2) {
        this.file1 = file1;
        this.file2 = file2;
        this.matchFile1 = matchFile1;
        this.matchFile2 = matchFile2;
    }

    public void init() {
        this.init(new FastqInputFile(), new FastqInputFile(), new FastqOutputFile(), new FastqOutputFile());
    }

    public void filter() throws Exception {
        long start = System.currentTimeMillis();
        this.file1.init(this.filename1, this.maxCachedLines);
        this.file2.init(this.filename2, this.maxCachedLines);
        this.matchFile1.init(this.matchFilename1);
        this.matchFile2.init(this.matchFilename2);
        int idx1 = 1;
        int idx2 = 1;
        boolean isDone = false;
        while (!isDone) {
            FastqRecord rec1 = this.file1.getRecord(idx1);
            FastqRecord rec2 = this.file2.getRecord(idx2);
            if (rec1 == null && rec2 == null) {
                isDone = true;
            } else if (rec1 == null) {
                isDone = true;
            } else if (rec2 == null) {
                isDone = true;
            } else if (rec1.hasSameBaseId(rec2)) {
                ++idx1;
                ++idx2;
                this.matchFile1.write(rec1);
                this.matchFile2.write(rec2);
            } else {
                boolean isFound = false;
                int cnt = 1;
                while (!isFound && cnt < this.maxCachedLines && rec2 != null) {
                    rec2 = this.file2.getRecord(idx2 + cnt);
                    if (rec1.hasSameBaseId(rec2)) {
                        idx2 = idx2 + cnt + 1;
                        ++idx1;
                        isFound = true;
                        this.matchFile1.write(rec1);
                        this.matchFile2.write(rec2);
                        continue;
                    }
                    ++cnt;
                }
                if (!isFound) {
                    rec2 = this.file2.getRecord(idx2);
                    cnt = 1;
                    while (!isFound && cnt < this.maxCachedLines && rec1 != null) {
                        rec1 = this.file1.getRecord(idx1 + cnt);
                        if (rec2.hasSameBaseId(rec1)) {
                            idx1 = idx1 + cnt + 1;
                            ++idx2;
                            isFound = true;
                            this.matchFile1.write(rec1);
                            this.matchFile2.write(rec2);
                            continue;
                        }
                        ++cnt;
                    }
                }
                if (!isFound) {
                    ++idx1;
                    ++idx2;
                }
            }
            if (idx1 % 1000000 != 0 && idx2 % 1000000 != 0) continue;
            System.out.println("Idx: " + idx1 + " - " + idx2);
        }
        this.matchFile1.close();
        this.matchFile2.close();
        long end = System.currentTimeMillis();
        System.out.println("FastqFilter elapsed time(seconds): " + (end - start) / 1000L);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("THIS CLASS IS DEPRECATED!  DO NOT USE IT!");
        int maxCachedLines = Integer.parseInt(args[4]);
        FastqFilter c = new FastqFilter(args[0], args[1], args[2], args[3], maxCachedLines);
        c.filter();
        System.out.println("Done");
        System.out.println("THIS CLASS IS DEPRECATED!  DO NOT USE IT!");
    }
}

