/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.fastq;

import edu.unc.bioinf.ubu.util.Options;
import joptsimple.OptionParser;

public class FastqFormatterOptions
extends Options {
    private static final String INPUT = "in";
    private static final String OUTPUT = "out";
    private static final String SUFFIX = "suffix";
    private static final String PHRED_33_TO_64 = "phred33to64";
    private static final String STRIP_AFTER_WHITESPACE = "strip";
    private OptionParser parser;
    private boolean isValid;

    @Override
    protected OptionParser getOptionParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.parser.accepts(INPUT, "Input FASTQ file").withRequiredArg().ofType(String.class);
            this.parser.accepts(OUTPUT, "Output FASTQ file").withRequiredArg().ofType(String.class);
            this.parser.accepts(SUFFIX, "Read suffix (i.e. /1 or /2)").withRequiredArg().ofType(String.class);
            this.parser.accepts(PHRED_33_TO_64, "If specified, convert quality from phred33 to phred64");
            this.parser.accepts(STRIP_AFTER_WHITESPACE, "Strip spaces and anything following a space from the read id");
            this.parser.accepts("help", "Print this help message");
        }
        return this.parser;
    }

    @Override
    protected void validate() {
        this.isValid = true;
        if (!this.getOptions().hasArgument(INPUT)) {
            this.isValid = false;
            System.err.println("Missing required input FASTQ file");
        }
        if (!this.getOptions().hasArgument(OUTPUT)) {
            this.isValid = false;
            System.err.println("Missing required output FASTQ file");
        }
        if (!this.getOptions().hasArgument(SUFFIX)) {
            this.isValid = false;
            System.err.println("Missing required read suffix");
        }
        if (!this.isValid) {
            this.printHelp();
        }
    }

    public String getInputFile() {
        return (String)this.getOptions().valueOf(INPUT);
    }

    public String getOutputFile() {
        return (String)this.getOptions().valueOf(OUTPUT);
    }

    public boolean hasSuffix() {
        return this.getOptions().has(SUFFIX);
    }

    public String getSuffix() {
        return (String)this.getOptions().valueOf(SUFFIX);
    }

    public boolean shouldConvertPhred33To64() {
        return this.getOptions().has(PHRED_33_TO_64);
    }

    public boolean shouldStripAfterWhitespace() {
        return this.getOptions().has(STRIP_AFTER_WHITESPACE);
    }

    public boolean isValid() {
        return this.isValid;
    }
}

